/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.citizens;

import com.elmakers.mine.bukkit.api.magic.MagicAPI;
import com.elmakers.mine.bukkit.magic.MagicPlugin;
import net.citizensnpcs.api.event.NPCRightClickEvent;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.MemoryDataKey;
import org.apache.commons.lang.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;

public class MagicCitizensTrait
extends Trait {
    private String spellKey;
    private boolean npcCaster = true;
    private String[] parameters = null;
    private MagicAPI api;

    public MagicCitizensTrait() {
        super("magic");
    }

    public void load(DataKey data) {
        this.spellKey = data.getString("spell", null);
        this.npcCaster = data.getBoolean("caster", false);
        String parameterString = data.getString("parameters", null);
        this.parameters = null;
        if (parameterString != null && !parameterString.isEmpty()) {
            this.parameters = StringUtils.split((String)parameterString, (String)" ");
            if (this.parameters.length == 0) {
                this.parameters = null;
            }
        }
    }

    public void save(DataKey data) {
        data.setString("spell", this.spellKey);
        data.setBoolean("caster", this.npcCaster);
        String parameterString = this.parameters != null && this.parameters.length > 0 ? StringUtils.join((Object[])this.parameters, (String)" ") : null;
        data.setString("parameters", parameterString);
    }

    public void onRemove() {
    }

    public void onAttach() {
        this.load((DataKey)new MemoryDataKey());
        this.api = MagicPlugin.getAPI();
    }

    @EventHandler
    public void onClick(NPCRightClickEvent event) {
        if (event.getNPC() != this.getNPC() || this.spellKey == null || this.spellKey.isEmpty()) {
            return;
        }
        String[] parameters = this.parameters;
        Player entity = null;
        Player sender = null;
        if (this.npcCaster) {
            if (event.getNPC().isSpawned()) {
                entity = event.getNPC().getBukkitEntity();
                if (parameters == null) {
                    parameters = new String[2];
                } else {
                    parameters = new String[parameters.length + 2];
                    System.arraycopy(this.parameters, 0, parameters, 2, this.parameters.length);
                }
                parameters[0] = "player";
                parameters[1] = event.getClicker().getName();
            }
        } else {
            entity = event.getClicker();
            sender = event.getClicker();
        }
        this.api.cast(this.spellKey, parameters, (CommandSender)sender, (Entity)entity);
    }

    public void describe(CommandSender sender) {
        sender.sendMessage(ChatColor.AQUA + "Magic NPC: " + ChatColor.GOLD + this.npc.getName() + ChatColor.WHITE + "(" + ChatColor.GRAY + this.npc.getId() + ChatColor.WHITE + ")");
        String spellDescription = this.spellKey == null ? ChatColor.RED + "(None)" : ChatColor.LIGHT_PURPLE + this.spellKey;
        sender.sendMessage(ChatColor.DARK_PURPLE + "Spell: " + spellDescription);
        String parameterDescription = this.parameters == null ? ChatColor.GRAY + "(None)" : ChatColor.LIGHT_PURPLE + StringUtils.join((Object[])this.parameters, (String)" ");
        sender.sendMessage(ChatColor.DARK_PURPLE + "Parameters: " + parameterDescription);
        String casterDescription = this.npcCaster ? ChatColor.GRAY + "NPC" : ChatColor.LIGHT_PURPLE + "Player";
        sender.sendMessage(ChatColor.DARK_PURPLE + "Caster: " + casterDescription);
    }

    public void configure(CommandSender sender, String key, String value) {
        if (key == null) {
            return;
        }
        if (key.equalsIgnoreCase("spell")) {
            if (value == null) {
                sender.sendMessage(ChatColor.RED + "Cleared spell");
            } else {
                this.spellKey = value;
                sender.sendMessage(ChatColor.DARK_PURPLE + "Set spell to: " + ChatColor.LIGHT_PURPLE + this.spellKey);
            }
        } else if (key.equalsIgnoreCase("parameters")) {
            if (value == null) {
                sender.sendMessage(ChatColor.RED + "Cleared parameters");
            } else {
                this.parameters = StringUtils.split((String)value, (String)" ");
                sender.sendMessage(ChatColor.DARK_PURPLE + "Set parameters to: " + ChatColor.LIGHT_PURPLE + value);
            }
        } else if (key.equalsIgnoreCase("caster")) {
            if (value == null || !value.equalsIgnoreCase("true")) {
                sender.sendMessage(ChatColor.DARK_PURPLE + "Set caster as player");
                this.npcCaster = false;
            } else {
                this.npcCaster = true;
                sender.sendMessage(ChatColor.DARK_PURPLE + "Set caster as NPC");
            }
        } else {
            sender.sendMessage(ChatColor.RED + "Expecting: spell, parameters or caster");
        }
    }
}

