/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.api.action.GUIAction;
import com.elmakers.mine.bukkit.api.action.GeneralAction;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.wand.LostWand;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.spell.BaseSpellAction;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.InventoryUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class RecallAction
extends BaseSpellAction
implements GeneralAction,
GUIAction {
    private static String MARKER_KEY = "recall_marker";
    private static String UNLOCKED_WARPS = "recall_warps";
    protected static Material DefaultWaypointMaterial = Material.BEACON;
    private static MaterialAndData defaultMaterial = new MaterialAndData(DefaultWaypointMaterial);
    private static int MAX_RETRY_COUNT = 8;
    private static int RETRY_INTERVAL = 10;
    private int retryCount = 0;
    private boolean allowCrossWorld = true;
    private Map<String, ConfigurationSection> warps = new HashMap<String, ConfigurationSection>();
    private List<RecallType> enabledTypes = new ArrayList<RecallType>();
    private Map<Integer, Waypoint> options = new HashMap<Integer, Waypoint>();

    @Override
    public boolean isUndoable() {
        return true;
    }

    @Override
    public void deactivated() {
    }

    @Override
    public void clicked(InventoryClickEvent event) {
        Waypoint waypoint;
        int slot = event.getSlot();
        event.setCancelled(true);
        if (event.getSlotType() == InventoryType.SlotType.CONTAINER && (waypoint = this.options.get(slot)) != null) {
            Mage mage = this.getMage();
            Player player = mage.getPlayer();
            mage.deactivateGUI();
            this.tryTeleport(player, waypoint);
        }
    }

    @Override
    public SpellResult perform(ConfigurationSection parameters) {
        this.enabledTypes.clear();
        this.warps.clear();
        Mage mage = this.getMage();
        MageController controller = this.getController();
        Player player = mage.getPlayer();
        if (player == null) {
            return SpellResult.PLAYER_REQUIRED;
        }
        HashSet<String> unlockedWarps = new HashSet<String>();
        String unlockedString = mage.getData().getString(UNLOCKED_WARPS);
        if (unlockedString != null && !unlockedString.isEmpty()) {
            unlockedWarps.addAll(Arrays.asList(StringUtils.split((String)unlockedString, (String)",")));
        }
        ConfigurationSection warpConfig = null;
        if (parameters.contains("warps")) {
            warpConfig = parameters.getConfigurationSection("warps");
        }
        if (parameters.contains("unlock")) {
            String unlockWarp = parameters.getString("unlock");
            if (unlockedWarps.contains(unlockWarp)) {
                return SpellResult.NO_ACTION;
            }
            unlockedWarps.add(unlockWarp);
            unlockedString = StringUtils.join(unlockedWarps, (String)",");
            mage.getData().set(UNLOCKED_WARPS, (Object)unlockedString);
            String warpName = unlockWarp;
            ConfigurationSection config = warpConfig.getConfigurationSection(unlockWarp);
            if (config != null) {
                warpName = config.getString("name", warpName);
            }
            String unlockMessage = this.getMessage("unlock_warp").replace("$name", warpName);
            this.sendMessage(unlockMessage);
            return SpellResult.DEACTIVATE;
        }
        if (parameters.contains("lock")) {
            String lockWarp = parameters.getString("lock");
            if (!unlockedWarps.contains(lockWarp)) {
                return SpellResult.NO_ACTION;
            }
            unlockedWarps.remove(lockWarp);
            unlockedString = StringUtils.join(unlockedWarps, (String)",");
            mage.getData().set(UNLOCKED_WARPS, (Object)unlockedString);
            return SpellResult.DEACTIVATE;
        }
        Location playerLocation = mage.getLocation();
        this.allowCrossWorld = parameters.getBoolean("cross_world", true);
        for (RecallType testType : RecallType.values()) {
            if (testType == RecallType.WARP) {
                if (warpConfig == null) continue;
                Set warpKeys = warpConfig.getKeys(false);
                for (String warpKey : warpKeys) {
                    ConfigurationSection config = warpConfig.getConfigurationSection(warpKey);
                    boolean isLocked = config.getBoolean("locked", false);
                    if (isLocked && !unlockedWarps.contains(warpKey)) continue;
                    this.warps.put(warpKey, config);
                }
                continue;
            }
            if (!parameters.getBoolean("allow_" + testType.name().toLowerCase(), true)) continue;
            this.enabledTypes.add(testType);
        }
        if (this.warps.size() > 0) {
            this.enabledTypes.add(RecallType.WARP);
        }
        if (parameters.contains("warp")) {
            String warpName = parameters.getString("warp");
            Waypoint waypoint = this.getWarp(warpName);
            if (this.tryTeleport(player, waypoint)) {
                return SpellResult.CAST;
            }
            return SpellResult.FAIL;
        }
        if (parameters.contains("type")) {
            String typeString = parameters.getString("type", "");
            if (typeString.equalsIgnoreCase("remove")) {
                if (this.removeMarker()) {
                    return SpellResult.TARGET_SELECTED;
                }
                return SpellResult.FAIL;
            }
            if (typeString.equalsIgnoreCase("place")) {
                if (this.placeMarker(this.getLocation().getBlock())) {
                    return SpellResult.TARGET_SELECTED;
                }
                return SpellResult.FAIL;
            }
            RecallType recallType = RecallType.valueOf(typeString.toUpperCase());
            if (recallType == null) {
                controller.getLogger().warning("Unknown recall type " + typeString);
                return SpellResult.FAIL;
            }
            Waypoint location = this.getWaypoint(player, recallType, 0, parameters);
            if (this.tryTeleport(player, location)) {
                return SpellResult.CAST;
            }
            return SpellResult.FAIL;
        }
        LinkedList<Waypoint> allWaypoints = new LinkedList<Waypoint>();
        for (RecallType selectedType : this.enabledTypes) {
            Waypoint targetLocation;
            if (selectedType == RecallType.WARP) {
                for (String warpKey : this.warps.keySet()) {
                    targetLocation = this.getWarp(warpKey);
                    if (targetLocation == null || !targetLocation.isValid(this.allowCrossWorld, playerLocation)) continue;
                    allWaypoints.add(targetLocation);
                }
                continue;
            }
            if (selectedType == RecallType.WAND) {
                List<LostWand> lostWands = mage.getLostWands();
                for (int i = 0; i < lostWands.size(); ++i) {
                    targetLocation = this.getWaypoint(player, selectedType, i, parameters);
                    if (targetLocation == null || !targetLocation.isValid(this.allowCrossWorld, playerLocation)) continue;
                    allWaypoints.add(targetLocation);
                }
                continue;
            }
            Waypoint targetLocation2 = this.getWaypoint(player, selectedType, 0, parameters);
            if (targetLocation2 == null || !targetLocation2.isValid(this.allowCrossWorld, playerLocation)) continue;
            allWaypoints.add(targetLocation2);
        }
        if (allWaypoints.size() == 0) {
            return SpellResult.NO_TARGET;
        }
        this.options.clear();
        Collections.sort(allWaypoints);
        String inventoryTitle = this.getMessage("title", "Recall");
        int invSize = (allWaypoints.size() + 9) / 9 * 9;
        Inventory displayInventory = CompatibilityUtils.createInventory(null, invSize, inventoryTitle);
        int index = 0;
        for (Waypoint waypoint : allWaypoints) {
            ItemMeta meta;
            ItemStack waypointItem = null;
            waypointItem = controller.isUrlIconsEnabled() && waypoint.iconURL != null && !waypoint.iconURL.isEmpty() ? InventoryUtils.getURLSkull(waypoint.iconURL) : waypoint.icon.getItemStack(1);
            ItemMeta itemMeta = meta = waypointItem == null ? null : waypointItem.getItemMeta();
            if (meta == null) {
                waypointItem = new ItemStack(DefaultWaypointMaterial);
                meta = waypointItem.getItemMeta();
                controller.getLogger().warning("Invalid waypoint icon for " + waypoint.name);
            }
            meta.setDisplayName(waypoint.name);
            if (waypoint.description != null && waypoint.description.length() > 0) {
                ArrayList<String> lore = new ArrayList<String>();
                lore.add(waypoint.description);
                meta.setLore(lore);
            }
            waypointItem.setItemMeta(meta);
            displayInventory.setItem(index, waypointItem);
            this.options.put(index, waypoint);
            ++index;
        }
        mage.activateGUI(this);
        mage.getPlayer().openInventory(displayInventory);
        return SpellResult.CAST;
    }

    protected Waypoint getWarp(String warpKey) {
        if (this.warps == null) {
            return null;
        }
        ConfigurationSection config = this.warps.get(warpKey);
        if (config == null) {
            return null;
        }
        MageController controller = this.getController();
        String warpName = config.getString("name", warpKey);
        String castMessage = this.getMessage("cast_warp").replace("$name", warpName);
        String failMessage = this.getMessage("no_target_warp").replace("$name", warpName);
        String title = this.getMessage("title_warp").replace("$name", warpName);
        String description = config.getString("description");
        String iconURL = config.getString("icon_url");
        MaterialAndData icon = ConfigurationUtils.getMaterialAndData(config, "icon");
        return new Waypoint(controller.getWarp(warpKey), title, castMessage, failMessage, description, icon, iconURL);
    }

    protected Waypoint getWaypoint(Player player, RecallType type, int index, ConfigurationSection parameters) {
        Mage mage = this.getMage();
        switch (type) {
            case MARKER: {
                Location location = ConfigurationUtils.getLocation(mage.getData(), MARKER_KEY);
                return new Waypoint(location, this.getMessage("title_marker"), this.getMessage("cast_marker"), this.getMessage("no_target_marker"), this.getMessage("description_marker", ""), ConfigurationUtils.getMaterialAndData(parameters, "icon_marker"));
            }
            case DEATH: {
                return new Waypoint(mage.getLastDeathLocation(), "Last Death", this.getMessage("cast_death"), this.getMessage("no_target_death"), this.getMessage("description_death", ""), ConfigurationUtils.getMaterialAndData(parameters, "icon_death"));
            }
            case SPAWN: {
                return new Waypoint(this.getWorld().getSpawnLocation(), this.getMessage("title_spawn"), this.getMessage("cast_spawn"), this.getMessage("no_target_spawn"), this.getMessage("description_spawn", ""), ConfigurationUtils.getMaterialAndData(parameters, "icon_spawn"));
            }
            case HOME: {
                return new Waypoint(player == null ? null : player.getBedSpawnLocation(), this.getMessage("title_home"), this.getMessage("cast_home"), this.getMessage("no_target_home"), this.getMessage("description_home", ""), ConfigurationUtils.getMaterialAndData(parameters, "icon_home"));
            }
            case WAND: {
                List<LostWand> lostWands = mage.getLostWands();
                if (lostWands == null || index < 0 || index >= lostWands.size()) {
                    return null;
                }
                return new Waypoint(lostWands.get(index).getLocation(), this.getMessage("title_wand"), this.getMessage("cast_wand"), this.getMessage("no_target_wand"), this.getMessage("description_wand", ""), ConfigurationUtils.getMaterialAndData(parameters, "icon_wand"));
            }
        }
        return null;
    }

    protected boolean removeMarker() {
        Mage mage = this.getMage();
        Location location = ConfigurationUtils.getLocation(mage.getData(), MARKER_KEY);
        if (location == null) {
            return false;
        }
        this.getMage().getData().set(MARKER_KEY, null);
        return true;
    }

    protected boolean tryTeleport(final Player player, final Waypoint waypoint) {
        Location targetLocation;
        Mage mage = this.getMage();
        Location location = targetLocation = waypoint == null ? null : waypoint.location;
        if (targetLocation == null) {
            if (waypoint != null) {
                this.sendMessage(waypoint.failMessage);
            }
            return false;
        }
        if (!this.allowCrossWorld && !mage.getLocation().getWorld().equals(targetLocation.getWorld())) {
            this.sendMessage(this.getMessage("cross_world_disallowed"));
            return false;
        }
        MageController controller = this.getController();
        Chunk chunk = targetLocation.getBlock().getChunk();
        if (!chunk.isLoaded()) {
            chunk.load(true);
            if (this.retryCount < MAX_RETRY_COUNT) {
                Plugin plugin = controller.getPlugin();
                final RecallAction me = this;
                Bukkit.getScheduler().scheduleSyncDelayedTask(plugin, new Runnable(){

                    @Override
                    public void run() {
                        me.tryTeleport(player, waypoint);
                    }
                }, (long)RETRY_INTERVAL);
                return true;
            }
        }
        this.setTarget(targetLocation);
        this.playEffects("teleport");
        this.registerMoved((Entity)player);
        Location playerLocation = player.getLocation();
        targetLocation.setYaw(playerLocation.getYaw());
        targetLocation.setPitch(playerLocation.getPitch());
        player.teleport(this.tryFindPlaceToStand(targetLocation));
        this.castMessage(waypoint.message);
        return true;
    }

    protected boolean placeMarker(Block target) {
        if (target == null) {
            return false;
        }
        Mage mage = this.getMage();
        Location location = ConfigurationUtils.getLocation(mage.getData(), MARKER_KEY);
        this.registerForUndo(new UndoMarkerMove(mage, location));
        if (location != null) {
            this.sendMessage(this.getMessage("cast_marker_move"));
        } else {
            this.sendMessage(this.getMessage("cast_marker_place"));
        }
        location = this.getLocation();
        location.setX((double)target.getX());
        location.setY((double)target.getY());
        location.setZ((double)target.getZ());
        this.getMage().getData().set(MARKER_KEY, (Object)ConfigurationUtils.fromLocation(location));
        return true;
    }

    @Override
    public void load(ConfigurationSection node) {
        Location location = ConfigurationUtils.getLocation(node, "location");
        if (location != null) {
            this.getMage().getData().set(MARKER_KEY, (Object)ConfigurationUtils.fromLocation(location));
        }
    }

    private class Waypoint
    implements Comparable<Waypoint> {
        public final String name;
        public final String description;
        public final Location location;
        public final String message;
        public final String failMessage;
        public final MaterialAndData icon;
        public final String iconURL;

        public Waypoint(Location location, String name, String message, String failMessage, String description, MaterialAndData icon) {
            this.name = name;
            this.location = location;
            this.message = message;
            this.description = description;
            this.failMessage = failMessage;
            this.icon = icon == null ? defaultMaterial : icon;
            this.iconURL = null;
        }

        public Waypoint(Location location, String name, String message, String failMessage, String description, MaterialAndData icon, String iconURL) {
            this.name = name;
            this.location = location;
            this.message = message;
            this.description = description;
            this.failMessage = failMessage;
            this.icon = icon == null ? defaultMaterial : icon;
            this.iconURL = iconURL;
        }

        public Waypoint(Location location, String name, String message, String failMessage, MaterialAndData icon) {
            this.name = name;
            this.location = location;
            this.message = message;
            this.description = "";
            this.failMessage = failMessage;
            this.icon = icon == null ? defaultMaterial : icon;
            this.iconURL = null;
        }

        public Waypoint(Location location, String name, String message, String failMessage) {
            this.name = name;
            this.location = location;
            this.message = message;
            this.description = "";
            this.failMessage = failMessage;
            this.icon = defaultMaterial;
            this.iconURL = null;
        }

        @Override
        public int compareTo(Waypoint o) {
            return this.name.compareTo(o.name);
        }

        public boolean isValid(boolean crossWorld, Location source) {
            if (this.location == null || this.location.getWorld() == null) {
                return false;
            }
            return crossWorld || source.getWorld().equals(this.location.getWorld());
        }
    }

    private static enum RecallType {
        MARKER,
        DEATH,
        SPAWN,
        HOME,
        WAND,
        WARP;

    }

    private class UndoMarkerMove
    implements Runnable {
        private final Location location;
        private final Mage mage;

        public UndoMarkerMove(Mage mage, Location currentLocation) {
            this.location = currentLocation;
            this.mage = mage;
        }

        @Override
        public void run() {
            this.mage.getData().set(MARKER_KEY, (Object)ConfigurationUtils.fromLocation(this.location));
        }
    }
}

