/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.api.action.BlockAction;
import com.elmakers.mine.bukkit.api.block.MaterialBrush;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.spell.CompoundAction;
import java.util.Arrays;
import java.util.Collection;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.util.Vector;

public class IterateAction
extends CompoundAction
implements BlockAction {
    private int DEFAULT_SIZE = 16;

    @Override
    public SpellResult perform(ConfigurationSection parameters, Block target) {
        Mage mage = this.getMage();
        boolean incrementData = parameters.getBoolean("increment_data", false);
        int radius = parameters.getInt("radius", 0);
        int size = parameters.getInt("size", this.DEFAULT_SIZE);
        boolean reverse = parameters.getBoolean("reverse", false);
        boolean requireBlock = parameters.getBoolean("require_block", false);
        size = (int)(mage.getConstructionMultiplier() * (float)size);
        int iterateBlocks = (int)this.getLocation().distance(target.getLocation());
        if (iterateBlocks <= 0) {
            return SpellResult.NO_TARGET;
        }
        iterateBlocks = Math.min(iterateBlocks, size);
        Vector targetLoc = new Vector(target.getX(), target.getY(), target.getZ());
        Vector playerLoc = this.getEyeLocation().toVector();
        Vector aim = null;
        if (reverse) {
            aim = playerLoc;
            aim.subtract(targetLoc);
            aim.normalize();
        } else {
            aim = targetLoc;
            aim.subtract(playerLoc);
            aim.normalize();
            targetLoc = playerLoc;
            targetLoc.add(aim);
            targetLoc.add(aim);
        }
        MaterialBrush buildWith = this.getBrush();
        buildWith.setTarget(target.getLocation());
        buildWith.update(mage, target.getLocation());
        for (int dr = 0; dr <= radius; ++dr) {
            int spokes = 1;
            if (dr > 0) {
                spokes = dr * 8;
            }
            for (int dspoke = 0; dspoke < spokes; ++dspoke) {
                Vector currentLoc = targetLoc.clone();
                if (dr > 0) {
                    double y;
                    double z;
                    Vector perp;
                    Vector axis;
                    double q = (double)dspoke * Math.PI * 2.0 / (double)spokes;
                    if (aim.getY() > 0.7) {
                        axis = new Vector(1, 0, 0);
                        perp = aim.clone().crossProduct(axis).multiply(dr);
                        double x = perp.getZ() * Math.sin(q) - perp.getX() * Math.cos(q);
                        z = perp.getZ() * Math.cos(q) - perp.getX() * Math.sin(q);
                        perp.setX(x);
                        perp.setZ(z);
                        currentLoc.add(perp);
                    } else if (aim.getX() > 0.7) {
                        axis = new Vector(0, 1, 0);
                        perp = aim.clone().crossProduct(axis).multiply(dr);
                        y = perp.getZ() * Math.sin(q) - perp.getY() * Math.cos(q);
                        z = perp.getZ() * Math.cos(q) - perp.getY() * Math.sin(q);
                        perp.setY(y);
                        perp.setZ(z);
                        currentLoc.add(perp);
                    } else {
                        axis = new Vector(0, 1, 0);
                        perp = aim.clone().crossProduct(axis).multiply(dr);
                        y = perp.getX() * Math.sin(q) - perp.getY() * Math.cos(q);
                        double x = perp.getX() * Math.cos(q) - perp.getY() * Math.sin(q);
                        perp.setY(y);
                        perp.setX(x);
                        currentLoc.add(perp);
                    }
                }
                for (int i = 0; i < iterateBlocks; ++i) {
                    Block currentTarget = target.getWorld().getBlockAt(currentLoc.getBlockX(), currentLoc.getBlockY(), currentLoc.getBlockZ());
                    if (!this.isTargetable(currentTarget.getType()) && this.isDestructible(currentTarget) && this.hasBuildPermission(currentTarget)) {
                        Block lowerBlock;
                        buildWith.update(mage, currentTarget.getLocation());
                        if (incrementData) {
                            short data = (short)(i > 15 ? 15 : (short)i);
                            buildWith.setData(data);
                        }
                        if (requireBlock && ((lowerBlock = currentTarget.getRelative(BlockFace.DOWN)).getType() == Material.AIR || lowerBlock.getType() == buildWith.getMaterial())) {
                            currentLoc.add(aim);
                            continue;
                        }
                        SpellResult result = this.perform(parameters, currentTarget.getLocation());
                        if (dr == 0 && this.usesBrush()) {
                            Location effectLocation = currentTarget.getLocation();
                            effectLocation.add(0.5, 0.5, 0.5);
                            Material material = buildWith.getMaterial();
                            if (material == Material.AIR) {
                                effectLocation.getWorld().playEffect(effectLocation, Effect.STEP_SOUND, Material.OBSIDIAN.getId());
                            } else {
                                effectLocation.getWorld().playEffect(effectLocation, Effect.STEP_SOUND, material.getId());
                            }
                        }
                    }
                    currentLoc.add(aim);
                }
            }
        }
        return SpellResult.CAST;
    }

    @Override
    public void getParameterNames(Collection<String> parameters) {
        super.getParameterNames(parameters);
        parameters.add("radius");
        parameters.add("size");
        parameters.add("increment_data");
        parameters.add("require_block");
        parameters.add("reverse");
    }

    @Override
    public void getParameterOptions(Collection<String> examples, String parameterKey) {
        if (parameterKey.equals("increment_data") || parameterKey.equals("reverse") || parameterKey.equals("require_block")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_BOOLEANS));
        } else if (parameterKey.equals("radius") || parameterKey.equals("size")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_SIZES));
        } else {
            super.getParameterOptions(examples, parameterKey);
        }
    }
}

