/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.api.action.EntityAction;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.spell.BaseSpellAction;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import java.util.Arrays;
import java.util.Collection;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class DamageAction
extends BaseSpellAction
implements EntityAction {
    @Override
    public SpellResult perform(ConfigurationSection parameters, Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return SpellResult.NO_TARGET;
        }
        double damage = parameters.getDouble("damage", 1.0);
        LivingEntity targetEntity = (LivingEntity)entity;
        this.registerModified((Entity)targetEntity);
        Mage mage = this.getMage();
        MageController controller = this.getController();
        if (controller.isElemental(entity)) {
            damage = parameters.getDouble("elemental_damage", damage);
            controller.damageElemental(entity, damage, 0, mage.getCommandSender());
        } else {
            damage = targetEntity instanceof Player ? parameters.getDouble("player_damage", damage) : parameters.getDouble("entity_damage", damage);
            CompatibilityUtils.magicDamage(targetEntity, damage * (double)mage.getDamageMultiplier(), mage.getEntity());
        }
        return SpellResult.CAST;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    @Override
    public void getParameterNames(Collection<String> parameters) {
        super.getParameterNames(parameters);
        parameters.add("damage");
        parameters.add("player_damage");
        parameters.add("entity_damage");
        parameters.add("elemental_damage");
    }

    @Override
    public void getParameterOptions(Collection<String> examples, String parameterKey) {
        if (parameterKey.equals("damage") || parameterKey.equals("player_damage") || parameterKey.equals("entity_damage") || parameterKey.equals("elemental_damage")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_SIZES));
        } else {
            super.getParameterOptions(examples, parameterKey);
        }
    }
}

