/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.api.action.BlockAction;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.CompoundAction;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;

public class CoverAction
extends CompoundAction
implements BlockAction {
    private static final int DEFAULT_RADIUS = 2;

    @Override
    public SpellResult perform(ConfigurationSection parameters, Block block) {
        if (!this.hasBuildPermission(block)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        Mage mage = this.getMage();
        int radius = parameters.getInt("radius", 2);
        radius = (int)(mage.getRadiusMultiplier() * (float)radius);
        block = this.findSpaceAbove(block);
        if (radius < 1) {
            return this.perform(parameters, this.findBlockUnder(block).getLocation());
        }
        SpellResult result = SpellResult.NO_ACTION;
        int y = block.getY();
        for (int dx = -radius; dx < radius; ++dx) {
            for (int dz = -radius; dz < radius; ++dz) {
                if (!this.isInCircle(dx, dz, radius)) continue;
                int x = block.getX() + dx;
                int z = block.getZ() + dz;
                Block targetBlock = this.getWorld().getBlockAt(x, y, z);
                targetBlock = this.findBlockUnder(targetBlock);
                Block coveringBlock = targetBlock.getRelative(BlockFace.UP);
                if (this.isTransparent(targetBlock.getType()) || !this.isTransparent(coveringBlock.getType())) continue;
                this.actions.perform(parameters, targetBlock.getLocation());
            }
        }
        return result;
    }

    protected boolean isInCircle(int x, int z, int R) {
        return x * x + z * z - R * R <= 0;
    }
}

