/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell.builtin;

import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.spell.BlockSpell;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;

public class RaiseSpell
extends BlockSpell {
    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        Block targetBlock = this.getTargetBlock();
        if (targetBlock == null) {
            return SpellResult.NO_TARGET;
        }
        if (!this.isDestructible(targetBlock)) {
            return SpellResult.NO_TARGET;
        }
        if (!this.hasBuildPermission(targetBlock)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        BlockFace direction = BlockFace.UP;
        Block highestBlock = targetBlock;
        for (int distance = parameters.getInt("distance", 5); distance > 0; --distance) {
            if ((highestBlock = highestBlock.getRelative(direction)).getType() == Material.AIR) continue;
            return SpellResult.NO_TARGET;
        }
        if (!this.hasBuildPermission(highestBlock)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        MaterialAndData blockState = new MaterialAndData(targetBlock);
        this.registerForUndo(targetBlock);
        this.registerForUndo(highestBlock);
        targetBlock.setType(Material.AIR);
        blockState.modify(highestBlock);
        highestBlock.setMetadata("breakable", (MetadataValue)new FixedMetadataValue(this.controller.getPlugin(), (Object)1));
        highestBlock.setMetadata("reflect_chance", (MetadataValue)new FixedMetadataValue(this.controller.getPlugin(), (Object)1));
        this.registerForUndo();
        return SpellResult.CAST;
    }
}

