/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell.builtin;

import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.block.UndoList;
import com.elmakers.mine.bukkit.block.batch.SimpleBlockAction;
import com.elmakers.mine.bukkit.spell.BlockSpell;
import com.elmakers.mine.bukkit.utility.Target;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;

@Deprecated
public class FireSpell
extends BlockSpell {
    private static final int DEFAULT_RADIUS = 4;
    private static final int DEFAULT_ELEMENTAL_DAMAGE = 5;
    private static final int DEFAULT_ELEMENTAL_FIRE_TICKS = 200;

    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        Target target = this.getTarget();
        if (target == null || !target.isValid()) {
            return SpellResult.NO_TARGET;
        }
        Block targetBlock = target.getBlock();
        if (!this.hasBuildPermission(targetBlock)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        Entity entity = target.getEntity();
        if (entity != null && this.controller.isElemental(entity)) {
            this.controller.damageElemental(entity, parameters.getDouble("elemental_damage", 5.0), parameters.getInt("fire_ticks", 200), this.mage.getCommandSender());
        }
        if (entity != null) {
            this.registerModified(entity);
        }
        int radius = parameters.getInt("radius", 4);
        radius = (int)(this.mage.getRadiusMultiplier() * (float)radius);
        FireAction action = new FireAction(this, this.getUndoList());
        if (radius < 1) {
            action.perform(parameters, this.findBlockUnder(targetBlock));
        } else {
            this.coverSurface(target.getLocation(), radius, action);
        }
        this.registerForUndo();
        return SpellResult.CAST;
    }

    public int checkPosition(int x, int z, int R) {
        return x * x + z * z - R * R;
    }

    public class FireAction
    extends SimpleBlockAction {
        public FireAction(Spell spell, UndoList undoList) {
            super(spell, undoList);
        }

        @Override
        public SpellResult perform(ConfigurationSection parameters, Block block) {
            if (block.getType() == Material.AIR || block.getType() == Material.FIRE || block.getType() == Material.WATER || block.getType() == Material.STATIONARY_WATER) {
                return SpellResult.NO_TARGET;
            }
            Material material = Material.FIRE;
            if (block.getType() == Material.ICE || block.getType() == Material.SNOW) {
                material = Material.AIR;
            } else {
                block = block.getRelative(BlockFace.UP);
            }
            if (block.getType() == Material.FIRE || block.getType() == Material.WATER || block.getType() == Material.STATIONARY_WATER) {
                return SpellResult.NO_TARGET;
            }
            super.perform(parameters, block);
            MaterialAndData applyMaterial = new MaterialAndData(material);
            applyMaterial.modify(block);
            return SpellResult.CAST;
        }
    }
}

