/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell;

import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.spell.TargetType;
import com.elmakers.mine.bukkit.block.UndoList;
import com.elmakers.mine.bukkit.spell.TargetingSpell;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.Target;
import java.util.Collection;
import java.util.List;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.potion.PotionEffect;

public abstract class UndoableSpell
extends TargetingSpell {
    private UndoList modifiedBlocks = null;
    private boolean undoEntityEffects = false;
    private boolean bypassUndo = false;
    private double targetBreakables = 0.0;
    private int autoUndo = 0;

    @Override
    protected void processParameters(ConfigurationSection parameters) {
        super.processParameters(parameters);
        this.undoEntityEffects = parameters.getBoolean("entity_undo", false);
        this.bypassUndo = parameters.getBoolean("bypass_undo", false);
        this.bypassUndo = parameters.getBoolean("bu", this.bypassUndo);
        this.autoUndo = parameters.getInt("undo", 0);
        this.autoUndo = parameters.getInt("u", this.autoUndo);
        this.targetBreakables = parameters.getDouble("target_breakables", 0.0);
        this.bypassUndo = parameters.getBoolean("bypass_undo", false);
    }

    @Override
    protected void loadTemplate(ConfigurationSection node) {
        super.loadTemplate(node);
        ConfigurationSection parameters = node.getConfigurationSection("parameters");
        if (parameters != null) {
            this.bypassUndo = parameters.getBoolean("bypass_undo", false);
            this.bypassUndo = parameters.getBoolean("bu", this.bypassUndo);
            this.autoUndo = parameters.getInt("undo", 0);
            this.autoUndo = parameters.getInt("u", this.autoUndo);
        }
    }

    @Override
    protected void reset() {
        super.reset();
        this.modifiedBlocks = null;
    }

    public int getModifiedCount() {
        return this.modifiedBlocks == null ? 0 : this.modifiedBlocks.size();
    }

    public void registerForUndo() {
        UndoList list = this.getUndoList();
        this.controller.update(list);
        this.mage.registerForUndo(list);
    }

    public void registerForUndo(Block block) {
        this.getUndoList().add(block, true);
    }

    public void registerForUndo(Block block, boolean addNeighbors) {
        this.getUndoList().add(block, addNeighbors);
    }

    public void registerForUndo(Runnable runnable) {
        this.getUndoList().add(runnable);
    }

    public void registerForUndo(Entity entity) {
        this.getUndoList().add(entity);
    }

    public void registerModified(Entity entity) {
        this.getUndoList().modify(entity);
    }

    public void registerPotionEffects(Entity entity) {
        this.getUndoList().addPotionEffects(entity);
    }

    public void registerMoved(Entity entity) {
        this.getUndoList().move(entity);
    }

    public void registerVelocity(Entity entity) {
        this.getUndoList().modifyVelocity(entity);
    }

    public void watch(Entity entity) {
        if (entity == null) {
            return;
        }
        this.getUndoList().watch(entity);
    }

    public UndoList getUndoList() {
        if (this.modifiedBlocks == null) {
            this.modifiedBlocks = new UndoList(this.mage, this, this.getName());
            this.modifiedBlocks.setEntityUndo(this.undoEntityEffects);
            this.modifiedBlocks.setBypass(this.bypassUndo);
            this.modifiedBlocks.setScheduleUndo(this.autoUndo);
        }
        return this.modifiedBlocks;
    }

    public boolean contains(Block block) {
        return this.modifiedBlocks.contains(block);
    }

    public int getScheduledUndo() {
        return this.autoUndo;
    }

    @Override
    public boolean isUndoable() {
        return !this.bypassUndo;
    }

    public void applyPotionEffects(Location location, int radius, Collection<PotionEffect> potionEffects) {
        if (potionEffects == null || radius <= 0 || potionEffects.size() == 0) {
            return;
        }
        int radiusSquared = radius * 2;
        List<Entity> entities = CompatibilityUtils.getNearbyEntities(location, radius, radius, radius);
        for (Entity entity : entities) {
            String playerMessage;
            boolean isSourcePlayer;
            if (!(entity instanceof LivingEntity)) continue;
            Mage targetMage = null;
            if (this.controller.isMage(entity)) {
                targetMage = this.controller.getMage(entity);
            }
            boolean bl = isSourcePlayer = entity == this.mage.getEntity();
            if (isSourcePlayer && this.getTargetType() != TargetType.ANY && this.getTargetType() != TargetType.SELF || targetMage != null && this.isSuperProtected(targetMage) && !isSourcePlayer || !this.canTarget(entity) || !(entity.getLocation().distanceSquared(location) < (double)radiusSquared)) continue;
            this.registerPotionEffects(entity);
            CompatibilityUtils.applyPotionEffects((LivingEntity)entity, potionEffects);
            if (targetMage == null || (playerMessage = this.getMessage("cast_player_message")).length() <= 0) continue;
            playerMessage = playerMessage.replace("$spell", this.getName());
            targetMage.sendMessage(playerMessage);
        }
    }

    protected void breakBlock(Block block, int recursion) {
        if (!block.hasMetadata("breakable")) {
            return;
        }
        Location effectLocation = block.getLocation().add(0.5, 0.5, 0.5);
        effectLocation.getWorld().playEffect(effectLocation, Effect.STEP_SOUND, block.getType().getId());
        UndoList undoList = this.getUndoList();
        if (undoList != null) {
            undoList.add(block);
        }
        block.removeMetadata("breakable", this.mage.getController().getPlugin());
        block.removeMetadata("backfire", this.mage.getController().getPlugin());
        block.setType(Material.AIR);
        if (--recursion > 0) {
            this.breakBlock(block.getRelative(BlockFace.UP), recursion);
            this.breakBlock(block.getRelative(BlockFace.DOWN), recursion);
            this.breakBlock(block.getRelative(BlockFace.EAST), recursion);
            this.breakBlock(block.getRelative(BlockFace.WEST), recursion);
            this.breakBlock(block.getRelative(BlockFace.NORTH), recursion);
            this.breakBlock(block.getRelative(BlockFace.SOUTH), recursion);
        }
    }

    @Override
    protected Target getTarget() {
        int breakable;
        Block block;
        Target target = super.getTarget();
        if (this.targetBreakables > 0.0 && target.isValid() && (block = this.getCurBlock()) != null && block.hasMetadata("breakable") && (breakable = (int)(this.targetBreakables > 1.0 ? this.targetBreakables : (double)(random.nextDouble() < this.targetBreakables ? 1 : 0))) > 0) {
            List metadata = block.getMetadata("breakable");
            for (MetadataValue value : metadata) {
                if (!value.getOwningPlugin().equals(this.controller.getPlugin())) continue;
                this.breakBlock(block, value.asInt() + breakable - 1);
                break;
            }
        }
        return target;
    }

    @Override
    public long getDuration() {
        if (!this.bypassUndo && this.autoUndo != 0) {
            return this.autoUndo;
        }
        return super.getDuration();
    }
}

