/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell;

import com.elmakers.mine.bukkit.api.action.BlockAction;
import com.elmakers.mine.bukkit.api.action.EntityAction;
import com.elmakers.mine.bukkit.api.action.GeneralAction;
import com.elmakers.mine.bukkit.api.action.SpellAction;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.spell.MageSpell;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.BaseSpellAction;
import com.elmakers.mine.bukkit.spell.TargetingSpell;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.Target;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;

public class ActionHandler {
    private static final String ACTION_BUILTIN_CLASSPATH = "com.elmakers.mine.bukkit.action.builtin";
    private List<SpellAction> allActions = new ArrayList<SpellAction>();
    private List<GeneralAction> generalActions = new ArrayList<GeneralAction>();
    private List<BlockAction> blockActions = new ArrayList<BlockAction>();
    private List<EntityAction> entityActions = new ArrayList<EntityAction>();
    private final Spell spell;
    private boolean undoable = false;
    private boolean usesBrush = false;
    private boolean requiresBuildPermission = false;
    private ConfigurationSection parameters = null;

    public ActionHandler(Spell spell) {
        this.spell = spell;
    }

    public void setParameters(ConfigurationSection parameters) {
        this.parameters = parameters;
    }

    public void load(ConfigurationSection root, String key) {
        this.undoable = false;
        this.usesBrush = false;
        this.requiresBuildPermission = false;
        Collection<ConfigurationSection> actionNodes = ConfigurationUtils.getNodeList(root, key);
        if (actionNodes != null) {
            for (ConfigurationSection actionConfiguration : actionNodes) {
                if (!actionConfiguration.contains("class")) continue;
                String actionClassName = actionConfiguration.getString("class");
                try {
                    Class<?> genericClass;
                    if (!actionClassName.contains(".")) {
                        actionClassName = "com.elmakers.mine.bukkit.action.builtin." + actionClassName;
                    }
                    if (!BaseSpellAction.class.isAssignableFrom(genericClass = Class.forName(actionClassName))) {
                        throw new Exception("Must extend SpellAction");
                    }
                    Class<?> actionClass = genericClass;
                    BaseSpellAction action = (BaseSpellAction)actionClass.newInstance();
                    actionConfiguration.set("class", null);
                    if (actionConfiguration.getKeys(false).size() == 0) {
                        actionConfiguration = null;
                    }
                    this.loadAction(action, actionConfiguration);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public void loadAction(SpellAction action) {
        this.loadAction(action, (ConfigurationSection)new MemoryConfiguration());
    }

    public void loadAction(SpellAction action, ConfigurationSection parameters) {
        action.initialize(this.spell, parameters);
        this.allActions.add(action);
        this.usesBrush = this.usesBrush || action.usesBrush();
        this.undoable = this.undoable || action.isUndoable();
        boolean bl = this.requiresBuildPermission = this.requiresBuildPermission || action.requiresBuildPermission();
        if (action instanceof GeneralAction) {
            this.generalActions.add((GeneralAction)action);
        }
        if (action instanceof EntityAction) {
            this.entityActions.add((EntityAction)action);
        }
        if (action instanceof BlockAction) {
            this.blockActions.add((BlockAction)action);
        }
    }

    public SpellResult perform(ConfigurationSection parameters) {
        this.spell.target();
        Location targetLocation = this.spell.getTargetLocation();
        ArrayList<Entity> targetEntities = new ArrayList<Entity>();
        Entity targetedEntity = this.spell.getTargetEntity();
        int targetCount = parameters.getInt("target_count", 1);
        if (targetedEntity != null && targetCount != 0) {
            targetEntities.add(targetedEntity);
        }
        if (targetCount != 1 && this.spell instanceof TargetingSpell) {
            List<Target> entities = ((TargetingSpell)this.spell).getAllTargetEntities();
            if (targetCount < 0) {
                targetCount = entities.size();
            }
            for (int i = 1; i < targetCount && i < entities.size(); ++i) {
                targetEntities.add(entities.get(i).getEntity());
            }
        }
        return this.perform(parameters, targetLocation, targetEntities);
    }

    public SpellResult perform(ConfigurationSection parameters, Location targetLocation, Collection<Entity> targetEntities) {
        Entity sourceEntity = null;
        Location sourceLocation = this.spell.getLocation();
        if (this.spell instanceof MageSpell) {
            Mage mage = ((MageSpell)this.spell).getMage();
            sourceEntity = mage.getEntity();
        }
        return this.perform(parameters, sourceLocation, sourceEntity, targetLocation, targetEntities);
    }

    public SpellResult perform(ConfigurationSection parameters, Location targetLocation) {
        return this.perform(parameters, targetLocation, (Entity)null);
    }

    public SpellResult perform(ConfigurationSection parameters, Location targetLocation, Entity targetEntity) {
        Entity sourceEntity = null;
        Location sourceLocation = this.spell.getLocation();
        if (this.spell instanceof MageSpell) {
            Mage mage = ((MageSpell)this.spell).getMage();
            sourceEntity = mage.getEntity();
        }
        ArrayList<Entity> targetEntities = new ArrayList<Entity>();
        if (targetEntity != null) {
            targetEntities.add(targetEntity);
        }
        return this.perform(parameters, sourceLocation, sourceEntity, targetLocation, targetEntities);
    }

    public SpellResult perform(Location targetLocation, Entity targetEntity) {
        return this.perform(null, targetLocation, targetEntity);
    }

    public SpellResult perform(Location sourceLocation, Entity sourceEntity, Location targetLocation, Entity targetEntity) {
        ArrayList<Entity> targetEntities = new ArrayList<Entity>();
        targetEntities.add(targetEntity);
        return this.perform(null, sourceLocation, sourceEntity, targetLocation, targetEntities);
    }

    public SpellResult perform(ConfigurationSection parameters, Location sourceLocation, Entity sourceEntity, Location targetLocation, Collection<Entity> targetEntities) {
        SpellResult actionResult;
        SpellResult result = SpellResult.NO_ACTION;
        if (this.parameters != null) {
            parameters = ConfigurationUtils.addConfigurations(this.parameters, parameters, true);
        }
        for (SpellAction spellAction : this.allActions) {
            spellAction.prepare(parameters);
        }
        for (GeneralAction generalAction : this.generalActions) {
            actionResult = generalAction.perform(generalAction.getParameters(parameters));
            result = result.min(actionResult);
        }
        if (targetLocation != null) {
            for (BlockAction blockAction : this.blockActions) {
                actionResult = blockAction.perform(blockAction.getParameters(parameters), targetLocation.getBlock());
                result = result.min(actionResult);
            }
        }
        if ((targetEntities == null || targetEntities.size() == 0) && this.entityActions.size() > 0) {
            result = SpellResult.NO_TARGET.min(result);
        }
        if (targetEntities != null) {
            for (Entity entity : targetEntities) {
                for (EntityAction action : this.entityActions) {
                    SpellResult actionResult2 = action.perform(action.getParameters(parameters), entity);
                    result = result.min(actionResult2);
                }
            }
        }
        for (SpellAction spellAction : this.allActions) {
            spellAction.finish(parameters);
        }
        return result;
    }

    public boolean isUndoable() {
        return this.undoable;
    }

    public boolean usesBrush() {
        return this.usesBrush;
    }

    public boolean requiresBuildPermission() {
        return this.requiresBuildPermission;
    }

    public void getParameterNames(Collection<String> parameters) {
        for (SpellAction action : this.allActions) {
            action.getParameterNames(parameters);
        }
    }

    public void getParameterOptions(Collection<String> examples, String parameterKey) {
        for (SpellAction action : this.allActions) {
            action.getParameterOptions(examples, parameterKey);
        }
    }

    public String transformMessage(String message) {
        for (SpellAction action : this.allActions) {
            message = action.transformMessage(message);
        }
        return message;
    }

    public static void setActions(Entity entity, ActionHandler actions, String messageKey) {
        if (actions != null && entity != null) {
            entity.setMetadata("actions", (MetadataValue)new FixedMetadataValue(actions.spell.getController().getPlugin(), (Object)actions));
        }
        if (messageKey != null && entity != null && actions != null) {
            entity.setMetadata("message", (MetadataValue)new FixedMetadataValue(actions.spell.getController().getPlugin(), (Object)messageKey));
        }
    }

    public static boolean hasActions(Entity entity) {
        return entity != null && entity.hasMetadata("actions");
    }

    public static void runActions(Entity entity, Location targetLocation, Entity targetEntity) {
        MetadataValue metadata;
        Object value;
        if (!ActionHandler.hasActions(entity)) {
            return;
        }
        ActionHandler actions = null;
        for (MetadataValue metadata2 : entity.getMetadata("actions")) {
            Object meta = metadata2.value();
            if (!(meta instanceof ActionHandler)) continue;
            actions = (ActionHandler)meta;
            break;
        }
        if (actions == null) {
            return;
        }
        Spell spell = actions.spell;
        String messageKey = null;
        Iterator i$ = entity.getMetadata("message").iterator();
        if (i$.hasNext() && (value = (metadata = (MetadataValue)i$.next()).value()) instanceof String) {
            messageKey = (String)value;
        }
        actions.perform(entity.getLocation(), entity, targetLocation, targetEntity);
        spell.messageTargets(messageKey);
        entity.removeMetadata("actions", spell.getController().getPlugin());
        entity.removeMetadata("message", spell.getController().getPlugin());
    }

    public static boolean hasEffects(Entity entity) {
        return entity != null && entity.hasMetadata("spell") && entity.hasMetadata("effects");
    }

    public static void runEffects(Entity entity) {
        MetadataValue metadata;
        Object value;
        if (!ActionHandler.hasEffects(entity)) {
            return;
        }
        String effectKey = null;
        Spell spell = null;
        Iterator i$ = entity.getMetadata("effects").iterator();
        if (i$.hasNext() && (value = (metadata = (MetadataValue)i$.next()).value()) instanceof String) {
            effectKey = (String)value;
        }
        if ((i$ = entity.getMetadata("spell").iterator()).hasNext() && (value = (metadata = (MetadataValue)i$.next()).value()) instanceof Spell) {
            spell = (Spell)value;
        }
        if (spell == null || effectKey == null || effectKey.isEmpty()) {
            return;
        }
        spell.playEffects(effectKey, 1.0f, entity.getLocation(), entity, spell.getTargetLocation(), spell.getTargetEntity());
        entity.removeMetadata("spell", spell.getController().getPlugin());
        entity.removeMetadata("effects", spell.getController().getPlugin());
    }

    public static void setEffects(Entity entity, Spell spell, String key) {
        if (key != null && spell != null && entity != null) {
            entity.setMetadata("spell", (MetadataValue)new FixedMetadataValue(spell.getController().getPlugin(), (Object)spell));
            entity.setMetadata("effects", (MetadataValue)new FixedMetadataValue(spell.getController().getPlugin(), (Object)key));
        }
    }

    public String toString() {
        return "ActionHandler [" + this.allActions.size() + "]";
    }
}

