/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.slikey.effectlib.effect;

import com.elmakers.mine.bukkit.slikey.effectlib.EffectManager;
import com.elmakers.mine.bukkit.slikey.effectlib.EffectType;
import com.elmakers.mine.bukkit.slikey.effectlib.effect.LocationEffect;
import com.elmakers.mine.bukkit.slikey.effectlib.util.ParticleEffect;
import com.elmakers.mine.bukkit.slikey.effectlib.util.VectorUtils;
import org.bukkit.Location;
import org.bukkit.util.Vector;

public class VortexLocationEffect
extends LocationEffect {
    public ParticleEffect particle = ParticleEffect.FLAME;
    public float radius = 2.0f;
    public float grow = 0.05f;
    public double radials = 0.19634954084936207;
    public int circles = 3;
    public int helixes = 4;
    protected int step = 0;

    public VortexLocationEffect(EffectManager effectManager, Location location) {
        super(effectManager, location);
        this.type = EffectType.REPEATING;
        this.period = 1;
        this.iterations = 200;
    }

    @Override
    public void onRun() {
        for (int x = 0; x < this.circles; ++x) {
            for (int i = 0; i < this.helixes; ++i) {
                double angle = (double)this.step * this.radials + Math.PI * 2 * (double)i / (double)this.helixes;
                Vector v = new Vector(Math.cos(angle) * (double)this.radius, (double)((float)this.step * this.grow), Math.sin(angle) * (double)this.radius);
                VectorUtils.rotateAroundAxisX(v, (this.location.getPitch() + 90.0f) * ((float)Math.PI / 180));
                VectorUtils.rotateAroundAxisY(v, -this.location.getYaw() * ((float)Math.PI / 180));
                this.location.add(v);
                this.particle.display(this.location, this.visibleRange);
                this.location.subtract(v);
            }
            ++this.step;
        }
    }
}

