/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.api.action.GeneralAction;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.ActionHandler;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.spell.BaseSpellAction;
import java.util.Arrays;
import java.util.Collection;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.util.Vector;

public class TNTAction
extends BaseSpellAction
implements GeneralAction {
    private ActionHandler actions = null;

    @Override
    public SpellResult perform(ConfigurationSection parameters) {
        Location loc;
        Mage mage = this.getMage();
        MageController controller = this.getController();
        int size = parameters.getInt("size", 6);
        int count = parameters.getInt("count", 1);
        size = (int)(mage.getRadiusMultiplier() * (float)size);
        int fuse = parameters.getInt("fuse", 80);
        boolean useFire = parameters.getBoolean("fire", false);
        boolean breakBlocks = parameters.getBoolean("break_blocks", true);
        if (this.actions != null) {
            this.actions.setParameters(parameters);
        }
        if ((loc = this.getEyeLocation()) == null) {
            return SpellResult.LOCATION_REQUIRED;
        }
        if (!this.hasBuildPermission(loc.getBlock())) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        Random rand = new Random();
        for (int i = 0; i < count; ++i) {
            TNTPrimed grenade;
            Location targetLoc = loc.clone();
            if (count > 1) {
                targetLoc.setX(targetLoc.getX() + (double)rand.nextInt(2 * count) - (double)count);
                targetLoc.setZ(targetLoc.getZ() + (double)rand.nextInt(2 * count) - (double)count);
            }
            if ((grenade = (TNTPrimed)this.getWorld().spawnEntity(targetLoc, EntityType.PRIMED_TNT)) == null) {
                return SpellResult.FAIL;
            }
            Vector aim = this.getDirection();
            grenade.setVelocity(aim);
            grenade.setYield((float)size);
            grenade.setFuseTicks(fuse);
            grenade.setIsIncendiary(useFire);
            this.registerForUndo((Entity)grenade);
            if (!breakBlocks) {
                grenade.setMetadata("cancel_explosion", (MetadataValue)new FixedMetadataValue(controller.getPlugin(), (Object)true));
            }
            ActionHandler.setActions((Entity)grenade, this.actions, "indirect_player_message");
            ActionHandler.setEffects((Entity)grenade, this.getSpell(), "explode");
        }
        return SpellResult.CAST;
    }

    @Override
    public void initialize(Spell spell, ConfigurationSection template) {
        super.initialize(spell, template);
        if (template != null && template.contains("actions")) {
            this.actions = new ActionHandler(this.getSpell());
            this.actions.load(template, "actions");
        }
    }

    @Override
    public void getParameterNames(Collection<String> parameters) {
        super.getParameterNames(parameters);
        parameters.add("size");
        parameters.add("count");
        parameters.add("fuse");
        parameters.add("fire");
        parameters.add("break_blocks");
    }

    @Override
    public void getParameterOptions(Collection<String> examples, String parameterKey) {
        if (parameterKey.equals("fire") || parameterKey.equals("break_blocks")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_BOOLEANS));
        } else if (parameterKey.equals("size") || parameterKey.equals("count") || parameterKey.equals("fuse")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_SIZES));
        } else {
            super.getParameterOptions(examples, parameterKey);
        }
    }

    @Override
    public boolean isUndoable() {
        return true;
    }
}

