/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell.builtin;

import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.UndoableSpell;
import com.elmakers.mine.bukkit.utility.Target;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;

public class GenericSpell
extends UndoableSpell {
    private boolean undoDamage = false;
    private boolean undoVelocity = false;
    private boolean undoMovement = false;

    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        Target target = this.getTarget();
        if (!target.hasTarget()) {
            return SpellResult.NO_TARGET;
        }
        if (target.hasEntity()) {
            Entity entity = target.getEntity();
            this.undoDamage = parameters.getBoolean("undo_damage", false);
            this.undoVelocity = parameters.getBoolean("undo_velocity", false);
            this.undoMovement = parameters.getBoolean("undo_movement", false);
            if (this.undoDamage || this.undoVelocity || this.undoMovement) {
                if (this.undoDamage) {
                    this.registerModified(entity);
                }
                if (this.undoVelocity) {
                    this.registerVelocity(entity);
                }
                if (this.undoMovement) {
                    this.registerMoved(entity);
                }
                this.registerForUndo();
            }
        }
        return SpellResult.CAST;
    }

    @Override
    protected void loadTemplate(ConfigurationSection node) {
        super.loadTemplate(node);
        ConfigurationSection parameters = node.getConfigurationSection("parameters");
        this.undoMovement = parameters.getBoolean("undo_movement", false);
        this.undoVelocity = parameters.getBoolean("undo_velocity", false);
        this.undoDamage = parameters.getBoolean("undo_damage", false);
    }

    @Override
    public boolean isUndoable() {
        return super.isUndoable() && (this.undoMovement || this.undoVelocity || this.undoDamage);
    }
}

