/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell;

import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.ActionHandler;
import com.elmakers.mine.bukkit.spell.BrushSpell;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;

public class ActionSpell
extends BrushSpell {
    private Map<String, ActionHandler> actions = new HashMap<String, ActionHandler>();
    private boolean undoable = false;

    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        ActionHandler downHandler;
        if (this.undoable) {
            this.registerForUndo();
        }
        if ((downHandler = this.actions.get("alternate_down")) != null && this.isLookingDown()) {
            return SpellResult.ALTERNATE_DOWN.max(downHandler.perform(parameters));
        }
        ActionHandler upHandler = this.actions.get("alternate_up");
        if (upHandler != null && this.isLookingUp()) {
            return SpellResult.ALTERNATE_UP.max(upHandler.perform(parameters));
        }
        ActionHandler sneakHandler = this.actions.get("alternate_sneak");
        if (sneakHandler != null && this.mage.isSneaking()) {
            return SpellResult.ALTERNATE_SNEAK.max(sneakHandler.perform(parameters));
        }
        ActionHandler castHandler = this.actions.get("cast");
        if (castHandler != null) {
            return castHandler.perform(parameters);
        }
        return SpellResult.CAST;
    }

    @Override
    protected void loadTemplate(ConfigurationSection template) {
        this.usesBrush = false;
        this.undoable = false;
        this.castOnNoTarget = true;
        if (template.contains("actions")) {
            ConfigurationSection actionsNode = template.getConfigurationSection("actions");
            Set actionKeys = actionsNode.getKeys(false);
            for (String actionKey : actionKeys) {
                ActionHandler handler = new ActionHandler(this);
                handler.load(actionsNode, actionKey);
                this.usesBrush = this.usesBrush || handler.usesBrush();
                this.undoable = this.undoable || handler.isUndoable();
                this.actions.put(actionKey, handler);
            }
        }
        this.undoable = template.getBoolean("undoable", this.undoable);
        super.loadTemplate(template);
    }

    @Override
    public boolean isUndoable() {
        return this.undoable;
    }

    public ActionHandler getActions(String key) {
        return this.actions.get(key);
    }

    @Override
    public void getParameters(Collection<String> parameters) {
        super.getParameters(parameters);
        for (ActionHandler handler : this.actions.values()) {
            handler.getParameterNames(parameters);
        }
    }

    @Override
    public void getParameterOptions(Collection<String> examples, String parameterKey) {
        super.getParameterOptions(examples, parameterKey);
        for (ActionHandler handler : this.actions.values()) {
            handler.getParameterOptions(examples, parameterKey);
        }
    }

    @Override
    public String getMessage(String messageKey, String def) {
        String message = super.getMessage(messageKey, def);
        for (ActionHandler handler : this.actions.values()) {
            message = handler.transformMessage(message);
        }
        return message;
    }
}

