/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.api.action.BlockAction;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.spell.BaseSpellAction;
import java.util.Arrays;
import java.util.Collection;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;

public class TorchAction
extends BaseSpellAction
implements BlockAction {
    @Override
    public SpellResult perform(ConfigurationSection parameters, Block target) {
        boolean useLightstone;
        boolean isAttachmentSlippery;
        Block face = this.getPreviousBlock();
        if (face == null) {
            return SpellResult.NO_TARGET;
        }
        if (!this.hasBuildPermission(target)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        boolean bl = isAttachmentSlippery = target.getType() == Material.GLASS || target.getType() == Material.ICE;
        if (isAttachmentSlippery) {
            return SpellResult.NO_TARGET;
        }
        Material torchType = parameters.getBoolean("redstone_torch", false) ? Material.REDSTONE_TORCH_ON : Material.TORCH;
        boolean isAir = face.getType() == Material.AIR;
        boolean replaceAttachment = target.getType() == Material.SNOW || target.getType() == Material.SNOW_BLOCK;
        boolean isWater = face.getType() == Material.STATIONARY_WATER || face.getType() == Material.WATER;
        boolean isNether = target.getType() == Material.NETHERRACK || target.getType() == Material.SOUL_SAND;
        MaterialAndData targetMaterial = new MaterialAndData(torchType);
        boolean allowLightstone = parameters.getBoolean("allow_glowstone", false);
        if (isNether && allowLightstone) {
            targetMaterial.setMaterial(Material.GLOWSTONE);
            replaceAttachment = true;
        }
        if (useLightstone = parameters.getBoolean("glowstone_torch", false)) {
            targetMaterial.setMaterial(Material.GLOWSTONE);
            allowLightstone = true;
        }
        if (isWater) {
            targetMaterial.setMaterial(Material.GLOWSTONE);
        }
        if (!isAir && !isWater) {
            return SpellResult.NO_TARGET;
        }
        if (targetMaterial.getMaterial() == torchType) {
            BlockFace direction = face.getFace(target);
            switch (direction) {
                case WEST: {
                    targetMaterial.setData((short)1);
                    break;
                }
                case EAST: {
                    targetMaterial.setData((short)2);
                    break;
                }
                case NORTH: {
                    targetMaterial.setData((short)3);
                    break;
                }
                case SOUTH: {
                    targetMaterial.setData((short)4);
                    break;
                }
                case DOWN: {
                    targetMaterial.setData((short)5);
                    break;
                }
                default: {
                    targetMaterial.setMaterial(Material.GLOWSTONE);
                }
            }
        }
        if (!allowLightstone && targetMaterial.getMaterial() == Material.GLOWSTONE) {
            return SpellResult.NO_TARGET;
        }
        if (!replaceAttachment) {
            target = face;
        }
        this.registerForUndo(target);
        targetMaterial.modify(target);
        this.updateBlock(target);
        return SpellResult.CAST;
    }

    @Override
    public void getParameterNames(Collection<String> parameters) {
        super.getParameterNames(parameters);
        parameters.add("redstone_torch");
        parameters.add("allow_glowstone");
    }

    @Override
    public void getParameterOptions(Collection<String> examples, String parameterKey) {
        if (parameterKey.equals("redstone_torch") || parameterKey.equals("allow_glowstone")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_BOOLEANS));
        } else {
            super.getParameterOptions(examples, parameterKey);
        }
    }

    @Override
    public boolean isUndoable() {
        return true;
    }
}

