/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.api.action.GeneralAction;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.spell.BaseSpellAction;
import java.util.Arrays;
import java.util.Collection;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;

public class TimeAction
extends BaseSpellAction
implements GeneralAction {
    private String timeType = "day";

    @Override
    public SpellResult perform(ConfigurationSection parameters) {
        long currentTime;
        World world = this.getWorld();
        if (world == null) {
            return SpellResult.WORLD_REQUIRED;
        }
        long targetTime = 0L;
        this.timeType = parameters.getString("time", "day");
        if (this.timeType.equalsIgnoreCase("toggle")) {
            currentTime = world.getTime();
            this.timeType = currentTime > 13000L ? "day" : "night";
        }
        if (this.timeType.equalsIgnoreCase("night")) {
            targetTime = 13000L;
        } else {
            try {
                targetTime = Long.parseLong(this.timeType);
                this.timeType = "raw(" + targetTime + ")";
            }
            catch (NumberFormatException ex) {
                targetTime = 0L;
            }
        }
        if (parameters.getBoolean("cycle_moon_phase", false)) {
            currentTime = world.getFullTime();
            currentTime = (currentTime % 24000L + 1L) * 24000L + targetTime;
            world.setFullTime(currentTime);
            return SpellResult.CAST;
        }
        world.setTime(targetTime);
        return SpellResult.CAST;
    }

    @Override
    public String transformMessage(String message) {
        return message.replace("$time", this.timeType);
    }

    @Override
    public void getParameterNames(Collection<String> parameters) {
        super.getParameterNames(parameters);
        parameters.add("time");
    }

    @Override
    public void getParameterOptions(Collection<String> examples, String parameterKey) {
        if (parameterKey.equals("time")) {
            examples.add("day");
            examples.add("night");
            examples.add("toggle");
            examples.add("0");
            examples.add("130000");
        } else if (parameterKey.equals("cycle_moon_phase")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_BOOLEANS));
        } else {
            super.getParameterOptions(examples, parameterKey);
        }
    }
}

