/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.api.action.BlockAction;
import com.elmakers.mine.bukkit.api.action.EntityAction;
import com.elmakers.mine.bukkit.api.action.GeneralAction;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.spell.BaseSpellAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;

public class CommandAction
extends BaseSpellAction
implements EntityAction,
GeneralAction,
BlockAction {
    public static final String[] PARAMETERS = new String[]{"command", "console", "op", "radius"};
    private List<String> commands = new ArrayList<String>();
    private List<String> entityCommands = new ArrayList<String>();
    private List<String> blockCommands = new ArrayList<String>();

    protected void addCommand(String command) {
        if (command.contains("@td") || command.contains("@tn") || command.contains("@tuuid")) {
            this.entityCommands.add(command);
        } else if (command.contains("@t")) {
            this.blockCommands.add(command);
        } else {
            this.commands.add(command);
        }
    }

    protected void addCommands(Collection<String> commands) {
        for (String command : commands) {
            this.addCommand(command);
        }
    }

    @Override
    public void prepare(ConfigurationSection parameters) {
        super.prepare(parameters);
        this.commands = new ArrayList<String>();
        this.entityCommands = new ArrayList<String>();
        this.blockCommands = new ArrayList<String>();
        if (parameters.contains("command")) {
            String command = parameters.getString("command");
            if (command != null && command.length() > 0) {
                this.addCommand(command);
            }
        } else {
            this.addCommands(parameters.getStringList("commands"));
        }
    }

    protected String parameterize(String command) {
        Location location = this.getLocation();
        Mage mage = this.getMage();
        command = command.replace("@_", " ").replace("@spell", this.getSpell().getName()).replace("@pd", mage.getDisplayName()).replace("@pn", mage.getName()).replace("@uuid", mage.getId());
        if (location != null) {
            command = command.replace("@world", location.getWorld().getName()).replace("@x", Double.toString(location.getX())).replace("@y", Double.toString(location.getY())).replace("@z", Double.toString(location.getZ()));
        }
        return command;
    }

    protected String parameterize(String command, Location targetLocation) {
        return command.replace("@tworld", targetLocation.getWorld().getName()).replace("@tx", Double.toString(targetLocation.getX())).replace("@ty", Double.toString(targetLocation.getY())).replace("@tz", Double.toString(targetLocation.getZ()));
    }

    protected String parameterize(String command, Entity targetEntity) {
        MageController controller = this.getController();
        if (controller.isMage(targetEntity)) {
            Mage targetMage = controller.getMage(targetEntity);
            return command.replace("@td", targetMage.getDisplayName()).replace("@tn", targetMage.getName()).replace("@tuuid", targetMage.getId());
        }
        return command.replace("@td", controller.getEntityDisplayName(targetEntity)).replace("@tn", controller.getEntityName(targetEntity)).replace("@tuuid", targetEntity.getUniqueId().toString());
    }

    @Override
    public SpellResult perform(ConfigurationSection parameters) {
        SpellResult result = SpellResult.NO_ACTION;
        for (String command : this.commands) {
            String converted = this.parameterize(command);
            result = result.min(this.perform(converted, parameters));
        }
        return result;
    }

    @Override
    public SpellResult perform(ConfigurationSection parameters, Block block) {
        SpellResult result = SpellResult.NO_ACTION;
        for (String command : this.blockCommands) {
            String converted = this.parameterize(command);
            converted = this.parameterize(converted, block.getLocation());
            result = result.min(this.perform(converted, parameters));
        }
        return result;
    }

    @Override
    public SpellResult perform(ConfigurationSection parameters, Entity entity) {
        SpellResult result = SpellResult.NO_ACTION;
        for (String command : this.entityCommands) {
            String converted = this.parameterize(command);
            converted = this.parameterize(converted, entity.getLocation());
            converted = this.parameterize(converted, entity);
            result = result.min(this.perform(converted, parameters));
        }
        return result;
    }

    protected SpellResult perform(String command, ConfigurationSection parameters) {
        ConsoleCommandSender sender;
        Mage mage = this.getMage();
        boolean asConsole = parameters.getBoolean("console", false);
        Object object = sender = asConsole ? Bukkit.getConsoleSender() : mage.getCommandSender();
        if (sender == null) {
            return SpellResult.FAIL;
        }
        boolean opPlayer = parameters.getBoolean("op", false);
        boolean isOp = sender.isOp();
        if (opPlayer && !isOp) {
            sender.setOp(true);
        }
        MageController controller = this.getController();
        try {
            controller.getPlugin().getServer().dispatchCommand((CommandSender)sender, command);
        }
        catch (Exception ex) {
            controller.getLogger().log(Level.WARNING, "Error running command: " + command, ex);
        }
        if (opPlayer && !isOp) {
            sender.setOp(false);
        }
        return SpellResult.CAST;
    }

    @Override
    public void getParameterNames(Collection<String> parameters) {
        super.getParameterNames(parameters);
        parameters.addAll(Arrays.asList(PARAMETERS));
    }

    @Override
    public void getParameterOptions(Collection<String> examples, String parameterKey) {
        super.getParameterOptions(examples, parameterKey);
        if (parameterKey.equals("command")) {
            examples.add("spawn");
            examples.add("clear");
        } else if (parameterKey.equals("console")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_BOOLEANS));
        } else if (parameterKey.equals("op")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_BOOLEANS));
        }
    }
}

