/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.api.action.BlockAction;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.CompoundAction;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.Target;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;

public class AreaOfEffectAction
extends CompoundAction
implements BlockAction {
    @Override
    public SpellResult perform(ConfigurationSection parameters, Block block) {
        int radius = parameters.getInt("radius", 8);
        boolean targetSelf = parameters.getBoolean("target_self", false);
        int targetCount = parameters.getInt("target_count", -1);
        Mage mage = this.getMage();
        Entity sourceEntity = null;
        Spell spell = this.getSpell();
        Location sourceLocation = block.getLocation();
        if (mage != null) {
            radius = (int)(mage.getRadiusMultiplier() * (float)radius);
            sourceEntity = mage.getEntity();
        }
        List<Entity> entities = CompatibilityUtils.getNearbyEntities(sourceLocation, radius, radius, radius);
        ArrayList<Entity> targetEntities = new ArrayList<Entity>();
        if (targetCount > 0) {
            ArrayList<Target> targets = new ArrayList<Target>();
            for (Entity entity : entities) {
                if (!targetSelf && entity == sourceEntity || !spell.canTarget(entity)) continue;
                targets.add(new Target(sourceLocation, entity, radius));
            }
            Collections.sort(targets);
            for (Target target : targets) {
                if (targetEntities.size() < targetCount) {
                    targetEntities.add(target.getEntity());
                    continue;
                }
                break;
            }
        } else {
            for (Entity entity : entities) {
                if (!targetSelf && entity == sourceEntity || !spell.canTarget(entity)) continue;
                targetEntities.add(entity);
            }
        }
        return this.perform(parameters, block.getLocation(), targetEntities);
    }
}

