/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility;

import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.slikey.effectlib.util.ParticleEffect;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.SoundEffect;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.util.Vector;

public class ConfigurationUtils {
    public static Random random = new Random();

    public static Location getLocation(ConfigurationSection node, String path) {
        String stringData = node.getString(path);
        if (stringData == null) {
            return null;
        }
        return ConfigurationUtils.toLocation(stringData);
    }

    public static BlockFace toBlockFace(String s) {
        BlockFace face = null;
        try {
            face = BlockFace.valueOf((String)s.toUpperCase());
        }
        catch (Exception ex) {
            face = null;
        }
        return face;
    }

    public static String fromBlockFace(BlockFace face) {
        return face.name().toLowerCase();
    }

    public static String fromVector(Vector vector) {
        if (vector == null) {
            return "";
        }
        return vector.getX() + "," + vector.getY() + "," + vector.getZ();
    }

    public static Vector getVector(ConfigurationSection node, String path) {
        String stringData = node.getString(path);
        if (stringData == null) {
            return null;
        }
        return ConfigurationUtils.toVector(stringData);
    }

    public static Material getMaterial(ConfigurationSection node, String path, Material def) {
        String stringData = node.getString(path);
        if (stringData == null) {
            return def;
        }
        return ConfigurationUtils.toMaterial(stringData);
    }

    public static MaterialAndData getMaterialAndData(ConfigurationSection node, String path) {
        return ConfigurationUtils.getMaterialAndData(node, path, null);
    }

    public static MaterialAndData getMaterialAndData(ConfigurationSection node, String path, MaterialAndData def) {
        String stringData = node.getString(path);
        if (stringData == null) {
            return def;
        }
        return ConfigurationUtils.toMaterialAndData(stringData);
    }

    public static Material getMaterial(ConfigurationSection node, String path) {
        return ConfigurationUtils.getMaterial(node, path, null);
    }

    public static Collection<ConfigurationSection> getNodeList(ConfigurationSection node, String path) {
        ArrayList<ConfigurationSection> results = new ArrayList<ConfigurationSection>();
        List mapList = node.getMapList(path);
        for (Map map : mapList) {
            results.add(ConfigurationUtils.toNodeList(map));
        }
        return results;
    }

    public static ConfigurationSection toNodeList(Map<?, ?> nodeMap) {
        MemoryConfiguration newSection = new MemoryConfiguration();
        for (Map.Entry<?, ?> entry : nodeMap.entrySet()) {
            ConfigurationUtils.set((ConfigurationSection)newSection, entry.getKey().toString(), entry.getValue());
        }
        return newSection;
    }

    public static String fromLocation(Location location) {
        if (location == null) {
            return "";
        }
        if (location.getWorld() == null) {
            return "";
        }
        return location.getX() + "," + location.getY() + "," + location.getZ() + "," + location.getWorld().getName() + "," + location.getYaw() + "," + location.getPitch();
    }

    public static String fromMaterial(Material material) {
        return material.name().toLowerCase();
    }

    public static String fromBlock(Block block) {
        return ConfigurationUtils.fromLocation(block.getLocation()) + "|" + block.getTypeId() + ":" + block.getData();
    }

    public static Location toLocation(Object o) {
        if (o instanceof Location) {
            return (Location)o;
        }
        if (o instanceof String) {
            try {
                float pitch = 0.0f;
                float yaw = 0.0f;
                String[] pieces = StringUtils.split((String)((String)o), (char)',');
                double x = Double.parseDouble(pieces[0]);
                double y = Double.parseDouble(pieces[1]);
                double z = Double.parseDouble(pieces[2]);
                World world = null;
                world = pieces.length > 3 ? Bukkit.getWorld((String)pieces[3]) : (World)Bukkit.getWorlds().get(0);
                if (pieces.length > 5) {
                    yaw = Float.parseFloat(pieces[4]);
                    pitch = Float.parseFloat(pieces[5]);
                }
                return new Location(world, x, y, z, yaw, pitch);
            }
            catch (Exception ex) {
                return null;
            }
        }
        return null;
    }

    public static Vector toVector(Object o) {
        if (o instanceof Vector) {
            return (Vector)o;
        }
        if (o instanceof String) {
            try {
                String[] pieces = StringUtils.split((String)((String)o), (char)',');
                double x = Double.parseDouble(pieces[0]);
                double y = Double.parseDouble(pieces[1]);
                double z = Double.parseDouble(pieces[2]);
                return new Vector(x, y, z);
            }
            catch (Exception ex) {
                return null;
            }
        }
        return null;
    }

    public static Material toMaterial(Object o) {
        if (o instanceof Material) {
            return (Material)o;
        }
        if (o instanceof Integer) {
            return Material.values()[(Integer)o];
        }
        if (o instanceof String) {
            String matName = (String)o;
            try {
                Integer value = Integer.parseInt(matName);
                if (value != null) {
                    return Material.getMaterial((int)value);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return Material.getMaterial((String)matName.toUpperCase());
        }
        return null;
    }

    public static MaterialAndData toMaterialAndData(Object o) {
        if (o instanceof MaterialAndData) {
            return (MaterialAndData)o;
        }
        if (o instanceof String) {
            String matName = (String)o;
            Material material = null;
            byte data = 0;
            String[] pieces = StringUtils.split((String)matName, (char)':');
            if (pieces.length > 0) {
                if (pieces.length > 1) {
                    try {
                        data = Byte.parseByte(pieces[1]);
                    }
                    catch (NumberFormatException ex) {
                        data = 0;
                    }
                }
                try {
                    Integer value = Integer.parseInt(pieces[0]);
                    if (value != null) {
                        material = Material.getMaterial((int)value);
                    }
                }
                catch (NumberFormatException ex) {
                    material = Material.getMaterial((String)pieces[0].toUpperCase());
                }
            }
            if (material == null) {
                return null;
            }
            return new MaterialAndData(material, data);
        }
        return null;
    }

    public static Set<Material> getMaterials(ConfigurationSection node, String key) {
        List materialData = node.getStringList(key);
        if (materialData == null) {
            return null;
        }
        HashSet<Material> materials = new HashSet<Material>();
        for (String matName : materialData) {
            Material material = ConfigurationUtils.toMaterial(matName);
            if (material == null) continue;
            materials.add(material);
        }
        return materials;
    }

    public static Set<Material> parseMaterials(String csv) {
        String[] nameList = StringUtils.split((String)csv, (char)',');
        HashSet<Material> materials = new HashSet<Material>();
        for (String matName : nameList) {
            Material material = ConfigurationUtils.toMaterial(matName);
            if (material == null) continue;
            materials.add(material);
        }
        return materials;
    }

    protected void combine(Map<Object, Object> to, Map<? extends Object, Object> from) {
        for (Map.Entry<? extends Object, Object> entry : from.entrySet()) {
            Object toValue;
            Object value = entry.getValue();
            Object key = entry.getKey();
            if (value instanceof Map && to.containsKey(key) && (toValue = to.get(key)) instanceof Map) {
                this.combine((Map)toValue, (Map)value);
                continue;
            }
            to.put(key, value);
        }
    }

    public static ConfigurationSection addConfigurations(ConfigurationSection first, ConfigurationSection second) {
        return ConfigurationUtils.addConfigurations(first, second, true);
    }

    public static ConfigurationSection addConfigurations(ConfigurationSection first, ConfigurationSection second, boolean override) {
        if (second == null) {
            return first;
        }
        Set keys = second.getKeys(false);
        for (String key : keys) {
            Object value = second.get(key);
            if (value == null) continue;
            Object existingValue = first.get(key);
            if (value instanceof ConfigurationSection && (existingValue == null || existingValue instanceof ConfigurationSection)) {
                ConfigurationSection addChild = (ConfigurationSection)value;
                if (existingValue == null) {
                    ConfigurationSection newChild = first.createSection(key);
                    ConfigurationUtils.addConfigurations(newChild, addChild, override);
                    continue;
                }
                ConfigurationUtils.addConfigurations((ConfigurationSection)existingValue, addChild, override);
                continue;
            }
            if (!override && existingValue != null) continue;
            first.set(key, value);
        }
        return first;
    }

    protected static double parseDouble(String s) {
        char firstChar = s.charAt(0);
        if (firstChar == 'r' || firstChar == 'R') {
            String[] pieces = StringUtils.split((String)s, (String)"(,)");
            try {
                double min = Double.parseDouble(pieces[1]);
                double max = Double.parseDouble(pieces[2]);
                return random.nextDouble() * (max - min) + min;
            }
            catch (Exception ex) {
                Bukkit.getLogger().warning("Failed to parse: " + s);
                ex.printStackTrace();
            }
        }
        try {
            return Double.parseDouble(s);
        }
        catch (Exception ex) {
            Bukkit.getLogger().warning("Failed to parse as double: " + s);
            ex.printStackTrace();
            return 0.0;
        }
    }

    protected static double overrideDouble(ConfigurationSection node, double value, String nodeName) {
        String override = node.getString(nodeName);
        if (override == null || override.length() == 0) {
            return value;
        }
        try {
            if (override.startsWith("~")) {
                override = override.substring(1);
                value += ConfigurationUtils.parseDouble(override);
            } else if (override.startsWith("*")) {
                override = override.substring(1);
                value *= ConfigurationUtils.parseDouble(override);
            } else {
                value = ConfigurationUtils.parseDouble(override);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return value;
    }

    public static World overrideWorld(ConfigurationSection node, String path, World world, boolean canCreateWorlds) {
        return ConfigurationUtils.overrideWorld(node.getString(path), world, canCreateWorlds);
    }

    public static World overrideWorld(String worldName, World world, boolean canCreateWorlds) {
        World worldOverride;
        if (worldName == null || worldName.length() == 0) {
            return null;
        }
        if (worldName.charAt(0) == '~') {
            if (world == null) {
                return null;
            }
            String baseWorld = world.getName();
            worldName = worldName.substring(1);
            if ((worldName = worldName.trim()).charAt(0) == '-') {
                worldName = worldName.substring(1);
                worldName = worldName.trim();
                worldName = baseWorld.replace(worldName, "");
            } else {
                worldName = baseWorld + worldName;
            }
        }
        if ((worldOverride = Bukkit.getWorld((String)worldName)) == null) {
            if (canCreateWorlds) {
                Bukkit.getLogger().info("Creating/Loading world: " + worldName);
                worldOverride = Bukkit.createWorld((WorldCreator)new WorldCreator(worldName).copy(world));
                if (worldOverride == null) {
                    Bukkit.getLogger().warning("Failed to load world: " + worldName);
                    return null;
                }
            } else {
                Bukkit.getLogger().warning("Could not load world: " + worldName);
                return null;
            }
        }
        return worldOverride;
    }

    public static Location overrideLocation(ConfigurationSection node, String basePath, Location location, boolean canCreateWorlds) {
        String xName = basePath + "x";
        String yName = basePath + "y";
        String zName = basePath + "z";
        String dxName = basePath + "dx";
        String dyName = basePath + "dy";
        String dzName = basePath + "dz";
        boolean hasPosition = node.contains(xName) || node.contains(yName) || node.contains(zName);
        boolean hasDirection = node.contains(dxName) || node.contains(dyName) || node.contains(dzName);
        World baseWorld = location == null ? null : location.getWorld();
        World worldOverride = ConfigurationUtils.overrideWorld(node, basePath + "world", baseWorld, canCreateWorlds);
        if (!hasPosition && !hasDirection && worldOverride == null) {
            return null;
        }
        if (location == null) {
            if (worldOverride == null || !hasPosition) {
                return null;
            }
            location = new Location(worldOverride, 0.0, 0.0, 0.0);
        } else {
            location = location.clone();
            if (worldOverride != null) {
                location.setWorld(worldOverride);
            }
        }
        if (hasPosition) {
            location.setX(ConfigurationUtils.overrideDouble(node, location.getX(), xName));
            location.setY(ConfigurationUtils.overrideDouble(node, location.getY(), yName));
            location.setZ(ConfigurationUtils.overrideDouble(node, location.getZ(), zName));
        }
        if (hasDirection) {
            Vector direction = location.getDirection();
            direction.setX(ConfigurationUtils.overrideDouble(node, direction.getX(), dxName));
            direction.setY(ConfigurationUtils.overrideDouble(node, direction.getY(), dyName));
            direction.setZ(ConfigurationUtils.overrideDouble(node, direction.getZ(), dzName));
            CompatibilityUtils.setDirection(location, direction);
        }
        return location;
    }

    public static Color getColor(ConfigurationSection node, String path, Color def) {
        Color o = ConfigurationUtils.toColor(node.get(path));
        return o == null ? def : o;
    }

    public static Color toColor(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Byte) {
            return Color.fromRGB((int)((Byte)o).byteValue());
        }
        if (o instanceof Integer) {
            return Color.fromRGB((int)((Integer)o));
        }
        if (o instanceof Double) {
            return Color.fromRGB((int)((int)((Double)o).doubleValue()));
        }
        if (o instanceof Float) {
            return Color.fromRGB((int)((int)((Float)o).floatValue()));
        }
        if (o instanceof Long) {
            return Color.fromRGB((int)((int)((Long)o).longValue()));
        }
        if (o instanceof String) {
            try {
                String s = (String)o;
                if (s.length() == 0) {
                    return null;
                }
                if (s.charAt(0) == '#') {
                    s = s.substring(1, s.length());
                }
                Integer rgb = Integer.parseInt(s, 16);
                return Color.fromRGB((int)rgb);
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
        return null;
    }

    public static Integer getInteger(ConfigurationSection node, String path, Integer def) {
        if (node.contains(path)) {
            return node.getInt(path);
        }
        return def;
    }

    public static Double getDouble(ConfigurationSection node, String path, Double def) {
        if (node.contains(path)) {
            return ConfigurationUtils.parseDouble(node.getString(path));
        }
        return def;
    }

    public static Boolean getBoolean(ConfigurationSection node, String path, Boolean def) {
        if (node.contains(path)) {
            return node.getBoolean(path);
        }
        return def;
    }

    public static void set(ConfigurationSection node, String path, Object value) {
        boolean isTrue = value.equals("true");
        boolean isFalse = value.equals("false");
        if (isTrue || isFalse) {
            node.set(path, (Object)isTrue);
        } else {
            try {
                Double d = value instanceof Double ? (Double)value : (value instanceof Float ? (double)((Float)value).floatValue() : Double.parseDouble(value.toString()));
                node.set(path, (Object)d);
            }
            catch (Exception ex) {
                try {
                    Integer i = value instanceof Integer ? (Integer)value : Integer.parseInt(value.toString());
                    node.set(path, (Object)i);
                }
                catch (Exception ex2) {
                    node.set(path, value);
                }
            }
        }
    }

    public static List<Object> getList(ConfigurationSection section, String path) {
        Object o = section.get(path);
        if (o == null) {
            return null;
        }
        if (o instanceof List) {
            return (List)o;
        }
        if (o instanceof String) {
            return new ArrayList<Object>(Arrays.asList(StringUtils.split((String)((String)o), (char)',')));
        }
        ArrayList<Object> single = new ArrayList<Object>();
        single.add(o);
        return single;
    }

    public static List<String> getStringList(ConfigurationSection section, String path, List<String> def) {
        ArrayList list = ConfigurationUtils.getStringList(section, path);
        return list == null ? (def == null ? new ArrayList() : def) : list;
    }

    public static List<String> getStringList(ConfigurationSection section, String path) {
        List<Object> raw = ConfigurationUtils.getList(section, path);
        if (raw == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Object o : raw) {
            if (o == null) continue;
            list.add(o.toString());
        }
        return list;
    }

    public static List<Integer> getIntegerList(ConfigurationSection section, String path) {
        List<Object> raw = ConfigurationUtils.getList(section, path);
        if (raw == null) {
            return new ArrayList<Integer>();
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (Object o : raw) {
            Integer i = ConfigurationUtils.castInt(o);
            if (i == null) continue;
            list.add(i);
        }
        return list;
    }

    private static Integer castInt(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Byte) {
            return (int)((Byte)o);
        }
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof Double) {
            return (int)((Double)o).doubleValue();
        }
        if (o instanceof Float) {
            return (int)((Float)o).floatValue();
        }
        if (o instanceof Long) {
            return (int)((Long)o).longValue();
        }
        if (o instanceof String) {
            try {
                return Integer.parseInt((String)o);
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
        return null;
    }

    public static void addParameters(String[] extraParameters, ConfigurationSection parameters) {
        if (extraParameters != null) {
            for (int i = 0; i < extraParameters.length - 1; i += 2) {
                ConfigurationUtils.set(parameters, extraParameters[i], extraParameters[i + 1]);
            }
        }
    }

    public static SoundEffect toSoundEffect(String soundConfig) {
        SoundEffect soundEffect = null;
        if (soundConfig.length() > 0) {
            String[] pieces = StringUtils.split((String)soundConfig, (char)',');
            try {
                String soundName = pieces[0].toUpperCase();
                soundEffect = new SoundEffect(Sound.valueOf((String)soundName));
                if (pieces.length > 1) {
                    soundEffect.setVolume(Float.parseFloat(pieces[1]));
                }
                if (pieces.length > 2) {
                    soundEffect.setPitch(Float.parseFloat(pieces[2]));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return soundEffect;
    }

    public static ParticleEffect toParticleEffect(String effectParticleName) {
        ParticleEffect effectParticle = null;
        if (effectParticleName.length() > 0) {
            String particleName = effectParticleName.toUpperCase();
            try {
                effectParticle = ParticleEffect.valueOf(particleName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return effectParticle;
    }
}

