/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell.builtin;

import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.block.UndoList;
import com.elmakers.mine.bukkit.block.batch.SimpleBlockAction;
import com.elmakers.mine.bukkit.spell.BlockSpell;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.NMSUtils;
import com.elmakers.mine.bukkit.utility.Target;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.util.Vector;

public class FlowerSpell
extends BlockSpell {
    private static final int DEFAULT_RADIUS = 4;
    private final ArrayList<MaterialAndData> flowers = new ArrayList();
    private final ArrayList<MaterialAndData> tallFlowers = new ArrayList();

    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        Target target = this.getTarget();
        if (target == null || !target.isValid()) {
            return SpellResult.NO_TARGET;
        }
        Block targetBlock = target.getBlock();
        if (!this.hasBuildPermission(targetBlock)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        int radius = parameters.getInt("radius", 4);
        radius = (int)(this.mage.getRadiusMultiplier() * (float)radius);
        double itemSpeed = parameters.getDouble("item_speed");
        int ageItems = parameters.getInt("age_items", 5500);
        Block faceBlock = this.getInteractBlock();
        Location effectLocation = faceBlock == null ? this.mage.getEyeLocation() : faceBlock.getLocation();
        FlowerAction action = new FlowerAction(this, itemSpeed, effectLocation, this.getUndoList(), this.flowers, this.tallFlowers, ageItems);
        if (radius <= 1) {
            action.perform(parameters, targetBlock);
        } else {
            this.coverSurface(target.getLocation(), radius, action);
        }
        this.registerForUndo();
        return SpellResult.CAST;
    }

    @Override
    public void loadTemplate(ConfigurationSection template) {
        super.loadTemplate(template);
        this.flowers.clear();
        this.tallFlowers.clear();
        List flowerKeys = template.getStringList("flowers");
        for (String flowerKey : flowerKeys) {
            this.flowers.add(new MaterialAndData(flowerKey));
        }
        List tallFlowerKeys = template.getStringList("tall_flowers");
        for (String flowerKey : tallFlowerKeys) {
            this.tallFlowers.add(new MaterialAndData(flowerKey));
        }
    }

    public int checkPosition(int x, int z, int R) {
        return x * x + z * z - R * R;
    }

    public class FlowerAction
    extends SimpleBlockAction {
        private final ArrayList<MaterialAndData> flowers;
        private final ArrayList<MaterialAndData> tallFlowers;
        private final Random random;
        private final Location effectsLocation;
        private final double effectsSpeed;
        private final int ageItems;

        public FlowerAction(Spell spell, double itemSpeed, Location effectsLocation, UndoList undoList, ArrayList<MaterialAndData> flowers, ArrayList<MaterialAndData> tallFlowers, int ageItems) {
            super(spell, undoList);
            this.flowers = flowers;
            this.tallFlowers = tallFlowers;
            this.effectsLocation = effectsLocation;
            this.effectsSpeed = itemSpeed;
            this.ageItems = ageItems;
            this.random = new Random();
        }

        @Override
        public SpellResult perform(ConfigurationSection parameters, Block block) {
            boolean tall;
            if (block.getType() != Material.GRASS) {
                return SpellResult.NO_TARGET;
            }
            if ((block = block.getRelative(BlockFace.UP)).getType() != Material.AIR) {
                return SpellResult.NO_TARGET;
            }
            MaterialAndData material = null;
            boolean bl = tall = this.tallFlowers.size() > 0 && this.random.nextBoolean();
            if (tall) {
                material = this.tallFlowers.get(this.random.nextInt(this.tallFlowers.size()));
            } else if (this.flowers.size() > 0) {
                material = this.flowers.get(this.random.nextInt(this.flowers.size()));
            }
            if (material == null) {
                return SpellResult.FAIL;
            }
            super.perform(parameters, block);
            material.modify(block);
            if (tall) {
                block = block.getRelative(BlockFace.UP);
                super.perform(parameters, block);
                material.setData((byte)8);
                material.modify(block);
            }
            if (this.effectsSpeed > 0.0) {
                Vector velocity = block.getLocation().toVector().subtract(this.effectsLocation.toVector()).normalize().multiply(this.effectsSpeed);
                ItemStack itemStack = new ItemStack(material.getMaterial(), 1, (short)material.getData().byteValue());
                NMSUtils.makeTemporary(itemStack, this.getMessage("removed").replace("$material", material.getName()));
                Item droppedItem = block.getWorld().dropItem(this.effectsLocation, itemStack);
                droppedItem.setMetadata("temporary", (MetadataValue)new FixedMetadataValue(FlowerSpell.this.controller.getPlugin(), (Object)true));
                CompatibilityUtils.ageItem(droppedItem, this.ageItems);
                droppedItem.setVelocity(velocity);
            }
            return SpellResult.CAST;
        }
    }
}

