/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell;

import com.elmakers.mine.bukkit.api.action.SpellAction;
import com.elmakers.mine.bukkit.api.block.MaterialBrush;
import com.elmakers.mine.bukkit.api.effect.EffectPlayer;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.MageSpell;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.spell.ActionHandler;
import com.elmakers.mine.bukkit.spell.ActionSpell;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.spell.BlockSpell;
import com.elmakers.mine.bukkit.spell.BrushSpell;
import com.elmakers.mine.bukkit.spell.TargetingSpell;
import com.elmakers.mine.bukkit.spell.UndoableSpell;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.Arrays;
import java.util.Collection;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.potion.PotionEffect;
import org.bukkit.util.Vector;

public abstract class BaseSpellAction
implements SpellAction {
    private Spell spell;
    private BaseSpell baseSpell;
    private BlockSpell blockSpell;
    private MageSpell mageSpell;
    private BrushSpell brushSpell;
    private TargetingSpell targetingSpell;
    private UndoableSpell undoSpell;
    private ActionSpell actionSpell;
    private ConfigurationSection parameters;

    public void registerForUndo(Runnable runnable) {
        if (this.undoSpell != null) {
            this.undoSpell.registerForUndo(runnable);
        }
    }

    public void registerModified(Entity entity) {
        if (this.undoSpell != null) {
            this.undoSpell.registerModified(entity);
        }
    }

    public void registerForUndo(Entity entity) {
        if (this.undoSpell != null) {
            this.undoSpell.registerForUndo(entity);
        }
    }

    public void registerForUndo(Block block) {
        if (this.undoSpell != null) {
            this.undoSpell.registerForUndo(block);
        }
    }

    public void registerForUndo(Block block, boolean addNeighbors) {
        if (this.undoSpell != null) {
            this.undoSpell.registerForUndo(block, addNeighbors);
        }
    }

    public void updateBlock(Block block) {
        MageController controller = this.getController();
        if (controller != null) {
            controller.updateBlock(block);
        }
    }

    public void registerVelocity(Entity entity) {
        if (this.undoSpell != null) {
            this.undoSpell.registerVelocity(entity);
        }
    }

    public void registerMoved(Entity entity) {
        if (this.undoSpell != null) {
            this.undoSpell.registerMoved(entity);
        }
    }

    public void registerPotionEffects(Entity entity) {
        if (this.undoSpell != null) {
            this.undoSpell.registerPotionEffects(entity);
        }
    }

    public ActionHandler getActions(String key) {
        if (this.actionSpell != null) {
            return this.actionSpell.getActions(key);
        }
        return null;
    }

    public Block getPreviousBlock() {
        return this.targetingSpell != null ? this.targetingSpell.getPreviousBlock() : null;
    }

    public Vector getDirection() {
        return this.baseSpell != null ? this.baseSpell.getDirection() : null;
    }

    public World getWorld() {
        return this.baseSpell != null ? this.baseSpell.getWorld() : null;
    }

    public Location getLocation() {
        return this.baseSpell != null ? this.baseSpell.getLocation() : null;
    }

    public Location getEyeLocation() {
        return this.baseSpell != null ? this.baseSpell.getEyeLocation() : null;
    }

    public boolean isIndestructible(Block block) {
        return this.blockSpell != null ? this.blockSpell.isIndestructible(block) : true;
    }

    public boolean hasBuildPermission(Block block) {
        return this.blockSpell != null ? this.blockSpell.hasBuildPermission(block) : false;
    }

    public void playEffects(String key) {
        if (this.baseSpell != null) {
            this.baseSpell.playEffects(key);
        }
    }

    public Collection<EffectPlayer> getEffects(String key) {
        return this.spell.getEffects(key);
    }

    public Collection<PotionEffect> getPotionEffects(ConfigurationSection parameters, Integer duration) {
        return this.baseSpell != null ? BaseSpell.getPotionEffects(parameters, duration) : null;
    }

    public Mage getMage() {
        return this.mageSpell == null ? null : this.mageSpell.getMage();
    }

    public MageController getController() {
        Mage mage = this.getMage();
        return mage == null ? null : mage.getController();
    }

    @Override
    public void load(ConfigurationSection parameters) {
    }

    @Override
    public void save(ConfigurationSection parameters) {
    }

    @Override
    public void initialize(Spell spell, ConfigurationSection parameters) {
        this.spell = spell;
        if (spell instanceof BaseSpell) {
            this.baseSpell = (BaseSpell)spell;
        }
        if (spell instanceof MageSpell) {
            this.mageSpell = (MageSpell)spell;
        }
        if (spell instanceof UndoableSpell) {
            this.undoSpell = (UndoableSpell)spell;
        }
        if (spell instanceof ActionSpell) {
            this.actionSpell = (ActionSpell)spell;
        }
        if (spell instanceof TargetingSpell) {
            this.targetingSpell = (TargetingSpell)spell;
        }
        if (spell instanceof BlockSpell) {
            this.blockSpell = (BlockSpell)spell;
        }
        if (spell instanceof BrushSpell) {
            this.brushSpell = (BrushSpell)spell;
        }
        this.parameters = parameters;
    }

    @Override
    public ConfigurationSection getParameters(ConfigurationSection baseParameters) {
        if (this.parameters == null) {
            return baseParameters;
        }
        MemoryConfiguration combined = new MemoryConfiguration();
        ConfigurationUtils.addConfigurations((ConfigurationSection)combined, baseParameters);
        ConfigurationUtils.addConfigurations((ConfigurationSection)combined, this.parameters);
        return combined;
    }

    @Override
    public void prepare(ConfigurationSection parameters) {
    }

    @Override
    public void finish(ConfigurationSection parameters) {
    }

    @Override
    public boolean usesBrush() {
        return false;
    }

    @Override
    public boolean isUndoable() {
        return false;
    }

    public Spell getSpell() {
        return this.spell;
    }

    @Override
    public void getParameterNames(Collection<String> parameters) {
        parameters.add("target_radius");
        parameters.add("target_count");
        parameters.add("target_self");
        parameters.add("target_all");
        parameters.add("target_all_worlds");
    }

    @Override
    public void getParameterOptions(Collection<String> examples, String parameterKey) {
        if (parameterKey.equals("target_radius") || parameterKey.equals("target_count")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_SIZES));
        } else if (parameterKey.equals("target_self")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_BOOLEANS));
        } else if (parameterKey.equals("target_all")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_BOOLEANS));
        } else if (parameterKey.equals("target_all_worlds")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_BOOLEANS));
        }
    }

    @Override
    public String transformMessage(String message) {
        return message;
    }

    public String getMessage(String key) {
        return this.getMessage(key, key);
    }

    public String getMessage(String key, String def) {
        return this.baseSpell != null ? this.baseSpell.getMessage(key, def) : def;
    }

    public Location tryFindPlaceToStand(Location location) {
        return this.baseSpell != null ? this.baseSpell.tryFindPlaceToStand(location) : location;
    }

    public void castMessage(String message) {
        if (this.baseSpell != null) {
            this.baseSpell.castMessage(message);
        }
    }

    public void sendMessage(String message) {
        if (this.baseSpell != null) {
            this.baseSpell.sendMessage(message);
        }
    }

    public void setTarget(Location location) {
        if (this.targetingSpell != null) {
            this.targetingSpell.setTarget(location);
        }
    }

    public void addTargetEntity(Entity entity) {
        if (this.targetingSpell != null) {
            this.targetingSpell.addTargetEntity(entity);
        }
    }

    public Block findBlockUnder(Block block) {
        if (this.targetingSpell != null) {
            block = this.targetingSpell.findBlockUnder(block);
        }
        return block;
    }

    public Block findSpaceAbove(Block block) {
        if (this.targetingSpell != null) {
            block = this.targetingSpell.findSpaceAbove(block);
        }
        return block;
    }

    public boolean isTransparent(Material material) {
        if (this.targetingSpell != null) {
            return this.targetingSpell.isTransparent(material);
        }
        return material.isTransparent();
    }

    public MaterialBrush getBrush() {
        return this.brushSpell == null ? null : this.brushSpell.getBrush();
    }
}

