/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.slikey.effectlib;

import com.elmakers.mine.bukkit.slikey.effectlib.Effect;
import com.elmakers.mine.bukkit.slikey.effectlib.util.Disposable;
import com.elmakers.mine.bukkit.slikey.effectlib.util.ParticleEffect;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;

public final class EffectManager
implements Disposable {
    private final Plugin owningPlugin;
    private final Map<Effect, BukkitTask> effects;
    private static List<EffectManager> effectManagers;
    private boolean disposed;
    private boolean disposeOnTermination;
    private boolean debug = false;

    public static void initialize() {
        effectManagers = new ArrayList<EffectManager>();
    }

    public static List<EffectManager> getManagers() {
        if (effectManagers == null) {
            EffectManager.initialize();
        }
        return effectManagers;
    }

    public static void disposeAll() {
        if (effectManagers != null) {
            Iterator<EffectManager> i = effectManagers.iterator();
            while (i.hasNext()) {
                EffectManager em = i.next();
                i.remove();
                em.dispose();
            }
        }
    }

    public EffectManager(Plugin owningPlugin) {
        this.owningPlugin = owningPlugin;
        this.effects = new HashMap<Effect, BukkitTask>();
        this.disposed = false;
        this.disposeOnTermination = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Effect effect) {
        if (this.disposed) {
            throw new IllegalStateException("EffectManager is disposed and not able to accept any effects.");
        }
        if (this.disposeOnTermination) {
            throw new IllegalStateException("EffectManager is awaiting termination to dispose and not able to accept any effects.");
        }
        if (this.effects.containsKey(effect)) {
            effect.cancel(false);
        }
        BukkitScheduler s = Bukkit.getScheduler();
        BukkitTask task = null;
        switch (effect.type) {
            case INSTANT: {
                task = s.runTask(this.owningPlugin, (Runnable)effect);
                break;
            }
            case DELAYED: {
                task = s.runTaskLater(this.owningPlugin, (Runnable)effect, (long)effect.delay);
                break;
            }
            case REPEATING: {
                task = s.runTaskTimer(this.owningPlugin, (Runnable)effect, (long)effect.delay, (long)effect.period);
            }
        }
        EffectManager effectManager = this;
        synchronized (effectManager) {
            this.effects.put(effect, task);
        }
    }

    public Effect start(String effectClass, ConfigurationSection parameters, Location origin, Location target, Entity originEntity, Entity targetEntity, Map<String, String> textMap) {
        Class<?> effectLibClass;
        try {
            if (!effectClass.contains(".")) {
                effectClass = "com.elmakers.mine.bukkit.slikey.effectlib.effect." + effectClass;
            }
            effectLibClass = Class.forName(effectClass);
        }
        catch (Throwable ex) {
            this.owningPlugin.getLogger().info("Error loading EffectLib class: " + effectClass + ": " + ex.getMessage());
            return null;
        }
        Effect effect = null;
        try {
            Constructor<?> constructor = effectLibClass.getConstructor(EffectManager.class);
            effect = (Effect)constructor.newInstance(this);
        }
        catch (Exception ex) {
            this.owningPlugin.getLogger().warning("Error creating Effect class: " + effectClass);
        }
        if (effect == null) {
            return null;
        }
        Set keys = parameters.getKeys(false);
        for (String key : keys) {
            if (key.equals("class") || this.setField(effect, key, parameters, textMap)) continue;
            this.owningPlugin.getLogger().warning("Unable to assign EffectLib property " + key + " of class " + effectLibClass.getName());
        }
        effect.setLocation(origin);
        effect.setTarget(target);
        effect.setTargetEntity(targetEntity);
        effect.setEntity(originEntity);
        effect.start();
        return effect;
    }

    protected boolean setField(Object effect, String key, ConfigurationSection section, Map<String, String> textMap) {
        try {
            Field field = effect.getClass().getField(key);
            if (field.getType().equals(Integer.TYPE)) {
                field.set(effect, section.getInt(key));
            } else if (field.getType().equals(Float.TYPE)) {
                field.set(effect, Float.valueOf((float)section.getDouble(key)));
            } else if (field.getType().equals(Double.TYPE)) {
                field.set(effect, section.getDouble(key));
            } else if (field.getType().equals(Boolean.TYPE)) {
                field.set(effect, section.getBoolean(key));
            } else if (field.getType().equals(Long.TYPE)) {
                field.set(effect, section.getLong(key));
            } else if (field.getType().isAssignableFrom(String.class)) {
                String value = section.getString(key);
                if (textMap != null) {
                    for (Map.Entry<String, String> replaceEntry : textMap.entrySet()) {
                        value = value.replace(replaceEntry.getKey(), replaceEntry.getValue());
                    }
                }
                field.set(effect, value);
            } else if (field.getType().isAssignableFrom(ParticleEffect.class)) {
                String typeName = section.getString(key);
                ParticleEffect particleType = ParticleEffect.valueOf(typeName.toUpperCase());
                field.set(effect, (Object)particleType);
            } else if (field.getType().equals(Sound.class)) {
                String soundName = section.getString(key);
                try {
                    Sound sound = Sound.valueOf((String)soundName.toUpperCase());
                    field.set(effect, sound);
                }
                catch (Exception ex) {
                    this.onError(ex);
                }
            } else if (field.getType().equals(Color.class)) {
                String hexColor = section.getString(key);
                try {
                    Integer rgb = Integer.parseInt(hexColor, 16);
                    Color color = Color.fromRGB((int)rgb);
                    field.set(effect, color);
                }
                catch (Exception ex) {
                    this.onError(ex);
                }
            } else if (field.getType().equals(Vector.class)) {
                double x = 0.0;
                double y = 0.0;
                double z = 0.0;
                try {
                    String[] pieces = StringUtils.split((String)section.getString(key), (char)',');
                    x = pieces.length > 0 ? Double.parseDouble(pieces[0]) : 0.0;
                    y = pieces.length > 1 ? Double.parseDouble(pieces[1]) : 0.0;
                    z = pieces.length > 2 ? Double.parseDouble(pieces[2]) : 0.0;
                }
                catch (Exception ex) {
                    this.onError(ex);
                }
                field.set(effect, new Vector(x, y, z));
            } else {
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            this.onError(ex);
            return false;
        }
    }

    public void cancel(boolean callback) {
        for (Map.Entry<Effect, BukkitTask> entry : this.effects.entrySet()) {
            entry.getKey().cancel(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void done(Effect effect) {
        EffectManager effectManager = this;
        synchronized (effectManager) {
            BukkitTask existingTask = this.effects.get(effect);
            if (existingTask != null) {
                existingTask.cancel();
            }
            this.effects.remove(effect);
        }
        if (effect.callback != null) {
            Bukkit.getScheduler().runTask(this.owningPlugin, effect.callback);
        }
        if (this.disposeOnTermination && this.effects.size() == 0) {
            this.dispose();
        }
    }

    @Override
    public void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        this.cancel(false);
        if (effectManagers != null) {
            effectManagers.remove(this);
        }
    }

    public void disposeOnTermination() {
        this.disposeOnTermination = true;
        if (this.effects.size() == 0) {
            this.dispose();
        }
    }

    public void enableDebug(boolean enable) {
        this.debug = enable;
    }

    public void onError(Throwable ex) {
        if (this.debug) {
            this.owningPlugin.getLogger().log(Level.WARNING, "Particle Effect error", ex);
        }
    }
}

