/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell.builtin;

import com.elmakers.mine.bukkit.api.block.MaterialBrush;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.BrushSpell;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;

public class PillarSpell
extends BrushSpell {
    int MAX_SEARCH_DISTANCE = 255;

    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        Block attachBlock = this.getTargetBlock();
        if (attachBlock == null) {
            return SpellResult.NO_TARGET;
        }
        BlockFace direction = BlockFace.UP;
        String typeString = parameters.getString("type", "");
        if (typeString.equals("down")) {
            direction = BlockFace.DOWN;
        }
        Block targetBlock = attachBlock.getRelative(direction);
        if (!this.hasBuildPermission(targetBlock)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        for (int distance = 0; this.isTargetable(targetBlock.getType()) && distance <= this.MAX_SEARCH_DISTANCE; ++distance) {
            attachBlock = targetBlock;
            targetBlock = attachBlock.getRelative(direction);
        }
        if (this.isTargetable(targetBlock.getType())) {
            return SpellResult.NO_TARGET;
        }
        if (!this.hasBuildPermission(targetBlock)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        MaterialBrush buildWith = this.getBrush();
        Block pillar = targetBlock;
        buildWith.setTarget(attachBlock.getLocation(), pillar.getLocation());
        buildWith.update(this.mage, pillar.getLocation());
        this.registerForUndo(pillar);
        buildWith.modify(pillar);
        this.registerForUndo();
        return SpellResult.CAST;
    }
}

