/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.slikey.effectlib.effect;

import com.elmakers.mine.bukkit.slikey.effectlib.Effect;
import com.elmakers.mine.bukkit.slikey.effectlib.EffectManager;
import com.elmakers.mine.bukkit.slikey.effectlib.EffectType;
import com.elmakers.mine.bukkit.slikey.effectlib.util.ParticleEffect;
import com.elmakers.mine.bukkit.slikey.effectlib.util.RandomUtils;
import com.elmakers.mine.bukkit.slikey.effectlib.util.VectorUtils;
import org.bukkit.Location;
import org.bukkit.util.Vector;

public class AtomEffect
extends Effect {
    public ParticleEffect particleNucleus = ParticleEffect.DRIP_WATER;
    public ParticleEffect particleOrbital = ParticleEffect.DRIP_LAVA;
    public int radius = 3;
    public float radiusNucleus = 0.2f;
    public int particlesNucleus = 10;
    public int particlesOrbital = 10;
    public int orbitals = 3;
    public double rotation = 0.0;
    public double angularVelocity = 0.039269908169872414;
    protected int step = 0;

    public AtomEffect(EffectManager effectManager) {
        super(effectManager);
        this.type = EffectType.REPEATING;
        this.period = 2;
        this.iterations = 200;
    }

    @Override
    public void onRun() {
        int i;
        Location location = this.getLocation();
        for (i = 0; i < this.particlesNucleus; ++i) {
            Vector v = RandomUtils.getRandomVector().multiply((float)this.radius * this.radiusNucleus);
            location.add(v);
            this.particleNucleus.display(location, this.visibleRange, 0.0f, 0.0f, 0.0f, 0.0f, 0);
            location.subtract(v);
        }
        for (i = 0; i < this.particlesOrbital; ++i) {
            double angle = (double)this.step * this.angularVelocity;
            for (int j = 0; j < this.orbitals; ++j) {
                double xRotation = Math.PI / (double)this.orbitals * (double)j;
                Vector v = new Vector(Math.cos(angle), Math.sin(angle), 0.0).multiply(this.radius);
                VectorUtils.rotateAroundAxisX(v, xRotation);
                VectorUtils.rotateAroundAxisY(v, this.rotation);
                location.add(v);
                this.particleOrbital.display(location, this.visibleRange, 0.0f, 0.0f, 0.0f, 0.0f, 0);
                location.subtract(v);
            }
            ++this.step;
        }
    }
}

