/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.command;

import com.elmakers.mine.bukkit.api.block.MaterialAndData;
import com.elmakers.mine.bukkit.api.magic.MagicAPI;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.magic.command.MagicTabExecutor;
import com.elmakers.mine.bukkit.spell.SpellCategory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SpellsCommandExecutor
extends MagicTabExecutor {
    public SpellsCommandExecutor(MagicAPI api) {
        super(api);
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, String comandName, String[] args) {
        return new ArrayList<String>();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!this.api.hasPermission(sender, "Magic.commands.spells")) {
            this.sendNoPermission(sender);
            return true;
        }
        this.listSpells(sender, -1, args.length > 0 ? args[0] : null);
        return true;
    }

    public void listSpellsByCategory(CommandSender sender, String category) {
        ArrayList<SpellTemplate> categorySpells = new ArrayList<SpellTemplate>();
        Collection<SpellTemplate> spellVariants = this.api.getSpellTemplates();
        Player player = sender instanceof Player ? (Player)sender : null;
        for (SpellTemplate spell : spellVariants) {
            com.elmakers.mine.bukkit.api.spell.SpellCategory spellCategory = spell.getCategory();
            if (spellCategory == null || !spellCategory.getKey().equalsIgnoreCase(category) || player != null && !spell.hasCastPermission((CommandSender)player)) continue;
            categorySpells.add(spell);
        }
        if (categorySpells.size() == 0) {
            String message = this.api.getMessages().get("general.no_spells_in_category");
            message = message.replace("$category", category);
            sender.sendMessage(message);
            return;
        }
        sender.sendMessage(category + ":");
        Collections.sort(categorySpells);
        for (SpellTemplate spell : categorySpells) {
            String name = spell.getName();
            String description = spell.getDescription();
            if (!name.equals(spell.getKey())) {
                description = name + " : " + description;
            }
            sender.sendMessage(ChatColor.AQUA + spell.getKey() + ChatColor.BLUE + " [" + spell.getIcon().getName() + "] : " + ChatColor.YELLOW + description);
        }
    }

    public void listCategories(Player player) {
        HashMap<String, Integer> spellCounts = new HashMap<String, Integer>();
        ArrayList<com.elmakers.mine.bukkit.api.spell.SpellCategory> spellGroups = new ArrayList<com.elmakers.mine.bukkit.api.spell.SpellCategory>();
        Collection<SpellTemplate> spellVariants = this.api.getSpellTemplates();
        for (SpellTemplate spell : spellVariants) {
            if (player != null && !spell.hasCastPermission((CommandSender)player) || spell.getCategory() == null) continue;
            Integer spellCount = (Integer)spellCounts.get(spell.getCategory());
            if (spellCount == null || spellCount == 0) {
                spellCounts.put(spell.getCategory().getKey(), 1);
                spellGroups.add(spell.getCategory());
                continue;
            }
            spellCounts.put(spell.getCategory().getKey(), spellCount + 1);
        }
        if (spellGroups.size() == 0) {
            player.sendMessage(this.api.getMessages().get("general.no_spells"));
            return;
        }
        Collections.sort(spellGroups);
        for (com.elmakers.mine.bukkit.api.spell.SpellCategory group : spellGroups) {
            player.sendMessage(group.getName() + " [" + spellCounts.get(group) + "]");
        }
    }

    public void listSpells(CommandSender sender, int pageNumber, String category) {
        if (category != null) {
            this.listSpellsByCategory(sender, category);
            return;
        }
        Player player = sender instanceof Player ? (Player)sender : null;
        Collection<SpellTemplate> spellVariants = this.api.getSpellTemplates();
        int spellCount = 0;
        for (SpellTemplate spell : spellVariants) {
            if (player != null && !spell.hasCastPermission((CommandSender)player) || spell.getCategory() == null) continue;
            ++spellCount;
        }
        Collection<com.elmakers.mine.bukkit.api.spell.SpellCategory> allCategories = this.api.getController().getCategories();
        ArrayList<SpellCategory> sortedGroups = new ArrayList<SpellCategory>();
        for (com.elmakers.mine.bukkit.api.spell.SpellCategory checkCategory : allCategories) {
            if (!(checkCategory instanceof SpellCategory)) continue;
            sortedGroups.add((SpellCategory)checkCategory);
        }
        Collections.sort(sortedGroups);
        int maxLines = -1;
        if (pageNumber >= 0) {
            maxLines = 5;
            int maxPages = spellCount / maxLines + 1;
            if (pageNumber > maxPages) {
                pageNumber = maxPages;
            }
            String message = this.api.getMessages().get("general.spell_list_page");
            message = message.replace("$count", Integer.toString(spellCount));
            message = message.replace("$pages", Integer.toString(maxPages));
            message = message.replace("$page", Integer.toString(pageNumber));
            sender.sendMessage(message);
        } else {
            String message = this.api.getMessages().get("general.spell_list");
            message = message.replace("$count", Integer.toString(spellCount));
            sender.sendMessage(message);
        }
        int currentPage = 1;
        int lineCount = 0;
        int printedCount = 0;
        block2: for (SpellCategory group : sortedGroups) {
            if (printedCount > maxLines && maxLines > 0) break;
            boolean isFirst = true;
            Collection<SpellTemplate> spells = group.getSpells();
            for (SpellTemplate spell : spells) {
                if (printedCount > maxLines && maxLines > 0) continue block2;
                if (!spell.hasCastPermission(sender)) continue;
                if (currentPage == pageNumber || maxLines < 0) {
                    MaterialAndData spellIcon;
                    if (isFirst) {
                        sender.sendMessage(group.getName() + ":");
                        isFirst = false;
                    }
                    String name = spell.getName();
                    String description = spell.getDescription();
                    if (!name.equals(spell.getKey())) {
                        description = name + " : " + description;
                    }
                    String icon = (spellIcon = spell.getIcon()) == null ? "None" : spellIcon.getMaterial().name().toLowerCase();
                    sender.sendMessage(ChatColor.AQUA + spell.getKey() + ChatColor.BLUE + " [" + icon + "] : " + ChatColor.YELLOW + description);
                    ++printedCount;
                }
                if (++lineCount != maxLines) continue;
                lineCount = 0;
                ++currentPage;
            }
        }
    }
}

