/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.wand;

import com.elmakers.mine.bukkit.api.block.BrushMode;
import com.elmakers.mine.bukkit.api.block.MaterialAndData;
import com.elmakers.mine.bukkit.api.block.MaterialBrush;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.Messages;
import com.elmakers.mine.bukkit.api.spell.CastingCost;
import com.elmakers.mine.bukkit.api.spell.CostReducer;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellKey;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.effect.builtin.EffectRing;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.slikey.effectlib.util.ParticleEffect;
import com.elmakers.mine.bukkit.utility.ColorHD;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.InventoryUtils;
import com.elmakers.mine.bukkit.utility.NMSUtils;
import com.elmakers.mine.bukkit.utility.SoundEffect;
import com.elmakers.mine.bukkit.wand.LostWand;
import com.elmakers.mine.bukkit.wand.UnknownWandException;
import com.elmakers.mine.bukkit.wand.WandLevel;
import com.elmakers.mine.bukkit.wand.WandMode;
import com.elmakers.mine.bukkit.wand.WandOrganizer;
import com.elmakers.mine.bukkit.wand.WandUpgradePath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerExpChangeEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class Wand
implements CostReducer,
com.elmakers.mine.bukkit.api.wand.Wand {
    public static final int INVENTORY_SIZE = 27;
    public static final int HOTBAR_SIZE = 9;
    public static final int HOTBAR_INVENTORY_SIZE = 8;
    public static final float DEFAULT_SPELL_COLOR_MIX_WEIGHT = 1.0E-4f;
    public static final float DEFAULT_WAND_COLOR_MIX_WEIGHT = 1.0f;
    public static final int POTION_EFFECT_DURATION = 240;
    public static final Material DEFAULT_BRUSH_MATERIAL = Material.SULPHUR;
    public static final String[] EMPTY_PARAMETERS = new String[0];
    public static final String[] PROPERTY_KEYS = new String[]{"active_spell", "active_material", "path", "xp", "xp_regeneration", "xp_max", "bound", "uses", "upgrade", "indestructible", "undroppable", "cost_reduction", "cooldown_reduction", "effect_bubbles", "effect_color", "effect_particle", "effect_particle_count", "effect_particle_data", "effect_particle_interval", "effect_sound", "effect_sound_interval", "effect_sound_pitch", "effect_sound_volume", "haste", "hotbar_count", "hotbar", "health_regeneration", "hunger_regeneration", "icon", "mode", "keep", "locked", "quiet", "force", "randomize", "rename", "power", "overrides", "protection", "protection_physical", "protection_projectiles", "protection_falling", "protection_fire", "protection_explosions", "materials", "spells"};
    public static final String[] HIDDEN_PROPERTY_KEYS = new String[]{"id", "owner", "owner_id", "name", "description", "template", "organize", "alphabetize", "fill", "stored", "upgrade_icon"};
    public static final String[] ALL_PROPERTY_KEYS = (String[])ArrayUtils.addAll((Object[])PROPERTY_KEYS, (Object[])HIDDEN_PROPERTY_KEYS);
    protected ItemStack item;
    protected MagicController controller;
    protected Mage mage;
    private String id = "";
    private List<Inventory> hotbars;
    private List<Inventory> inventories;
    private Map<String, Integer> spells = new HashMap<String, Integer>();
    private Map<String, Integer> spellLevels = new HashMap<String, Integer>();
    private Map<String, Integer> brushes = new HashMap<String, Integer>();
    private String activeSpell = "";
    private String activeMaterial = "";
    protected String wandName = "";
    protected String description = "";
    private String owner = "";
    private String ownerId = "";
    private String template = "";
    private String path = "";
    private boolean bound = false;
    private boolean indestructible = false;
    private boolean undroppable = false;
    private boolean keep = false;
    private boolean autoOrganize = false;
    private boolean autoAlphabetize = false;
    private boolean autoFill = false;
    private boolean isUpgrade = false;
    private boolean randomize = false;
    private boolean rename = false;
    private com.elmakers.mine.bukkit.block.MaterialAndData icon = null;
    private com.elmakers.mine.bukkit.block.MaterialAndData upgradeIcon = null;
    private float costReduction = 0.0f;
    private float cooldownReduction = 0.0f;
    private float damageReduction = 0.0f;
    private float damageReductionPhysical = 0.0f;
    private float damageReductionProjectiles = 0.0f;
    private float damageReductionFalling = 0.0f;
    private float damageReductionFire = 0.0f;
    private float damageReductionExplosions = 0.0f;
    private float power = 0.0f;
    private boolean hasInventory = false;
    private boolean locked = false;
    private boolean forceUpgrade = false;
    private int uses = 0;
    private int xp = 0;
    private int xpRegeneration = 0;
    private int xpMax = 0;
    private float healthRegeneration = 0.0f;
    private PotionEffect healthRegenEffect = null;
    private float hungerRegeneration = 0.0f;
    private PotionEffect hungerRegenEffect = null;
    private ColorHD effectColor = null;
    private float effectColorSpellMixWeight = 1.0E-4f;
    private float effectColorMixWeight = 1.0f;
    private ParticleEffect effectParticle = null;
    private float effectParticleData = 0.0f;
    private int effectParticleCount = 0;
    private int effectParticleInterval = 0;
    private int effectParticleCounter = 0;
    private boolean effectBubbles = false;
    private EffectRing effectPlayer = null;
    private SoundEffect effectSound = null;
    private int effectSoundInterval = 0;
    private int effectSoundCounter = 0;
    private float speedIncrease = 0.0f;
    private PotionEffect hasteEffect = null;
    private int quietLevel = 0;
    private Map<String, String> castOverrides = null;
    private int storedXpLevel = 0;
    private float storedXpProgress = 0.0f;
    private WandMode mode = null;
    private int openInventoryPage = 0;
    private boolean inventoryIsOpen = false;
    private Inventory displayInventory = null;
    private int currentHotbar = 0;
    private boolean suspendSave = false;
    protected static Map<String, ConfigurationSection> wandTemplates = new HashMap<String, ConfigurationSection>();
    public static boolean displayManaAsBar = true;
    public static boolean displayManaAsDurability = true;
    public static boolean displayManaAsGlow = true;
    public static boolean retainLevelDisplay = true;
    public static Material DefaultUpgradeMaterial = Material.NETHER_STAR;
    public static Material DefaultWandMaterial = Material.BLAZE_ROD;
    public static Material EnchantableWandMaterial = null;
    public static boolean EnableGlow = true;
    public static boolean SpellGlow = true;
    public static SoundEffect inventoryOpenSound = null;
    public static SoundEffect inventoryCloseSound = null;
    public static SoundEffect inventoryCycleSound = null;
    private Inventory storedInventory = null;
    private Integer playerInventorySlot = null;
    private static final ItemStack[] itemTemplate = new ItemStack[0];

    public Wand(MagicController controller, ItemStack itemStack) {
        this.controller = controller;
        this.hotbars = new ArrayList<Inventory>();
        this.setHotbarCount(1);
        this.icon = new com.elmakers.mine.bukkit.block.MaterialAndData(itemStack.getType(), (byte)itemStack.getDurability());
        this.inventories = new ArrayList<Inventory>();
        this.item = itemStack;
        this.indestructible = controller.getIndestructibleWands();
        this.loadState();
        this.updateName();
        this.updateLore();
    }

    protected void setHotbarCount(int count) {
        this.hotbars.clear();
        while (this.hotbars.size() < count) {
            this.hotbars.add(CompatibilityUtils.createInventory(null, 8, "Wand"));
        }
        while (this.hotbars.size() > count) {
            this.hotbars.remove(0);
        }
    }

    public Wand(MagicController controller) {
        this(controller, DefaultWandMaterial, 0);
    }

    public Wand(MagicController controller, ConfigurationSection config) {
        this(controller, DefaultWandMaterial, 0);
        this.loadProperties(config);
        this.updateName();
        this.updateLore();
        this.saveState();
    }

    protected Wand(MagicController controller, String templateName) throws UnknownWandException {
        this(controller);
        this.suspendSave = true;
        String wandName = controller.getMessages().get("wand.default_name");
        String wandDescription = "";
        if ((templateName == null || templateName.length() == 0) && wandTemplates.containsKey("default")) {
            templateName = "default";
        }
        if (templateName != null && templateName.length() > 0) {
            int level = 0;
            if (templateName.contains("(")) {
                String levelString = templateName.substring(templateName.indexOf(40) + 1, templateName.length() - 1);
                try {
                    level = Integer.parseInt(levelString);
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException(ex);
                }
                templateName = templateName.substring(0, templateName.indexOf(40));
            }
            if (!wandTemplates.containsKey(templateName)) {
                throw new UnknownWandException(templateName);
            }
            ConfigurationSection wandConfig = wandTemplates.get(templateName);
            wandName = wandConfig.getString("name", wandName);
            wandName = controller.getMessages().get("wands." + templateName + ".name", wandName);
            wandDescription = wandConfig.getString("description", wandDescription);
            wandDescription = controller.getMessages().get("wands." + templateName + ".description", wandDescription);
            this.loadProperties(wandConfig);
            if (level > 0) {
                boolean wasLocked = this.locked;
                this.locked = false;
                this.randomize(level, false, null);
                this.locked = wasLocked;
            }
        }
        this.setDescription(wandDescription);
        this.setName(wandName);
        if (!this.randomize) {
            this.randomize();
        }
        this.setTemplate(templateName);
        this.suspendSave = false;
        this.saveState();
    }

    public Wand(MagicController controller, Material icon, short iconData) {
        this(controller, InventoryUtils.makeReal(new ItemStack(icon, 1, iconData)));
        this.wandName = controller.getMessages().get("wand.default_name");
        this.saveState();
        this.updateName();
    }

    @Override
    public void unenchant() {
        this.item = new ItemStack(this.item.getType(), 1, this.item.getDurability());
    }

    public void setIcon(Material material, byte data) {
        this.setIcon(material == null ? null : new com.elmakers.mine.bukkit.block.MaterialAndData(material, data));
    }

    public void setIcon(com.elmakers.mine.bukkit.block.MaterialAndData materialData) {
        this.icon = materialData;
        if (this.icon != null) {
            this.item.setType(this.icon.getMaterial());
            this.item.setDurability((short)this.icon.getData().byteValue());
        }
    }

    @Override
    public void makeUpgrade() {
        if (!this.isUpgrade) {
            this.isUpgrade = true;
            String oldName = this.wandName;
            this.wandName = this.controller.getMessages().get("wand.upgrade_name");
            this.wandName = this.wandName.replace("$name", oldName);
            this.description = this.controller.getMessages().get("wand.upgrade_default_description");
            if (this.template != null && this.template.length() > 0) {
                this.description = this.controller.getMessages().get("wands." + this.template + ".upgrade_description", this.description);
            }
            this.setIcon(DefaultUpgradeMaterial, (byte)0);
            this.saveState();
            this.updateName(true);
            this.updateLore();
        }
    }

    protected void activateBrush(String materialKey) {
        MaterialBrush brush;
        this.setActiveBrush(materialKey);
        if (materialKey != null && (brush = this.mage.getBrush()) != null) {
            boolean eraseWasActive = brush.isEraseModifierActive();
            brush.activate(this.mage.getLocation(), materialKey);
            if (this.mage != null) {
                BrushMode mode = brush.getMode();
                if (mode == BrushMode.CLONE) {
                    this.mage.sendMessage(this.controller.getMessages().get("wand.clone_material_activated"));
                } else if (mode == BrushMode.REPLICATE) {
                    this.mage.sendMessage(this.controller.getMessages().get("wand.replicate_material_activated"));
                }
                if (!eraseWasActive && brush.isEraseModifierActive()) {
                    this.mage.sendMessage(this.controller.getMessages().get("wand.erase_modifier_activated"));
                }
            }
        }
    }

    public void activateBrush(ItemStack itemStack) {
        if (!Wand.isBrush(itemStack)) {
            return;
        }
        this.activateBrush(Wand.getBrush(itemStack));
    }

    public String getLostId() {
        return this.id;
    }

    public void clearLostId() {
        if (this.id != null) {
            this.id = null;
            this.saveState();
        }
    }

    public int getXpRegeneration() {
        return this.xpRegeneration;
    }

    public int getXpMax() {
        return this.xpMax;
    }

    public int getMana() {
        return this.xp;
    }

    public void removeMana(int amount) {
        this.xp = Math.max(0, this.xp - amount);
        this.updateMana();
    }

    public float getHealthRegeneration() {
        return this.healthRegeneration;
    }

    public float getHungerRegeneration() {
        return this.hungerRegeneration;
    }

    public boolean isModifiable() {
        return !this.locked;
    }

    public boolean isIndestructible() {
        return this.indestructible;
    }

    public boolean isUndroppable() {
        return this.undroppable || this.isInventoryOpen();
    }

    public boolean isUpgrade() {
        return this.isUpgrade;
    }

    public boolean usesMana() {
        return this.xpMax > 0 && this.xpRegeneration > 0 && !this.isCostFree();
    }

    public float getCooldownReduction() {
        return this.controller.getCooldownReduction() + this.cooldownReduction * this.controller.getMaxCooldownReduction();
    }

    @Override
    public float getCostReduction() {
        if (this.isCostFree()) {
            return 1.0f;
        }
        return this.controller.getCostReduction() + this.costReduction * this.controller.getMaxCostReduction();
    }

    public void setCooldownReduction(float reduction) {
        this.cooldownReduction = reduction;
    }

    public boolean getHasInventory() {
        return this.hasInventory;
    }

    public float getPower() {
        return this.power;
    }

    public float getHaste() {
        return this.speedIncrease;
    }

    public boolean isSuperProtected() {
        return this.damageReduction > 1.0f;
    }

    public boolean isSuperPowered() {
        return this.power > 1.0f;
    }

    public boolean isCostFree() {
        return this.costReduction > 1.0f;
    }

    public boolean isCooldownFree() {
        return this.cooldownReduction > 1.0f;
    }

    public float getDamageReduction() {
        return this.damageReduction * this.controller.getMaxDamageReduction();
    }

    public float getDamageReductionPhysical() {
        return this.damageReductionPhysical * this.controller.getMaxDamageReductionPhysical();
    }

    public float getDamageReductionProjectiles() {
        return this.damageReductionProjectiles * this.controller.getMaxDamageReductionProjectiles();
    }

    public float getDamageReductionFalling() {
        return this.damageReductionFalling * this.controller.getMaxDamageReductionFalling();
    }

    public float getDamageReductionFire() {
        return this.damageReductionFire * this.controller.getMaxDamageReductionFire();
    }

    public float getDamageReductionExplosions() {
        return this.damageReductionExplosions * this.controller.getMaxDamageReductionExplosions();
    }

    public int getUses() {
        return this.uses;
    }

    @Override
    public String getName() {
        return this.wandName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getOwner() {
        return this.owner;
    }

    @Override
    public long getWorth() {
        long worth = 0L;
        Collection spells = this.getSpells();
        for (String spellKey : spells) {
            SpellTemplate spell = this.controller.getSpellTemplate(spellKey);
            if (spell == null) continue;
            worth += spell.getWorth();
        }
        return worth;
    }

    @Override
    public void setName(String name) {
        this.wandName = ChatColor.stripColor((String)name);
        this.updateName();
    }

    public void setTemplate(String templateName) {
        this.template = templateName;
    }

    public String getTemplate() {
        return this.template;
    }

    public WandUpgradePath getPath() {
        String pathKey = this.path;
        if (pathKey == null || pathKey.length() == 0) {
            pathKey = this.controller.getDefaultWandPath();
        }
        return WandUpgradePath.getPath(pathKey);
    }

    public boolean hasPath() {
        return this.path != null && this.path.length() > 0;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
        this.updateLore();
    }

    public void tryToOwn(Player player) {
        if (this.ownerId == null || this.ownerId.length() == 0) {
            if (this.owner != null && !this.owner.equals(player.getName())) {
                return;
            }
            this.takeOwnership(player);
        }
    }

    protected void takeOwnership(Player player) {
        this.takeOwnership(player, this.controller != null && this.controller.bindWands(), this.controller != null && this.controller.keepWands());
    }

    public void takeOwnership(Player player, boolean setBound, boolean setKeep) {
        this.owner = player.getName();
        this.ownerId = player.getUniqueId().toString();
        if (setBound) {
            this.bound = true;
        }
        if (setKeep) {
            this.keep = true;
        }
        this.updateLore();
    }

    @Override
    public ItemStack getItem() {
        return this.item;
    }

    protected List<Inventory> getAllInventories() {
        ArrayList<Inventory> allInventories = new ArrayList<Inventory>(this.inventories.size() + this.hotbars.size());
        allInventories.addAll(this.hotbars);
        allInventories.addAll(this.inventories);
        return allInventories;
    }

    public Set<String> getSpells() {
        return this.spells.keySet();
    }

    protected String getSpellString() {
        TreeSet<String> spellNames = new TreeSet<String>();
        for (Map.Entry<String, Integer> spellSlot : this.spells.entrySet()) {
            Integer slot = spellSlot.getValue();
            String spellKey = spellSlot.getKey();
            if (slot != null) {
                spellKey = spellKey + "@" + slot;
            }
            spellNames.add(spellKey);
        }
        return StringUtils.join(spellNames, (String)",");
    }

    public Set<String> getBrushes() {
        return this.brushes.keySet();
    }

    protected String getMaterialString() {
        TreeSet<String> materialNames = new TreeSet<String>();
        for (Map.Entry<String, Integer> brushSlot : this.brushes.entrySet()) {
            Integer slot = brushSlot.getValue();
            String materialKey = brushSlot.getKey();
            if (slot != null) {
                materialKey = materialKey + "@" + slot;
            }
            materialNames.add(materialKey);
        }
        return StringUtils.join(materialNames, (String)",");
    }

    protected Integer parseSlot(String[] pieces) {
        Integer slot = null;
        if (pieces.length > 1) {
            try {
                slot = Integer.parseInt(pieces[1]);
            }
            catch (Exception ex) {
                slot = null;
            }
            if (slot != null && slot < 0) {
                slot = null;
            }
        }
        return slot;
    }

    protected void addToInventory(ItemStack itemStack) {
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            return;
        }
        List<Inventory> checkInventories = this.getAllInventories();
        boolean added = false;
        for (Inventory inventory : checkInventories) {
            HashMap returned = inventory.addItem(new ItemStack[]{itemStack});
            if (returned.size() != 0) continue;
            added = true;
            break;
        }
        if (!added) {
            Inventory newInventory = CompatibilityUtils.createInventory(null, 27, "Wand");
            newInventory.addItem(new ItemStack[]{itemStack});
            this.inventories.add(newInventory);
        }
    }

    protected Inventory getDisplayInventory() {
        if (this.displayInventory == null) {
            this.displayInventory = CompatibilityUtils.createInventory(null, 36, "Wand");
        }
        return this.displayInventory;
    }

    protected Inventory getInventoryByIndex(int inventoryIndex) {
        while (inventoryIndex >= this.inventories.size()) {
            this.inventories.add(CompatibilityUtils.createInventory(null, 27, "Wand"));
        }
        return this.inventories.get(inventoryIndex);
    }

    protected int getHotbarSize() {
        return this.hotbars.size() * 8;
    }

    protected Inventory getInventory(Integer slot) {
        Inventory inventory = null;
        int hotbarSize = this.getHotbarSize();
        if (slot >= hotbarSize) {
            int inventoryIndex = (slot - hotbarSize) / 27;
            inventory = this.getInventoryByIndex(inventoryIndex);
        } else {
            inventory = this.hotbars.get(slot / 8);
        }
        return inventory;
    }

    protected int getInventorySlot(Integer slot) {
        int hotbarSize = this.getHotbarSize();
        if (slot < hotbarSize) {
            return slot % 8;
        }
        return (slot - hotbarSize) % 27;
    }

    protected void addToInventory(ItemStack itemStack, Integer slot) {
        if (slot == null) {
            this.addToInventory(itemStack);
            return;
        }
        Inventory inventory = this.getInventory(slot);
        slot = this.getInventorySlot(slot);
        ItemStack existing = inventory.getItem(slot.intValue());
        inventory.setItem(slot.intValue(), itemStack);
        if (existing != null && existing.getType() != Material.AIR) {
            this.addToInventory(existing);
        }
    }

    protected void parseInventoryStrings(String spellString, String materialString) {
        String[] materialNames;
        ItemStack itemStack;
        String[] spellNames;
        for (Inventory hotbar : this.hotbars) {
            hotbar.clear();
        }
        this.inventories.clear();
        this.spells.clear();
        this.spellLevels.clear();
        this.brushes.clear();
        spellString = spellString.replaceAll("[\\]\\[]", "");
        for (String spellName : spellNames = StringUtils.split((String)spellString, (String)",")) {
            String[] pieces = spellName.split("@");
            Integer slot = this.parseSlot(pieces);
            SpellKey spellKey = new SpellKey(pieces[0].trim());
            this.spells.put(spellKey.getKey(), slot);
            Integer currentLevel = this.spellLevels.get(spellKey.getBaseKey());
            if (currentLevel == null || currentLevel < spellKey.getLevel()) {
                this.spellLevels.put(spellKey.getBaseKey(), spellKey.getLevel());
            }
            if ((itemStack = this.createSpellIcon(spellKey.getKey())) == null) {
                itemStack = new ItemStack(this.item.getType(), 1);
                CompatibilityUtils.setDisplayName(itemStack, spellKey.getKey());
                CompatibilityUtils.setMeta(itemStack, "spell", spellKey.getKey());
            } else if (this.activeSpell == null || this.activeSpell.length() == 0) {
                this.activeSpell = spellKey.getKey();
            }
            this.addToInventory(itemStack, slot);
        }
        materialString = materialString.replaceAll("[\\]\\[]", "");
        for (String materialName : materialNames = StringUtils.split((String)materialString, (String)",")) {
            String[] pieces = materialName.split("@");
            Integer slot = this.parseSlot(pieces);
            String materialKey = pieces[0].trim();
            this.brushes.put(materialKey, slot);
            itemStack = this.createBrushIcon(materialKey);
            if (itemStack == null) {
                this.controller.getPlugin().getLogger().warning("Unable to create material icon for key " + materialKey);
                continue;
            }
            if (this.activeMaterial == null || this.activeMaterial.length() == 0) {
                this.activeMaterial = materialKey;
            }
            this.addToInventory(itemStack, slot);
        }
        this.hasInventory = spellNames.length + materialNames.length > 1;
    }

    protected ItemStack createSpellIcon(SpellTemplate spell) {
        return Wand.createSpellItem(spell, this.controller, this, false);
    }

    public static ItemStack createSpellItem(String spellKey, MagicController controller, Wand wand, boolean isItem) {
        return Wand.createSpellItem(controller.getSpellTemplate(spellKey), controller, wand, isItem);
    }

    public static ItemStack createSpellItem(SpellTemplate spell, MagicController controller, Wand wand, boolean isItem) {
        if (spell == null) {
            return null;
        }
        MaterialAndData icon = spell.getIcon();
        if (icon == null) {
            controller.getPlugin().getLogger().warning("Unable to create spell icon for " + spell.getName() + ", missing material");
            return null;
        }
        ItemStack itemStack = null;
        ItemStack originalItemStack = null;
        try {
            originalItemStack = new ItemStack(icon.getMaterial(), 1, 0, Byte.valueOf(icon.getData()));
            itemStack = InventoryUtils.makeReal(originalItemStack);
        }
        catch (Exception ex) {
            itemStack = null;
        }
        if (itemStack == null) {
            controller.getPlugin().getLogger().warning("Unable to create spell icon for " + spell.getKey() + " with material " + icon.getMaterial().name());
            return originalItemStack;
        }
        Wand.updateSpellItem(controller.getMessages(), itemStack, spell, wand, wand == null ? null : wand.activeMaterial, isItem);
        return itemStack;
    }

    protected ItemStack createSpellIcon(String spellKey) {
        return Wand.createSpellItem(spellKey, this.controller, this, false);
    }

    private String getActiveWandName(String materialKey) {
        SpellTemplate spell = null;
        if (this.activeSpell != null && this.activeSpell.length() > 0) {
            spell = this.controller.getSpellTemplate(this.activeSpell);
        }
        return this.getActiveWandName(spell, materialKey);
    }

    protected ItemStack createBrushIcon(String materialKey) {
        return Wand.createBrushItem(materialKey, this.controller, this, false);
    }

    public static ItemStack createBrushItem(String materialKey, MagicController controller, Wand wand, boolean isItem) {
        com.elmakers.mine.bukkit.block.MaterialAndData brushData = com.elmakers.mine.bukkit.block.MaterialBrush.parseMaterialKey(materialKey, false);
        if (brushData == null) {
            return null;
        }
        Material material = brushData.getMaterial();
        if (material == null || material == Material.AIR) {
            return null;
        }
        byte dataId = brushData.getData();
        ItemStack originalItemStack = new ItemStack(material, 1, 0, Byte.valueOf(dataId));
        ItemStack itemStack = InventoryUtils.makeReal(originalItemStack);
        if (itemStack == null) {
            itemStack = new ItemStack(DEFAULT_BRUSH_MATERIAL, 1, 0, Byte.valueOf(dataId));
            if ((itemStack = InventoryUtils.makeReal(itemStack)) == null) {
                return itemStack;
            }
        }
        ArrayList<String> lore = new ArrayList<String>();
        if (material != null) {
            lore.add(ChatColor.GRAY + controller.getMessages().get("wand.building_material_info").replace("$material", com.elmakers.mine.bukkit.block.MaterialBrush.getMaterialName(materialKey)));
            if (material == com.elmakers.mine.bukkit.block.MaterialBrush.EraseMaterial) {
                lore.add(controller.getMessages().get("wand.erase_material_description"));
            } else if (material == com.elmakers.mine.bukkit.block.MaterialBrush.CopyMaterial) {
                lore.add(controller.getMessages().get("wand.copy_material_description"));
            } else if (material == com.elmakers.mine.bukkit.block.MaterialBrush.CloneMaterial) {
                lore.add(controller.getMessages().get("wand.clone_material_description"));
            } else if (material == com.elmakers.mine.bukkit.block.MaterialBrush.ReplicateMaterial) {
                lore.add(controller.getMessages().get("wand.replicate_material_description"));
            } else if (material == com.elmakers.mine.bukkit.block.MaterialBrush.MapMaterial) {
                lore.add(controller.getMessages().get("wand.map_material_description"));
            } else if (material == com.elmakers.mine.bukkit.block.MaterialBrush.SchematicMaterial) {
                lore.add(controller.getMessages().get("wand.schematic_material_description").replace("$schematic", brushData.getCustomName()));
            } else {
                lore.add(ChatColor.LIGHT_PURPLE + controller.getMessages().get("wand.building_material_description"));
            }
        }
        if (isItem) {
            lore.add(ChatColor.YELLOW + controller.getMessages().get("wand.brush_item_description"));
        }
        CompatibilityUtils.setLore(itemStack, lore);
        Wand.updateBrushItem(itemStack, materialKey, wand);
        return itemStack;
    }

    protected void saveState() {
        if (this.suspendSave) {
            return;
        }
        if (this.checkWandItem()) {
            this.updateName();
            this.updateLore();
            if (displayManaAsDurability && this.xpMax > 0 && this.xpRegeneration > 0) {
                this.updateDurability();
            }
        }
        MemoryConfiguration stateNode = new MemoryConfiguration();
        this.saveProperties((ConfigurationSection)stateNode);
        Object wandNode = InventoryUtils.createNode(this.item, "wand");
        if (wandNode == null) {
            this.controller.getLogger().warning("Failed to save wand state for wand to : " + this.item + " in slot " + this.playerInventorySlot);
        } else {
            InventoryUtils.saveTagsToNBT((ConfigurationSection)stateNode, wandNode, ALL_PROPERTY_KEYS);
        }
    }

    protected void loadState() {
        if (this.item == null) {
            return;
        }
        Object wandNode = InventoryUtils.getNode(this.item, "wand");
        if (wandNode == null) {
            return;
        }
        MemoryConfiguration stateNode = new MemoryConfiguration();
        InventoryUtils.loadTagsFromNBT((ConfigurationSection)stateNode, wandNode, ALL_PROPERTY_KEYS);
        this.loadProperties((ConfigurationSection)stateNode);
    }

    public void saveProperties(ConfigurationSection node) {
        String iconKey;
        node.set("id", (Object)this.id);
        node.set("materials", (Object)this.getMaterialString());
        node.set("spells", (Object)this.getSpellString());
        node.set("hotbar_count", (Object)this.hotbars.size());
        node.set("hotbar", (Object)this.currentHotbar);
        node.set("active_spell", (Object)this.activeSpell);
        node.set("active_material", (Object)this.activeMaterial);
        node.set("name", (Object)this.wandName);
        node.set("description", (Object)this.description);
        node.set("owner", (Object)this.owner);
        node.set("owner_id", (Object)this.ownerId);
        node.set("cost_reduction", (Object)Float.valueOf(this.costReduction));
        node.set("cooldown_reduction", (Object)Float.valueOf(this.cooldownReduction));
        node.set("power", (Object)Float.valueOf(this.power));
        node.set("protection", (Object)Float.valueOf(this.damageReduction));
        node.set("protection_physical", (Object)Float.valueOf(this.damageReductionPhysical));
        node.set("protection_projectiles", (Object)Float.valueOf(this.damageReductionProjectiles));
        node.set("protection_falling", (Object)Float.valueOf(this.damageReductionFalling));
        node.set("protection_fire", (Object)Float.valueOf(this.damageReductionFire));
        node.set("protection_explosions", (Object)Float.valueOf(this.damageReductionExplosions));
        node.set("haste", (Object)Float.valueOf(this.speedIncrease));
        node.set("xp", (Object)this.xp);
        node.set("xp_regeneration", (Object)this.xpRegeneration);
        node.set("xp_max", (Object)this.xpMax);
        node.set("health_regeneration", (Object)Float.valueOf(this.healthRegeneration));
        node.set("hunger_regeneration", (Object)Float.valueOf(this.hungerRegeneration));
        node.set("uses", (Object)this.uses);
        node.set("locked", (Object)this.locked);
        node.set("effect_color", (Object)(this.effectColor == null ? "none" : this.effectColor.toString()));
        node.set("effect_bubbles", (Object)this.effectBubbles);
        node.set("effect_particle_data", (Object)Float.toString(this.effectParticleData));
        node.set("effect_particle_count", (Object)this.effectParticleCount);
        node.set("effect_particle_interval", (Object)this.effectParticleInterval);
        node.set("effect_sound_interval", (Object)this.effectSoundInterval);
        node.set("quiet", (Object)this.quietLevel);
        node.set("keep", (Object)this.keep);
        node.set("randomize", (Object)this.randomize);
        node.set("rename", (Object)this.rename);
        node.set("bound", (Object)this.bound);
        node.set("force", (Object)this.forceUpgrade);
        node.set("indestructible", (Object)this.indestructible);
        node.set("undroppable", (Object)this.undroppable);
        node.set("fill", (Object)this.autoFill);
        node.set("upgrade", (Object)this.isUpgrade);
        node.set("organize", (Object)this.autoOrganize);
        node.set("alphabetize", (Object)this.autoAlphabetize);
        if (this.castOverrides != null && this.castOverrides.size() > 0) {
            ArrayList<String> parameters = new ArrayList<String>();
            for (Map.Entry<String, String> entry : this.castOverrides.entrySet()) {
                parameters.add(entry.getKey() + " " + entry.getValue());
            }
            node.set("overrides", (Object)StringUtils.join(parameters, (String)","));
        } else {
            node.set("overrides", null);
        }
        if (this.effectSound != null) {
            node.set("effect_sound", (Object)this.effectSound.toString());
        } else {
            node.set("effectSound", null);
        }
        if (this.effectParticle != null) {
            node.set("effect_particle", (Object)this.effectParticle.name());
        } else {
            node.set("effect_particle", null);
        }
        if (this.mode != null) {
            node.set("mode", (Object)this.mode.name());
        } else {
            node.set("mode", null);
        }
        if (this.icon != null) {
            iconKey = this.icon.getKey();
            if (iconKey != null && iconKey.length() > 0) {
                node.set("icon", (Object)iconKey);
            } else {
                node.set("icon", null);
            }
        } else {
            node.set("icon", null);
        }
        if (this.upgradeIcon != null) {
            iconKey = com.elmakers.mine.bukkit.block.MaterialBrush.getMaterialKey(this.upgradeIcon);
            if (iconKey != null && iconKey.length() > 0) {
                node.set("upgrade_icon", (Object)iconKey);
            } else {
                node.set("upgrade_icon", null);
            }
        } else {
            node.set("upgrade_icon", null);
        }
        if (this.template != null && this.template.length() > 0) {
            node.set("template", (Object)this.template);
        } else {
            node.set("template", null);
        }
        if (this.path != null && this.path.length() > 0) {
            node.set("path", (Object)this.path);
        } else {
            node.set("path", null);
        }
        if (this.storedInventory != null && this.controller.isInventoryBackupEnabled()) {
            YamlConfiguration inventoryConfig = new YamlConfiguration();
            ItemStack[] contents = this.storedInventory.getContents();
            inventoryConfig.set("contents", (Object)contents);
            String serialized = inventoryConfig.saveToString();
            node.set("stored", (Object)serialized);
        }
    }

    public void loadProperties(ConfigurationSection wandConfig) {
        this.loadProperties(wandConfig, false);
    }

    public void setEffectColor(String hexColor) {
        if (hexColor.contains(".")) {
            hexColor = hexColor.substring(0, hexColor.indexOf(46));
        }
        if (hexColor == null || hexColor.length() == 0 || hexColor.equals("none")) {
            this.effectColor = null;
            return;
        }
        this.effectColor = new ColorHD(hexColor);
    }

    public void loadProperties(ConfigurationSection wandConfig, boolean safe) {
        String wandSpells;
        this.locked = wandConfig.getBoolean("locked", this.locked);
        float _costReduction = (float)wandConfig.getDouble("cost_reduction", (double)this.costReduction);
        this.costReduction = safe ? Math.max(_costReduction, this.costReduction) : _costReduction;
        float _cooldownReduction = (float)wandConfig.getDouble("cooldown_reduction", (double)this.cooldownReduction);
        this.cooldownReduction = safe ? Math.max(_cooldownReduction, this.cooldownReduction) : _cooldownReduction;
        float _power = (float)wandConfig.getDouble("power", (double)this.power);
        this.power = safe ? Math.max(_power, this.power) : _power;
        float _damageReduction = (float)wandConfig.getDouble("protection", (double)this.damageReduction);
        this.damageReduction = safe ? Math.max(_damageReduction, this.damageReduction) : _damageReduction;
        float _damageReductionPhysical = (float)wandConfig.getDouble("protection_physical", (double)this.damageReductionPhysical);
        this.damageReductionPhysical = safe ? Math.max(_damageReductionPhysical, this.damageReductionPhysical) : _damageReductionPhysical;
        float _damageReductionProjectiles = (float)wandConfig.getDouble("protection_projectiles", (double)this.damageReductionProjectiles);
        this.damageReductionProjectiles = safe ? Math.max(_damageReductionProjectiles, this.damageReductionPhysical) : _damageReductionProjectiles;
        float _damageReductionFalling = (float)wandConfig.getDouble("protection_falling", (double)this.damageReductionFalling);
        this.damageReductionFalling = safe ? Math.max(_damageReductionFalling, this.damageReductionFalling) : _damageReductionFalling;
        float _damageReductionFire = (float)wandConfig.getDouble("protection_fire", (double)this.damageReductionFire);
        this.damageReductionFire = safe ? Math.max(_damageReductionFire, this.damageReductionFire) : _damageReductionFire;
        float _damageReductionExplosions = (float)wandConfig.getDouble("protection_explosions", (double)this.damageReductionExplosions);
        this.damageReductionExplosions = safe ? Math.max(_damageReductionExplosions, this.damageReductionExplosions) : _damageReductionExplosions;
        int _xpRegeneration = wandConfig.getInt("xp_regeneration", this.xpRegeneration);
        this.xpRegeneration = safe ? Math.max(_xpRegeneration, this.xpRegeneration) : _xpRegeneration;
        int _xpMax = wandConfig.getInt("xp_max", this.xpMax);
        this.xpMax = safe ? Math.max(_xpMax, this.xpMax) : _xpMax;
        int _xp = wandConfig.getInt("xp", this.xp);
        this.xp = safe ? Math.max(_xp, this.xp) : _xp;
        float _healthRegeneration = (float)wandConfig.getDouble("health_regeneration", (double)this.healthRegeneration);
        this.healthRegeneration = safe ? Math.max(_healthRegeneration, this.healthRegeneration) : _healthRegeneration;
        float _hungerRegeneration = (float)wandConfig.getDouble("hunger_regeneration", (double)this.hungerRegeneration);
        this.hungerRegeneration = safe ? Math.max(_hungerRegeneration, this.hungerRegeneration) : _hungerRegeneration;
        int _uses = wandConfig.getInt("uses", this.uses);
        this.uses = safe ? Math.max(_uses, this.uses) : _uses;
        float _speedIncrease = (float)wandConfig.getDouble("haste", (double)this.speedIncrease);
        float f = this.speedIncrease = safe ? Math.max(_speedIncrease, this.speedIncrease) : _speedIncrease;
        if (wandConfig.contains("effect_color") && !safe) {
            this.setEffectColor(wandConfig.getString("effect_color"));
        }
        if (wandConfig.contains("hotbar_count")) {
            int newCount = Math.max(1, wandConfig.getInt("hotbar_count"));
            if (!safe && newCount != this.hotbars.size() || newCount > this.hotbars.size()) {
                if (this.isInventoryOpen()) {
                    this.closeInventory();
                }
                wandSpells = this.getSpellString();
                String wandMaterials = this.getMaterialString();
                this.setHotbarCount(newCount);
                if (wandMaterials.length() > 0 || wandSpells.length() > 0) {
                    this.parseInventoryStrings(wandSpells, wandMaterials);
                }
            }
        }
        if (wandConfig.contains("hotbar")) {
            int hotbar = wandConfig.getInt("hotbar");
            int n = this.currentHotbar = hotbar < 0 || hotbar >= this.hotbars.size() ? 0 : hotbar;
        }
        if (!safe) {
            this.id = wandConfig.getString("id", this.id);
            this.isUpgrade = wandConfig.getBoolean("upgrade", this.isUpgrade);
            this.quietLevel = wandConfig.getInt("quiet", this.quietLevel);
            this.effectBubbles = wandConfig.getBoolean("effect_bubbles", this.effectBubbles);
            this.keep = wandConfig.getBoolean("keep", this.keep);
            this.indestructible = wandConfig.getBoolean("indestructible", this.indestructible);
            this.undroppable = wandConfig.getBoolean("undroppable", this.undroppable);
            this.bound = wandConfig.getBoolean("bound", this.bound);
            this.forceUpgrade = wandConfig.getBoolean("force", this.forceUpgrade);
            this.autoOrganize = wandConfig.getBoolean("organize", this.autoOrganize);
            this.autoAlphabetize = wandConfig.getBoolean("alphabetize", this.autoAlphabetize);
            this.autoFill = wandConfig.getBoolean("fill", this.autoFill);
            this.randomize = wandConfig.getBoolean("randomize", this.randomize);
            this.rename = wandConfig.getBoolean("rename", this.rename);
            if (wandConfig.contains("effect_particle")) {
                this.effectParticle = ConfigurationUtils.toParticleEffect(wandConfig.getString("effect_particle"));
                this.effectParticleData = 0.0f;
            }
            if (wandConfig.contains("effect_sound")) {
                this.effectSound = ConfigurationUtils.toSoundEffect(wandConfig.getString("effect_sound"));
            }
            this.effectParticleData = (float)wandConfig.getDouble("effect_particle_data", (double)this.effectParticleData);
            this.effectParticleCount = wandConfig.getInt("effect_particle_count", this.effectParticleCount);
            this.effectParticleInterval = wandConfig.getInt("effect_particle_interval", this.effectParticleInterval);
            this.effectSoundInterval = wandConfig.getInt("effect_sound_interval", this.effectSoundInterval);
            this.setMode(Wand.parseWandMode(wandConfig.getString("mode"), this.mode));
            this.owner = wandConfig.getString("owner", this.owner);
            this.ownerId = wandConfig.getString("owner_id", this.ownerId);
            this.wandName = wandConfig.getString("name", this.wandName);
            this.description = wandConfig.getString("description", this.description);
            this.template = wandConfig.getString("template", this.template);
            this.path = wandConfig.getString("path", this.path);
            this.activeSpell = wandConfig.getString("active_spell", this.activeSpell);
            this.activeMaterial = wandConfig.getString("active_material", this.activeMaterial);
            String wandMaterials = wandConfig.getString("materials", "");
            wandSpells = wandConfig.getString("spells", "");
            if (wandMaterials.length() > 0 || wandSpells.length() > 0) {
                wandMaterials = wandMaterials.length() == 0 ? this.getMaterialString() : wandMaterials;
                wandSpells = wandSpells.length() == 0 ? this.getSpellString() : wandSpells;
                this.parseInventoryStrings(wandSpells, wandMaterials);
            }
            if (wandConfig.contains("randomize_icon")) {
                this.setIcon(ConfigurationUtils.toMaterialAndData(wandConfig.getString("randomize_icon")));
                this.randomize = true;
            } else if (!this.randomize && wandConfig.contains("icon")) {
                String iconKey = wandConfig.getString("icon");
                if (iconKey.contains(",")) {
                    Random r = new Random();
                    String[] keys = StringUtils.split((String)iconKey, (char)',');
                    iconKey = keys[r.nextInt(keys.length)];
                }
                this.setIcon(ConfigurationUtils.toMaterialAndData(iconKey));
            }
            if (wandConfig.contains("upgrade_icon")) {
                this.upgradeIcon = ConfigurationUtils.toMaterialAndData(wandConfig.getString("upgrade_icon"));
            }
            if (wandConfig.contains("overrides")) {
                this.castOverrides = null;
                String overrides = wandConfig.getString("overrides", null);
                if (overrides != null && !overrides.isEmpty()) {
                    String[] pairs;
                    this.castOverrides = new HashMap<String, String>();
                    for (String pair : pairs = StringUtils.split((String)overrides, (char)',')) {
                        String[] keyValue = StringUtils.split((String)pair, (String)" ");
                        if (keyValue.length <= 0) continue;
                        String value = keyValue.length > 1 ? keyValue[1] : "";
                        this.castOverrides.put(keyValue[0], value);
                    }
                }
            }
            if (wandConfig.contains("stored")) {
                try {
                    YamlConfiguration inventoryConfig = new YamlConfiguration();
                    String serialized = wandConfig.getString("stored");
                    if (serialized.isEmpty()) {
                        this.storedInventory = null;
                    } else {
                        inventoryConfig.loadFromString(serialized);
                        Collection collection = (Collection)inventoryConfig.get("contents");
                        ItemStack[] contents = collection.toArray(itemTemplate);
                        this.storedInventory = CompatibilityUtils.createInventory(null, contents.length, "Stored Inventory");
                        this.storedInventory.setContents(contents);
                    }
                }
                catch (Exception ex) {
                    this.controller.getLogger().warning("Error loading stored wand inventory");
                    ex.printStackTrace();
                }
            }
        }
        if (this.effectSound == null) {
            this.effectSoundInterval = 0;
        } else {
            int n = this.effectSoundInterval = this.effectSoundInterval == 0 ? 5 : this.effectSoundInterval;
        }
        if (this.effectParticle == null) {
            this.effectParticleInterval = 0;
        }
        if (this.xp > this.xpMax) {
            this.xp = this.xpMax;
        }
        this.checkActiveMaterial();
    }

    @Override
    public void describe(CommandSender sender) {
        Object wandNode = InventoryUtils.getNode(this.item, "wand");
        if (wandNode == null) {
            sender.sendMessage("Found a wand with missing NBT data. This may be an old wand, or something may have wiped its data");
            return;
        }
        ChatColor wandColor = this.isModifiable() ? ChatColor.AQUA : ChatColor.RED;
        sender.sendMessage(wandColor + this.wandName);
        if (this.description.length() > 0) {
            sender.sendMessage(ChatColor.ITALIC + "" + ChatColor.GREEN + this.description);
        } else {
            sender.sendMessage(ChatColor.ITALIC + "" + ChatColor.GREEN + "(No Description)");
        }
        if (this.owner.length() > 0 || this.ownerId.length() > 0) {
            sender.sendMessage(ChatColor.ITALIC + "" + ChatColor.WHITE + this.owner + " (" + ChatColor.GRAY + this.ownerId + ChatColor.WHITE + ")");
        } else {
            sender.sendMessage(ChatColor.ITALIC + "" + ChatColor.WHITE + "(No Owner)");
        }
        if (this.storedInventory != null) {
            sender.sendMessage(ChatColor.RED + "Has a stored inventory");
        }
        for (String key : PROPERTY_KEYS) {
            String value = InventoryUtils.getMeta(wandNode, key);
            if (value == null || value.length() <= 0) continue;
            sender.sendMessage(key + ": " + value);
        }
    }

    private static String getBrushDisplayName(String materialKey) {
        String materialName = com.elmakers.mine.bukkit.block.MaterialBrush.getMaterialName(materialKey);
        if (materialName == null) {
            materialName = "none";
        }
        return ChatColor.GRAY + materialName;
    }

    private static String getSpellDisplayName(SpellTemplate spell, String materialKey) {
        String name = "";
        if (spell != null) {
            name = materialKey != null && spell.usesBrush() ? ChatColor.GOLD + spell.getName() + " " + Wand.getBrushDisplayName(materialKey) + ChatColor.WHITE : ChatColor.GOLD + spell.getName() + ChatColor.WHITE;
        }
        return name;
    }

    private String getActiveWandName(SpellTemplate spell, String materialKey) {
        boolean showSpell;
        int remaining = this.getRemainingUses();
        ChatColor wandColor = remaining > 0 ? ChatColor.DARK_RED : (this.isModifiable() ? (this.bound ? ChatColor.DARK_AQUA : ChatColor.AQUA) : (this.path != null && this.path.length() > 0 ? ChatColor.LIGHT_PURPLE : ChatColor.GOLD));
        String name = wandColor + this.getDisplayName();
        if (this.randomize) {
            return name;
        }
        Collection spells = this.getSpells();
        boolean bl = showSpell = this.isModifiable() && this.hasPath();
        if (spell != null && (spells.size() > 1 || showSpell)) {
            name = Wand.getSpellDisplayName(spell, materialKey) + " (" + name + ChatColor.WHITE + ")";
        }
        if (remaining > 0) {
            String message = remaining == 1 ? this.controller.getMessages().get("wand.uses_remaining_singular") : this.controller.getMessages().get("wand.uses_remaining_brief");
            name = name + ChatColor.DARK_RED + " (" + ChatColor.RED + message.replace("$count", Integer.valueOf(remaining).toString()) + ChatColor.DARK_RED + ")";
        }
        return name;
    }

    private String getActiveWandName(SpellTemplate spell) {
        return this.getActiveWandName(spell, this.activeMaterial);
    }

    private String getActiveWandName() {
        SpellTemplate spell = null;
        if (this.activeSpell != null && this.activeSpell.length() > 0) {
            spell = this.controller.getSpellTemplate(this.activeSpell);
        }
        return this.getActiveWandName(spell);
    }

    protected String getDisplayName() {
        return this.randomize ? this.controller.getMessages().get("wand.randomized_name") : this.wandName;
    }

    public void updateName(boolean isActive) {
        CompatibilityUtils.setDisplayName(this.item, isActive && !this.isUpgrade ? this.getActiveWandName() : ChatColor.GOLD + this.getDisplayName());
        if (EnableGlow) {
            CompatibilityUtils.addGlow(this.item);
        }
        if (this.indestructible && !displayManaAsDurability) {
            CompatibilityUtils.makeUnbreakable(this.item);
        } else {
            CompatibilityUtils.removeUnbreakable(this.item);
        }
        CompatibilityUtils.hideFlags(this.item);
    }

    private void updateName() {
        this.updateName(true);
    }

    protected static String convertToHTML(String line) {
        int tagCount = 1;
        line = "<span style=\"color:white\">" + line;
        for (ChatColor c : ChatColor.values()) {
            tagCount += StringUtils.countMatches((String)line, (String)c.toString());
            String replaceStyle = "";
            if (c == ChatColor.ITALIC) {
                replaceStyle = "font-style: italic";
            } else if (c == ChatColor.BOLD) {
                replaceStyle = "font-weight: bold";
            } else if (c == ChatColor.UNDERLINE) {
                replaceStyle = "text-decoration: underline";
            } else {
                String color = c.name().toLowerCase().replace("_", "");
                if (c == ChatColor.LIGHT_PURPLE) {
                    color = "mediumpurple";
                }
                replaceStyle = "color:" + color;
            }
            line = line.replace(c.toString(), "<span style=\"" + replaceStyle + "\">");
        }
        for (int i = 0; i < tagCount; ++i) {
            line = line + "</span>";
        }
        return line;
    }

    public String getHTMLDescription() {
        List<String> rawLore = this.getLore();
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("<h2>" + Wand.convertToHTML(this.getActiveWandName()) + "</h2>");
        for (String line : rawLore) {
            lore.add(Wand.convertToHTML(line));
        }
        return "<div style=\"background-color: black; margin: 8px; padding: 8px\">" + StringUtils.join(lore, (String)"<br/>") + "</div>";
    }

    protected List<String> getLore() {
        return this.getLore(this.getSpells().size(), this.getBrushes().size());
    }

    protected void addPropertyLore(List<String> lore) {
        if (this.usesMana()) {
            lore.add(ChatColor.LIGHT_PURPLE + "" + ChatColor.ITALIC + Wand.getLevelString(this.controller.getMessages(), "wand.mana_amount", this.xpMax, this.controller.getMaxMana()));
            lore.add(ChatColor.RESET + "" + ChatColor.LIGHT_PURPLE + Wand.getLevelString(this.controller.getMessages(), "wand.mana_regeneration", this.xpRegeneration, this.controller.getMaxManaRegeneration()));
        }
        if (this.costReduction > 0.0f) {
            lore.add(ChatColor.AQUA + Wand.getLevelString(this.controller.getMessages(), "wand.cost_reduction", this.costReduction));
        }
        if (this.cooldownReduction > 0.0f) {
            lore.add(ChatColor.AQUA + Wand.getLevelString(this.controller.getMessages(), "wand.cooldown_reduction", this.cooldownReduction));
        }
        if (this.power > 0.0f) {
            lore.add(ChatColor.AQUA + Wand.getLevelString(this.controller.getMessages(), "wand.power", this.power));
        }
        if (this.speedIncrease > 0.0f) {
            lore.add(ChatColor.AQUA + Wand.getLevelString(this.controller.getMessages(), "wand.haste", this.speedIncrease));
        }
        if (this.damageReduction > 0.0f) {
            lore.add(ChatColor.AQUA + Wand.getLevelString(this.controller.getMessages(), "wand.protection", this.damageReduction));
        }
        if (this.damageReduction < 1.0f) {
            if (this.damageReductionPhysical > 0.0f) {
                lore.add(ChatColor.AQUA + Wand.getLevelString(this.controller.getMessages(), "wand.protection_physical", this.damageReductionPhysical));
            }
            if (this.damageReductionProjectiles > 0.0f) {
                lore.add(ChatColor.AQUA + Wand.getLevelString(this.controller.getMessages(), "wand.protection_projectile", this.damageReductionProjectiles));
            }
            if (this.damageReductionFalling > 0.0f) {
                lore.add(ChatColor.AQUA + Wand.getLevelString(this.controller.getMessages(), "wand.protection_fall", this.damageReductionFalling));
            }
            if (this.damageReductionFire > 0.0f) {
                lore.add(ChatColor.AQUA + Wand.getLevelString(this.controller.getMessages(), "wand.protection_fire", this.damageReductionFire));
            }
            if (this.damageReductionExplosions > 0.0f) {
                lore.add(ChatColor.AQUA + Wand.getLevelString(this.controller.getMessages(), "wand.protection_blast", this.damageReductionExplosions));
            }
        }
        if (this.healthRegeneration > 0.0f) {
            lore.add(ChatColor.AQUA + Wand.getLevelString(this.controller.getMessages(), "wand.health_regeneration", this.healthRegeneration));
        }
        if (this.hungerRegeneration > 0.0f) {
            lore.add(ChatColor.AQUA + Wand.getLevelString(this.controller.getMessages(), "wand.hunger_regeneration", this.hungerRegeneration));
        }
    }

    public static String getLevelString(Messages messages, String templateName, float amount) {
        return Wand.getLevelString(messages, templateName, amount, 1.0f);
    }

    public static String getLevelString(Messages messages, String templateName, float amount, float max) {
        String templateString = messages.get(templateName);
        if (templateString.contains("$roman")) {
            templateString = templateString.replace("$roman", Wand.getRomanString(messages, amount));
        }
        return templateString.replace("$amount", Integer.toString((int)amount));
    }

    private static String getRomanString(Messages messages, float amount) {
        String roman = "";
        roman = amount > 1.0f ? messages.get("wand.enchantment_level_max") : ((double)amount > 0.8 ? messages.get("wand.enchantment_level_5") : ((double)amount > 0.6 ? messages.get("wand.enchantment_level_4") : ((double)amount > 0.4 ? messages.get("wand.enchantment_level_3") : ((double)amount > 0.2 ? messages.get("wand.enchantment_level_2") : messages.get("wand.enchantment_level_1")))));
        return roman;
    }

    protected List<String> getLore(int spellCount, int materialCount) {
        int remaining;
        ArrayList<String> lore = new ArrayList<String>();
        if (this.description.length() > 0) {
            if (this.description.contains("$")) {
                String randomDescription = this.controller.getMessages().get("wand.randomized_lore");
                if (randomDescription.length() > 0) {
                    lore.add(ChatColor.ITALIC + "" + ChatColor.DARK_GREEN + randomDescription);
                }
            } else {
                lore.add(ChatColor.ITALIC + "" + ChatColor.GREEN + this.description);
            }
        }
        if (this.randomize) {
            return lore;
        }
        SpellTemplate spell = this.controller.getSpellTemplate(this.activeSpell);
        if (spell != null && spellCount == 1 && !this.hasInventory && !this.isUpgrade && this.hasPath()) {
            lore.add(Wand.getSpellDisplayName(spell, null));
            Wand.addSpellLore(this.controller.getMessages(), spell, lore, this);
        }
        if (materialCount == 1 && this.activeMaterial != null && this.activeMaterial.length() > 0) {
            lore.add(Wand.getBrushDisplayName(this.activeMaterial));
        }
        if (!this.isUpgrade && this.owner.length() > 0) {
            String ownerDescription;
            if (this.bound) {
                ownerDescription = this.controller.getMessages().get("wand.bound_description", "$name").replace("$name", this.owner);
                lore.add(ChatColor.ITALIC + "" + ChatColor.DARK_AQUA + ownerDescription);
            } else {
                ownerDescription = this.controller.getMessages().get("wand.owner_description", "$name").replace("$name", this.owner);
                lore.add(ChatColor.ITALIC + "" + ChatColor.DARK_GREEN + ownerDescription);
            }
        }
        if (spellCount > 0) {
            if (this.isUpgrade) {
                lore.add(this.controller.getMessages().get("wand.upgrade_spell_count").replace("$count", Integer.valueOf(spellCount).toString()));
            } else if (spellCount > 1) {
                lore.add(this.controller.getMessages().get("wand.spell_count").replace("$count", Integer.valueOf(spellCount).toString()));
            }
        }
        if (materialCount > 0) {
            if (this.isUpgrade) {
                lore.add(this.controller.getMessages().get("wand.upgrade_material_count").replace("$count", Integer.valueOf(materialCount).toString()));
            } else if (materialCount > 1) {
                lore.add(this.controller.getMessages().get("wand.material_count").replace("$count", Integer.valueOf(materialCount).toString()));
            }
        }
        if ((remaining = this.getRemainingUses()) > 0) {
            if (this.isUpgrade) {
                String message = remaining == 1 ? this.controller.getMessages().get("wand.upgrade_uses_singular") : this.controller.getMessages().get("wand.upgrade_uses");
                lore.add(ChatColor.RED + message.replace("$count", Integer.valueOf(remaining).toString()));
            } else {
                String message = remaining == 1 ? this.controller.getMessages().get("wand.uses_remaining_singular") : this.controller.getMessages().get("wand.uses_remaining_brief");
                lore.add(ChatColor.RED + message.replace("$count", Integer.valueOf(remaining).toString()));
            }
        }
        this.addPropertyLore(lore);
        if (this.isUpgrade) {
            lore.add(ChatColor.YELLOW + this.controller.getMessages().get("wand.upgrade_item_description"));
        }
        return lore;
    }

    protected void updateLore() {
        CompatibilityUtils.setLore(this.item, this.getLore());
        if (EnableGlow) {
            CompatibilityUtils.addGlow(this.item);
        }
    }

    public int getRemainingUses() {
        return this.uses;
    }

    public void makeEnchantable(boolean enchantable) {
        if (EnchantableWandMaterial == null) {
            return;
        }
        if (!enchantable) {
            this.item.setType(this.icon.getMaterial());
            this.item.setDurability((short)this.icon.getData().byteValue());
        } else {
            Set<Material> enchantableMaterials = this.controller.getMaterialSet("enchantable");
            if (!enchantableMaterials.contains(this.item.getType())) {
                this.item.setType(EnchantableWandMaterial);
                this.item.setDurability((short)0);
            }
        }
        this.updateName();
    }

    public static boolean hasActiveWand(Player player) {
        if (player == null) {
            return false;
        }
        ItemStack activeItem = player.getInventory().getItemInHand();
        return Wand.isWand(activeItem);
    }

    public static Wand getActiveWand(MagicController spells, Player player) {
        ItemStack activeItem = player.getInventory().getItemInHand();
        if (Wand.isWand(activeItem)) {
            return new Wand(spells, activeItem);
        }
        return null;
    }

    public static boolean isWand(ItemStack item) {
        return item != null && InventoryUtils.hasMeta(item, "wand") && !Wand.isUpgrade(item);
    }

    public static boolean isUpgrade(ItemStack item) {
        if (item == null) {
            return false;
        }
        Object wandNode = InventoryUtils.getNode(item, "wand");
        if (wandNode == null) {
            return false;
        }
        String upgradeData = InventoryUtils.getMeta(wandNode, "upgrade");
        return upgradeData != null && upgradeData.equals("true");
    }

    public static boolean isSpell(ItemStack item) {
        return item != null && InventoryUtils.hasMeta(item, "spell");
    }

    public static boolean isBrush(ItemStack item) {
        return item != null && InventoryUtils.hasMeta(item, "brush");
    }

    public static String getSpell(ItemStack item) {
        Object spellNode = InventoryUtils.getNode(item, "spell");
        if (spellNode == null) {
            return null;
        }
        return InventoryUtils.getMeta(spellNode, "key");
    }

    public static String getBrush(ItemStack item) {
        Object brushNode = InventoryUtils.getNode(item, "brush");
        if (brushNode == null) {
            return null;
        }
        return InventoryUtils.getMeta(brushNode, "key");
    }

    protected void updateInventoryName(ItemStack item, boolean activeName) {
        if (Wand.isSpell(item)) {
            Spell spell = this.mage.getSpell(Wand.getSpell(item));
            if (spell != null) {
                Wand.updateSpellItem(this.controller.getMessages(), item, spell, activeName ? this : null, this.activeMaterial, false);
            }
        } else if (Wand.isBrush(item)) {
            Wand.updateBrushItem(item, Wand.getBrush(item), activeName ? this : null);
        }
    }

    public static void updateSpellItem(Messages messages, ItemStack itemStack, SpellTemplate spell, Wand wand, String activeMaterial, boolean isItem) {
        String displayName = wand != null ? wand.getActiveWandName(spell) : Wand.getSpellDisplayName(spell, activeMaterial);
        CompatibilityUtils.setDisplayName(itemStack, displayName);
        ArrayList<String> lore = new ArrayList<String>();
        Wand.addSpellLore(messages, spell, lore, wand);
        if (isItem) {
            lore.add(ChatColor.YELLOW + messages.get("wand.spell_item_description"));
        }
        CompatibilityUtils.setLore(itemStack, lore);
        Object spellNode = CompatibilityUtils.createNode(itemStack, "spell");
        CompatibilityUtils.setMeta(spellNode, "key", spell.getKey());
        if (SpellGlow) {
            CompatibilityUtils.addGlow(itemStack);
        }
    }

    public static void updateBrushItem(ItemStack itemStack, String materialKey, Wand wand) {
        String displayName = null;
        displayName = wand != null ? wand.getActiveWandName(materialKey) : com.elmakers.mine.bukkit.block.MaterialBrush.getMaterialName(materialKey);
        CompatibilityUtils.setDisplayName(itemStack, displayName);
        Object brushNode = CompatibilityUtils.createNode(itemStack, "brush");
        CompatibilityUtils.setMeta(brushNode, "key", materialKey);
    }

    public void updateHotbar() {
        if (this.mage == null) {
            return;
        }
        if (!this.isInventoryOpen()) {
            return;
        }
        Player player = this.mage.getPlayer();
        if (player == null) {
            return;
        }
        if (!this.hasStoredInventory()) {
            return;
        }
        WandMode wandMode = this.getMode();
        if (wandMode == WandMode.INVENTORY) {
            PlayerInventory inventory = player.getInventory();
            this.updateHotbar(inventory);
            player.updateInventory();
        }
    }

    private void updateInventory() {
        if (this.mage == null) {
            return;
        }
        if (!this.isInventoryOpen()) {
            return;
        }
        Player player = this.mage.getPlayer();
        if (player == null) {
            return;
        }
        WandMode wandMode = this.getMode();
        if (wandMode == WandMode.INVENTORY) {
            if (!this.hasStoredInventory()) {
                return;
            }
            PlayerInventory inventory = player.getInventory();
            inventory.clear();
            this.updateHotbar(inventory);
            this.updateInventory((Inventory)inventory, 9, false);
            this.updateName();
            player.updateInventory();
        } else if (wandMode == WandMode.CHEST) {
            Inventory inventory = this.getDisplayInventory();
            inventory.clear();
            this.updateInventory(inventory, 0, true);
            player.updateInventory();
        }
    }

    private void updateHotbar(PlayerInventory playerInventory) {
        Inventory hotbar = this.getHotbar();
        int currentSlot = playerInventory.getHeldItemSlot();
        int targetOffset = 0;
        for (int hotbarSlot = 0; hotbarSlot < 8; ++hotbarSlot) {
            if (hotbarSlot == currentSlot) {
                targetOffset = 1;
            }
            ItemStack hotbarItem = hotbar.getItem(hotbarSlot);
            this.updateInventoryName(hotbarItem, true);
            playerInventory.setItem(hotbarSlot + targetOffset, hotbarItem);
        }
        playerInventory.setItem(currentSlot, this.item);
        this.item = playerInventory.getItem(currentSlot);
    }

    private void updateInventory(Inventory targetInventory, int startOffset, boolean addHotbar) {
        int currentOffset = startOffset;
        if (this.openInventoryPage < this.inventories.size()) {
            Inventory inventory = this.inventories.get(this.openInventoryPage);
            ItemStack[] contents = inventory.getContents();
            for (int i = 0; i < contents.length; ++i) {
                ItemStack inventoryItem = contents[i];
                this.updateInventoryName(inventoryItem, false);
                targetInventory.setItem(currentOffset, inventoryItem);
                ++currentOffset;
            }
        }
        if (addHotbar) {
            Inventory hotbar = this.getHotbar();
            for (int i = 0; i < 8; ++i) {
                ItemStack inventoryItem = hotbar.getItem(i);
                this.updateInventoryName(inventoryItem, false);
                targetInventory.setItem(currentOffset++, inventoryItem);
            }
        }
    }

    protected static void addSpellLore(Messages messages, SpellTemplate spell, List<String> lore, CostReducer reducer) {
        String undoableText;
        String brushText;
        long duration;
        Collection<CastingCost> activeCosts;
        Collection<CastingCost> costs;
        String cooldownDescription;
        String description = spell.getDescription();
        String usage = spell.getUsage();
        String levelString = spell.getLevelDescription();
        if (levelString != null && levelString.length() > 0) {
            lore.add(ChatColor.GOLD + levelString);
        }
        if (description != null && description.length() > 0) {
            lore.add(description);
        }
        if (usage != null && usage.length() > 0) {
            lore.add(usage);
        }
        if ((cooldownDescription = spell.getCooldownDescription()) != null && !cooldownDescription.isEmpty()) {
            lore.add(messages.get("cooldown.description").replace("$time", cooldownDescription));
        }
        if ((costs = spell.getCosts()) != null) {
            for (CastingCost cost : costs) {
                if (!cost.hasCosts(reducer)) continue;
                lore.add(ChatColor.YELLOW + messages.get("wand.costs_description").replace("$description", cost.getFullDescription(messages, reducer)));
            }
        }
        if ((activeCosts = spell.getActiveCosts()) != null) {
            for (CastingCost cost : activeCosts) {
                if (!cost.hasCosts(reducer)) continue;
                lore.add(ChatColor.YELLOW + messages.get("wand.active_costs_description").replace("$description", cost.getFullDescription(messages, reducer)));
            }
        }
        if ((duration = spell.getDuration()) > 0L) {
            long seconds = duration / 1000L;
            if (seconds > 3600L) {
                long hours = seconds / 3600L;
                lore.add(messages.get("duration.lasts_hours").replace("$hours", Long.valueOf(hours).toString()));
            } else if (seconds > 60L) {
                long minutes = seconds / 60L;
                lore.add(messages.get("duration.lasts_minutes").replace("$minutes", Long.valueOf(minutes).toString()));
            } else {
                lore.add(messages.get("duration.lasts_seconds").replace("$seconds", Long.valueOf(seconds).toString()));
            }
        }
        if (spell.usesBrush() && !(brushText = messages.get("spell.brush")).isEmpty()) {
            lore.add(ChatColor.GOLD + brushText);
        }
        if (spell.isUndoable() && !(undoableText = messages.get("spell.undoable")).isEmpty()) {
            lore.add(ChatColor.GRAY + undoableText);
        }
    }

    protected Inventory getOpenInventory() {
        while (this.openInventoryPage >= this.inventories.size()) {
            this.inventories.add(CompatibilityUtils.createInventory(null, 27, "Wand"));
        }
        return this.inventories.get(this.openInventoryPage);
    }

    public void saveInventory() {
        if (this.mage == null) {
            return;
        }
        if (!this.isInventoryOpen()) {
            return;
        }
        if (this.mage.getPlayer() == null) {
            return;
        }
        if (this.getMode() != WandMode.INVENTORY) {
            return;
        }
        if (!this.hasStoredInventory()) {
            return;
        }
        if (this.mage.isDead()) {
            return;
        }
        Player player = this.mage.getPlayer();
        PlayerInventory playerInventory = player.getInventory();
        Inventory hotbar = this.getHotbar();
        int saveOffset = 0;
        for (int i = 0; i < 9; ++i) {
            ItemStack playerItem = playerInventory.getItem(i);
            if (Wand.isWand(playerItem)) {
                saveOffset = -1;
                continue;
            }
            hotbar.setItem(i + saveOffset, playerItem);
            this.updateSlot(i + saveOffset + this.currentHotbar * 8, playerItem);
        }
        int hotbarOffset = this.getHotbarSize();
        Inventory openInventory = this.getOpenInventory();
        for (int i = 0; i < openInventory.getSize(); ++i) {
            ItemStack playerItem = playerInventory.getItem(i + 9);
            openInventory.setItem(i, playerItem);
            this.updateSlot(i + hotbarOffset + this.openInventoryPage * 27, playerItem);
        }
    }

    protected void updateSlot(int slot, ItemStack item) {
        String spellKey = Wand.getSpell(item);
        if (spellKey != null) {
            this.spells.put(spellKey, slot);
        } else {
            String brushKey = Wand.getBrush(item);
            if (brushKey != null) {
                this.brushes.put(brushKey, slot);
            }
        }
    }

    @Override
    public int enchant(int totalLevels, com.elmakers.mine.bukkit.api.magic.Mage mage) {
        return this.randomize(totalLevels, true, mage);
    }

    @Override
    public int enchant(int totalLevels) {
        return this.randomize(totalLevels, true, null);
    }

    protected int randomize(int totalLevels, boolean additive, com.elmakers.mine.bukkit.api.magic.Mage enchanter) {
        WandUpgradePath path;
        if (enchanter == null && this.mage != null) {
            enchanter = this.mage;
        }
        if ((path = this.getPath()) == null) {
            if (enchanter != null) {
                enchanter.sendMessage(this.controller.getMessages().get("wand.no_path"));
            }
            return 0;
        }
        path.catchup(this, enchanter);
        int minLevel = path.getMinLevel();
        if (totalLevels < minLevel) {
            if (enchanter != null) {
                String levelMessage = this.controller.getMessages().get("wand.need_more_levels");
                levelMessage = levelMessage.replace("$levels", Integer.toString(minLevel));
                enchanter.sendMessage(levelMessage);
            }
            return 0;
        }
        int maxLevel = path.getMaxLevel();
        totalLevels = Math.min(totalLevels, maxLevel * 50);
        int addLevels = Math.min(totalLevels, maxLevel);
        int levels = 0;
        boolean modified = true;
        while (addLevels >= minLevel && modified) {
            WandLevel level = path.getLevel(addLevels);
            modified = level.randomizeWand(enchanter, this, additive);
            totalLevels -= maxLevel;
            if (modified) {
                if (enchanter != null) {
                    path.enchanted(enchanter);
                }
                levels += addLevels;
            } else if (path.hasUpgrade()) {
                if (path.checkUpgrade(enchanter, this)) {
                    WandUpgradePath newPath = path.getUpgrade();
                    if (newPath == null) {
                        enchanter.sendMessage("Configuration issue, please check logs");
                        this.controller.getLogger().warning("Invalid upgrade path: " + path.getUpgrade());
                    } else {
                        enchanter.sendMessage(this.controller.getMessages().get("wand.level_up").replace("$path", newPath.getName()));
                        path.upgraded(this, enchanter);
                        this.path = newPath.getKey();
                        levels += addLevels;
                    }
                }
            } else if (enchanter != null) {
                enchanter.sendMessage(this.controller.getMessages().get("wand.fully_enchanted"));
            }
            addLevels = Math.min(totalLevels, maxLevel);
            additive = true;
        }
        this.saveState();
        this.updateName();
        this.updateLore();
        return levels;
    }

    public static ItemStack createItem(MagicController controller, String templateName) {
        Wand wand;
        ItemStack item = Wand.createSpellItem(templateName, controller, null, true);
        if (item == null && (item = Wand.createBrushItem(templateName, controller, null, true)) == null && (wand = Wand.createWand(controller, templateName)) != null) {
            item = wand.getItem();
        }
        return item;
    }

    public static Wand createWand(MagicController controller, String templateName) {
        if (controller == null) {
            return null;
        }
        Wand wand = null;
        try {
            wand = new Wand(controller, templateName);
        }
        catch (UnknownWandException ignore) {
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return wand;
    }

    protected void sendAddMessage(String messageKey, String nameParam) {
        if (this.mage == null) {
            return;
        }
        String message = this.controller.getMessages().get(messageKey).replace("$name", nameParam);
        this.mage.sendMessage(message);
    }

    public boolean add(Wand other) {
        Player player;
        int newCount;
        if (!(this.isModifiable() || other.isUpgrade() && other.path != null && this.path != null && other.path.equals(this.path))) {
            return false;
        }
        if (!(!other.isUpgrade() || other.path == null || other.path.isEmpty() || this.path != null && this.path.equals(other.path))) {
            return false;
        }
        boolean modified = false;
        Messages messages = this.controller.getMessages();
        if (other.isForcedUpgrade() || other.costReduction > this.costReduction) {
            this.costReduction = other.costReduction;
            modified = true;
            if (this.costReduction > 0.0f) {
                this.sendAddMessage("wand.upgraded_property", Wand.getLevelString(messages, "wand.cost_reduction", this.costReduction));
            }
        }
        if (other.isForcedUpgrade() || other.power > this.power) {
            this.power = other.power;
            modified = true;
            if (this.power > 0.0f) {
                this.sendAddMessage("wand.upgraded_property", Wand.getLevelString(messages, "wand.power", this.power));
            }
        }
        if (other.isForcedUpgrade() || other.damageReduction > this.damageReduction) {
            this.damageReduction = other.damageReduction;
            modified = true;
            if (this.damageReduction > 0.0f) {
                this.sendAddMessage("wand.upgraded_property", Wand.getLevelString(messages, "wand.protection", this.damageReduction));
            }
        }
        if (other.isForcedUpgrade() || other.damageReductionPhysical > this.damageReductionPhysical) {
            this.damageReductionPhysical = other.damageReductionPhysical;
            modified = true;
            if (this.damageReductionPhysical > 0.0f) {
                this.sendAddMessage("wand.upgraded_property", Wand.getLevelString(messages, "wand.protection_physical", this.damageReductionPhysical));
            }
        }
        if (other.isForcedUpgrade() || other.damageReductionProjectiles > this.damageReductionProjectiles) {
            this.damageReductionProjectiles = other.damageReductionProjectiles;
            modified = true;
            if (this.damageReductionProjectiles > 0.0f) {
                this.sendAddMessage("wand.upgraded_property", Wand.getLevelString(messages, "wand.protection_projectile", this.damageReductionProjectiles));
            }
        }
        if (other.isForcedUpgrade() || other.damageReductionFalling > this.damageReductionFalling) {
            this.damageReductionFalling = other.damageReductionFalling;
            modified = true;
            if (this.damageReductionFalling > 0.0f) {
                this.sendAddMessage("wand.upgraded_property", Wand.getLevelString(messages, "wand.protection_fall", this.damageReductionFalling));
            }
        }
        if (other.isForcedUpgrade() || other.damageReductionFire > this.damageReductionFire) {
            this.damageReductionFire = other.damageReductionFire;
            modified = true;
            if (this.damageReductionFire > 0.0f) {
                this.sendAddMessage("wand.upgraded_property", Wand.getLevelString(messages, "wand.protection_fire", this.damageReductionFire));
            }
        }
        if (other.isForcedUpgrade() || other.damageReductionExplosions > this.damageReductionExplosions) {
            this.damageReductionExplosions = other.damageReductionExplosions;
            modified = true;
            if (this.damageReductionExplosions > 0.0f) {
                this.sendAddMessage("wand.upgraded_property", Wand.getLevelString(messages, "wand.protection_blast", this.damageReductionExplosions));
            }
        }
        if (other.isForcedUpgrade() || other.healthRegeneration > this.healthRegeneration) {
            this.healthRegeneration = other.healthRegeneration;
            modified = true;
            if (this.healthRegeneration > 0.0f) {
                this.sendAddMessage("wand.upgraded_property", Wand.getLevelString(messages, "wand.health_regeneration", this.healthRegeneration));
            }
        }
        if (other.isForcedUpgrade() || other.hungerRegeneration > this.hungerRegeneration) {
            this.hungerRegeneration = other.hungerRegeneration;
            modified = true;
            if (this.hungerRegeneration > 0.0f) {
                this.sendAddMessage("wand.upgraded_property", Wand.getLevelString(messages, "wand.hunger_regeneration", this.hungerRegeneration));
            }
        }
        if (other.isForcedUpgrade() || other.speedIncrease > this.speedIncrease) {
            this.speedIncrease = other.speedIncrease;
            modified = true;
            if (this.speedIncrease > 0.0f) {
                this.sendAddMessage("wand.upgraded_property", Wand.getLevelString(messages, "wand.haste", this.speedIncrease));
            }
        }
        if ((other.isForcedUpgrade() || other.hotbars.size() > this.hotbars.size()) && (newCount = Math.max(1, other.hotbars.size())) != this.hotbars.size()) {
            if (this.isInventoryOpen()) {
                this.closeInventory();
            }
            String wandSpells = this.getSpellString();
            String wandMaterials = this.getMaterialString();
            this.setHotbarCount(newCount);
            if (wandMaterials.length() > 0 || wandSpells.length() > 0) {
                this.parseInventoryStrings(wandSpells, wandMaterials);
            }
            modified = true;
            this.sendAddMessage("wand.hotbar_added", Integer.toString(newCount));
        }
        if (other.effectColor != null) {
            this.effectColor = this.effectColor == null || other.isUpgrade() && other.effectColor != null ? other.effectColor : this.effectColor.mixColor(other.effectColor, (double)other.effectColorMixWeight);
            modified = true;
        }
        if (other.rename && other.template != null && other.template.length() > 0) {
            ConfigurationSection template = wandTemplates.get(other.template);
            this.wandName = template.getString("name", this.wandName);
            this.wandName = messages.get("wands." + other.template + ".name", this.wandName);
            this.updateName();
        }
        if (other.quietLevel < 0) {
            int quiet = -other.quietLevel - 1;
            modified = this.quietLevel != quiet;
            this.quietLevel = quiet;
        }
        modified |= !this.keep && other.keep;
        modified |= !this.bound && other.bound;
        modified |= !this.effectBubbles && other.effectBubbles;
        modified |= !this.undroppable && other.undroppable;
        modified |= !this.indestructible && other.indestructible;
        this.keep = this.keep || other.keep;
        this.bound = this.bound || other.bound;
        this.indestructible = this.indestructible || other.indestructible;
        this.undroppable = this.undroppable || other.undroppable;
        boolean bl = this.effectBubbles = this.effectBubbles || other.effectBubbles;
        if (other.effectParticle != null && (other.isUpgrade || this.effectParticle == null)) {
            modified |= this.effectParticle != other.effectParticle;
            this.effectParticle = other.effectParticle;
            modified |= this.effectParticleData != other.effectParticleData;
            this.effectParticleData = other.effectParticleData;
            modified |= this.effectParticleCount != other.effectParticleCount;
            this.effectParticleCount = other.effectParticleCount;
            modified |= this.effectParticleInterval != other.effectParticleInterval;
            this.effectParticleInterval = other.effectParticleInterval;
        }
        if (other.effectSound != null && (other.isUpgrade || this.effectSound == null)) {
            modified |= this.effectSound == null || !this.effectSound.equals(other.effectSound);
            this.effectSound = other.effectSound;
            modified |= this.effectSoundInterval != other.effectSoundInterval;
            this.effectSoundInterval = other.effectSoundInterval;
        }
        if ((this.template == null || this.template.length() == 0) && other.template != null && other.template.length() > 0) {
            modified = true;
            this.template = other.template;
        }
        if (other.isUpgrade && other.mode != null) {
            modified |= this.mode != other.mode;
            this.setMode(other.mode);
        }
        if (other.upgradeIcon != null && (this.icon == null || this.icon.getMaterial() != other.upgradeIcon.getMaterial() || this.icon.getData() != other.upgradeIcon.getData())) {
            modified = true;
            this.setIcon(other.upgradeIcon);
        }
        if (this.isCostFree()) {
            this.xpRegeneration = 0;
            this.xpMax = 0;
            this.xp = 0;
        } else {
            if (other.isForcedUpgrade() || other.xpRegeneration > this.xpRegeneration) {
                this.xpRegeneration = other.xpRegeneration;
                modified = true;
                this.sendAddMessage("wand.upgraded_property", Wand.getLevelString(messages, "wand.mana_regeneration", this.xpRegeneration, this.controller.getMaxManaRegeneration()));
            }
            if (other.isForcedUpgrade() || other.xpMax > this.xpMax) {
                this.xpMax = other.xpMax;
                modified = true;
                this.sendAddMessage("wand.upgraded_property", Wand.getLevelString(messages, "wand.mana_amount", this.xpMax, this.controller.getMaxMana()));
            }
            if (other.isForcedUpgrade() || other.xp > this.xp) {
                this.xp = other.xp;
                modified = true;
            }
        }
        if (this.uses == 0 || other.uses == 0) {
            modified |= this.uses != 0;
            this.uses = 0;
        } else {
            modified |= other.uses != 0;
            this.uses += other.uses;
        }
        Collection spells = other.getSpells();
        for (String spellKey : spells) {
            SpellTemplate currentSpell = this.getBaseSpell(spellKey);
            if (!this.addSpell(spellKey)) continue;
            modified = true;
            String spellName = spellKey;
            SpellTemplate spell = this.controller.getSpellTemplate(spellKey);
            if (spell != null) {
                spellName = spell.getName();
            }
            if (this.mage == null) continue;
            if (currentSpell != null) {
                String levelDescription = spell.getLevelDescription();
                if (levelDescription == null || levelDescription.isEmpty()) {
                    levelDescription = spell.getName();
                }
                this.mage.sendMessage(messages.get("wand.spell_upgraded").replace("$name", currentSpell.getName()).replace("$level", levelDescription));
                continue;
            }
            this.mage.sendMessage(messages.get("wand.spell_added").replace("$name", spell.getName()));
        }
        Collection materials = other.getBrushes();
        for (String materialKey : materials) {
            if (!this.addBrush(materialKey)) continue;
            modified = true;
            if (this.mage == null) continue;
            this.mage.sendMessage(messages.get("wand.brush_added").replace("$name", com.elmakers.mine.bukkit.block.MaterialBrush.getMaterialName(materialKey)));
        }
        if (other.castOverrides != null && other.castOverrides.size() > 0) {
            if (this.castOverrides == null) {
                this.castOverrides = new HashMap<String, String>();
            }
            HashSet<String> upgradedSpells = new HashSet<String>();
            for (Map.Entry<String, String> entry : other.castOverrides.entrySet()) {
                String overrideKey = entry.getKey();
                String currentValue = this.castOverrides.get(overrideKey);
                String value = entry.getValue();
                if (currentValue != null && !other.isForcedUpgrade()) {
                    try {
                        double currentDouble = Double.parseDouble(currentValue);
                        double newDouble = Double.parseDouble(value);
                        if (newDouble < currentDouble) {
                            value = currentValue;
                        }
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                boolean addOverride = currentValue == null || !value.equals(currentValue);
                boolean bl2 = modified = modified || addOverride;
                if (addOverride && this.mage != null && overrideKey.contains(".")) {
                    String spellKey;
                    String[] pieces = StringUtils.split((String)overrideKey, (char)'.');
                    String spellName = spellKey = pieces[0];
                    if (!upgradedSpells.contains(spellKey)) {
                        SpellTemplate spell = this.controller.getSpellTemplate(spellKey);
                        if (spell != null) {
                            spellName = spell.getName();
                        }
                        this.mage.sendMessage(messages.get("wand.spell_override_upgraded").replace("$name", spellName));
                        upgradedSpells.add(spellKey);
                    }
                }
                this.castOverrides.put(entry.getKey(), entry.getValue());
            }
        }
        Player player2 = player = this.mage == null ? null : this.mage.getPlayer();
        if (other.autoFill && player != null) {
            this.fill(player);
            modified = true;
            if (this.mage != null) {
                this.mage.sendMessage(this.controller.getMessages().get("wand.filled"));
            }
        }
        if (other.autoOrganize && this.mage != null) {
            this.organizeInventory(this.mage);
            modified = true;
            if (this.mage != null) {
                this.mage.sendMessage(this.controller.getMessages().get("wand.reorganized"));
            }
        }
        if (other.autoAlphabetize) {
            this.alphabetizeInventory();
            modified = true;
            if (this.mage != null) {
                this.mage.sendMessage(this.controller.getMessages().get("wand.alphabetized"));
            }
        }
        this.saveState();
        this.updateName();
        this.updateLore();
        return modified;
    }

    public boolean isForcedUpgrade() {
        return this.isUpgrade && this.forceUpgrade;
    }

    public boolean keepOnDeath() {
        return this.keep;
    }

    public static void loadTemplates(ConfigurationSection properties) {
        wandTemplates.clear();
        Set wandKeys = properties.getKeys(false);
        for (String key : wandKeys) {
            ConfigurationSection wandNode = properties.getConfigurationSection(key);
            wandNode.set("key", (Object)key);
            ConfigurationSection existing = wandTemplates.get(key);
            if (existing != null) {
                Set overrideKeys = existing.getKeys(false);
                for (String propertyKey : overrideKeys) {
                    existing.set(propertyKey, existing.get(key));
                }
            } else {
                wandTemplates.put(key, wandNode);
            }
            if (wandNode.getBoolean("enabled", true)) continue;
            wandTemplates.remove(key);
        }
    }

    public static Collection<String> getWandKeys() {
        return wandTemplates.keySet();
    }

    public static Collection<ConfigurationSection> getWandTemplates() {
        return wandTemplates.values();
    }

    public static ConfigurationSection getWandTemplate(String key) {
        return wandTemplates.get(key);
    }

    public static WandMode parseWandMode(String modeString, WandMode defaultValue) {
        for (WandMode testMode : WandMode.values()) {
            if (!testMode.name().equalsIgnoreCase(modeString)) continue;
            return testMode;
        }
        return defaultValue;
    }

    private void updateActiveMaterial() {
        if (this.mage == null) {
            return;
        }
        if (this.activeMaterial == null) {
            this.mage.clearBuildingMaterial();
        } else {
            MaterialBrush brush = this.mage.getBrush();
            brush.update(this.activeMaterial);
        }
    }

    public void toggleInventory() {
        if (!this.hasInventory) {
            if (this.activeSpell == null || this.activeSpell.length() == 0) {
                Collection spells = this.getSpells();
                if (spells.size() > 1) {
                    this.hasInventory = true;
                }
                if (spells.size() > 0) {
                    this.activeSpell = (String)spells.iterator().next();
                }
            }
            this.updateName();
            return;
        }
        if (!this.isInventoryOpen()) {
            this.openInventory();
        } else {
            this.closeInventory();
        }
    }

    public void cycleInventory(int direction) {
        if (!this.hasInventory) {
            return;
        }
        if (this.isInventoryOpen()) {
            this.saveInventory();
            int inventoryCount = this.inventories.size();
            this.openInventoryPage = inventoryCount == 0 ? 0 : (this.openInventoryPage + inventoryCount + direction) % inventoryCount;
            this.updateInventory();
            if (this.mage != null && this.inventories.size() > 1) {
                if (inventoryCycleSound != null) {
                    this.mage.playSound(inventoryCycleSound.getSound(), inventoryCycleSound.getVolume(), inventoryCycleSound.getPitch());
                }
                this.mage.getPlayer().updateInventory();
            }
        }
    }

    public void cycleHotbar(int direction) {
        if (!this.hasInventory) {
            return;
        }
        if (this.isInventoryOpen() && this.mage != null && this.hotbars.size() > 1) {
            this.saveInventory();
            int hotbarCount = this.hotbars.size();
            this.currentHotbar = hotbarCount == 0 ? 0 : (this.currentHotbar + hotbarCount + direction) % hotbarCount;
            this.updateHotbar();
            if (inventoryCycleSound != null) {
                this.mage.playSound(inventoryCycleSound.getSound(), inventoryCycleSound.getVolume(), inventoryCycleSound.getPitch());
            }
            this.mage.getPlayer().updateInventory();
        }
    }

    public void cycleInventory() {
        this.cycleInventory(1);
    }

    private void openInventory() {
        if (this.mage == null) {
            return;
        }
        WandMode wandMode = this.getMode();
        if (wandMode == WandMode.CHEST) {
            this.inventoryIsOpen = true;
            if (inventoryOpenSound != null) {
                this.mage.playSound(inventoryOpenSound.getSound(), inventoryOpenSound.getVolume(), inventoryOpenSound.getPitch());
            }
            this.updateInventory();
            this.mage.getPlayer().openInventory(this.getDisplayInventory());
        } else if (wandMode == WandMode.INVENTORY) {
            if (this.hasStoredInventory()) {
                return;
            }
            ItemStack debugStack = this.mage.getPlayer().getInventory().getItem(this.mage.getPlayer().getInventory().getHeldItemSlot());
            if (this.storeInventory()) {
                this.inventoryIsOpen = true;
                if (inventoryOpenSound != null) {
                    this.mage.playSound(inventoryOpenSound.getSound(), inventoryOpenSound.getVolume(), inventoryOpenSound.getPitch());
                }
                this.updateInventory();
                this.mage.getPlayer().updateInventory();
            }
        }
    }

    @Override
    public void closeInventory() {
        if (!this.isInventoryOpen()) {
            return;
        }
        this.saveInventory();
        this.inventoryIsOpen = false;
        if (this.mage != null) {
            if (inventoryCloseSound != null) {
                this.mage.playSound(inventoryCloseSound.getSound(), inventoryCloseSound.getVolume(), inventoryCloseSound.getPitch());
            }
            if (this.getMode() == WandMode.INVENTORY) {
                this.restoreInventory();
            } else {
                this.mage.getPlayer().closeInventory();
            }
        }
    }

    @Override
    public boolean fill(Player player) {
        Collection<SpellTemplate> allSpells = this.controller.getPlugin().getSpellTemplates();
        for (SpellTemplate spell : allSpells) {
            if (!spell.hasCastPermission((CommandSender)player) || !spell.hasIcon() || spell.isHidden()) continue;
            this.addSpell(spell.getKey());
        }
        this.autoFill = false;
        this.saveState();
        return true;
    }

    protected boolean checkWandItem() {
        Player player;
        ItemStack currentItem;
        if (this.playerInventorySlot != null && this.mage != null && this.mage.isPlayer() && Wand.isWand(currentItem = (player = this.mage.getPlayer()).getInventory().getItem(this.playerInventorySlot.intValue())) && NMSUtils.getHandle(currentItem) != NMSUtils.getHandle(this.item)) {
            this.item = currentItem;
            return true;
        }
        return false;
    }

    public void activate(Mage mage, ItemStack wandItem, int slot) {
        if (mage == null || wandItem == null) {
            return;
        }
        this.id = null;
        if (!this.canUse(mage.getPlayer())) {
            mage.sendMessage(this.controller.getMessages().get("wand.bound").replace("$name", this.getOwner()));
            mage.setActiveWand(null);
            return;
        }
        if (this.isUpgrade) {
            this.controller.getLogger().warning("Activated an upgrade item- this shouldn't happen");
            return;
        }
        this.playerInventorySlot = slot;
        boolean needsSave = NMSUtils.getHandle(this.item) != NMSUtils.getHandle(wandItem);
        this.item = wandItem;
        this.mage = mage;
        Player player = mage.getPlayer();
        PlayerInventory inventory = player.getInventory();
        ItemStack[] items = inventory.getContents();
        boolean forceUpdate = false;
        for (int i = 0; i < items.length; ++i) {
            ItemStack item = items[i];
            if (!this.addItem(item)) continue;
            inventory.setItem(i, null);
            forceUpdate = true;
        }
        if (!this.isUpgrade && (this.controller.fillWands() || this.autoFill)) {
            this.fill(mage.getPlayer());
        }
        if (this.autoOrganize && !this.isUpgrade) {
            this.organizeInventory(mage);
        }
        if (this.autoAlphabetize && !this.isUpgrade) {
            this.alphabetizeInventory();
        }
        if (!(!this.bound || this.ownerId != null && this.ownerId.length() != 0 || this.controller.hasPermission(player, "Magic.wand.override_bind", false) || this.owner != null && this.owner.length() != 0 && !this.owner.equals(player.getName()))) {
            this.takeOwnership(mage.getPlayer());
            needsSave = true;
        }
        if (this.randomize) {
            this.randomize();
            forceUpdate = true;
        }
        this.checkActiveMaterial();
        mage.setActiveWand(this);
        if (this.usesMana()) {
            if (this.displayManaAsXp()) {
                this.storedXpLevel = player.getLevel();
                this.storedXpProgress = player.getExp();
            }
            this.updateMana();
        }
        if (needsSave) {
            this.saveState();
        }
        this.updateActiveMaterial();
        this.updateName();
        this.updateLore();
        this.updateEffects();
        if (forceUpdate) {
            player.updateInventory();
        }
    }

    protected void randomize() {
        ConfigurationSection wandConfig;
        String newDescription;
        boolean modified = this.randomize;
        this.randomize = false;
        if (this.description.contains("$") && !(newDescription = this.controller.getMessages().escape(this.description)).equals(this.description)) {
            this.description = newDescription;
            modified = true;
            this.updateLore();
            this.updateName();
        }
        if (this.template != null && this.template.length() > 0 && (wandConfig = wandTemplates.get(this.template)) != null && wandConfig.contains("icon")) {
            String iconKey = wandConfig.getString("icon");
            if (iconKey.contains(",")) {
                Random r = new Random();
                String[] keys = StringUtils.split((String)iconKey, (char)',');
                iconKey = keys[r.nextInt(keys.length)];
            }
            this.setIcon(ConfigurationUtils.toMaterialAndData(iconKey));
            modified = true;
        }
        if (modified) {
            this.saveState();
        }
    }

    protected void checkActiveMaterial() {
        Collection materials;
        if ((this.activeMaterial == null || this.activeMaterial.length() == 0) && (materials = this.getBrushes()).size() > 0) {
            this.activeMaterial = (String)materials.iterator().next();
        }
    }

    public boolean addItem(ItemStack item) {
        if (this.isUpgrade) {
            return false;
        }
        if (Wand.isSpell(item)) {
            SpellTemplate spell;
            String spellKey = Wand.getSpell(item);
            SpellTemplate currentSpell = this.getBaseSpell(spellKey);
            Collection spells = this.getSpells();
            if (!spells.contains(spellKey) && this.addSpell(spellKey) && (spell = this.controller.getSpellTemplate(spellKey)) != null) {
                if (this.mage != null) {
                    if (currentSpell != null) {
                        String levelDescription = spell.getLevelDescription();
                        if (levelDescription == null || levelDescription.isEmpty()) {
                            levelDescription = spell.getName();
                        }
                        this.mage.sendMessage(this.controller.getMessages().get("wand.spell_upgraded").replace("$name", currentSpell.getName()).replace("$level", levelDescription));
                    } else {
                        this.mage.sendMessage(this.controller.getMessages().get("wand.spell_added").replace("$name", spell.getName()));
                    }
                }
                return true;
            }
        } else if (Wand.isBrush(item)) {
            String materialKey = Wand.getBrush(item);
            Collection materials = this.getBrushes();
            if (!materials.contains(materialKey) && this.addBrush(materialKey)) {
                if (this.mage != null) {
                    this.mage.sendMessage(this.controller.getMessages().get("wand.brush_added").replace("$name", com.elmakers.mine.bukkit.block.MaterialBrush.getMaterialName(materialKey)));
                }
                return true;
            }
        } else if (Wand.isUpgrade(item)) {
            Wand wand = new Wand(this.controller, item);
            return this.add(wand);
        }
        return false;
    }

    protected void updateEffects() {
        if (this.mage == null) {
            return;
        }
        Player player = this.mage.getPlayer();
        if (player == null) {
            return;
        }
        if (this.effectBubbles) {
            CompatibilityUtils.addPotionEffect((LivingEntity)player, this.effectColor.getColor());
        }
        Location location = this.mage.getLocation();
        if (this.effectParticle != null && location != null && this.effectParticleInterval > 0 && this.effectParticleCount > 0 && this.effectParticleCounter++ % this.effectParticleInterval == 0) {
            if (this.effectPlayer == null) {
                this.effectPlayer = new EffectRing((Plugin)this.controller.getPlugin());
                this.effectPlayer.setParticleCount(2);
                this.effectPlayer.setIterations(2);
                this.effectPlayer.setRadius(2.0f);
                this.effectPlayer.setSize(5);
                this.effectPlayer.setMaterial(location.getBlock().getRelative(BlockFace.DOWN));
            }
            this.effectPlayer.setParticleType(this.effectParticle);
            this.effectPlayer.setParticleData(this.effectParticleData);
            this.effectPlayer.setParticleCount(this.effectParticleCount);
            this.effectPlayer.start(player.getEyeLocation(), null);
        }
        if (this.effectSound != null && location != null && this.controller.soundsEnabled() && this.effectSoundCounter++ % this.effectSoundInterval == 0) {
            this.mage.getLocation().getWorld().playSound(location, this.effectSound.getSound(), this.effectSound.getVolume(), this.effectSound.getPitch());
        }
    }

    protected void updateDurability() {
        short maxDurability = this.item.getType().getMaxDurability();
        if (maxDurability > 0) {
            int durability = this.xp * maxDurability / this.xpMax;
            if ((durability = maxDurability - durability) >= maxDurability) {
                durability = maxDurability - 1;
            } else if (durability < 0) {
                durability = 0;
            }
            this.item.setDurability((short)durability);
        }
    }

    public boolean displayManaAsXp() {
        return !displayManaAsGlow && !displayManaAsDurability;
    }

    protected void updateMana() {
        if (this.mage != null && this.xpMax > 0 && this.xpRegeneration > 0) {
            Player player = this.mage.getPlayer();
            if (displayManaAsGlow) {
                if (this.xp == this.xpMax) {
                    CompatibilityUtils.addGlow(this.item);
                } else {
                    CompatibilityUtils.removeGlow(this.item);
                }
            }
            if (displayManaAsDurability) {
                this.updateDurability();
            } else if (displayManaAsBar) {
                if (!retainLevelDisplay) {
                    player.setLevel(0);
                }
                player.setExp((float)this.xp / (float)this.xpMax);
            } else {
                player.setLevel(this.xp);
                player.setExp(0.0f);
            }
        }
    }

    public boolean isInventoryOpen() {
        return this.mage != null && this.inventoryIsOpen;
    }

    @Override
    public void deactivate() {
        if (this.mage == null) {
            return;
        }
        Player player = this.mage.getPlayer();
        if (this.effectBubbles && player != null) {
            CompatibilityUtils.removePotionEffect((LivingEntity)player);
        }
        this.mage.deactivateAllSpells();
        if (this.isInventoryOpen()) {
            this.closeInventory();
        }
        this.playerInventorySlot = null;
        this.storedInventory = null;
        if (this.usesMana() && this.displayManaAsXp() && player != null) {
            player.setExp(this.storedXpProgress);
            if (!retainLevelDisplay) {
                player.setLevel(this.storedXpLevel);
            }
            this.storedXpProgress = 0.0f;
            this.storedXpLevel = 0;
        }
        this.saveState();
        this.mage.setActiveWand(null);
        this.mage = null;
    }

    @Override
    public Spell getActiveSpell() {
        if (this.mage == null || this.activeSpell == null || this.activeSpell.length() == 0) {
            return null;
        }
        return this.mage.getSpell(this.activeSpell);
    }

    @Override
    public SpellTemplate getBaseSpell(String spellName) {
        SpellKey key = new SpellKey(spellName);
        Integer spellLevel = this.spellLevels.get(key.getBaseKey());
        if (spellLevel == null) {
            return null;
        }
        String spellKey = key.getBaseKey();
        if (key.isVariant()) {
            spellKey = spellKey + "|" + key.getLevel();
        }
        return this.controller.getSpellTemplate(spellKey);
    }

    @Override
    public String getActiveSpellKey() {
        return this.activeSpell;
    }

    @Override
    public String getActiveBrushKey() {
        return this.activeMaterial;
    }

    public boolean cast() {
        Spell spell = this.getActiveSpell();
        if (spell != null) {
            this.use();
            ArrayList<String> castParameters = null;
            if (this.castOverrides != null && this.castOverrides.size() > 0) {
                castParameters = new ArrayList<String>();
                for (Map.Entry<String, String> entry : this.castOverrides.entrySet()) {
                    String[] key = StringUtils.split((String)entry.getKey(), (String)".");
                    if (key.length == 0 || key.length == 2 && !key[0].equals("default") && !key[0].equals(spell.getSpellKey().getBaseKey()) && !key[0].equals(spell.getSpellKey().getKey())) continue;
                    castParameters.add(key.length == 2 ? key[1] : key[0]);
                    castParameters.add(entry.getValue());
                }
            }
            if (spell.cast(castParameters == null ? null : castParameters.toArray(EMPTY_PARAMETERS))) {
                Color spellColor = spell.getColor();
                if (spellColor != null && this.effectColor != null) {
                    this.effectColor = this.effectColor.mixColor(spellColor, (double)this.effectColorSpellMixWeight);
                }
                this.updateHotbarGlow();
                return true;
            }
        }
        return false;
    }

    protected void use() {
        if (this.mage == null) {
            return;
        }
        if (this.uses > 0) {
            --this.uses;
            if (this.uses <= 0) {
                this.uses = 1;
                Player player = this.mage.getPlayer();
                this.mage.playSound(Sound.ITEM_BREAK, 1.0f, 0.8f);
                this.deactivate();
                PlayerInventory playerInventory = player.getInventory();
                playerInventory.setItemInHand(new ItemStack(Material.AIR, 1));
                player.updateInventory();
            } else {
                this.saveState();
                this.updateName();
                this.updateLore();
            }
        }
    }

    public void onPlayerExpChange(PlayerExpChangeEvent event) {
        if (this.mage == null) {
            return;
        }
        if (this.addExperience(event.getAmount())) {
            event.setAmount(0);
        }
    }

    public boolean addExperience(int xp) {
        if (this.usesMana() && this.displayManaAsXp()) {
            Player player;
            Player player2 = player = this.mage == null ? null : this.mage.getPlayer();
            if (player != null) {
                player.setExp(this.storedXpProgress);
                if (!retainLevelDisplay) {
                    player.setLevel(this.storedXpLevel);
                }
                player.giveExp(xp);
                this.storedXpProgress = player.getExp();
                this.storedXpLevel = player.getLevel();
            }
            return true;
        }
        return false;
    }

    public void updateExperience() {
        if (this.mage != null && this.mage.isPlayer() && this.usesMana() && this.displayManaAsXp()) {
            Player player = this.mage.getPlayer();
            this.storedXpProgress = player.getExp();
            this.storedXpLevel = player.getLevel();
        }
    }

    protected void updateHotbarGlow() {
        Player player;
        Player player2 = player = this.mage == null ? null : this.mage.getPlayer();
        if (player != null && SpellGlow && this.getMode() == WandMode.INVENTORY && this.isInventoryOpen()) {
            Location location = this.mage.getLocation();
            for (int i = 0; i < 9; ++i) {
                Spell spell;
                ItemStack spellItem = player.getInventory().getItem(i);
                String spellKey = Wand.getSpell(spellItem);
                if (spellKey == null || (spell = this.mage.getSpell(spellKey)) == null) continue;
                if (spell.canCast(location) && spell.getRemainingCooldown() == 0L && spell.getRequiredCost() == null) {
                    CompatibilityUtils.addGlow(spellItem);
                    continue;
                }
                CompatibilityUtils.removeGlow(spellItem);
            }
        }
    }

    public void tick() {
        int regenLevel;
        if (this.mage == null || this.item == null) {
            return;
        }
        Player player = this.mage.getPlayer();
        if (player == null) {
            return;
        }
        boolean modified = this.checkWandItem();
        short maxDurability = this.item.getType().getMaxDurability();
        if (!displayManaAsDurability && maxDurability > 0) {
            this.item.setDurability((short)0);
        }
        this.updateHotbarGlow();
        if (this.speedIncrease > 0.0f) {
            int hasteLevel = (int)(this.speedIncrease * this.controller.getMaxHaste());
            if (this.hasteEffect == null || this.hasteEffect.getAmplifier() != hasteLevel) {
                this.hasteEffect = new PotionEffect(PotionEffectType.SPEED, 240, hasteLevel, true);
            }
            CompatibilityUtils.applyPotionEffect((LivingEntity)player, this.hasteEffect);
        }
        if (this.healthRegeneration > 0.0f) {
            regenLevel = (int)(this.healthRegeneration * this.controller.getMaxHealthRegeneration());
            if (this.healthRegenEffect == null || this.healthRegenEffect.getAmplifier() != regenLevel) {
                this.healthRegenEffect = new PotionEffect(PotionEffectType.REGENERATION, 240, regenLevel, true);
            }
            CompatibilityUtils.applyPotionEffect((LivingEntity)player, this.healthRegenEffect);
        }
        if (this.hungerRegeneration > 0.0f) {
            regenLevel = (int)(this.hungerRegeneration * this.controller.getMaxHungerRegeneration());
            if (this.hungerRegenEffect == null || this.hungerRegenEffect.getAmplifier() != regenLevel) {
                this.hungerRegenEffect = new PotionEffect(PotionEffectType.SATURATION, 240, regenLevel, true);
            }
            CompatibilityUtils.applyPotionEffect((LivingEntity)player, this.hungerRegenEffect);
        }
        if (this.usesMana()) {
            this.xp = Math.min(this.xpMax, this.xp + this.xpRegeneration);
            this.updateMana();
        }
        if (this.damageReductionFire > 0.0f && player.getFireTicks() > 0) {
            player.setFireTicks(0);
        }
        this.updateEffects();
        if (modified) {
            this.saveState();
        }
    }

    public MagicController getMaster() {
        return this.controller;
    }

    public void cycleSpells() {
        Collection spellsSet = this.getSpells();
        ArrayList spells = new ArrayList(spellsSet);
        if (spells.size() == 0) {
            return;
        }
        if (this.activeSpell == null) {
            this.activeSpell = ((String)spells.get(0)).split("@")[0];
            return;
        }
        int spellIndex = 0;
        for (int i = 0; i < spells.size(); ++i) {
            if (!((String)spells.get(i)).split("@")[0].equals(this.activeSpell)) continue;
            spellIndex = i;
            break;
        }
        spellIndex = (spellIndex + 1) % spells.size();
        this.setActiveSpell(((String)spells.get(spellIndex)).split("@")[0]);
    }

    public void cycleMaterials() {
        Collection materialsSet = this.getBrushes();
        ArrayList materials = new ArrayList(materialsSet);
        if (materials.size() == 0) {
            return;
        }
        if (this.activeMaterial == null) {
            this.activeMaterial = ((String)materials.get(0)).split("@")[0];
            return;
        }
        int materialIndex = 0;
        for (int i = 0; i < materials.size(); ++i) {
            if (!((String)materials.get(i)).split("@")[0].equals(this.activeMaterial)) continue;
            materialIndex = i;
            break;
        }
        materialIndex = (materialIndex + 1) % materials.size();
        this.activateBrush(((String)materials.get(materialIndex)).split("@")[0]);
    }

    public Mage getActivePlayer() {
        return this.mage;
    }

    public Color getEffectColor() {
        return this.effectColor == null ? null : this.effectColor.getColor();
    }

    public ParticleEffect getEffectParticle() {
        return this.effectParticle;
    }

    public Inventory getHotbar() {
        if (this.currentHotbar < 0 || this.currentHotbar >= this.hotbars.size()) {
            this.currentHotbar = 0;
        }
        return this.hotbars.get(this.currentHotbar);
    }

    public List<Inventory> getHotbars() {
        return this.hotbars;
    }

    public WandMode getMode() {
        return this.mode != null ? this.mode : this.controller.getDefaultWandMode();
    }

    public void setMode(WandMode mode) {
        this.mode = mode;
    }

    public boolean showCastMessages() {
        return this.quietLevel == 0;
    }

    public boolean showMessages() {
        return this.quietLevel < 2;
    }

    public boolean isStealth() {
        return this.quietLevel > 2;
    }

    @Override
    public boolean isLost() {
        return this.id != null;
    }

    @Override
    public boolean isLost(com.elmakers.mine.bukkit.api.wand.LostWand lostWand) {
        return this.id != null && this.id.equals(lostWand.getId());
    }

    @Override
    public LostWand makeLost(Location location) {
        if (this.id == null || this.id.length() == 0) {
            this.id = UUID.randomUUID().toString();
            this.saveState();
        }
        return new LostWand(this, location);
    }

    @Override
    public void activate(com.elmakers.mine.bukkit.api.magic.Mage mage) {
        Player player = mage.getPlayer();
        if (!Wand.hasActiveWand(player)) {
            this.controller.getLogger().warning("Wand activated without holding a wand!");
            return;
        }
        if (mage instanceof Mage) {
            this.activate((Mage)mage, player.getItemInHand(), player.getInventory().getHeldItemSlot());
        }
    }

    @Override
    public void organizeInventory(com.elmakers.mine.bukkit.api.magic.Mage mage) {
        WandOrganizer organizer = new WandOrganizer(this, mage);
        organizer.organize();
        this.openInventoryPage = 0;
        this.currentHotbar = 0;
        this.autoOrganize = false;
        this.autoAlphabetize = false;
        this.saveState();
        this.loadState();
        this.updateInventory();
    }

    @Override
    public void alphabetizeInventory() {
        WandOrganizer organizer = new WandOrganizer(this);
        organizer.alphabetize();
        this.openInventoryPage = 0;
        this.currentHotbar = 0;
        this.autoOrganize = false;
        this.autoAlphabetize = false;
        this.saveState();
        this.loadState();
        this.updateInventory();
    }

    @Override
    public com.elmakers.mine.bukkit.api.wand.Wand duplicate() {
        ItemStack newItem = InventoryUtils.getCopy(this.item);
        Wand newWand = new Wand(this.controller, newItem);
        newWand.saveState();
        return newWand;
    }

    @Override
    public boolean configure(Map<String, Object> properties) {
        HashMap<String, Object> convertedProperties = new HashMap<String, Object>(properties);
        this.loadProperties(ConfigurationUtils.toNodeList(convertedProperties), false);
        this.saveState();
        this.updateName();
        this.updateLore();
        return true;
    }

    @Override
    public boolean upgrade(Map<String, Object> properties) {
        HashMap<String, Object> convertedProperties = new HashMap<String, Object>(properties);
        this.loadProperties(ConfigurationUtils.toNodeList(convertedProperties), true);
        this.saveState();
        this.updateName();
        this.updateLore();
        return true;
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public void unlock() {
        this.locked = false;
    }

    @Override
    public boolean canUse(Player player) {
        if (!this.bound || this.owner == null || this.owner.length() == 0) {
            return true;
        }
        if (this.controller.hasPermission(player, "Magic.wand.override_bind", false)) {
            return true;
        }
        if (this.ownerId == null || this.ownerId.length() == 0) {
            return this.owner.equalsIgnoreCase(player.getName());
        }
        return this.ownerId.equalsIgnoreCase(player.getUniqueId().toString());
    }

    @Override
    public boolean addSpell(String spellName) {
        SpellTemplate template;
        if (!this.isModifiable()) {
            return false;
        }
        SpellKey spellKey = new SpellKey(spellName);
        if (this.hasSpell(spellKey)) {
            return false;
        }
        if (this.isInventoryOpen()) {
            this.saveInventory();
        }
        if ((template = this.controller.getSpellTemplate(spellName)) == null) {
            this.controller.getLogger().warning("Tried to add unknown spell to wand: " + spellName);
            return false;
        }
        if (this.hasSpell(template.getKey())) {
            return false;
        }
        ItemStack spellItem = this.createSpellIcon(template);
        if (spellItem == null) {
            return false;
        }
        spellKey = template.getSpellKey();
        int level = spellKey.getLevel();
        Integer inventorySlot = null;
        Integer currentLevel = this.spellLevels.get(spellKey.getBaseKey());
        if (currentLevel != null) {
            SpellKey currentKey;
            if (this.activeSpell != null && !this.activeSpell.isEmpty() && (currentKey = new SpellKey(this.activeSpell)).getBaseKey().equals(spellKey.getBaseKey())) {
                this.activeSpell = spellKey.getKey();
            }
            List<Inventory> allInventories = this.getAllInventories();
            int currentSlot = 0;
            for (Inventory inventory : allInventories) {
                ItemStack[] items = inventory.getContents();
                for (int index = 0; index < items.length; ++index) {
                    SpellKey checkKey;
                    ItemStack itemStack = items[index];
                    if (Wand.isSpell(itemStack) && (checkKey = new SpellKey(Wand.getSpell(itemStack))).getBaseKey().equals(spellKey.getBaseKey())) {
                        inventorySlot = currentSlot;
                        inventory.setItem(index, null);
                        this.spells.remove(checkKey.getKey());
                    }
                    ++currentSlot;
                }
            }
        }
        this.spellLevels.put(spellKey.getBaseKey(), level);
        this.spells.put(template.getKey(), inventorySlot);
        this.addToInventory(spellItem, inventorySlot);
        this.updateInventory();
        this.hasInventory = this.getSpells().size() + this.getBrushes().size() > 1;
        this.saveState();
        this.updateLore();
        return true;
    }

    @Override
    public boolean add(com.elmakers.mine.bukkit.api.wand.Wand other) {
        if (other instanceof Wand) {
            return this.add((Wand)other);
        }
        return false;
    }

    @Override
    public boolean hasBrush(String materialKey) {
        return this.getBrushes().contains(materialKey);
    }

    @Override
    public boolean hasSpell(String spellName) {
        return this.hasSpell(new SpellKey(spellName));
    }

    public boolean hasSpell(SpellKey spellKey) {
        Integer level = this.spellLevels.get(spellKey.getBaseKey());
        return level != null && level >= spellKey.getLevel();
    }

    @Override
    public boolean addBrush(String materialKey) {
        ItemStack itemStack;
        if (!this.isModifiable()) {
            return false;
        }
        if (this.hasBrush(materialKey)) {
            return false;
        }
        if (this.isInventoryOpen()) {
            this.saveInventory();
        }
        if ((itemStack = this.createBrushIcon(materialKey)) == null) {
            return false;
        }
        this.brushes.put(materialKey, null);
        this.addToInventory(itemStack);
        if (this.activeMaterial == null || this.activeMaterial.length() == 0) {
            this.setActiveBrush(materialKey);
        } else {
            this.updateInventory();
        }
        this.hasInventory = this.getSpells().size() + this.getBrushes().size() > 1;
        this.saveState();
        this.updateLore();
        return true;
    }

    @Override
    public void setActiveBrush(String materialKey) {
        this.activeMaterial = materialKey;
        this.saveState();
        this.updateName();
        this.updateActiveMaterial();
        this.updateHotbar();
    }

    @Override
    public void setActiveSpell(String activeSpell) {
        this.activeSpell = activeSpell;
        this.saveState();
        this.updateName();
    }

    @Override
    public boolean removeBrush(String materialKey) {
        if (!this.isModifiable() || materialKey == null) {
            return false;
        }
        if (this.isInventoryOpen()) {
            this.saveInventory();
        }
        if (materialKey.equals(this.activeMaterial)) {
            this.activeMaterial = null;
        }
        this.brushes.remove(materialKey);
        List<Inventory> allInventories = this.getAllInventories();
        boolean found = false;
        block0: for (Inventory inventory : allInventories) {
            ItemStack[] items = inventory.getContents();
            for (int index = 0; index < items.length; ++index) {
                ItemStack itemStack = items[index];
                if (itemStack == null || !Wand.isBrush(itemStack)) continue;
                String itemKey = Wand.getBrush(itemStack);
                if (itemKey.equals(materialKey)) {
                    found = true;
                    inventory.setItem(index, null);
                } else if (this.activeMaterial == null) {
                    this.activeMaterial = materialKey;
                }
                if (found && this.activeMaterial != null) continue block0;
            }
        }
        this.updateActiveMaterial();
        this.updateInventory();
        this.saveState();
        this.updateName();
        this.updateLore();
        return found;
    }

    @Override
    public boolean removeSpell(String spellName) {
        if (!this.isModifiable()) {
            return false;
        }
        if (this.isInventoryOpen()) {
            this.saveInventory();
        }
        if (spellName.equals(this.activeSpell)) {
            this.activeSpell = null;
        }
        this.spells.remove(spellName);
        SpellKey spellKey = new SpellKey(spellName);
        this.spellLevels.remove(spellKey.getBaseKey());
        List<Inventory> allInventories = this.getAllInventories();
        boolean found = false;
        block0: for (Inventory inventory : allInventories) {
            ItemStack[] items = inventory.getContents();
            for (int index = 0; index < items.length; ++index) {
                ItemStack itemStack = items[index];
                if (itemStack == null || itemStack.getType() == Material.AIR || !Wand.isSpell(itemStack)) continue;
                if (Wand.getSpell(itemStack).equals(spellName)) {
                    found = true;
                    inventory.setItem(index, null);
                } else if (this.activeSpell == null) {
                    this.activeSpell = Wand.getSpell(itemStack);
                }
                if (found && this.activeSpell != null) continue block0;
            }
        }
        this.updateInventory();
        this.saveState();
        this.updateName();
        this.updateLore();
        return found;
    }

    @Override
    public Map<String, String> getOverrides() {
        return this.castOverrides == null ? new HashMap<String, String>() : new HashMap<String, String>(this.castOverrides);
    }

    @Override
    public void setOverrides(Map<String, String> overrides) {
        this.castOverrides = overrides == null ? null : new HashMap<String, String>(overrides);
    }

    @Override
    public void removeOverride(String key) {
        if (this.castOverrides != null) {
            this.castOverrides.remove(key);
        }
    }

    @Override
    public void setOverride(String key, String value) {
        if (this.castOverrides == null) {
            this.castOverrides = new HashMap<String, String>();
        }
        if (value == null || value.length() == 0) {
            this.castOverrides.remove(key);
        } else {
            this.castOverrides.put(key, value);
        }
    }

    public void setStoredXpLevel(int level) {
        this.storedXpLevel = level;
    }

    public int getStoredXpLevel() {
        return this.storedXpLevel;
    }

    public boolean hasStoredInventory() {
        return this.storedInventory != null;
    }

    public Inventory getStoredInventory() {
        return this.storedInventory;
    }

    public boolean addToStoredInventory(ItemStack item) {
        if (this.storedInventory == null) {
            return false;
        }
        HashMap remainder = this.storedInventory.addItem(new ItemStack[]{item});
        return remainder.size() == 0;
    }

    public boolean storeInventory() {
        if (this.storedInventory != null) {
            if (this.mage != null) {
                this.mage.sendMessage("Your wand contains a previously stored inventory and will not activate, let go of it to clear.");
            }
            this.controller.getLogger().warning("Tried to store an inventory with one already present: " + (this.mage == null ? "?" : this.mage.getName()));
            return false;
        }
        Player player = this.mage.getPlayer();
        if (player == null) {
            return false;
        }
        PlayerInventory inventory = player.getInventory();
        this.storedInventory = CompatibilityUtils.createInventory(null, inventory.getSize(), "Stored Inventory");
        ItemStack[] contents = inventory.getContents();
        for (int i = 0; i < contents.length; ++i) {
            if (!Wand.isSpell(contents[i])) continue;
            contents[i] = null;
        }
        this.storedInventory.setContents(contents);
        inventory.clear();
        if (this.controller.isInventoryBackupEnabled()) {
            this.saveState();
        }
        return true;
    }

    public boolean restoreInventory() {
        if (this.storedInventory == null) {
            return false;
        }
        Player player = this.mage.getPlayer();
        if (player == null) {
            return false;
        }
        PlayerInventory inventory = player.getInventory();
        inventory.setContents(this.storedInventory.getContents());
        this.storedInventory = null;
        this.saveState();
        player.updateInventory();
        return true;
    }

    public boolean isBound() {
        return this.bound;
    }

    public int getSpellLevel(String spellKey) {
        SpellKey key = new SpellKey(spellKey);
        Integer level = this.spellLevels.get(key.getBaseKey());
        return level == null ? 0 : level;
    }

    public Integer getPlayerInventorySlot() {
        return this.playerInventorySlot;
    }

    public MageController getController() {
        return this.controller;
    }

    protected Map<String, Integer> getSpellInventory() {
        return new HashMap<String, Integer>(this.spells);
    }

    protected Map<String, Integer> getBrushInventory() {
        return new HashMap<String, Integer>(this.brushes);
    }

    protected void updateSpellInventory(Map<String, Integer> updateSpells) {
        for (Map.Entry<String, Integer> spellEntry : this.spells.entrySet()) {
            String spellKey = spellEntry.getKey();
            Integer slot = updateSpells.get(spellKey);
            if (slot == null) continue;
            spellEntry.setValue(slot);
        }
    }

    protected void updateBrushInventory(Map<String, Integer> updateBrushes) {
        for (Map.Entry<String, Integer> brushEntry : this.brushes.entrySet()) {
            String brushKey = brushEntry.getKey();
            Integer slot = updateBrushes.get(brushKey);
            if (slot == null) continue;
            brushEntry.setValue(slot);
        }
    }
}

