/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell.builtin;

import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.block.UndoList;
import com.elmakers.mine.bukkit.block.batch.SimpleBlockAction;
import com.elmakers.mine.bukkit.spell.UndoableSpell;
import com.elmakers.mine.bukkit.utility.Target;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;

public class LightningSpell
extends UndoableSpell {
    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        Target target = this.getTarget();
        if (!target.hasTarget()) {
            return SpellResult.NO_TARGET;
        }
        int radius = parameters.getInt("radius", 1);
        radius = (int)(this.mage.getRadiusMultiplier() * (float)radius);
        double ratio = radius < 2 ? 1.0 : (radius < 4 ? 0.5 : 0.25);
        ShockAction action = new ShockAction(this, null, ratio, 5);
        if (radius <= 1) {
            action.perform(parameters, target.getBlock());
        } else {
            this.coverSurface(target.getLocation(), radius, action);
        }
        this.registerForUndo();
        return SpellResult.CAST;
    }

    public class ShockAction
    extends SimpleBlockAction {
        protected double density;
        protected int thunderThreshold;

        public ShockAction(Spell spell, UndoList undoList, double density, int thunderThreshold) {
            super(spell, undoList);
            this.density = density;
            this.thunderThreshold = thunderThreshold;
        }

        @Override
        public SpellResult perform(ConfigurationSection parameters, Block block) {
            if (Math.random() > this.density) {
                return SpellResult.COST_FREE;
            }
            super.perform(parameters, block);
            World world = block.getWorld();
            world.strikeLightning(block.getLocation());
            return SpellResult.CAST;
        }
    }
}

