/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell;

import com.elmakers.mine.bukkit.api.action.SpellAction;
import com.elmakers.mine.bukkit.api.effect.EffectPlayer;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.MageSpell;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.spell.ActionHandler;
import com.elmakers.mine.bukkit.spell.ActionSpell;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.spell.BlockSpell;
import com.elmakers.mine.bukkit.spell.UndoableSpell;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.Collection;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.potion.PotionEffect;
import org.bukkit.util.Vector;

public abstract class BaseSpellAction
implements SpellAction {
    private Spell spell;
    private BaseSpell baseSpell;
    private BlockSpell blockSpell;
    private MageSpell mageSpell;
    private UndoableSpell undoSpell;
    private ActionSpell actionSpell;
    private ConfigurationSection parameters;

    public void registerModified(Entity entity) {
        if (this.undoSpell != null) {
            this.undoSpell.registerModified(entity);
        }
    }

    public void registerForUndo(Entity entity) {
        if (this.undoSpell != null) {
            this.undoSpell.registerForUndo(entity);
        }
    }

    public void registerPotionEffects(Entity entity) {
        if (this.undoSpell != null) {
            this.undoSpell.registerPotionEffects(entity);
        }
    }

    public ActionHandler getActions(String key) {
        if (this.actionSpell != null) {
            return this.actionSpell.getActions(key);
        }
        return null;
    }

    public Vector getDirection() {
        return this.baseSpell != null ? this.baseSpell.getDirection() : null;
    }

    public Location getLocation() {
        return this.baseSpell != null ? this.baseSpell.getLocation() : null;
    }

    public Location getEyeLocation() {
        return this.baseSpell != null ? this.baseSpell.getEyeLocation() : null;
    }

    public boolean isIndestructible(Block block) {
        return this.blockSpell != null ? this.blockSpell.isIndestructible(block) : true;
    }

    public boolean hasBuildPermission(Block block) {
        return this.blockSpell != null ? this.blockSpell.hasBuildPermission(block) : false;
    }

    public Collection<EffectPlayer> getEffects(String key) {
        return this.spell.getEffects(key);
    }

    public Collection<PotionEffect> getPotionEffects(ConfigurationSection parameters, Integer duration) {
        return this.baseSpell != null ? BaseSpell.getPotionEffects(parameters, duration) : null;
    }

    public Mage getMage() {
        return this.mageSpell == null ? null : this.mageSpell.getMage();
    }

    public MageController getController() {
        Mage mage = this.getMage();
        return mage == null ? null : mage.getController();
    }

    @Override
    public void load(Spell spell, ConfigurationSection parameters) {
        this.spell = spell;
        if (spell instanceof BaseSpell) {
            this.baseSpell = (BaseSpell)spell;
        }
        if (spell instanceof MageSpell) {
            this.mageSpell = (MageSpell)spell;
        }
        if (spell instanceof UndoableSpell) {
            this.undoSpell = (UndoableSpell)spell;
        }
        if (spell instanceof ActionSpell) {
            this.actionSpell = (ActionSpell)spell;
        }
        if (spell instanceof BlockSpell) {
            this.blockSpell = (BlockSpell)spell;
        }
        this.parameters = parameters;
    }

    @Override
    public ConfigurationSection getParameters(ConfigurationSection baseParameters) {
        if (this.parameters == null) {
            return baseParameters;
        }
        MemoryConfiguration combined = new MemoryConfiguration();
        ConfigurationUtils.addConfigurations((ConfigurationSection)combined, baseParameters);
        ConfigurationUtils.addConfigurations((ConfigurationSection)combined, this.parameters);
        return combined;
    }

    @Override
    public boolean usesBrush() {
        return false;
    }

    @Override
    public boolean isUndoable() {
        return false;
    }
}

