/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell;

import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.ActionHandler;
import com.elmakers.mine.bukkit.spell.BrushSpell;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;

public class ActionSpell
extends BrushSpell {
    private Map<String, ActionHandler> actions = new HashMap<String, ActionHandler>();
    private boolean undoable = false;

    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        ActionHandler downHandler;
        if (this.undoable) {
            this.registerForUndo();
        }
        if ((downHandler = this.actions.get("alt_down")) != null && this.isLookingDown()) {
            return downHandler.perform(parameters);
        }
        ActionHandler upHandler = this.actions.get("alt_up");
        if (upHandler != null && this.isLookingUp()) {
            return upHandler.perform(parameters);
        }
        ActionHandler sneakHandler = this.actions.get("alt_sneak");
        if (sneakHandler != null && this.mage.isSneaking()) {
            return sneakHandler.perform(parameters);
        }
        ActionHandler castHandler = this.actions.get("cast");
        if (castHandler != null) {
            return castHandler.perform(parameters);
        }
        return SpellResult.FAIL;
    }

    @Override
    protected void loadTemplate(ConfigurationSection template) {
        this.usesBrush = false;
        this.undoable = false;
        this.castOnNoTarget = true;
        if (template.contains("actions")) {
            ConfigurationSection actionsNode = template.getConfigurationSection("actions");
            Set actionKeys = actionsNode.getKeys(false);
            for (String actionKey : actionKeys) {
                ActionHandler handler = new ActionHandler(this);
                handler.load(actionsNode, actionKey);
                this.usesBrush = this.usesBrush || handler.usesBrush();
                this.undoable = this.undoable || handler.isUndoable();
                this.actions.put(actionKey, handler);
            }
        }
        this.undoable = template.getBoolean("undoable", this.undoable);
        super.loadTemplate(template);
    }

    @Override
    public boolean isUndoable() {
        return this.undoable;
    }

    public ActionHandler getActions(String key) {
        return this.actions.get(key);
    }
}

