/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell;

import com.elmakers.mine.bukkit.api.action.BlockAction;
import com.elmakers.mine.bukkit.api.action.EntityAction;
import com.elmakers.mine.bukkit.api.action.GeneralAction;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.ActionSpell;
import com.elmakers.mine.bukkit.spell.BaseSpellAction;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.Target;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;

public class ActionHandler {
    private static final String ACTION_BUILTIN_CLASSPATH = "com.elmakers.mine.bukkit.action.builtin";
    private List<GeneralAction> generalActions = new ArrayList<GeneralAction>();
    private List<BlockAction> blockActions = new ArrayList<BlockAction>();
    private List<EntityAction> entityActions = new ArrayList<EntityAction>();
    private final ActionSpell spell;
    private boolean undoable = false;
    private boolean usesBrush = false;

    public ActionHandler(ActionSpell spell) {
        this.spell = spell;
    }

    public void load(ConfigurationSection root, String key) {
        this.undoable = false;
        this.usesBrush = false;
        Collection<ConfigurationSection> actionNodes = ConfigurationUtils.getNodeList(root, key);
        if (actionNodes != null) {
            for (ConfigurationSection actionConfiguration : actionNodes) {
                if (!actionConfiguration.contains("class")) continue;
                String actionClassName = actionConfiguration.getString("class");
                try {
                    Class<?> genericClass;
                    if (!actionClassName.contains(".")) {
                        actionClassName = "com.elmakers.mine.bukkit.action.builtin." + actionClassName;
                    }
                    if (!BaseSpellAction.class.isAssignableFrom(genericClass = Class.forName(actionClassName))) {
                        throw new Exception("Must extend SpellAction");
                    }
                    Class<?> actionClass = genericClass;
                    BaseSpellAction action = (BaseSpellAction)actionClass.newInstance();
                    actionConfiguration.set("class", null);
                    if (actionConfiguration.getKeys(false).size() == 0) {
                        actionConfiguration = null;
                    }
                    action.load(this.spell, actionConfiguration);
                    this.usesBrush = this.usesBrush || action.usesBrush();
                    boolean bl = this.undoable = this.undoable || action.isUndoable();
                    if (action instanceof GeneralAction) {
                        this.generalActions.add((GeneralAction)((Object)action));
                    }
                    if (action instanceof EntityAction) {
                        this.entityActions.add((EntityAction)((Object)action));
                    }
                    if (!(action instanceof BlockAction)) continue;
                    this.blockActions.add((BlockAction)((Object)action));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public SpellResult perform(ConfigurationSection parameters) {
        return this.perform(parameters, null);
    }

    public SpellResult perform(ConfigurationSection parameters, Location targetLocation) {
        List<Target> entities;
        SpellResult result = SpellResult.CAST;
        for (GeneralAction generalAction : this.generalActions) {
            SpellResult actionResult = generalAction.perform(generalAction.getParameters(parameters));
            if (actionResult.ordinal() <= result.ordinal()) continue;
            result = actionResult;
        }
        if (this.entityActions.size() == 0 && this.blockActions.size() == 0) {
            return result;
        }
        Entity targetedEntity = null;
        ArrayList<Entity> targetEntities = new ArrayList<Entity>();
        if (targetLocation == null) {
            Target target = this.spell.getTarget();
            if (!target.hasTarget()) {
                return SpellResult.NO_TARGET;
            }
            if (target.hasEntity()) {
                targetedEntity = target.getEntity();
                targetEntities.add(targetedEntity);
            }
            targetLocation = target.getLocation();
        }
        int radius = parameters.getInt("radius", 0);
        int coneCount = parameters.getInt("count", 0);
        Mage mage = this.spell.getMage();
        radius = (int)(mage.getRadiusMultiplier() * (float)radius);
        if (radius > 0) {
            entities = CompatibilityUtils.getNearbyEntities(targetLocation, radius, radius, radius);
            for (Entity entity : entities) {
                if (entity == targetedEntity || entity == mage.getEntity() || !this.spell.canTarget(entity)) continue;
                targetEntities.add(entity);
            }
        } else if (coneCount > 1) {
            entities = this.spell.getAllTargetEntities();
            for (int i = 1; i < coneCount; ++i) {
                targetEntities.add(entities.get(i).getEntity());
            }
        }
        if (targetEntities.size() == 0) {
            return SpellResult.NO_TARGET;
        }
        for (Entity entity : targetEntities) {
            for (EntityAction action : this.entityActions) {
                SpellResult actionResult = action.perform(action.getParameters(parameters), entity);
                if (actionResult.ordinal() <= result.ordinal()) continue;
                result = actionResult;
            }
        }
        return result;
    }

    public boolean isUndoable() {
        return this.undoable;
    }

    public boolean usesBrush() {
        return this.usesBrush;
    }
}

