/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.slikey.effectlib.effect;

import com.elmakers.mine.bukkit.slikey.effectlib.Effect;
import com.elmakers.mine.bukkit.slikey.effectlib.EffectManager;
import com.elmakers.mine.bukkit.slikey.effectlib.EffectType;
import com.elmakers.mine.bukkit.slikey.effectlib.util.ParticleEffect;
import com.elmakers.mine.bukkit.slikey.effectlib.util.RandomUtils;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.util.Vector;

public class CloudEffect
extends Effect {
    public ParticleEffect cloudParticle = ParticleEffect.CLOUD;
    public Color cloudColor = null;
    public ParticleEffect mainParticle = ParticleEffect.DRIP_WATER;
    public float cloudSize = 0.7f;
    public float particleRadius = this.cloudSize - 0.1f;
    public double yOffset = 0.8;

    public CloudEffect(EffectManager manager) {
        super(manager);
        this.type = EffectType.REPEATING;
        this.period = 5;
        this.iterations = 50;
    }

    @Override
    public void onRun() {
        Location location = this.getLocation();
        location.add(0.0, this.yOffset, 0.0);
        for (int i = 0; i < 50; ++i) {
            Vector v = RandomUtils.getRandomCircleVector().multiply(RandomUtils.random.nextDouble() * (double)this.cloudSize);
            this.display(this.cloudParticle, location.add(v), this.cloudColor, 0.0f, 7);
            location.subtract(v);
        }
        Location l = location.add(0.0, 0.2, 0.0);
        for (int i = 0; i < 15; ++i) {
            int r = RandomUtils.random.nextInt(2);
            double x = RandomUtils.random.nextDouble() * (double)this.particleRadius;
            double z = RandomUtils.random.nextDouble() * (double)this.particleRadius;
            l.add(x, 0.0, z);
            if (r != 1) {
                this.display(this.mainParticle, l);
            }
            l.subtract(x, 0.0, z);
            l.subtract(x, 0.0, z);
            if (r != 1) {
                this.display(this.mainParticle, l);
            }
            l.add(x, 0.0, z);
        }
    }
}

