/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.protection;

import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.protection.WGCustomFlagsManager;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.flags.DefaultFlag;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.managers.RegionManager;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class WorldGuardManager {
    private boolean enabled = false;
    private WorldGuardPlugin worldGuard = null;
    private WGCustomFlagsManager customFlags = null;

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled && this.worldGuard != null;
    }

    public void initialize(Plugin plugin) {
        if (this.enabled) {
            try {
                Plugin wgPlugin = plugin.getServer().getPluginManager().getPlugin("WorldGuard");
                if (wgPlugin instanceof WorldGuardPlugin) {
                    String[] versionPieces = StringUtils.split((String)wgPlugin.getDescription().getVersion(), (char)'.');
                    int version = Integer.parseInt(versionPieces[0]);
                    if (version >= 6) {
                        this.worldGuard = (WorldGuardPlugin)wgPlugin;
                    } else {
                        plugin.getLogger().warning("Only WorldGuard 6 and above are supported- please update! (WG version: " + wgPlugin.getDescription().getVersion() + ")");
                    }
                }
            }
            catch (Throwable ex) {
                // empty catch block
            }
            if (this.worldGuard == null) {
                plugin.getLogger().info("WorldGuard not found, region protection and pvp checks will not be used.");
            } else {
                try {
                    Plugin customFlagsPlugin = plugin.getServer().getPluginManager().getPlugin("WGCustomFlags");
                    if (customFlagsPlugin != null) {
                        this.customFlags = new WGCustomFlagsManager(customFlagsPlugin);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                plugin.getLogger().info("WorldGuard found, will respect build permissions for construction spells");
                if (this.customFlags != null) {
                    plugin.getLogger().info("WGCustomFlags found, adding allowed-spells and blocked-spells flags");
                }
            }
        } else {
            plugin.getLogger().info("Region manager disabled, region protection and pvp checks will not be used.");
            this.worldGuard = null;
        }
    }

    public boolean isPVPAllowed(Location location) {
        if (!this.enabled || this.worldGuard == null || location == null) {
            return true;
        }
        RegionManager regionManager = this.worldGuard.getRegionManager(location.getWorld());
        if (regionManager == null) {
            return true;
        }
        ApplicableRegionSet checkSet = regionManager.getApplicableRegions(location);
        if (checkSet == null) {
            return true;
        }
        return checkSet.queryState(null, new StateFlag[]{DefaultFlag.PVP}) != StateFlag.State.DENY;
    }

    public boolean isPassthrough(Location location) {
        if (!this.enabled || this.worldGuard == null || location == null) {
            return true;
        }
        RegionManager regionManager = this.worldGuard.getRegionManager(location.getWorld());
        if (regionManager == null) {
            return true;
        }
        ApplicableRegionSet checkSet = regionManager.getApplicableRegions(location);
        if (checkSet == null) {
            return true;
        }
        return checkSet.size() == 0 || checkSet.testState(null, new StateFlag[]{DefaultFlag.PASSTHROUGH});
    }

    public boolean hasBuildPermission(Player player, Block block) {
        if (this.enabled && block != null && this.worldGuard != null) {
            if (player == null) {
                return this.isPassthrough(block.getLocation());
            }
            return this.worldGuard.canBuild(player, block);
        }
        return true;
    }

    public boolean hasCastPermission(Player player, SpellTemplate spell) {
        if (player != null && this.worldGuard != null && this.customFlags != null) {
            Location location = player.getLocation();
            RegionManager regionManager = this.worldGuard.getRegionManager(location.getWorld());
            if (regionManager == null) {
                return true;
            }
            ApplicableRegionSet checkSet = regionManager.getApplicableRegions(location);
            if (checkSet == null) {
                return true;
            }
            return this.customFlags.canCast(checkSet, spell.getSpellKey().getBaseKey());
        }
        return true;
    }
}

