/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic;

import com.elmakers.mine.bukkit.api.wand.Wand;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.plugin.Plugin;

public class MagicRecipe {
    private String outputKey;
    private Set<Material> ingredients = new HashSet<Material>();
    private Material outputType;
    private Material substitue;
    private Recipe recipe;
    private final MagicController controller;

    public MagicRecipe(MagicController controller) {
        this.controller = controller;
    }

    public boolean load(ConfigurationSection configuration) {
        this.outputKey = configuration.getString("output");
        this.substitue = ConfigurationUtils.getMaterial(configuration, "substitue", null);
        Wand wand = this.controller.createWand(this.outputKey);
        if (wand == null) {
            return false;
        }
        ItemStack wandItem = wand.getItem();
        this.outputType = wandItem.getType();
        ShapedRecipe shaped = new ShapedRecipe(wandItem);
        String recipeRow1 = configuration.getString("row_1", "");
        String recipeRow2 = configuration.getString("row_2", "");
        String recipeRow3 = configuration.getString("row_3", "");
        ArrayList<String> rows = new ArrayList<String>();
        for (int i = 1; i <= 3; ++i) {
            String recipeRow = configuration.getString("row_" + i, "");
            if (recipeRow.length() <= 0) continue;
            rows.add(recipeRow);
        }
        if (rows.size() == 0) {
            return false;
        }
        shaped = shaped.shape(rows.toArray(new String[0]));
        ConfigurationSection materials = configuration.getConfigurationSection("materials");
        Set keys = materials.getKeys(false);
        for (String key : keys) {
            MaterialAndData mat = new MaterialAndData(materials.getString(key));
            this.ingredients.add(mat.getMaterial());
            shaped.setIngredient(key.charAt(0), mat.getMaterial());
        }
        this.recipe = shaped;
        return true;
    }

    public void register(Plugin plugin) {
        if (this.recipe != null) {
            plugin.getServer().addRecipe(this.recipe);
        }
    }

    public Material getOutputType() {
        return this.outputType;
    }

    public Set<Material> getIngredients() {
        return this.ingredients;
    }

    public Material getSubstitute() {
        return this.substitue;
    }

    public ItemStack craft() {
        ItemStack item = this.controller.createWand(this.outputKey).getItem();
        return item;
    }
}

