/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.api.action.GeneralAction;
import com.elmakers.mine.bukkit.api.effect.EffectPlayer;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.ActionHandler;
import com.elmakers.mine.bukkit.spell.BaseSpellAction;
import com.elmakers.mine.bukkit.utility.NMSUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Projectile;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;

public class ProjectileAction
extends BaseSpellAction
implements GeneralAction {
    private int defaultSize = 1;
    private Random random = new Random();
    private static Field lifeField = null;
    private static Method getHandleMethod = null;
    private static boolean reflectionInitialized = false;
    private static Class<?> projectileClass;
    private static Class<?> fireballClass;
    private static Class<?> arrowClass;
    private static Class<?> worldClass;
    private static Class<?> entityClass;
    private static Class<?> craftArrowClass;

    private void checkReflection() {
        if (!reflectionInitialized) {
            projectileClass = NMSUtils.getBukkitClass("net.minecraft.server.EntityProjectile");
            fireballClass = NMSUtils.getBukkitClass("net.minecraft.server.EntityFireball");
            arrowClass = NMSUtils.getBukkitClass("net.minecraft.server.EntityArrow");
            worldClass = NMSUtils.getBukkitClass("net.minecraft.server.World");
            entityClass = NMSUtils.getBukkitClass("net.minecraft.server.Entity");
            craftArrowClass = NMSUtils.getBukkitClass("org.bukkit.craftbukkit.entity.CraftArrow");
            reflectionInitialized = true;
            try {
                try {
                    lifeField = arrowClass.getDeclaredField("ap");
                }
                catch (Throwable ignore2) {
                    try {
                        lifeField = arrowClass.getDeclaredField("at");
                    }
                    catch (Throwable ignore) {
                        lifeField = arrowClass.getDeclaredField("j");
                    }
                }
                getHandleMethod = craftArrowClass.getMethod("getHandle", new Class[0]);
            }
            catch (Throwable ex) {
                lifeField = null;
                getHandleMethod = null;
                this.getController().getLogger().warning("Failed to create short-lived arrow. Set tick_increase to 0 to avoid this message");
            }
            if (lifeField != null) {
                lifeField.setAccessible(true);
            }
        }
    }

    @Override
    public SpellResult perform(ConfigurationSection parameters) {
        this.checkReflection();
        int count = parameters.getInt("count", 1);
        int checkFrequency = parameters.getInt("check_frequency", 20);
        int size = parameters.getInt("size", this.defaultSize);
        double damage = parameters.getDouble("damage", 0.0);
        float speed = (float)parameters.getDouble("speed", (double)0.6f);
        float spread = (float)parameters.getDouble("spread", 12.0);
        ActionHandler actions = null;
        Mage mage = this.getMage();
        MageController controller = this.getController();
        actions = this.getActions("projectile");
        size = (int)(mage.getRadiusMultiplier() * (float)size);
        float damageMultiplier = mage.getDamageMultiplier();
        damage *= (double)damageMultiplier;
        spread /= damageMultiplier;
        boolean useFire = parameters.getBoolean("fire", true);
        int tickIncrease = parameters.getInt("tick_increase", 1180);
        String projectileTypeName = parameters.getString("projectile", "Arrow");
        if (projectileClass == null || worldClass == null || fireballClass == null || arrowClass == null || craftArrowClass == null) {
            controller.getLogger().warning("Can't find NMS classess");
            return SpellResult.FAIL;
        }
        Class<?> projectileType = NMSUtils.getBukkitClass("net.minecraft.server.Entity" + projectileTypeName);
        if (projectileType == null || !arrowClass.isAssignableFrom(projectileType) && !projectileClass.isAssignableFrom(projectileType) && !fireballClass.isAssignableFrom(projectileType)) {
            controller.getLogger().warning("Bad projectile class: " + projectileTypeName);
            return SpellResult.FAIL;
        }
        Constructor<?> constructor = null;
        Method shootMethod = null;
        Method setPositionRotationMethod = null;
        Field dirXField = null;
        Field dirYField = null;
        Field dirZField = null;
        Method addEntityMethod = null;
        try {
            constructor = projectileType.getConstructor(worldClass);
            if (fireballClass.isAssignableFrom(projectileType)) {
                dirXField = projectileType.getField("dirX");
                dirYField = projectileType.getField("dirY");
                dirZField = projectileType.getField("dirZ");
            }
            if (projectileClass.isAssignableFrom(projectileType) || arrowClass.isAssignableFrom(projectileType)) {
                shootMethod = projectileType.getMethod("shoot", Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Float.TYPE);
            }
            setPositionRotationMethod = projectileType.getMethod("setPositionRotation", Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Float.TYPE);
            addEntityMethod = worldClass.getMethod("addEntity", entityClass);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return SpellResult.FAIL;
        }
        Location location = this.getEyeLocation();
        Vector direction = this.getDirection().normalize();
        ArrayList<Projectile> projectiles = new ArrayList<Projectile>();
        Object nmsWorld = NMSUtils.getHandle(location.getWorld());
        LivingEntity player = mage.getLivingEntity();
        for (int i = 0; i < count; ++i) {
            try {
                Entity entity;
                Object nmsProjectile = null;
                nmsProjectile = constructor.newInstance(nmsWorld);
                if (nmsProjectile == null) {
                    throw new Exception("Failed to spawn projectile of class " + projectileTypeName);
                }
                if (dirXField != null && dirYField != null && dirZField != null) {
                    double spreadWeight = Math.min((double)0.4f, (double)spread * (double)0.0075f);
                    double dx = (double)speed * (direction.getX() + this.random.nextGaussian() * spreadWeight);
                    double dy = (double)speed * (direction.getY() + this.random.nextGaussian() * spreadWeight);
                    double dz = (double)speed * (direction.getZ() + this.random.nextGaussian() * spreadWeight);
                    dirXField.set(nmsProjectile, dx * 0.1);
                    dirYField.set(nmsProjectile, dy * 0.1);
                    dirZField.set(nmsProjectile, dz * 0.1);
                }
                Vector modifiedLocation = location.toVector().clone();
                if (i > 0 && fireballClass.isAssignableFrom(projectileType) && spread > 0.0f) {
                    modifiedLocation.setX(modifiedLocation.getX() + direction.getX() + this.random.nextGaussian() * (double)spread / 5.0);
                    modifiedLocation.setY(modifiedLocation.getY() + direction.getY() + this.random.nextGaussian() * (double)spread / 5.0);
                    modifiedLocation.setZ(modifiedLocation.getZ() + direction.getZ() + this.random.nextGaussian() * (double)spread / 5.0);
                }
                setPositionRotationMethod.invoke(nmsProjectile, modifiedLocation.getX(), modifiedLocation.getY(), modifiedLocation.getZ(), Float.valueOf(location.getYaw()), Float.valueOf(location.getPitch()));
                if (shootMethod != null) {
                    shootMethod.invoke(nmsProjectile, direction.getX(), direction.getY(), direction.getZ(), Float.valueOf(speed), Float.valueOf(spread));
                }
                if ((entity = NMSUtils.getBukkitEntity(nmsProjectile)) == null || !(entity instanceof Projectile)) {
                    throw new Exception("Got invalid bukkit entity from projectile of class " + projectileTypeName);
                }
                Projectile projectile = (Projectile)entity;
                if (player != null) {
                    projectile.setShooter((ProjectileSource)player);
                }
                projectiles.add(projectile);
                addEntityMethod.invoke(nmsWorld, nmsProjectile);
                if (projectile instanceof Fireball) {
                    Fireball fireball = (Fireball)projectile;
                    fireball.setIsIncendiary(useFire);
                    fireball.setYield((float)size);
                }
                if (projectile instanceof Arrow) {
                    Arrow arrow = (Arrow)projectile;
                    if (useFire) {
                        arrow.setFireTicks(300);
                    }
                    try {
                        if (arrowClass == null || craftArrowClass == null) {
                            controller.getLogger().warning("Can not access NMS EntityArrow class");
                        } else {
                            Method getHandleMethod = arrow.getClass().getMethod("getHandle", new Class[0]);
                            Object handle = getHandleMethod.invoke((Object)arrow, new Object[0]);
                            Field fromPlayerField = arrowClass.getField("fromPlayer");
                            fromPlayerField.setInt(handle, 2);
                            if (damage > 0.0) {
                                Field damageField = arrowClass.getDeclaredField("damage");
                                damageField.setAccessible(true);
                                damageField.set(handle, damage);
                            }
                        }
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                    }
                }
                Collection<EffectPlayer> projectileEffects = this.getEffects("projectile");
                for (EffectPlayer effectPlayer : projectileEffects) {
                    effectPlayer.start(projectile.getLocation(), (Entity)projectile, null, null);
                }
                this.registerForUndo((Entity)projectile);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (projectiles.size() > 0) {
            this.scheduleProjectileCheck(projectiles, parameters, tickIncrease, actions, checkFrequency, 5);
        }
        return SpellResult.CAST;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    protected void scheduleProjectileCheck(final Collection<Projectile> projectiles, final ConfigurationSection parameters, final int tickIncrease, final ActionHandler actions, final int checkFrequency, final int retries) {
        Bukkit.getScheduler().scheduleSyncDelayedTask(this.getController().getPlugin(), new Runnable(){

            @Override
            public void run() {
                ProjectileAction.this.checkProjectiles(projectiles, parameters, tickIncrease, actions, checkFrequency, retries);
            }
        }, (long)checkFrequency);
    }

    protected void checkProjectiles(Collection<Projectile> projectiles, ConfigurationSection parameters, int tickIncrease, ActionHandler actions, int checkFrequency, int retries) {
        ArrayList<Projectile> remaining = new ArrayList<Projectile>();
        for (Projectile projectile : projectiles) {
            if (retries == 0) {
                projectile.remove();
            }
            if (projectile.isDead()) {
                if (actions == null) continue;
                actions.perform(parameters, projectile.getLocation());
                continue;
            }
            remaining.add(projectile);
            if (!(projectile instanceof Arrow) || tickIncrease <= 0 || lifeField == null || getHandleMethod == null) continue;
            try {
                Object handle = getHandleMethod.invoke((Object)projectile, new Object[0]);
                int currentLife = (Integer)lifeField.get(handle);
                if (currentLife >= tickIncrease) continue;
                lifeField.set(handle, tickIncrease);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (remaining.size() > 0 && retries > 0) {
            this.scheduleProjectileCheck(remaining, parameters, tickIncrease, actions, checkFrequency, retries - 1);
        }
    }

    protected void projectileDied(Projectile projectile) {
    }
}

