/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.api.action.EntityAction;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.BaseSpellAction;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class CureAction
extends BaseSpellAction
implements EntityAction {
    private static final PotionEffectType[] _negativeEffects = new PotionEffectType[]{PotionEffectType.BLINDNESS, PotionEffectType.CONFUSION, PotionEffectType.HARM, PotionEffectType.HUNGER, PotionEffectType.POISON, PotionEffectType.SLOW, PotionEffectType.SLOW_DIGGING, PotionEffectType.WEAKNESS, PotionEffectType.WITHER};
    protected static final Set<PotionEffectType> negativeEffects = new HashSet<PotionEffectType>(Arrays.asList(_negativeEffects));

    @Override
    public SpellResult perform(ConfigurationSection parameters, Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return SpellResult.NO_TARGET;
        }
        LivingEntity targetEntity = (LivingEntity)entity;
        Collection currentEffects = targetEntity.getActivePotionEffects();
        for (PotionEffect effect : currentEffects) {
            if (!negativeEffects.contains(effect.getType())) continue;
            this.registerPotionEffects((Entity)targetEntity);
            targetEntity.removePotionEffect(effect.getType());
        }
        return SpellResult.CAST;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }
}

