/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell.builtin;

import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.block.UndoList;
import com.elmakers.mine.bukkit.block.batch.SimpleBlockAction;
import com.elmakers.mine.bukkit.spell.BlockSpell;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.Target;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class FrostSpell
extends BlockSpell {
    private static final int DEFAULT_RADIUS = 2;
    private static final int DEFAULT_PLAYER_DAMAGE = 1;
    private static final int DEFAULT_ELEMENTAL_DAMAGE = 10;
    private static final int DEFALT_ENTITY_DAMAGE = 10;
    private static final int DEFAULT_SLOWNESS = 1;
    private static final int DEFAULT_SLOWNESS_DURATION = 200;

    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        Target target = this.getTarget();
        if (!target.hasTarget()) {
            return SpellResult.NO_TARGET;
        }
        int playerDamage = parameters.getInt("player_damage", 1);
        int entityDamage = parameters.getInt("entity_damage", 10);
        int defaultRadius = parameters.getInt("radius", 2);
        int slowness = parameters.getInt("slowness", 1);
        int slownessDuration = parameters.getInt("slowness_duration", 200);
        Material iceMaterial = ConfigurationUtils.getMaterial(parameters, "ice", Material.ICE);
        boolean freezeWater = parameters.getBoolean("freeze_water", true);
        boolean freezeLava = parameters.getBoolean("freeze_lava", true);
        boolean freezeFire = parameters.getBoolean("freeze_fire", true);
        if (target.hasEntity()) {
            Entity targetEntity = target.getEntity();
            if (targetEntity instanceof LivingEntity) {
                this.registerModified(targetEntity);
                LivingEntity li = (LivingEntity)targetEntity;
                if (slowness > 0) {
                    PotionEffect effect = new PotionEffect(PotionEffectType.SLOW, slownessDuration, slowness, false);
                    li.addPotionEffect(effect);
                }
                if (li instanceof Player) {
                    CompatibilityUtils.magicDamage(li, playerDamage, this.mage.getEntity());
                } else {
                    CompatibilityUtils.magicDamage(li, entityDamage, this.mage.getEntity());
                }
                li.setFireTicks(0);
            } else if (this.controller.isElemental(targetEntity)) {
                this.controller.damageElemental(targetEntity, parameters.getDouble("elemental_damage", 10.0), 0, this.mage.getCommandSender());
            }
        }
        if (!this.hasBuildPermission(target.getBlock())) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        int radius = parameters.getInt("radius", defaultRadius);
        radius = (int)(this.mage.getRadiusMultiplier() * (float)radius);
        FrostAction action = new FrostAction(this.controller, this.getUndoList(), iceMaterial, freezeWater, freezeLava, freezeFire);
        if (radius < 1) {
            action.perform(this.findBlockUnder(target.getBlock()));
        } else {
            this.coverSurface(target.getLocation(), radius, action);
        }
        this.registerForUndo();
        return SpellResult.CAST;
    }

    public int checkPosition(int x, int z, int R) {
        return x * x + z * z - R * R;
    }

    public class FrostAction
    extends SimpleBlockAction {
        private final Material iceMaterial;
        private final boolean freezeWater;
        private final boolean freezeLava;
        private final boolean freezeFire;

        public FrostAction(MageController controller, UndoList undoList, Material iceMaterial, boolean freezeWater, boolean freezeLava, boolean freezeFire) {
            super(controller, undoList);
            this.iceMaterial = iceMaterial;
            this.freezeLava = freezeLava;
            this.freezeWater = freezeWater;
            this.freezeFire = freezeFire;
        }

        @Override
        public SpellResult perform(Block block) {
            if (FrostSpell.this.isTransparent(block.getType())) {
                return SpellResult.NO_TARGET;
            }
            Material material = Material.SNOW;
            if (block.getType() == Material.WATER || block.getType() == Material.STATIONARY_WATER) {
                if (!this.freezeWater) {
                    return SpellResult.NO_TARGET;
                }
                material = this.iceMaterial;
            } else if (block.getType() == Material.LAVA) {
                if (!this.freezeLava) {
                    return SpellResult.NO_TARGET;
                }
                material = Material.COBBLESTONE;
            } else if (block.getType() == Material.STATIONARY_LAVA) {
                if (!this.freezeLava) {
                    return SpellResult.NO_TARGET;
                }
                material = Material.OBSIDIAN;
            } else if (block.getType() == Material.FIRE) {
                if (!this.freezeFire) {
                    return SpellResult.NO_TARGET;
                }
                material = Material.AIR;
            } else if (block.getType() == Material.SNOW) {
                material = Material.SNOW;
            } else {
                block = block.getRelative(BlockFace.UP);
            }
            super.perform(block);
            MaterialAndData applyMaterial = new MaterialAndData(material);
            if (block.getType() == Material.SNOW && material == Material.SNOW && block.getData() < 7) {
                applyMaterial.setData((byte)(block.getData() + 1));
            }
            applyMaterial.modify(block);
            return SpellResult.CAST;
        }
    }
}

