/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell.builtin;

import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.UndoableSpell;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class BlinkSpell
extends UndoableSpell {
    private int verticalSearchDistance = 255;
    private static int DEFAULT_PASSTHROUGH_RANGE = 4;

    protected SpellResult ascend(Entity entity) {
        Location targetLocation = this.getLocation();
        for (int i = 0; i < 2; ++i) {
            if (!this.allowPassThrough(targetLocation.getBlock().getType())) {
                return SpellResult.NO_TARGET;
            }
            targetLocation.setY(targetLocation.getY() + 1.0);
        }
        Location location = this.findPlaceToStand(targetLocation, true);
        if (location != null) {
            this.setTarget(location);
            this.delayTeleport(entity, location);
            return SpellResult.CAST;
        }
        return SpellResult.NO_TARGET;
    }

    protected SpellResult descend(Entity entity) {
        Location targetLocation = this.getLocation();
        for (int i = 0; i < 2; ++i) {
            if (!this.allowPassThrough(targetLocation.getBlock().getType())) {
                return SpellResult.NO_TARGET;
            }
            targetLocation.setY(targetLocation.getY() - 1.0);
        }
        Location location = this.findPlaceToStand(targetLocation, false);
        if (location != null) {
            this.setTarget(location);
            this.delayTeleport(entity, location);
            return SpellResult.CAST;
        }
        return SpellResult.NO_TARGET;
    }

    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        String elevateType = parameters.getString("type", "");
        LivingEntity entity = this.mage.getLivingEntity();
        if (entity == null) {
            return SpellResult.ENTITY_REQUIRED;
        }
        boolean autoAscend = parameters.getBoolean("allow_ascend", true);
        boolean autoDescend = parameters.getBoolean("allow_descend", true);
        boolean autoPassthrough = parameters.getBoolean("allow_passthrough", true);
        this.verticalSearchDistance = parameters.getInt("vertical_range", 8);
        boolean isPassthrough = false;
        if (elevateType.equals("descend") || this.isLookingDown() && autoDescend) {
            return this.descend((Entity)entity);
        }
        if (elevateType.equals("ascend") || this.isLookingUp() && autoAscend) {
            return this.ascend((Entity)entity);
        }
        if (autoPassthrough && !this.isLookingUp() && !this.isLookingDown()) {
            Block firstBlock = this.getInteractBlock();
            if (firstBlock == null) {
                return SpellResult.NO_TARGET;
            }
            if (!this.allowPassThrough(firstBlock.getType())) {
                return SpellResult.NO_TARGET;
            }
            if (firstBlock != null && firstBlock.getType() != Material.AIR && !this.isWater(firstBlock.getType())) {
                int passthroughRange = (int)Math.floor(this.mage.getRangeMultiplier() * (float)parameters.getInt("passthrough_range", DEFAULT_PASSTHROUGH_RANGE));
                this.setMaxRange(passthroughRange);
                this.offsetTarget(0, -1, 0);
                this.setTargetSpaceRequired();
                this.setTargetMinOffset(1);
                isPassthrough = true;
            }
        }
        Block target = this.getTargetBlock();
        Block face = this.getPreviousBlock();
        if (target == null) {
            return SpellResult.NO_TARGET;
        }
        if (face == null) {
            face = target;
        }
        World world = this.getWorld();
        Block destination = face;
        int distanceUp = 0;
        int distanceDown = 0;
        if (isPassthrough || destination == null) {
            destination = target;
        }
        if (!(entity instanceof Player) || !((Player)entity).isFlying()) {
            Block groundBlock = destination.getRelative(BlockFace.DOWN);
            while (distanceDown < this.verticalSearchDistance && !this.isOkToStandOn(groundBlock.getType())) {
                destination = groundBlock;
                groundBlock = destination.getRelative(BlockFace.DOWN);
                ++distanceDown;
            }
        }
        Block ledge = null;
        if (!(isPassthrough || face.equals(target.getRelative(BlockFace.DOWN)) && !autoAscend)) {
            ledge = target;
            Block inFront = face;
            Block oneUp = ledge.getRelative(BlockFace.UP);
            Block twoUp = oneUp.getRelative(BlockFace.UP);
            Block faceOneUp = face.getRelative(BlockFace.UP);
            Block faceTwoUp = faceOneUp.getRelative(BlockFace.UP);
            if (!(autoPassthrough || autoAscend || this.isTransparent(oneUp.getType()) && this.isTransparent(twoUp.getType()) && this.isTransparent(face.getType()) && this.isTransparent(faceOneUp.getType()) && this.isTransparent(faceTwoUp.getType()))) {
                ledge = null;
            } else {
                while ((autoPassthrough || autoAscend || this.isTransparent(face.getType()) && this.isTransparent(faceOneUp.getType()) && this.isTransparent(faceTwoUp.getType())) && distanceUp < this.verticalSearchDistance && this.isOkToStandIn(inFront.getType()) && (!this.isOkToStandOn(ledge.getType()) || !this.isOkToStandIn(oneUp.getType()) || !this.isOkToStandIn(twoUp.getType()))) {
                    faceOneUp = faceOneUp.getRelative(BlockFace.UP);
                    faceTwoUp = faceOneUp.getRelative(BlockFace.UP);
                    inFront = inFront.getRelative(BlockFace.UP);
                    ledge = ledge.getRelative(BlockFace.UP);
                    ++distanceUp;
                }
            }
        } else {
            ledge = null;
        }
        if (ledge != null && distanceUp < distanceDown && this.isOkToStandOn(ledge.getType())) {
            destination = ledge.getRelative(BlockFace.UP);
        }
        Block oneUp = destination.getRelative(BlockFace.UP);
        Block twoUp = oneUp.getRelative(BlockFace.UP);
        if (!this.isOkToStandIn(oneUp.getType()) || !this.isOkToStandIn(twoUp.getType())) {
            return SpellResult.NO_TARGET;
        }
        Location targetLocation = new Location(world, (double)destination.getX() + 0.5, (double)destination.getY(), (double)destination.getZ() + 0.5, entity.getLocation().getYaw(), entity.getLocation().getPitch());
        this.setTarget(targetLocation);
        this.delayTeleport((Entity)entity, targetLocation);
        return SpellResult.CAST;
    }

    protected void delayTeleport(final Entity entity, final Location location) {
        this.registerMoved(entity);
        Bukkit.getScheduler().scheduleSyncDelayedTask(this.controller.getPlugin(), new Runnable(){

            @Override
            public void run() {
                entity.teleport(location);
                BlinkSpell.this.registerForUndo();
            }
        }, 1L);
    }
}

