/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell.builtin;

import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.wand.Wand;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.spell.BrushSpell;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;

public class AbsorbSpell
extends BrushSpell {
    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        Block target;
        Wand wand = this.mage.getActiveWand();
        if (wand == null) {
            return SpellResult.FAIL;
        }
        Material material = Material.AIR;
        Set<Material> buildingMaterials = this.controller.getBuildingMaterials();
        byte data = 0;
        if (!this.isUnderwater()) {
            this.noTargetThrough(Material.STATIONARY_WATER);
            this.noTargetThrough(Material.WATER);
        }
        if ((target = this.getTargetBlock()) == null) {
            return SpellResult.NO_TARGET;
        }
        material = target.getType();
        data = target.getData();
        if (material == null || material == Material.AIR || !buildingMaterials.contains(material)) {
            return SpellResult.NO_TARGET;
        }
        MaterialAndData mat = new MaterialAndData(material, data);
        wand.addBrush(mat.getKey());
        wand.setActiveBrush(mat.getKey());
        return SpellResult.CAST;
    }

    @Override
    public boolean hasBrushOverride() {
        return true;
    }

    @Override
    public boolean isUndoable() {
        return false;
    }
}

