/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.slikey.effectlib.effect;

import com.elmakers.mine.bukkit.slikey.effectlib.Effect;
import com.elmakers.mine.bukkit.slikey.effectlib.EffectManager;
import com.elmakers.mine.bukkit.slikey.effectlib.EffectType;
import com.elmakers.mine.bukkit.slikey.effectlib.util.ParticleEffect;
import com.elmakers.mine.bukkit.slikey.effectlib.util.VectorUtils;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.util.Vector;

public class ColoredImageEffect
extends Effect {
    public ParticleEffect particle = ParticleEffect.FLAME;
    public int stepX = 10;
    public int stepY = 10;
    public float size = 0.025f;
    public boolean enableRotation = true;
    public Plane plane = Plane.XYZ;
    public double angularVelocityX = 0.015707963267948967;
    public double angularVelocityY = 0.018479956785822312;
    public double angularVelocityZ = 0.02026833970057931;
    protected BufferedImage image = null;
    protected boolean isGif = false;
    protected File gifFile = null;
    protected int step = 0;
    protected int rotationStep = 0;
    protected int delay = 0;
    private final Color[] colors = new Color[]{this.c(0, 0, 0), this.c(0, 0, 170), this.c(0, 170, 0), this.c(0, 170, 170), this.c(170, 0, 0), this.c(170, 0, 170), this.c(255, 170, 0), this.c(170, 170, 170), this.c(85, 85, 85), this.c(85, 85, 255), this.c(85, 255, 85), this.c(85, 255, 255), this.c(255, 85, 85), this.c(255, 85, 255), this.c(255, 255, 85), this.c(255, 255, 255)};

    public ColoredImageEffect(EffectManager effectManager) throws IOException {
        super(effectManager);
        this.type = EffectType.REPEATING;
        this.period = 2;
        this.iterations = 200;
    }

    public void loadFile(File file) {
        try {
            this.image = ImageIO.read(file);
            this.isGif = file.getName().endsWith(".gif");
            this.gifFile = file;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.image = null;
        }
    }

    @Override
    public void onRun() {
        if (this.image == null) {
            this.cancel();
            return;
        }
        if (this.isGif) {
            try {
                this.image = this.getImg(this.step);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (this.delay == 5) {
                ++this.step;
                this.delay = 0;
            }
            ++this.delay;
        }
        Location location = this.getLocation();
        for (int y = 0; y < this.image.getHeight(); y += this.stepY) {
            for (int x = 0; x < this.image.getWidth(); x += this.stepX) {
                int clr = this.image.getRGB(x, y);
                ParticleEffect colorEffect = this.particle;
                ChatColor cc = this.matchColor(new Color(this.image.getRGB(x, y)));
                if (cc.equals((Object)ChatColor.BLACK) || cc.equals((Object)ChatColor.DARK_GRAY)) {
                    colorEffect = ParticleEffect.SMOKE;
                } else if (cc.equals((Object)ChatColor.BLUE) || cc.equals((Object)ChatColor.DARK_BLUE) || cc.equals((Object)ChatColor.AQUA)) {
                    colorEffect = ParticleEffect.DRIP_WATER;
                } else if (cc.equals((Object)ChatColor.GREEN) || cc.equals((Object)ChatColor.DARK_GREEN)) {
                    colorEffect = ParticleEffect.HAPPY_VILLAGER;
                } else if (cc.equals((Object)ChatColor.RED) || cc.equals((Object)ChatColor.DARK_RED)) {
                    colorEffect = ParticleEffect.RED_DUST;
                } else if (cc.equals((Object)ChatColor.GOLD) || cc.equals((Object)ChatColor.YELLOW)) {
                    colorEffect = ParticleEffect.FLAME;
                } else if (cc.equals((Object)ChatColor.DARK_PURPLE) || cc.equals((Object)ChatColor.LIGHT_PURPLE)) {
                    colorEffect = ParticleEffect.WITCH_MAGIC;
                } else if (cc.equals((Object)ChatColor.WHITE) || cc.equals((Object)ChatColor.GRAY)) {
                    colorEffect = ParticleEffect.SNOW_SHOVEL;
                }
                Vector v = new Vector((float)this.image.getWidth() / 2.0f - (float)x, (float)this.image.getHeight() / 2.0f - (float)y, 0.0f).multiply(this.size);
                VectorUtils.rotateAroundAxisY(v, -location.getYaw() * ((float)Math.PI / 180));
                if (this.enableRotation) {
                    double rotX = 0.0;
                    double rotY = 0.0;
                    double rotZ = 0.0;
                    switch (this.plane) {
                        case X: {
                            rotX = this.angularVelocityX * (double)this.rotationStep;
                            break;
                        }
                        case Y: {
                            rotY = this.angularVelocityY * (double)this.rotationStep;
                            break;
                        }
                        case Z: {
                            rotZ = this.angularVelocityZ * (double)this.rotationStep;
                            break;
                        }
                        case XY: {
                            rotX = this.angularVelocityX * (double)this.rotationStep;
                            rotY = this.angularVelocityY * (double)this.rotationStep;
                            break;
                        }
                        case XZ: {
                            rotX = this.angularVelocityX * (double)this.rotationStep;
                            rotZ = this.angularVelocityZ * (double)this.rotationStep;
                            break;
                        }
                        case XYZ: {
                            rotX = this.angularVelocityX * (double)this.rotationStep;
                            rotY = this.angularVelocityY * (double)this.rotationStep;
                            rotZ = this.angularVelocityZ * (double)this.rotationStep;
                            break;
                        }
                        case YZ: {
                            rotY = this.angularVelocityY * (double)this.rotationStep;
                            rotZ = this.angularVelocityZ * (double)this.step;
                        }
                    }
                    VectorUtils.rotateVector(v, rotX, rotY, rotZ);
                }
                colorEffect.display(location.add(v), this.visibleRange, 0.0f, 0.0f, 0.0f, 0.0f, 2);
                location.subtract(v);
            }
        }
        ++this.rotationStep;
    }

    private BufferedImage getImg(int s) throws IOException {
        ArrayList<BufferedImage> images = new ArrayList<BufferedImage>();
        ImageReader reader = ImageIO.getImageReadersBySuffix("GIF").next();
        ImageInputStream in = ImageIO.createImageInputStream(this.gifFile);
        reader.setInput(in);
        int count = reader.getNumImages(true);
        for (int i = 0; i < count; ++i) {
            BufferedImage image = reader.read(i);
            images.add(image);
        }
        if (this.step >= reader.getNumImages(true)) {
            this.step = 0;
            return (BufferedImage)images.get(s - 1);
        }
        return (BufferedImage)images.get(s);
    }

    private Color c(int r, int g, int b) {
        return new Color(r, g, b);
    }

    private double getDistance(Color c1, Color c2) {
        double rmean = (double)(c1.getRed() + c2.getRed()) / 2.0;
        double r = c1.getRed() - c2.getRed();
        double g = c1.getGreen() - c2.getGreen();
        int b = c1.getBlue() - c2.getBlue();
        double weightR = 2.0 + rmean / 256.0;
        double weightG = 4.0;
        double weightB = 2.0 + (255.0 - rmean) / 256.0;
        return weightR * r * r + weightG * g * g + weightB * (double)b * (double)b;
    }

    public boolean areIdentical(Color c1, Color c2) {
        return Math.abs(c1.getRed() - c2.getRed()) <= 5 && Math.abs(c1.getGreen() - c2.getGreen()) <= 5 && Math.abs(c1.getBlue() - c2.getBlue()) <= 5;
    }

    public ChatColor matchColor(int r, int g, int b) {
        return this.matchColor(new Color(r, g, b));
    }

    public ChatColor matchColor(Color color) {
        int i;
        if (color.getAlpha() < 128) {
            return ChatColor.BLACK;
        }
        int index = 0;
        double best = -1.0;
        for (i = 0; i < this.colors.length; ++i) {
            if (!this.areIdentical(this.colors[i], color)) continue;
            return ChatColor.values()[i];
        }
        for (i = 0; i < this.colors.length; ++i) {
            double distance = this.getDistance(color, this.colors[i]);
            if (!(distance < best) && best != -1.0) continue;
            best = distance;
            index = i;
        }
        return ChatColor.values()[index];
    }

    public static enum Plane {
        X,
        Y,
        Z,
        XY,
        XZ,
        XYZ,
        YZ;

    }
}

