/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic;

import com.elmakers.mine.bukkit.api.block.BlockBatch;
import com.elmakers.mine.bukkit.api.block.MaterialBrush;
import com.elmakers.mine.bukkit.api.block.UndoBatch;
import com.elmakers.mine.bukkit.api.block.UndoList;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.CostReducer;
import com.elmakers.mine.bukkit.api.spell.MageSpell;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellEventType;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.api.wand.LostWand;
import com.elmakers.mine.bukkit.block.UndoQueue;
import com.elmakers.mine.bukkit.effect.HoloUtils;
import com.elmakers.mine.bukkit.effect.Hologram;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.slikey.effectlib.util.ParticleEffect;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.wand.Wand;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.util.Vector;

public class Mage
implements CostReducer,
com.elmakers.mine.bukkit.api.magic.Mage {
    protected static int AUTOMATA_ONLINE_TIMEOUT = 5000;
    private static final Set<Material> EMPTY_MATERIAL_SET = new HashSet<Material>();
    private static String defaultMageName = "Mage";
    protected final String id;
    protected ConfigurationSection data = new MemoryConfiguration();
    protected WeakReference<Player> _player;
    protected WeakReference<Entity> _entity;
    protected WeakReference<CommandSender> _commandSender;
    protected boolean hasEntity;
    protected String playerName;
    protected final MagicController controller;
    protected HashMap<String, MageSpell> spells = new HashMap();
    private Wand activeWand = null;
    private Wand boundWand = null;
    private final Collection<Listener> quitListeners = new HashSet<Listener>();
    private final Collection<Listener> deathListeners = new HashSet<Listener>();
    private final Collection<Listener> damageListeners = new HashSet<Listener>();
    private final Set<MageSpell> activeSpells = new HashSet<MageSpell>();
    private UndoQueue undoQueue = null;
    private LinkedList<BlockBatch> pendingBatches = new LinkedList();
    private boolean loading = false;
    private Location location;
    private float costReduction = 0.0f;
    private float cooldownReduction = 0.0f;
    private float powerMultiplier = 1.0f;
    private long lastClick = 0L;
    private long lastCast = 0L;
    private long blockPlaceTimeout = 0L;
    private Location lastDeathLocation = null;
    private final com.elmakers.mine.bukkit.block.MaterialBrush brush;
    private long fallProtection = 0L;
    private boolean isNewPlayer = true;
    private Hologram hologram;
    private Integer hologramTaskId = null;
    private boolean hologramIsVisible = false;

    public Mage(String id, MagicController controller) {
        this.id = id;
        this.controller = controller;
        this.brush = new com.elmakers.mine.bukkit.block.MaterialBrush((com.elmakers.mine.bukkit.api.magic.Mage)this, Material.DIRT, 0);
        this._player = new WeakReference<Object>(null);
        this._entity = new WeakReference<Object>(null);
        this._commandSender = new WeakReference<Object>(null);
        this.hasEntity = false;
    }

    public static int getExpToLevel(int expLevel) {
        return expLevel >= 30 ? 62 + (expLevel - 30) * 7 : (expLevel >= 15 ? 17 + (expLevel - 15) * 3 : 17);
    }

    public void setCostReduction(float reduction) {
        this.costReduction = reduction;
    }

    @Override
    public boolean hasStoredInventory() {
        return this.activeWand != null && this.activeWand.hasStoredInventory();
    }

    @Override
    public Set<Spell> getActiveSpells() {
        return new HashSet<Spell>(this.activeSpells);
    }

    public Inventory getStoredInventory() {
        return this.activeWand != null ? this.activeWand.getStoredInventory() : null;
    }

    @Override
    public void setLocation(Location location) {
        LivingEntity entity = this.getLivingEntity();
        if (entity != null && location != null) {
            entity.teleport(location);
            return;
        }
        this.location = location;
    }

    public void setLocation(Location location, boolean direction) {
        if (!direction) {
            if (this.location == null) {
                this.location = location;
            } else {
                this.location.setX(location.getX());
                this.location.setY(location.getY());
                this.location.setZ(location.getZ());
            }
        } else {
            this.location = location;
        }
    }

    public void clearCache() {
        if (this.brush != null) {
            this.brush.clearSchematic();
        }
    }

    public void setCooldownReduction(float reduction) {
        this.cooldownReduction = reduction;
    }

    public void setPowerMultiplier(float mutliplier) {
        this.powerMultiplier = mutliplier;
    }

    public boolean usesMana() {
        return this.activeWand == null ? false : this.activeWand.usesMana();
    }

    public boolean addToStoredInventory(ItemStack item) {
        return this.activeWand == null ? false : this.activeWand.addToStoredInventory(item);
    }

    public boolean cancel() {
        boolean result = false;
        for (MageSpell spell : this.spells.values()) {
            result = spell.cancel() || result;
        }
        return result;
    }

    public void onPlayerQuit(PlayerEvent event) {
        Player player = this.getPlayer();
        if (player == null || player != event.getPlayer()) {
            return;
        }
        ArrayList<Listener> active = new ArrayList<Listener>(this.quitListeners);
        for (Listener listener : active) {
            this.callEvent(listener, (Event)event);
        }
    }

    public void onPlayerDeath(EntityDeathEvent event) {
        Player player = this.getPlayer();
        if (player == null || player != event.getEntity()) {
            return;
        }
        this.lastDeathLocation = player.getLocation();
        ArrayList<Listener> active = new ArrayList<Listener>(this.deathListeners);
        for (Listener listener : active) {
            this.callEvent(listener, (Event)event);
        }
    }

    public void onPlayerCombust(EntityCombustEvent event) {
        if (this.activeWand != null && this.activeWand.getDamageReductionFire() > 0.0f) {
            event.getEntity().setFireTicks(0);
            event.setCancelled(true);
        }
    }

    protected void callEvent(Listener listener, Event event) {
        for (Method method : listener.getClass().getMethods()) {
            Class<?>[] parameters;
            if (!method.isAnnotationPresent(EventHandler.class) || (parameters = method.getParameterTypes()).length != 1 || !parameters[0].isAssignableFrom(event.getClass())) continue;
            try {
                method.invoke((Object)listener, event);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void onPlayerDamage(EntityDamageEvent event) {
        Player player = this.getPlayer();
        if (player == null) {
            return;
        }
        ArrayList<Listener> active = new ArrayList<Listener>(this.damageListeners);
        for (Listener listener : active) {
            this.callEvent(listener, (Event)event);
            if (!event.isCancelled()) continue;
            break;
        }
        if (this.isSuperProtected()) {
            event.setCancelled(true);
            if (player.getFireTicks() > 0) {
                player.setFireTicks(0);
            }
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        EntityDamageEvent.DamageCause cause = event.getCause();
        if (cause == EntityDamageEvent.DamageCause.FALL && this.fallProtection > 0L && this.fallProtection > System.currentTimeMillis()) {
            event.setCancelled(true);
            return;
        }
        float reduction = 0.0f;
        if (this.activeWand != null) {
            reduction = this.activeWand.getDamageReduction();
            float damageReductionFire = this.activeWand.getDamageReductionFire();
            switch (cause) {
                case CONTACT: 
                case ENTITY_ATTACK: {
                    reduction += this.activeWand.getDamageReductionPhysical();
                    break;
                }
                case PROJECTILE: {
                    reduction += this.activeWand.getDamageReductionProjectiles();
                    break;
                }
                case FALL: {
                    reduction += this.activeWand.getDamageReductionFalling();
                    break;
                }
                case FIRE: 
                case FIRE_TICK: 
                case LAVA: {
                    if (damageReductionFire > 0.0f && player.getFireTicks() > 0) {
                        player.setFireTicks(0);
                    }
                    reduction += damageReductionFire;
                    break;
                }
                case BLOCK_EXPLOSION: 
                case ENTITY_EXPLOSION: {
                    reduction += this.activeWand.getDamageReductionExplosions();
                }
            }
        }
        if (reduction > 1.0f) {
            event.setCancelled(true);
            return;
        }
        if (reduction > 0.0f) {
            double newDamage = (double)(1.0f - reduction) * event.getDamage();
            if (newDamage <= 0.0) {
                newDamage = 0.1;
            }
            event.setDamage(newDamage);
        }
    }

    public void setActiveWand(Wand activeWand) {
        this.activeWand = activeWand;
        if (activeWand != null && activeWand.isBound() && activeWand.canUse(this.getPlayer())) {
            this.boundWand = activeWand;
        }
        this.blockPlaceTimeout = System.currentTimeMillis() + 200L;
    }

    public long getBlockPlaceTimeout() {
        return this.blockPlaceTimeout;
    }

    @Override
    public void castMessage(String message) {
        if (message == null || message.length() == 0) {
            return;
        }
        if (this.activeWand != null && !this.activeWand.showCastMessages()) {
            return;
        }
        CommandSender sender = this.getCommandSender();
        if (sender != null && this.controller.showCastMessages() && this.controller.showMessages()) {
            sender.sendMessage(this.controller.getCastMessagePrefix() + message);
        }
    }

    @Override
    public void sendMessage(String message) {
        if (message == null || message.length() == 0) {
            return;
        }
        if (this.activeWand != null && !this.activeWand.showMessages()) {
            return;
        }
        CommandSender sender = this.getCommandSender();
        if (sender != null && this.controller.showMessages()) {
            sender.sendMessage(this.controller.getMessagePrefix() + message);
        }
    }

    public void clearBuildingMaterial() {
        this.brush.setMaterial(this.controller.getDefaultMaterial(), (byte)1);
    }

    public void playSound(Sound sound, float volume, float pitch) {
        if (!this.controller.soundsEnabled()) {
            return;
        }
        Player player = this.getPlayer();
        if (player != null) {
            player.playSound(player.getLocation(), sound, volume, pitch);
        } else {
            Entity entity = this.getEntity();
            entity.getLocation().getWorld().playSound(entity.getLocation(), sound, volume, pitch);
        }
    }

    @Override
    public UndoQueue getUndoQueue() {
        if (this.undoQueue == null) {
            this.undoQueue = new UndoQueue(this);
            this.undoQueue.setMaxSize(this.controller.getUndoQueueDepth());
        }
        return this.undoQueue;
    }

    @Override
    public UndoList getLastUndoList() {
        if (this.undoQueue == null || this.undoQueue.isEmpty()) {
            return null;
        }
        return this.undoQueue.getLast();
    }

    @Override
    public boolean registerForUndo(UndoList undoList) {
        if (undoList == null) {
            return false;
        }
        if (undoList.bypass()) {
            return true;
        }
        UndoQueue queue = this.getUndoQueue();
        int autoUndo = this.controller.getAutoUndoInterval();
        if (autoUndo > 0 && undoList.getScheduledUndo() == 0) {
            undoList.setScheduleUndo(autoUndo);
        }
        queue.add(undoList);
        this.controller.registerForUndo(this);
        return true;
    }

    @Override
    public void addUndoBatch(UndoBatch batch) {
        this.pendingBatches.addLast(batch);
        this.controller.addPending(this);
    }

    protected void setPlayer(Player player) {
        if (player != null) {
            this.playerName = player.getName();
            this._player = new WeakReference<Player>(player);
            this._entity = new WeakReference<Player>(player);
            this._commandSender = new WeakReference<Player>(player);
            this.hasEntity = true;
        } else {
            this._player.clear();
            this._entity.clear();
            this._commandSender.clear();
            this.hasEntity = false;
        }
    }

    protected void setEntity(Entity entity) {
        if (entity != null) {
            LivingEntity li;
            String customName;
            this.playerName = entity.getType().name().toLowerCase().replace("_", " ");
            if (entity instanceof LivingEntity && (customName = (li = (LivingEntity)entity).getCustomName()) != null && customName.length() > 0) {
                this.playerName = customName;
            }
            this._entity = new WeakReference<Entity>(entity);
            this.hasEntity = true;
        } else {
            this._entity.clear();
            this.hasEntity = false;
        }
    }

    protected void setCommandSender(CommandSender sender) {
        if (sender != null) {
            this._commandSender = new WeakReference<CommandSender>(sender);
            if (sender instanceof BlockCommandSender) {
                BlockCommandSender commandBlock = (BlockCommandSender)sender;
                this.playerName = commandBlock.getName();
                Location location = this.getLocation();
                if (location == null) {
                    location = commandBlock.getBlock().getLocation();
                } else {
                    Location blockLocation = commandBlock.getBlock().getLocation();
                    location.setX(blockLocation.getX());
                    location.setY(blockLocation.getY());
                    location.setZ(blockLocation.getZ());
                }
                this.setLocation(location, false);
            } else {
                this.setLocation(null);
            }
        } else {
            this._commandSender.clear();
            this.setLocation(null);
        }
    }

    protected void onLoad() {
        this.loading = false;
        Player player = this.getPlayer();
        if (player != null) {
            String welcomeWand = this.controller.getWelcomeWand();
            Wand wand = Wand.getActiveWand(this.controller, player);
            if (wand != null) {
                wand.activate(this);
                wand.restoreInventory();
            } else if (this.isNewPlayer && welcomeWand.length() > 0) {
                this.isNewPlayer = false;
                wand = Wand.createWand(this.controller, welcomeWand);
                if (wand != null) {
                    wand.takeOwnership(player, false, false);
                    this.controller.giveItemToPlayer(player, wand.getItem());
                    this.controller.getLogger().info("Gave welcome wand " + wand.getName() + " to " + player.getName());
                } else {
                    this.controller.getLogger().warning("Unable to give welcome wand '" + welcomeWand + "' to " + player.getName());
                }
            }
        }
        Collection<Spell> spells = this.getSpells();
        for (Spell spell : spells) {
            if (!spell.isActive()) continue;
            this.sendMessage(this.controller.getMessages().get("spell.reactivate").replace("$name", spell.getName()));
            this.activateSpell(spell);
        }
    }

    protected void load(ConfigurationSection configNode) {
        try {
            if (configNode == null) {
                this.onLoad();
                return;
            }
            this.boundWand = null;
            if (configNode.contains("bound_wand")) {
                this.boundWand = new Wand(this.controller, configNode.getConfigurationSection("bound_wand"));
            }
            if (configNode.contains("data")) {
                this.data = configNode.getConfigurationSection("data");
            }
            this.isNewPlayer = false;
            this.playerName = configNode.getString("name", this.playerName);
            this.lastDeathLocation = ConfigurationUtils.getLocation(configNode, "last_death_location");
            this.location = ConfigurationUtils.getLocation(configNode, "location");
            this.lastCast = configNode.getLong("last_cast", this.lastCast);
            this.getUndoQueue().load(configNode);
            ConfigurationSection spellNode = configNode.getConfigurationSection("spells");
            if (spellNode != null) {
                Set keys = spellNode.getKeys(false);
                for (String key : keys) {
                    Spell spell = this.getSpell(key);
                    if (spell == null || !(spell instanceof MageSpell)) continue;
                    ConfigurationSection spellSection = spellNode.getConfigurationSection(key);
                    ((MageSpell)spell).load(spellSection);
                }
            }
            if (configNode.contains("brush")) {
                this.brush.load(configNode.getConfigurationSection("brush"));
            }
        }
        catch (Exception ex) {
            this.controller.getPlugin().getLogger().warning("Failed to load player data for " + this.playerName + ": " + ex.getMessage());
        }
        this.onLoad();
    }

    @Override
    public void save(ConfigurationSection configNode) {
        try {
            configNode.set("name", (Object)this.playerName);
            configNode.set("last_cast", (Object)this.lastCast);
            configNode.set("last_death_location", (Object)ConfigurationUtils.fromLocation(this.lastDeathLocation));
            if (this.location != null) {
                configNode.set("location", (Object)ConfigurationUtils.fromLocation(this.location));
            }
            ConfigurationSection brushNode = configNode.createSection("brush");
            this.brush.save(brushNode);
            this.getUndoQueue().save(configNode);
            ConfigurationSection spellNode = configNode.createSection("spells");
            for (MageSpell spell : this.spells.values()) {
                ConfigurationSection section = spellNode.createSection(spell.getKey());
                section.set("active", (Object)spell.isActive());
                spell.save(section);
            }
            if (this.boundWand != null) {
                ConfigurationSection wandConfig = configNode.createSection("bound_wand");
                this.boundWand.saveProperties(wandConfig);
            }
            ConfigurationSection dataSection = configNode.createSection("data");
            ConfigurationUtils.addConfigurations(dataSection, this.data);
        }
        catch (Exception ex) {
            this.controller.getPlugin().getLogger().warning("Failed to save player data for " + this.playerName + ": " + ex.getMessage());
        }
    }

    protected boolean checkLastClick(long maxInterval) {
        long now = System.currentTimeMillis();
        long previous = this.lastClick;
        this.lastClick = now;
        return previous <= 0L || previous + maxInterval < now;
    }

    protected void tick() {
        Player player = this.getPlayer();
        if (player != null && player.isOnline()) {
            if (this.activeWand != null) {
                this.activeWand.tick();
            }
            ArrayList<MageSpell> active = new ArrayList<MageSpell>(this.activeSpells);
            for (MageSpell spell : active) {
                spell.tick();
                if (spell.isActive()) continue;
                this.deactivateSpell(spell);
            }
        }
    }

    public void processPendingBatches(int maxBlockUpdates) {
        if (this.pendingBatches.size() > 0) {
            int updated = 0;
            ArrayList<BlockBatch> processBatches = new ArrayList<BlockBatch>(this.pendingBatches);
            this.pendingBatches.clear();
            for (BlockBatch batch : processBatches) {
                if (updated < maxBlockUpdates) {
                    int batchUpdated = batch.process(maxBlockUpdates - updated);
                    updated += batchUpdated;
                }
                if (batch.isFinished()) continue;
                this.pendingBatches.add(batch);
            }
        }
        if (this.pendingBatches.size() == 0) {
            this.controller.removePending(this);
        }
    }

    public void setLastHeldMapId(short mapId) {
        this.brush.setMapId(mapId);
    }

    protected void loadSpells(ConfigurationSection config) {
        if (config == null) {
            return;
        }
        ArrayList<MageSpell> currentSpells = new ArrayList<MageSpell>(this.spells.values());
        for (MageSpell spell : currentSpells) {
            String key = spell.getKey();
            if (config.contains(key)) {
                ConfigurationSection template = config.getConfigurationSection(key);
                String className = template.getString("class");
                if (!spell.getClass().getName().contains(className)) {
                    MemoryConfiguration spellData = new MemoryConfiguration();
                    spell.save((ConfigurationSection)spellData);
                    this.spells.remove(key);
                    Spell newSpell = this.getSpell(key);
                    if (newSpell == null || !(newSpell instanceof MageSpell)) continue;
                    ((MageSpell)newSpell).load((ConfigurationSection)spellData);
                    continue;
                }
                spell.loadTemplate(key, template);
                continue;
            }
            this.spells.remove(key);
        }
    }

    public boolean isNewPlayer() {
        return this.isNewPlayer;
    }

    public void clearNewPlayer() {
        this.isNewPlayer = false;
    }

    @Override
    public Collection<BlockBatch> getPendingBatches() {
        ArrayList<BlockBatch> pending = new ArrayList<BlockBatch>();
        pending.addAll(this.pendingBatches);
        return pending;
    }

    @Override
    public String getName() {
        return this.playerName == null || this.playerName.length() == 0 ? defaultMageName : this.playerName;
    }

    @Override
    public String getDisplayName() {
        Entity entity = this.getEntity();
        if (entity == null) {
            return this.getName();
        }
        if (entity instanceof Player) {
            return ((Player)entity).getDisplayName();
        }
        return this.controller.getEntityDisplayName(entity);
    }

    public void setName(String name) {
        this.playerName = name;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Location getLocation() {
        if (this.location != null) {
            return this.location.clone();
        }
        LivingEntity livingEntity = this.getLivingEntity();
        if (livingEntity == null) {
            return null;
        }
        return livingEntity.getLocation();
    }

    @Override
    public Location getEyeLocation() {
        LivingEntity entity = this.getLivingEntity();
        if (entity != null) {
            return entity.getEyeLocation();
        }
        Location location = this.getLocation();
        if (location != null) {
            location.setY(location.getY() + 1.5);
            return location;
        }
        return null;
    }

    @Override
    public Vector getDirection() {
        Location location = this.getLocation();
        if (location != null) {
            return location.getDirection();
        }
        return new Vector(0, 1, 0);
    }

    @Override
    public UndoList undo(Block target) {
        return this.getUndoQueue().undo(target);
    }

    @Override
    public BlockBatch cancelPending() {
        BlockBatch stoppedPending = null;
        if (this.pendingBatches.size() > 0) {
            ArrayList<BlockBatch> batches = new ArrayList<BlockBatch>();
            batches.addAll(this.pendingBatches);
            for (BlockBatch batch : batches) {
                if (batch instanceof com.elmakers.mine.bukkit.block.batch.UndoBatch) continue;
                batch.finish();
                this.pendingBatches.remove(batch);
                stoppedPending = batch;
                break;
            }
        }
        return stoppedPending;
    }

    @Override
    public UndoList undo() {
        return this.getUndoQueue().undo();
    }

    @Override
    public boolean commit() {
        return this.getUndoQueue().commit();
    }

    @Override
    public boolean hasCastPermission(Spell spell) {
        return spell.hasCastPermission(this.getCommandSender());
    }

    @Override
    public Spell getSpell(String key) {
        if (this.loading) {
            return null;
        }
        MageSpell playerSpell = this.spells.get(key);
        if (playerSpell == null) {
            SpellTemplate spellTemplate = this.controller.getSpellTemplate(key);
            if (spellTemplate == null) {
                return null;
            }
            Spell newSpell = spellTemplate.createSpell();
            if (newSpell == null || !(newSpell instanceof MageSpell)) {
                return null;
            }
            playerSpell = (MageSpell)newSpell;
            this.spells.put(newSpell.getKey(), playerSpell);
        }
        playerSpell.setMage(this);
        return playerSpell;
    }

    @Override
    public Collection<Spell> getSpells() {
        ArrayList<Spell> export = new ArrayList<Spell>(this.spells.values());
        return export;
    }

    @Override
    public void activateSpell(Spell spell) {
        if (spell instanceof MageSpell) {
            MageSpell mageSpell = (MageSpell)spell;
            this.activeSpells.add(mageSpell);
            mageSpell.reactivate();
        }
    }

    @Override
    public void deactivateSpell(Spell spell) {
        this.activeSpells.remove(spell);
        if (spell instanceof MageSpell) {
            ((MageSpell)spell).deactivate();
        }
    }

    @Override
    public void deactivateAllSpells() {
        this.deactivateAllSpells(false, false);
    }

    @Override
    public void deactivateAllSpells(boolean force, boolean quiet) {
        ArrayList<MageSpell> active = new ArrayList<MageSpell>(this.activeSpells);
        for (MageSpell spell : active) {
            if (!spell.deactivate(force, quiet)) continue;
            this.activeSpells.remove(spell);
        }
    }

    @Override
    public boolean isCostFree() {
        if (this.getPlayer() == null) {
            return true;
        }
        return this.activeWand == null ? false : this.activeWand.isCostFree();
    }

    @Override
    public boolean isSuperProtected() {
        LivingEntity livingEntity = this.getLivingEntity();
        if (livingEntity != null && livingEntity.hasPotionEffect(PotionEffectType.DAMAGE_RESISTANCE)) {
            Collection effects = livingEntity.getActivePotionEffects();
            for (PotionEffect effect : effects) {
                if (!effect.getType().equals((Object)PotionEffectType.DAMAGE_RESISTANCE)) continue;
                if (effect.getAmplifier() < 100) break;
                return true;
            }
        }
        return this.activeWand != null && this.activeWand.isSuperProtected();
    }

    @Override
    public boolean isSuperPowered() {
        return this.activeWand != null && this.activeWand.isSuperPowered();
    }

    @Override
    public float getCostReduction() {
        return this.activeWand == null ? this.costReduction + this.controller.getCostReduction() : this.activeWand.getCostReduction() + this.costReduction;
    }

    @Override
    public float getCooldownReduction() {
        return this.activeWand == null ? this.cooldownReduction + this.controller.getCooldownReduction() : this.activeWand.getCooldownReduction() + this.cooldownReduction;
    }

    @Override
    public boolean isCooldownFree() {
        return this.activeWand == null ? false : this.activeWand.isCooldownFree();
    }

    @Override
    public Color getEffectColor() {
        if (this.activeWand == null) {
            return null;
        }
        return this.activeWand.getEffectColor();
    }

    @Override
    public String getEffectParticleName() {
        if (this.activeWand == null) {
            return null;
        }
        ParticleEffect particle = this.activeWand.getEffectParticle();
        return particle == null ? null : particle.name();
    }

    @Override
    public void onCast(Spell spell, SpellResult result) {
        this.lastCast = System.currentTimeMillis();
        if (spell != null && result.isSuccess()) {
            this.controller.onCast(this, spell, result);
            if (this.controller.getShowCastHoloText()) {
                this.showHoloText(this.getEyeLocation(), spell.getName(), 10000);
            }
        }
    }

    @Override
    public float getPower() {
        float power = Math.min(this.controller.getMaxPower(), this.activeWand == null ? 0.0f : this.activeWand.getPower());
        return power * this.powerMultiplier;
    }

    @Override
    public boolean isRestricted(Material material) {
        if (this.isSuperPowered()) {
            return false;
        }
        return this.controller.isRestricted(material);
    }

    @Override
    public MageController getController() {
        return this.controller;
    }

    @Override
    public Set<Material> getRestrictedMaterials() {
        if (this.isSuperPowered()) {
            return EMPTY_MATERIAL_SET;
        }
        return this.controller.getRestrictedMaterials();
    }

    @Override
    public boolean isPVPAllowed(Location location) {
        Player player = this.getPlayer();
        if (player != null) {
            return this.controller.isPVPAllowed(player, location);
        }
        return this.controller.isPVPAllowed(location == null ? this.getLocation() : location);
    }

    @Override
    public boolean hasBuildPermission(Block block) {
        return this.controller.hasBuildPermission(this.getPlayer(), block);
    }

    @Override
    public boolean isIndestructible(Block block) {
        return this.controller.isIndestructible(block);
    }

    @Override
    public boolean isDestructible(Block block) {
        return this.controller.isDestructible(block);
    }

    @Override
    public boolean isDead() {
        LivingEntity entity = this.getLivingEntity();
        if (entity != null) {
            return entity.isDead();
        }
        CommandSender sender = this.getCommandSender();
        if (sender == null || !(sender instanceof BlockCommandSender)) {
            return true;
        }
        BlockCommandSender commandBlock = (BlockCommandSender)sender;
        Block block = commandBlock.getBlock();
        if (!block.getChunk().isLoaded()) {
            return true;
        }
        return block.getType() != Material.COMMAND;
    }

    @Override
    public boolean isOnline() {
        Player player = this.getPlayer();
        if (player != null) {
            return player.isOnline();
        }
        CommandSender sender = this.getCommandSender();
        if (sender == null || !(sender instanceof BlockCommandSender)) {
            return true;
        }
        return this.lastCast > System.currentTimeMillis() - (long)AUTOMATA_ONLINE_TIMEOUT;
    }

    @Override
    public boolean isPlayer() {
        Player player = this.getPlayer();
        return player != null;
    }

    @Override
    public boolean hasLocation() {
        return this.getLocation() != null;
    }

    @Override
    public Inventory getInventory() {
        if (this.hasStoredInventory()) {
            return this.getStoredInventory();
        }
        Player player = this.getPlayer();
        if (player != null) {
            return player.getInventory();
        }
        return null;
    }

    @Override
    public Wand getActiveWand() {
        return this.activeWand;
    }

    @Override
    public MaterialBrush getBrush() {
        return this.brush;
    }

    @Override
    public float getDamageMultiplier() {
        float maxPowerMultiplier = this.controller.getMaxDamagePowerMultiplier() - 1.0f;
        return 1.0f + maxPowerMultiplier * this.getPower();
    }

    @Override
    public float getRangeMultiplier() {
        if (this.activeWand == null) {
            return 1.0f;
        }
        float maxPowerMultiplier = this.controller.getMaxRangePowerMultiplier() - 1.0f;
        float maxPowerMultiplierMax = this.controller.getMaxRangePowerMultiplierMax();
        float multiplier = 1.0f + maxPowerMultiplier * this.getPower();
        return Math.min(multiplier, maxPowerMultiplierMax);
    }

    @Override
    public float getConstructionMultiplier() {
        float maxPowerMultiplier = this.controller.getMaxConstructionPowerMultiplier() - 1.0f;
        return 1.0f + maxPowerMultiplier * this.getPower();
    }

    @Override
    public float getRadiusMultiplier() {
        if (this.activeWand == null) {
            return 1.0f;
        }
        float maxPowerMultiplier = this.controller.getMaxRadiusPowerMultiplier() - 1.0f;
        float maxPowerMultiplierMax = this.controller.getMaxRadiusPowerMultiplierMax();
        float multiplier = 1.0f + maxPowerMultiplier * this.getPower();
        return Math.min(multiplier, maxPowerMultiplierMax);
    }

    @Override
    public int getMana() {
        return this.activeWand == null ? 0 : this.activeWand.getMana();
    }

    @Override
    public void removeMana(int mana) {
        if (this.activeWand != null) {
            this.activeWand.removeMana(mana);
        }
    }

    @Override
    public void removeExperience(int xp) {
        Player player = this.getPlayer();
        if (player == null) {
            return;
        }
        float expProgress = player.getExp();
        int expLevel = player.getLevel();
        while ((expProgress > 0.0f || expLevel > 0) && xp > 0) {
            if (expProgress > 0.0f) {
                int expAtLevel = (int)(expProgress * (float)player.getExpToLevel());
                if (expAtLevel > xp) {
                    xp = 0;
                    expProgress = (float)(expAtLevel -= xp) / (float)Mage.getExpToLevel(expLevel);
                    continue;
                }
                expProgress = 0.0f;
                xp -= expAtLevel;
                continue;
            }
            --expLevel;
            if ((xp -= player.getExpToLevel()) >= 0) continue;
            expProgress = (float)(-xp) / (float)Mage.getExpToLevel(expLevel);
            xp = 0;
        }
        player.setExp(expProgress);
        player.setLevel(expLevel);
        if (this.activeWand != null) {
            this.activeWand.updateExperience();
        }
    }

    @Override
    public int getLevel() {
        if (this.activeWand != null && this.activeWand.usesMana() && this.activeWand.displayManaAsXp() && !Wand.retainLevelDisplay) {
            return this.activeWand.getStoredXpLevel();
        }
        Player player = this.getPlayer();
        if (player != null) {
            return player.getLevel();
        }
        return 0;
    }

    @Override
    public void setLevel(int level) {
        Player player = this.getPlayer();
        if (player != null) {
            player.setLevel(level);
        }
        if (this.activeWand != null && this.activeWand.usesMana() && this.activeWand.displayManaAsXp()) {
            this.activeWand.setStoredXpLevel(level);
        }
    }

    @Override
    public int getExperience() {
        Player player = this.getPlayer();
        if (player == null) {
            return 0;
        }
        int xp = 0;
        float expProgress = player.getExp();
        int expLevel = player.getLevel();
        for (int level = 0; level < expLevel; ++level) {
            xp += Mage.getExpToLevel(level);
        }
        return xp + (int)(expProgress * (float)Mage.getExpToLevel(expLevel));
    }

    @Override
    public void giveExperience(int xp) {
        Player player;
        if (this.activeWand != null && this.activeWand.usesMana() && this.activeWand.displayManaAsXp()) {
            this.activeWand.addExperience(xp);
        }
        if ((player = this.getPlayer()) != null) {
            player.giveExp(xp);
        }
    }

    @Override
    public boolean addPendingBlockBatch(BlockBatch batch) {
        if (this.pendingBatches.size() >= this.controller.getPendingQueueDepth()) {
            this.controller.getLogger().info("Rejected construction for " + this.getName() + ", already has " + this.pendingBatches.size() + " pending, limit: " + this.controller.getPendingQueueDepth());
            return false;
        }
        this.pendingBatches.addLast(batch);
        this.controller.addPending(this);
        return true;
    }

    @Override
    public void registerEvent(SpellEventType type, Listener spell) {
        switch (type) {
            case PLAYER_QUIT: {
                if (this.quitListeners.contains(spell)) break;
                this.quitListeners.add(spell);
                break;
            }
            case PLAYER_DAMAGE: {
                if (this.damageListeners.contains(spell)) break;
                this.damageListeners.add(spell);
                break;
            }
            case PLAYER_DEATH: {
                if (this.deathListeners.contains(spell)) break;
                this.deathListeners.add(spell);
            }
        }
    }

    @Override
    public void unregisterEvent(SpellEventType type, Listener spell) {
        switch (type) {
            case PLAYER_DAMAGE: {
                this.damageListeners.remove(spell);
                break;
            }
            case PLAYER_QUIT: {
                this.quitListeners.remove(spell);
                break;
            }
            case PLAYER_DEATH: {
                this.deathListeners.remove(spell);
            }
        }
    }

    @Override
    public Player getPlayer() {
        return (Player)this._player.get();
    }

    @Override
    public Entity getEntity() {
        return (Entity)this._entity.get();
    }

    @Override
    public LivingEntity getLivingEntity() {
        Entity entity = (Entity)this._entity.get();
        return entity != null && entity instanceof LivingEntity ? (LivingEntity)entity : null;
    }

    @Override
    public CommandSender getCommandSender() {
        return (CommandSender)this._commandSender.get();
    }

    @Override
    public List<LostWand> getLostWands() {
        Collection<LostWand> allWands = this.controller.getLostWands();
        ArrayList<LostWand> mageWands = new ArrayList<LostWand>();
        for (LostWand lostWand : allWands) {
            String owner = lostWand.getOwner();
            if (owner == null || !owner.equals(this.playerName)) continue;
            mageWands.add(lostWand);
        }
        return mageWands;
    }

    @Override
    public Location getLastDeathLocation() {
        return this.lastDeathLocation;
    }

    public void showHoloText(Location location, String text, int duration) {
        if (!this.isPlayer()) {
            return;
        }
        final Player player = this.getPlayer();
        if (this.hologram == null) {
            this.hologram = HoloUtils.createHoloText(location, text);
        } else {
            if (this.hologramIsVisible) {
                this.hologram.hide(player);
            }
            this.hologram.teleport(location);
            this.hologram.setLabel(text);
        }
        this.hologram.show(player);
        BukkitScheduler scheduler = Bukkit.getScheduler();
        if (this.hologramTaskId != null) {
            scheduler.cancelTask(this.hologramTaskId.intValue());
        }
        if (duration > 0) {
            scheduler.scheduleSyncDelayedTask((Plugin)this.controller.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    Mage.this.hologram.hide(player);
                    Mage.this.hologramIsVisible = false;
                }
            }, (long)duration);
        }
    }

    @Override
    public void enableFallProtection(int ms) {
        if (ms == 0) {
            return;
        }
        long nextTime = System.currentTimeMillis() + (long)ms;
        if (nextTime > this.fallProtection) {
            this.fallProtection = nextTime;
        }
    }

    public void setLoading(boolean loading) {
        this.loading = loading;
    }

    @Override
    public boolean isValid() {
        if (!this.hasEntity) {
            return true;
        }
        Entity entity = this.getEntity();
        if (entity == null) {
            return false;
        }
        if (this.controller.isNPC(entity)) {
            return true;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return player.isOnline();
        }
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            return !living.isDead();
        }
        return true;
    }

    @Override
    public boolean restoreWand() {
        if (this.boundWand == null) {
            return false;
        }
        Player player = this.getPlayer();
        if (player == null) {
            return false;
        }
        this.controller.giveItemToPlayer(player, this.boundWand.duplicate().getItem());
        return true;
    }

    @Override
    public boolean isStealth() {
        Player player = this.getPlayer();
        if (player != null && player.isSneaking()) {
            return true;
        }
        return this.activeWand != null && this.activeWand.isStealth();
    }

    @Override
    public ConfigurationSection getData() {
        return this.data;
    }
}

