/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.wand;

import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.spell.CastingCost;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.block.MaterialBrush;
import com.elmakers.mine.bukkit.spell.BrushSpell;
import com.elmakers.mine.bukkit.utility.Messages;
import com.elmakers.mine.bukkit.utility.RandomUtils;
import com.elmakers.mine.bukkit.utility.WeightedPair;
import com.elmakers.mine.bukkit.wand.Wand;
import com.elmakers.mine.bukkit.wand.WandUpgradePath;
import java.util.Collection;
import java.util.LinkedList;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;

public class WandLevel {
    private final WandUpgradePath path;
    private LinkedList<WeightedPair<Integer>> spellCountProbability = new LinkedList();
    private LinkedList<WeightedPair<Integer>> materialCountProbability = new LinkedList();
    private LinkedList<WeightedPair<String>> spellProbability = new LinkedList();
    private LinkedList<WeightedPair<String>> materialProbability = new LinkedList();
    private LinkedList<WeightedPair<Integer>> useProbability = new LinkedList();
    private LinkedList<WeightedPair<Integer>> addUseProbability = new LinkedList();
    private LinkedList<WeightedPair<Integer>> propertyCountProbability = new LinkedList();
    private LinkedList<WeightedPair<Float>> costReductionProbability = new LinkedList();
    private LinkedList<WeightedPair<Float>> powerProbability = new LinkedList();
    private LinkedList<WeightedPair<Float>> damageReductionProbability = new LinkedList();
    private LinkedList<WeightedPair<Float>> damageReductionPhysicalProbability = new LinkedList();
    private LinkedList<WeightedPair<Float>> damageReductionProjectilesProbability = new LinkedList();
    private LinkedList<WeightedPair<Float>> damageReductionFallingProbability = new LinkedList();
    private LinkedList<WeightedPair<Float>> damageReductionFireProbability = new LinkedList();
    private LinkedList<WeightedPair<Float>> damageReductionExplosionsProbability = new LinkedList();
    private LinkedList<WeightedPair<Integer>> xpRegenerationProbability = new LinkedList();
    private LinkedList<WeightedPair<Integer>> xpMaxProbability = new LinkedList();
    private LinkedList<WeightedPair<Integer>> healthRegenerationProbability = new LinkedList();
    private LinkedList<WeightedPair<Integer>> hungerRegenerationProbability = new LinkedList();
    private LinkedList<WeightedPair<Float>> hasteProbability = new LinkedList();

    protected WandLevel(WandUpgradePath path, ConfigurationSection template, int levelIndex, int nextLevelIndex, float distance) {
        this.path = path;
        RandomUtils.populateStringProbabilityMap(this.spellProbability, template.getConfigurationSection("spells"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateIntegerProbabilityMap(this.spellCountProbability, template.getConfigurationSection("spell_count"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateStringProbabilityMap(this.materialProbability, template.getConfigurationSection("materials"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateIntegerProbabilityMap(this.materialCountProbability, template.getConfigurationSection("material_count"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateIntegerProbabilityMap(this.useProbability, template.getConfigurationSection("uses"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateIntegerProbabilityMap(this.addUseProbability, template.getConfigurationSection("add_uses"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateIntegerProbabilityMap(this.propertyCountProbability, template.getConfigurationSection("property_count"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateFloatProbabilityMap(this.costReductionProbability, template.getConfigurationSection("cost_reduction"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateFloatProbabilityMap(this.damageReductionProbability, template.getConfigurationSection("protection"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateFloatProbabilityMap(this.damageReductionPhysicalProbability, template.getConfigurationSection("protection_physical"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateFloatProbabilityMap(this.damageReductionFallingProbability, template.getConfigurationSection("protection_falling"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateFloatProbabilityMap(this.damageReductionProjectilesProbability, template.getConfigurationSection("protection_projectiles"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateFloatProbabilityMap(this.damageReductionFireProbability, template.getConfigurationSection("protection_fire"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateFloatProbabilityMap(this.damageReductionExplosionsProbability, template.getConfigurationSection("protection_explosions"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateIntegerProbabilityMap(this.xpRegenerationProbability, template.getConfigurationSection("xp_regeneration"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateIntegerProbabilityMap(this.xpMaxProbability, template.getConfigurationSection("xp_max"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateIntegerProbabilityMap(this.healthRegenerationProbability, template.getConfigurationSection("health_regeneration"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateIntegerProbabilityMap(this.hungerRegenerationProbability, template.getConfigurationSection("hunger_regeneration"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateFloatProbabilityMap(this.hasteProbability, template.getConfigurationSection("haste"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateFloatProbabilityMap(this.powerProbability, template.getConfigurationSection("power"), levelIndex, nextLevelIndex, distance);
    }

    public void add(WandLevel other) {
        this.spellProbability = RandomUtils.merge(this.spellProbability, other.spellProbability);
        this.materialProbability = RandomUtils.merge(this.materialProbability, other.materialProbability);
        this.materialCountProbability = this.materialCountProbability.isEmpty() ? other.materialCountProbability : this.materialCountProbability;
        this.spellCountProbability = this.spellCountProbability.isEmpty() ? other.spellCountProbability : this.spellCountProbability;
        this.useProbability = this.useProbability.isEmpty() ? other.useProbability : this.useProbability;
        this.addUseProbability = this.addUseProbability.isEmpty() ? other.addUseProbability : this.addUseProbability;
        this.propertyCountProbability = this.propertyCountProbability.isEmpty() ? other.propertyCountProbability : this.propertyCountProbability;
        this.costReductionProbability = this.costReductionProbability.isEmpty() ? other.costReductionProbability : this.costReductionProbability;
        this.powerProbability = this.powerProbability.isEmpty() ? other.powerProbability : this.powerProbability;
        this.damageReductionProbability = this.damageReductionProbability.isEmpty() ? other.damageReductionProbability : this.damageReductionProbability;
        this.damageReductionPhysicalProbability = this.damageReductionPhysicalProbability.isEmpty() ? other.damageReductionPhysicalProbability : this.damageReductionPhysicalProbability;
        this.damageReductionProjectilesProbability = this.damageReductionProjectilesProbability.isEmpty() ? other.damageReductionProjectilesProbability : this.damageReductionProjectilesProbability;
        this.damageReductionFallingProbability = this.damageReductionFallingProbability.isEmpty() ? other.damageReductionFallingProbability : this.damageReductionFallingProbability;
        this.damageReductionFireProbability = this.damageReductionFireProbability.isEmpty() ? other.damageReductionFireProbability : this.damageReductionFireProbability;
        this.damageReductionExplosionsProbability = this.damageReductionExplosionsProbability.isEmpty() ? other.damageReductionExplosionsProbability : this.damageReductionExplosionsProbability;
        this.xpRegenerationProbability = this.xpRegenerationProbability.isEmpty() ? other.xpRegenerationProbability : this.xpRegenerationProbability;
        this.xpMaxProbability = this.xpMaxProbability.isEmpty() ? other.xpMaxProbability : this.xpMaxProbability;
        this.healthRegenerationProbability = this.healthRegenerationProbability.isEmpty() ? other.healthRegenerationProbability : this.healthRegenerationProbability;
        this.hungerRegenerationProbability = this.hungerRegenerationProbability.isEmpty() ? other.hungerRegenerationProbability : this.hungerRegenerationProbability;
    }

    protected void sendAddMessage(Mage mage, String messageKey, String nameParam) {
        if (mage == null) {
            return;
        }
        String message = Messages.get(messageKey).replace("$name", nameParam);
        mage.sendMessage(message);
    }

    /*
     * WARNING - void declaration
     */
    public boolean randomizeWand(Mage mage, Wand wand, boolean additive) {
        void var14_31;
        boolean bl;
        if (mage == null) {
            mage = wand.getActivePlayer();
        }
        boolean addedSpells = false;
        LinkedList remainingSpells = new LinkedList();
        for (WeightedPair weightedPair : this.spellProbability) {
            if (wand.hasSpell((String)weightedPair.getValue())) continue;
            remainingSpells.add(weightedPair);
        }
        SpellTemplate firstSpell = null;
        if (remainingSpells.size() > 0) {
            Integer n = (Integer)RandomUtils.weightedRandom(this.spellCountProbability);
            for (int i = 0; n != null && i < n; ++i) {
                String spellKey = (String)RandomUtils.weightedRandom(remainingSpells);
                Spell currentSpell = wand.getBaseSpell(spellKey);
                if (!wand.addSpell(spellKey)) continue;
                SpellTemplate spell = wand.getMaster().getSpellTemplate(spellKey);
                if (mage != null && spell != null) {
                    if (currentSpell != null) {
                        String levelDescription = spell.getLevelDescription();
                        if (levelDescription == null || levelDescription.isEmpty()) {
                            levelDescription = spell.getName();
                        }
                        mage.sendMessage(Messages.get("wand.spell_upgraded").replace("$name", currentSpell.getName()).replace("$level", levelDescription));
                    } else {
                        mage.sendMessage(Messages.get("wand.spell_added").replace("$name", spell.getName()));
                    }
                }
                if (firstSpell == null) {
                    firstSpell = spell;
                }
                addedSpells = true;
            }
        }
        boolean bl2 = false;
        int maxXpCost = 0;
        Collection spells = wand.getSpells();
        for (String spellName : spells) {
            SpellTemplate spell = wand.getMaster().getSpellTemplate(spellName);
            if (spell == null) continue;
            boolean bl3 = bl = bl || spell instanceof BrushSpell && !((BrushSpell)spell).hasBrushOverride();
            Collection<CastingCost> costs = spell.getCosts();
            if (costs == null) continue;
            for (CastingCost cost : costs) {
                maxXpCost = Math.max(maxXpCost, cost.getXP());
            }
        }
        boolean addedMaterials = false;
        Collection wandMaterials = wand.getBrushes();
        LinkedList remainingMaterials = new LinkedList();
        for (WeightedPair weightedPair : this.materialProbability) {
            String materialKey = (String)weightedPair.getValue();
            materialKey = materialKey.replace("|", ":");
            if (wandMaterials.contains(weightedPair.getValue()) || !MaterialBrush.isValidMaterial(materialKey, false)) continue;
            remainingMaterials.add(weightedPair);
        }
        if (bl && remainingMaterials.size() > 0) {
            void var14_28;
            int currentMaterialCount = wand.getBrushes().size();
            Integer n = (Integer)RandomUtils.weightedRandom(this.materialCountProbability);
            if (n == null) {
                Integer n2 = 0;
            }
            if (currentMaterialCount == 0) {
                void var14_26;
                Integer n3 = Math.max(1, var14_26.intValue());
            }
            int retries = 100;
            for (int i = 0; i < var14_28.intValue(); ++i) {
                String materialKey = (String)RandomUtils.weightedRandom(remainingMaterials);
                if (!wand.addBrush(materialKey = materialKey.replace("|", ":"))) {
                    if (retries-- <= 0) continue;
                    --i;
                    continue;
                }
                addedMaterials = true;
                if (mage == null) continue;
                mage.sendMessage(Messages.get("wand.brush_added").replace("$name", MaterialAndData.getMaterialName(materialKey)));
            }
        }
        boolean addedProperties = false;
        Integer n = this.propertyCountProbability.size() == 0 ? 0 : (Integer)RandomUtils.weightedRandom(this.propertyCountProbability);
        MemoryConfiguration wandProperties = new MemoryConfiguration();
        double costReduction = wand.getCostReduction();
        while (var14_31 != null) {
            Integer n4;
            void var20_40 = var14_31;
            Integer n5 = n4 = Integer.valueOf(var14_31.intValue() - 1);
            if (var20_40.intValue() <= 0) break;
            int randomProperty = (int)(Math.random() * 11.0);
            switch (randomProperty) {
                case 0: {
                    if (this.costReductionProbability.size() <= 0 || !(costReduction < (double)this.path.getMaxCostReduction())) break;
                    addedProperties = true;
                    costReduction = Math.min((double)this.path.getMaxCostReduction(), costReduction + (double)((Float)RandomUtils.weightedRandom(this.costReductionProbability)).floatValue());
                    wandProperties.set("cost_reduction", (Object)costReduction);
                    this.sendAddMessage(mage, "wand.upgraded_property", Wand.getLevelString("wand.cost_reduction", (float)costReduction));
                    break;
                }
                case 1: {
                    double power = wand.getPower();
                    if (this.powerProbability.size() <= 0 || !(power < (double)this.path.getMaxPower())) break;
                    addedProperties = true;
                    power = Math.min((double)this.path.getMaxPower(), power + (double)((Float)RandomUtils.weightedRandom(this.powerProbability)).floatValue());
                    wandProperties.set("power", (Object)power);
                    this.sendAddMessage(mage, "wand.upgraded_property", Wand.getLevelString("wand.power", (float)power));
                    break;
                }
                case 2: {
                    double damageReduction = wand.getDamageReduction();
                    if (this.damageReductionProbability.size() <= 0 || !(damageReduction < (double)this.path.getMaxDamageReduction())) break;
                    addedProperties = true;
                    damageReduction = Math.min((double)this.path.getMaxDamageReduction(), damageReduction + (double)((Float)RandomUtils.weightedRandom(this.damageReductionProbability)).floatValue());
                    wandProperties.set("protection", (Object)damageReduction);
                    this.sendAddMessage(mage, "wand.upgraded_property", Wand.getLevelString("wand.protection", (float)damageReduction));
                    break;
                }
                case 3: {
                    double damageReductionPhysical = wand.getDamageReductionPhysical();
                    if (this.damageReductionPhysicalProbability.size() <= 0 || !(damageReductionPhysical < (double)this.path.getMaxDamageReductionPhysical())) break;
                    addedProperties = true;
                    damageReductionPhysical = Math.min((double)this.path.getMaxDamageReductionPhysical(), damageReductionPhysical + (double)((Float)RandomUtils.weightedRandom(this.damageReductionPhysicalProbability)).floatValue());
                    wandProperties.set("protection_physical", (Object)damageReductionPhysical);
                    this.sendAddMessage(mage, "wand.upgraded_property", Wand.getLevelString("wand.protection_physical", (float)damageReductionPhysical));
                    break;
                }
                case 4: {
                    double damageReductionProjectiles = wand.getDamageReductionProjectiles();
                    if (this.damageReductionProjectilesProbability.size() <= 0 || !(damageReductionProjectiles < (double)this.path.getMaxDamageReductionProjectiles())) break;
                    addedProperties = true;
                    damageReductionProjectiles = Math.min((double)this.path.getMaxDamageReductionProjectiles(), damageReductionProjectiles + (double)((Float)RandomUtils.weightedRandom(this.damageReductionProjectilesProbability)).floatValue());
                    wandProperties.set("protection_projectiles", (Object)damageReductionProjectiles);
                    this.sendAddMessage(mage, "wand.upgraded_property", Wand.getLevelString("wand.protection_projectile", (float)damageReductionProjectiles));
                    break;
                }
                case 5: {
                    double damageReductionFalling = wand.getDamageReductionFalling();
                    if (this.damageReductionFallingProbability.size() <= 0 || !(damageReductionFalling < (double)this.path.getMaxDamageReductionFalling())) break;
                    addedProperties = true;
                    damageReductionFalling = Math.min((double)this.path.getMaxDamageReductionFalling(), damageReductionFalling + (double)((Float)RandomUtils.weightedRandom(this.damageReductionFallingProbability)).floatValue());
                    wandProperties.set("protection_falling", (Object)damageReductionFalling);
                    this.sendAddMessage(mage, "wand.upgraded_property", Wand.getLevelString("wand.protection_fall", (float)damageReductionFalling));
                    break;
                }
                case 6: {
                    double damageReductionFire = wand.getDamageReductionFire();
                    if (this.damageReductionFireProbability.size() <= 0 || !(damageReductionFire < (double)this.path.getMaxDamageReductionFire())) break;
                    addedProperties = true;
                    damageReductionFire = Math.min((double)this.path.getMaxDamageReductionFire(), damageReductionFire + (double)((Float)RandomUtils.weightedRandom(this.damageReductionFireProbability)).floatValue());
                    wandProperties.set("protection_fire", (Object)damageReductionFire);
                    this.sendAddMessage(mage, "wand.upgraded_property", Wand.getLevelString("wand.protection_fire", (float)damageReductionFire));
                    break;
                }
                case 7: {
                    double damageReductionExplosions = wand.getDamageReductionExplosions();
                    if (this.damageReductionExplosionsProbability.size() <= 0 || !(damageReductionExplosions < (double)this.path.getMaxDamageReductionExplosions())) break;
                    addedProperties = true;
                    damageReductionExplosions = Math.min((double)this.path.getMaxDamageReductionExplosions(), damageReductionExplosions + (double)((Float)RandomUtils.weightedRandom(this.damageReductionExplosionsProbability)).floatValue());
                    wandProperties.set("protection_explosions", (Object)damageReductionExplosions);
                    this.sendAddMessage(mage, "wand.upgraded_property", Wand.getLevelString("wand.protection_blast", (float)damageReductionExplosions));
                    break;
                }
                case 8: {
                    double healthRegeneration = wand.getHealthRegeneration();
                    if (this.healthRegenerationProbability.size() <= 0 || !(healthRegeneration < (double)this.path.getMaxHealthRegeneration())) break;
                    addedProperties = true;
                    healthRegeneration = Math.min((double)this.path.getMaxHealthRegeneration(), healthRegeneration + (double)((Integer)RandomUtils.weightedRandom(this.healthRegenerationProbability)).intValue());
                    wandProperties.set("health_regeneration", (Object)healthRegeneration);
                    this.sendAddMessage(mage, "wand.upgraded_property", Wand.getLevelString("wand.health_regeneration", (float)healthRegeneration));
                    break;
                }
                case 9: {
                    double hungerRegeneration = wand.getHungerRegeneration();
                    if (this.hungerRegenerationProbability.size() <= 0 || !(hungerRegeneration < (double)this.path.getMaxHungerRegeneration())) break;
                    addedProperties = true;
                    hungerRegeneration = Math.min((double)this.path.getMaxHungerRegeneration(), hungerRegeneration + (double)((Integer)RandomUtils.weightedRandom(this.hungerRegenerationProbability)).intValue());
                    wandProperties.set("hunger_regeneration", (Object)hungerRegeneration);
                    this.sendAddMessage(mage, "wand.upgraded_property", Wand.getLevelString("wand.hunger_regeneration", (float)hungerRegeneration));
                    break;
                }
                case 10: {
                    double haste = wand.getHaste();
                    if (this.hasteProbability.size() <= 0 || !(haste < (double)this.path.getMaxHaste())) break;
                    addedProperties = true;
                    haste = Math.min((double)this.path.getMaxHaste(), haste + (double)((Float)RandomUtils.weightedRandom(this.hasteProbability)).floatValue());
                    wandProperties.set("haste", (Object)haste);
                    this.sendAddMessage(mage, "wand.upgraded_property", Wand.getLevelString("wand.haste", (float)haste));
                }
            }
        }
        if (costReduction > 1.0) {
            wandProperties.set("xp_regeneration", (Object)0);
            wandProperties.set("xp_max", (Object)0);
            wandProperties.set("xp", (Object)0);
        } else {
            int xpRegeneration = wand.getXpRegeneration();
            if (this.xpRegenerationProbability.size() > 0 && xpRegeneration < this.path.getMaxXpRegeneration()) {
                addedProperties = true;
                xpRegeneration = Math.min(this.path.getMaxXpRegeneration(), xpRegeneration + (Integer)RandomUtils.weightedRandom(this.xpRegenerationProbability));
                wandProperties.set("xp_regeneration", (Object)xpRegeneration);
                String updateString = Messages.get("wand.mana_regeneration");
                updateString = updateString.replace("$amount", Integer.toString(xpRegeneration));
                this.sendAddMessage(mage, "wand.upgraded_property", updateString);
            }
            int xpMax = wand.getXpMax();
            if (this.xpMaxProbability.size() > 0 && xpMax < this.path.getMaxMaxXp()) {
                xpMax = Math.min(this.path.getMaxMaxXp(), xpMax + (Integer)RandomUtils.weightedRandom(this.xpMaxProbability));
                if (this.path.getMatchSpellMana()) {
                    xpMax = Math.max(maxXpCost, xpMax);
                }
                wandProperties.set("xp_max", (Object)xpMax);
                addedProperties = true;
                String updateString = Messages.get("wand.mana_amount");
                updateString = updateString.replace("$amount", Integer.toString(xpMax));
                this.sendAddMessage(mage, "wand.upgraded_property", updateString);
            }
            wandProperties.set("xp", (Object)xpMax);
        }
        if (additive) {
            int wandUses = wand.getUses();
            if (wandUses > 0 && wandUses < this.path.getMaxUses() && this.addUseProbability.size() > 0) {
                wandProperties.set("uses", (Object)Math.min(this.path.getMaxUses(), wandUses + (Integer)RandomUtils.weightedRandom(this.addUseProbability)));
                addedProperties = true;
            }
        } else if (this.useProbability.size() > 0) {
            wandProperties.set("uses", (Object)Math.min(this.path.getMaxUses(), (Integer)RandomUtils.weightedRandom(this.useProbability)));
        }
        wand.loadProperties((ConfigurationSection)wandProperties);
        return addedMaterials || addedSpells || addedProperties;
    }
}

