/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell.builtin;

import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.spell.TargetType;
import com.elmakers.mine.bukkit.spell.TargetingSpell;
import com.elmakers.mine.bukkit.utility.Target;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class CommandSpell
extends TargetingSpell {
    public static final String[] PARAMETERS = new String[]{"command", "console", "op"};

    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        ConsoleCommandSender sender;
        ArrayList<String> commands = null;
        if (parameters.contains("command")) {
            String command = parameters.getString("command");
            if (command != null && command.length() > 0) {
                commands = new ArrayList<String>();
                commands.add(command);
            }
        } else {
            commands = parameters.getStringList("commands");
        }
        if (commands == null || commands.size() == 0) {
            return SpellResult.FAIL;
        }
        boolean asConsole = parameters.getBoolean("console", false);
        Object object = sender = asConsole ? Bukkit.getConsoleSender() : this.mage.getCommandSender();
        if (sender == null) {
            return SpellResult.FAIL;
        }
        boolean opPlayer = parameters.getBoolean("op", false);
        boolean isOp = sender.isOp();
        if (opPlayer && !isOp) {
            sender.setOp(true);
        }
        Location location = this.getLocation();
        Target target = null;
        Location targetLocation = null;
        if (this.getTargetType() != TargetType.NONE && (targetLocation = (target = this.getTarget()).getLocation()) == null) {
            return SpellResult.NO_TARGET;
        }
        for (String command : commands) {
            command = command.replace("@_", " ").replace("@spell", this.getName()).replace("@pd", this.mage.getDisplayName()).replace("@p", this.mage.getName()).replace("@uuid", this.mage.getId()).replace("@world", location.getWorld().getName()).replace("@x", Double.toString(location.getX())).replace("@y", Double.toString(location.getY())).replace("@z", Double.toString(location.getZ()));
            if (targetLocation != null) {
                command = command.replace("@tworld", targetLocation.getWorld().getName()).replace("@tx", Double.toString(targetLocation.getX())).replace("@ty", Double.toString(targetLocation.getY())).replace("@tz", Double.toString(targetLocation.getZ()));
                if (target.hasEntity()) {
                    Entity targetEntity = target.getEntity();
                    if (this.controller.isMage(targetEntity)) {
                        Mage targetMage = this.controller.getMage(targetEntity);
                        command = command.replace("@td", targetMage.getDisplayName()).replace("@t", targetMage.getName()).replace("@tuuid", targetMage.getId());
                    } else {
                        command = command.replace("@td", this.controller.getEntityDisplayName(targetEntity)).replace("@t", this.controller.getEntityName(targetEntity)).replace("@tuuid", targetEntity.getUniqueId().toString());
                    }
                } else {
                    return SpellResult.NO_TARGET;
                }
            }
            if (command.contains("@a")) {
                Player[] players;
                Player exclude = this.mage.getPlayer();
                if (parameters.getBoolean("excludePlayer", true)) {
                    exclude = null;
                }
                for (Player player : players = Bukkit.getOnlinePlayers()) {
                    if (exclude != null && exclude.equals(player)) continue;
                    String playerCommand = command;
                    playerCommand = playerCommand.replace("@a", player.getName());
                    this.controller.getPlugin().getServer().dispatchCommand((CommandSender)sender, playerCommand);
                }
                continue;
            }
            this.controller.getPlugin().getServer().dispatchCommand((CommandSender)sender, command);
        }
        if (opPlayer && !isOp) {
            sender.setOp(false);
        }
        return SpellResult.CAST;
    }

    @Override
    public void getParameters(Collection<String> parameters) {
        super.getParameters(parameters);
        parameters.addAll(Arrays.asList(PARAMETERS));
    }

    @Override
    public void getParameterOptions(Collection<String> examples, String parameterKey) {
        super.getParameterOptions(examples, parameterKey);
        if (parameterKey.equals("command")) {
            examples.add("spawn");
            examples.add("clear");
        } else if (parameterKey.equals("console")) {
            examples.addAll(Arrays.asList(EXAMPLE_BOOLEANS));
        } else if (parameterKey.equals("op")) {
            examples.addAll(Arrays.asList(EXAMPLE_BOOLEANS));
        }
    }
}

