/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell;

import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.spell.CostReducer;
import com.elmakers.mine.bukkit.api.spell.MageSpell;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.utility.Messages;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class CastingCost
implements com.elmakers.mine.bukkit.api.spell.CastingCost {
    protected MaterialAndData item;
    protected int amount;
    protected int xp;
    protected int mana;

    public CastingCost(String key, int cost) {
        if (key.toLowerCase().equals("xp")) {
            this.xp = cost;
        } else if (key.toLowerCase().equals("mana")) {
            this.mana = cost;
        } else {
            this.item = new MaterialAndData(key);
            this.amount = cost;
        }
    }

    public CastingCost(Material item, int amount) {
        this.item = new MaterialAndData(item, 0);
        this.amount = amount;
    }

    public CastingCost(Material item, byte data, int amount) {
        this.item = new MaterialAndData(item, data);
        this.amount = amount;
    }

    @Override
    public MaterialAndData getMaterial() {
        return this.item;
    }

    public Map<String, Object> export() {
        HashMap<String, Object> cost = new HashMap<String, Object>();
        cost.put("material", this.item.getName());
        cost.put("amount", this.amount);
        cost.put("xp", this.xp);
        cost.put("mana", this.mana);
        return cost;
    }

    public boolean has(Spell spell) {
        if (!(spell instanceof MageSpell)) {
            return false;
        }
        Mage mage = ((MageSpell)spell).getMage();
        Inventory inventory = mage.getInventory();
        int amount = this.getAmount(spell);
        boolean hasItem = this.item == null || amount <= 0 || inventory.containsAtLeast(this.item.getItemStack(amount), amount);
        boolean hasXp = this.xp <= 0 || mage.getExperience() >= this.getXP(spell);
        boolean hasMana = this.mana <= 0 || mage.getMana() >= this.getMana(spell);
        return hasItem && hasXp && hasMana;
    }

    public void use(Spell spell) {
        int mana;
        int xp;
        if (!(spell instanceof MageSpell)) {
            return;
        }
        Mage mage = ((MageSpell)spell).getMage();
        Inventory inventory = mage.getInventory();
        int amount = this.getAmount(spell);
        if (this.item != null && amount > 0) {
            ItemStack itemStack = this.getItemStack(spell);
            inventory.removeItem(new ItemStack[]{itemStack});
        }
        if ((xp = this.getXP(spell)) > 0) {
            mage.removeExperience(xp);
        }
        if ((mana = this.getMana(spell)) > 0) {
            mage.removeMana(mana);
        }
    }

    protected ItemStack getItemStack() {
        return this.item.getItemStack(this.getAmount());
    }

    protected ItemStack getItemStack(CostReducer reducer) {
        return this.item.getItemStack(this.getAmount(reducer));
    }

    @Override
    public int getAmount() {
        return this.amount;
    }

    @Override
    public int getXP() {
        return this.xp;
    }

    @Override
    public int getMana() {
        return this.mana;
    }

    @Override
    public int getAmount(CostReducer reducer) {
        return this.getReducedCost(this.amount, reducer);
    }

    @Override
    public int getXP(CostReducer reducer) {
        return this.getReducedCost(this.xp, reducer);
    }

    @Override
    public int getMana(CostReducer reducer) {
        return this.getReducedCost(this.mana, reducer);
    }

    protected int getReducedCost(int cost, CostReducer reducer) {
        float reduction;
        float reducedAmount = cost;
        float f = reduction = reducer == null ? 0.0f : reducer.getCostReduction();
        if (reduction > 0.0f) {
            reducedAmount = (1.0f - reduction) * reducedAmount;
        }
        return (int)Math.ceil(reducedAmount);
    }

    @Override
    public boolean hasCosts(CostReducer reducer) {
        return this.item != null && this.getAmount(reducer) > 0 || this.getXP(reducer) > 0 || this.getMana(reducer) > 0;
    }

    @Override
    public String getDescription(CostReducer reducer) {
        if (this.item != null && this.getAmount() != 0) {
            return this.item.getName();
        }
        if (reducer != null && !reducer.usesMana()) {
            return Messages.get("costs.xp");
        }
        return Messages.get("costs.mana");
    }

    @Override
    public String getFullDescription(CostReducer reducer) {
        if (this.item != null) {
            return this.getAmount(reducer) + " " + this.item.getName();
        }
        if (reducer != null && !reducer.usesMana()) {
            return Messages.get("costs.xp_amount").replace("$amount", Integer.valueOf(this.getXP(reducer)).toString());
        }
        return Messages.get("costs.mana_amount").replace("$amount", Integer.valueOf(this.getMana(reducer)).toString());
    }
}

