/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.protection;

import java.lang.reflect.Method;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class FactionsManager {
    private boolean enabled = false;
    private Class<?> factionsManager = null;
    private Method factionsCanBuildMethod = null;
    private Method psFactoryMethod = null;

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled && this.factionsManager != null;
    }

    public void initialize(Plugin plugin) {
        if (this.enabled) {
            try {
                Class<?> psClass = Class.forName("com.massivecraft.mcore.ps.PS");
                this.factionsManager = Class.forName("com.massivecraft.factions.listeners.FactionsListenerMain");
                this.factionsCanBuildMethod = this.factionsManager.getMethod("canPlayerBuildAt", Player.class, psClass, Boolean.TYPE);
                this.psFactoryMethod = psClass.getMethod("valueOf", Location.class);
                if (this.factionsManager != null && this.factionsCanBuildMethod != null && this.psFactoryMethod != null) {
                    plugin.getLogger().info("Factions found, build permissions will be respected.");
                } else {
                    this.factionsManager = null;
                    this.factionsCanBuildMethod = null;
                    this.psFactoryMethod = null;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.factionsManager == null) {
                plugin.getLogger().info("Factions not found, will not integrate.");
            }
        } else {
            plugin.getLogger().info("Factions integration disabled");
        }
    }

    public boolean hasBuildPermission(Player player, Block block) {
        if (this.enabled && block != null && this.factionsManager != null && this.factionsCanBuildMethod != null && this.psFactoryMethod != null) {
            if (player == null) {
                return false;
            }
            try {
                Object loc = this.psFactoryMethod.invoke(null, block.getLocation());
                return loc != null && (Boolean)this.factionsCanBuildMethod.invoke(null, player, loc, false) != false;
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                return false;
            }
        }
        return true;
    }
}

