/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.block;

import com.elmakers.mine.bukkit.api.block.BlockData;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.block.BlockList;
import com.elmakers.mine.bukkit.block.UndoQueue;
import com.elmakers.mine.bukkit.block.batch.UndoBatch;
import com.elmakers.mine.bukkit.entity.EntityData;
import com.elmakers.mine.bukkit.spell.UndoableSpell;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class UndoList
extends BlockList
implements com.elmakers.mine.bukkit.api.block.UndoList {
    protected static Map<Long, BlockData> modified = new HashMap<Long, BlockData>();
    protected Set<UUID> entities;
    protected List<Runnable> runnables;
    protected HashMap<UUID, EntityData> modifiedEntities;
    protected final Mage owner;
    protected final Plugin plugin;
    protected boolean undone = false;
    protected int timeToLive = 0;
    protected boolean applyPhysics = false;
    protected boolean bypass = false;
    protected final long createdTime;
    protected long modifiedTime;
    protected long scheduledTime;
    protected final UndoableSpell spell;
    protected UndoQueue undoQueue;
    protected UndoList next;
    protected UndoList previous;
    protected String name;
    private boolean undoEntityEffects = true;

    public UndoList(Mage mage, UndoableSpell spell, String name) {
        this(mage, spell);
        this.name = name;
    }

    public UndoList(Mage mage, UndoableSpell spell) {
        this.owner = mage;
        this.spell = spell;
        this.plugin = this.owner.getController().getPlugin();
        this.modifiedTime = this.createdTime = System.currentTimeMillis();
    }

    @Override
    public int size() {
        return (this.blockList == null ? 0 : this.blockList.size()) + (this.entities == null ? 0 : this.entities.size()) + (this.runnables == null ? 0 : this.runnables.size());
    }

    @Override
    public boolean isEmpty() {
        return !(this.blockList != null && !this.blockList.isEmpty() || this.entities != null && !this.entities.isEmpty() || this.runnables != null && !this.runnables.isEmpty());
    }

    public boolean isComplete() {
        return this.undone;
    }

    @Override
    public void setScheduleUndo(int ttl) {
        this.timeToLive = ttl;
        this.scheduledTime = System.currentTimeMillis() + (long)this.timeToLive;
    }

    @Override
    public int getScheduledUndo() {
        return this.timeToLive;
    }

    @Override
    public boolean add(BlockData blockData) {
        if (!super.add(blockData)) {
            return false;
        }
        this.modifiedTime = System.currentTimeMillis();
        if (this.bypass) {
            return true;
        }
        BlockData priorState = modified.get(blockData.getId());
        if (priorState != null) {
            priorState.setNextState(blockData);
            blockData.setPriorState(priorState);
        }
        modified.put(blockData.getId(), blockData);
        return true;
    }

    @Override
    public void commit() {
        this.unlink();
        if (this.blockList == null) {
            return;
        }
        for (BlockData block : this.blockList) {
            BlockData currentState = modified.get(block.getId());
            if (currentState == block) {
                modified.remove(block.getId());
            }
            block.commit();
        }
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof BlockData) {
            BlockData block = (BlockData)o;
            UndoList.removeFromModified(block);
        }
        return super.remove(o);
    }

    protected static void removeFromModified(BlockData block) {
        BlockData currentState = modified.get(block.getId());
        if (currentState == block) {
            BlockData priorState = block.getPriorState();
            if (priorState == null) {
                modified.remove(block.getId());
            } else {
                modified.put(block.getId(), priorState);
            }
        }
    }

    public static boolean undo(BlockData undoBlock, boolean applyPhysics) {
        if (undoBlock.undo(applyPhysics)) {
            UndoList.removeFromModified(undoBlock);
            return true;
        }
        return false;
    }

    public void undoEntityEffects() {
        if (this.entities != null || this.modifiedEntities != null) {
            World world;
            HashMap<UUID, Entity> currentEntities = new HashMap<UUID, Entity>();
            World world2 = world = this.worldName != null && this.worldName.length() > 0 ? Bukkit.getWorld((String)this.worldName) : null;
            if (world != null) {
                List entities = world.getEntities();
                for (Entity entity : entities) {
                    currentEntities.put(entity.getUniqueId(), entity);
                }
            }
            if (this.entities != null) {
                for (UUID uUID : this.entities) {
                    Entity entity;
                    entity = (Entity)currentEntities.get(uUID);
                    if (entity == null || !entity.isValid()) continue;
                    entity.remove();
                }
                this.entities = null;
            }
            if (this.modifiedEntities != null) {
                for (Map.Entry entry : this.modifiedEntities.entrySet()) {
                    EntityData data = (EntityData)entry.getValue();
                    if (!this.undoEntityEffects && !data.isHanging() && !data.isProjectile()) continue;
                    Entity entity = (Entity)currentEntities.get(entry.getKey());
                    if (entity == null) {
                        data.spawn();
                        continue;
                    }
                    data.modify(entity);
                }
                this.modifiedEntities = null;
            }
        }
    }

    @Override
    public void undo() {
        this.undo(false);
    }

    @Override
    public void undo(boolean blocking) {
        this.undo(blocking, true);
    }

    @Override
    public void undoScheduled(boolean blocking) {
        this.undo(blocking, false);
    }

    @Override
    public void undoScheduled() {
        this.undoScheduled(false);
    }

    public void undo(boolean blocking, boolean undoEntities) {
        this.undoEntityEffects = this.undoEntityEffects || undoEntities;
        this.unlink();
        if (this.isComplete()) {
            return;
        }
        this.undone = true;
        if (this.spell != null) {
            this.spell.cancelEffects();
        }
        if (this.runnables != null) {
            for (Runnable runnable : this.runnables) {
                runnable.run();
            }
            this.runnables = null;
        }
        if (this.blockList == null) {
            this.undoEntityEffects();
            return;
        }
        UndoBatch batch = new UndoBatch(this);
        if (blocking) {
            while (!batch.isFinished()) {
                batch.process(1000);
            }
        } else {
            this.owner.addUndoBatch(batch);
        }
        this.blockList = null;
    }

    @Override
    public void load(ConfigurationSection node) {
        super.load(node);
        this.timeToLive = node.getInt("time_to_live", this.timeToLive);
        this.name = node.getString("name", this.name);
        this.applyPhysics = node.getBoolean("apply_physics", this.applyPhysics);
    }

    @Override
    public void save(ConfigurationSection node) {
        super.save(node);
        node.set("time_to_live", (Object)this.timeToLive);
        node.set("name", (Object)this.name);
        node.set("apply_physics", (Object)this.applyPhysics);
    }

    public void watch(Entity entity) {
        if (entity == null) {
            return;
        }
        if (this.worldName != null && !entity.getWorld().getName().equals(this.worldName)) {
            return;
        }
        if (this.worldName == null) {
            this.worldName = entity.getWorld().getName();
        }
        entity.setMetadata("MagicBlockList", (MetadataValue)new FixedMetadataValue(this.plugin, (Object)this));
        this.modifiedTime = System.currentTimeMillis();
    }

    @Override
    public void add(Entity entity) {
        if (entity == null) {
            return;
        }
        if (this.entities == null) {
            this.entities = new HashSet<UUID>();
        }
        if (this.worldName != null && !entity.getWorld().getName().equals(this.worldName)) {
            return;
        }
        this.entities.add(entity.getUniqueId());
        this.watch(entity);
        this.contain(entity.getLocation().toVector());
        this.modifiedTime = System.currentTimeMillis();
    }

    @Override
    public void add(Runnable runnable) {
        if (runnable == null) {
            return;
        }
        if (this.runnables == null) {
            this.runnables = new LinkedList<Runnable>();
        }
        this.runnables.add(runnable);
        this.modifiedTime = System.currentTimeMillis();
    }

    @Override
    public EntityData modify(Entity entity) {
        EntityData entityData = null;
        if (entity == null) {
            return entityData;
        }
        if (this.worldName != null && !entity.getWorld().getName().equals(this.worldName)) {
            return entityData;
        }
        if (this.worldName == null) {
            this.worldName = entity.getWorld().getName();
        }
        if (this.entities != null && this.entities.contains(entity) && !entity.isValid()) {
            this.entities.remove(entity);
        } else {
            if (this.modifiedEntities == null) {
                this.modifiedEntities = new HashMap();
            }
            if ((entityData = this.modifiedEntities.get(entity)) == null) {
                entityData = new EntityData(entity);
                this.modifiedEntities.put(entity.getUniqueId(), entityData);
            }
        }
        this.modifiedTime = System.currentTimeMillis();
        return entityData;
    }

    public void move(Entity entity) {
        EntityData entityData = this.modify(entity);
        if (entityData != null) {
            entityData.setHasMoved(true);
        }
    }

    public void modifyVelocity(Entity entity) {
        EntityData entityData = this.modify(entity);
        if (entityData != null) {
            entityData.setHasVelocity(true);
        }
    }

    public void addPotionEffects(Entity entity) {
        EntityData entityData = this.modify(entity);
        if (entityData != null) {
            entityData.setHasPotionEffects(true);
        }
    }

    @Override
    public void remove(Entity entity) {
        if (this.entities != null && this.entities.contains(entity)) {
            this.entities.remove(entity);
        }
        if (this.modifiedEntities != null && this.modifiedEntities.containsKey(entity)) {
            this.entities.remove(entity);
        }
        this.modifiedTime = System.currentTimeMillis();
    }

    @Override
    public void convert(Entity fallingBlock, Block block) {
        if (this.entities != null) {
            this.entities.remove(fallingBlock);
        }
        this.add(block);
        this.modifiedTime = System.currentTimeMillis();
    }

    @Override
    public void fall(Entity fallingBlock, Block block) {
        this.add(fallingBlock);
        this.add(block);
        this.modifiedTime = System.currentTimeMillis();
    }

    @Override
    public void explode(Entity explodingEntity, List<Block> blocks) {
        if (this.entities != null) {
            this.entities.remove(explodingEntity);
        }
        for (Block block : blocks) {
            this.add(block);
        }
        this.modifiedTime = System.currentTimeMillis();
    }

    @Override
    public void cancelExplosion(Entity explodingEntity) {
        if (this.entities != null) {
            this.entities.remove(explodingEntity);
            this.modifiedTime = System.currentTimeMillis();
        }
    }

    @Override
    public boolean bypass() {
        return this.bypass;
    }

    public void setBypass(boolean bypass) {
        this.bypass = bypass;
    }

    @Override
    public long getCreatedTime() {
        return this.createdTime;
    }

    @Override
    public long getModifiedTime() {
        return this.modifiedTime;
    }

    @Override
    public boolean contains(Location location, int threshold) {
        if (location == null || this.area == null || this.worldName == null) {
            return false;
        }
        if (!location.getWorld().getName().equals(this.worldName)) {
            return false;
        }
        return this.area.contains(location.toVector(), threshold);
    }

    @Override
    public void prune() {
        if (this.blockList == null) {
            return;
        }
        ArrayList current = new ArrayList(this.blockList);
        this.blockList = null;
        this.blockIdMap = null;
        for (BlockData block : current) {
            if (block.isDifferent()) {
                super.add(block);
                continue;
            }
            UndoList.removeFromModified(block);
            block.unlink();
        }
        this.modifiedTime = System.currentTimeMillis();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public UndoableSpell getSpell() {
        return this.spell;
    }

    @Override
    public Mage getOwner() {
        return this.owner;
    }

    @Override
    public long getScheduledTime() {
        return this.scheduledTime;
    }

    @Override
    public boolean isScheduled() {
        return this.timeToLive > 0;
    }

    @Override
    public int compareTo(com.elmakers.mine.bukkit.api.block.UndoList o) {
        return (int)(this.scheduledTime - o.getScheduledTime());
    }

    @Override
    public void setEntityUndo(boolean undoEntityEffects) {
        this.undoEntityEffects = undoEntityEffects;
    }

    public void setNext(UndoList next) {
        this.next = next;
    }

    public void setPrevious(UndoList previous) {
        this.previous = previous;
    }

    public void setUndoQueue(com.elmakers.mine.bukkit.api.block.UndoQueue undoQueue) {
        if (undoQueue != null && undoQueue instanceof UndoQueue) {
            this.undoQueue = (UndoQueue)undoQueue;
        }
    }

    public boolean hasUndoQueue() {
        return this.undoQueue != null;
    }

    public void unlink() {
        if (this.undoQueue != null) {
            this.undoQueue.removed(this);
            this.undoQueue = null;
        }
        if (this.next != null) {
            this.next.previous = this.previous;
        }
        if (this.previous != null) {
            this.previous.next = this.next;
        }
        this.previous = null;
        this.next = null;
    }

    public UndoList getNext() {
        return this.next;
    }

    public UndoList getPrevious() {
        return this.previous;
    }

    public void setApplyPhysics(boolean applyPhysics) {
        this.applyPhysics = applyPhysics;
    }

    public boolean getApplyPhysics() {
        return this.applyPhysics;
    }
}

