/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility;

import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.NMSUtils;
import java.lang.reflect.Method;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class InventoryUtils
extends NMSUtils {
    public static boolean saveTagsToNBT(ConfigurationSection tags, Object node, String[] tagNames) {
        if (node == null) {
            Bukkit.getLogger().warning("Tring to save tags to a null node");
            return false;
        }
        if (!class_NBTTagCompound.isAssignableFrom(node.getClass())) {
            Bukkit.getLogger().warning("Tring to save tags to a non-CompoundTag");
            return false;
        }
        for (String tagName : tagNames) {
            String value = tags.getString(tagName);
            if (value == null || value.length() == 0 || value.equals("0") || value.equals("0.0") || value.equals("false")) {
                InventoryUtils.removeMeta(node, tagName);
                continue;
            }
            InventoryUtils.setMeta(node, tagName, value);
        }
        return true;
    }

    public static boolean loadTagsFromNBT(ConfigurationSection tags, Object node, String[] tagNames) {
        if (node == null) {
            Bukkit.getLogger().warning("Tring to load tags from a null node");
            return false;
        }
        if (!class_NBTTagCompound.isAssignableFrom(node.getClass())) {
            Bukkit.getLogger().warning("Tring to load tags from a non-CompoundTag");
            return false;
        }
        for (String tagName : tagNames) {
            String meta = InventoryUtils.getMeta(node, tagName);
            if (meta == null || meta.length() <= 0) continue;
            ConfigurationUtils.set(tags, tagName, meta);
        }
        return true;
    }

    public static boolean inventorySetItem(Inventory inventory, int index, ItemStack item) {
        try {
            Method setItemMethod = class_CraftInventoryCustom.getMethod("setItem", Integer.TYPE, ItemStack.class);
            setItemMethod.invoke((Object)inventory, index, item);
            return true;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static boolean setInventoryResults(Inventory inventory, ItemStack item) {
        try {
            Method getResultsMethod = inventory.getClass().getMethod("getResultInventory", new Class[0]);
            Object inv = getResultsMethod.invoke((Object)inventory, new Object[0]);
            Method setItemMethod = inv.getClass().getMethod("setItem", Integer.TYPE, class_ItemStack);
            setItemMethod.invoke(inv, 0, InventoryUtils.getHandle(item));
            return true;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return false;
        }
    }
}

