/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell.builtin;

import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.wand.LostWand;
import com.elmakers.mine.bukkit.spell.UndoableSpell;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.Target;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class RecallSpell
extends UndoableSpell {
    public Location location;
    private static int MAX_RETRY_COUNT = 8;
    private static int RETRY_INTERVAL = 10;
    private int retryCount = 0;
    private boolean allowCrossWorld = true;
    private int selectedIndex = 0;
    private List<String> warps = new ArrayList<String>();
    private RecallType selectedType = RecallType.MARKER;
    private int selectedTypeIndex = 0;
    private List<RecallType> enabledTypes = new ArrayList<RecallType>();
    private String castMessage;
    private String failMessage;

    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        boolean allowMarker = true;
        this.selectedTypeIndex = 0;
        int cycleRetries = 5;
        this.enabledTypes.clear();
        this.warps = null;
        Player player = this.mage.getPlayer();
        if (player == null) {
            return SpellResult.PLAYER_REQUIRED;
        }
        this.allowCrossWorld = parameters.getBoolean("cross_world", true);
        for (RecallType testType : RecallType.values()) {
            if (testType == RecallType.WARP) {
                if (!parameters.contains("allow_warps")) continue;
                this.warps = ConfigurationUtils.getStringList(parameters, "allow_warps");
                this.enabledTypes.add(testType);
                if (testType != this.selectedType) continue;
                this.selectedTypeIndex = this.enabledTypes.size() - 1;
                continue;
            }
            if (parameters.getBoolean("allow_" + testType.name().toLowerCase(), true)) {
                this.enabledTypes.add(testType);
                if (testType != this.selectedType) continue;
                this.selectedTypeIndex = this.enabledTypes.size() - 1;
                continue;
            }
            if (testType != RecallType.MARKER) continue;
            allowMarker = false;
        }
        boolean reverseDirection = false;
        if (parameters.contains("warp")) {
            this.selectedType = RecallType.WARP;
            String warpName = parameters.getString("warp");
            this.castMessage = this.getMessage("cast_warp").replace("$name", warpName);
            Location location = this.controller.getWarp(warpName);
            if (this.tryTeleport(player, location)) {
                this.registerForUndo();
                return SpellResult.CAST;
            }
            return SpellResult.FAIL;
        }
        if (parameters.contains("type")) {
            cycleRetries = 0;
            String typeString = parameters.getString("type", "");
            if (this.location != null && typeString.equalsIgnoreCase("remove")) {
                this.removeMarker();
                return SpellResult.TARGET_SELECTED;
            }
            RecallType newType = RecallType.valueOf(typeString.toUpperCase());
            if (newType == null) {
                this.controller.getLogger().warning("Unknown recall type " + typeString);
                return SpellResult.FAIL;
            }
            this.selectedType = newType;
            Location location = this.getTargetLocation(player, this.selectedType, 0);
            if (this.tryTeleport(player, location)) {
                this.registerForUndo();
                return SpellResult.CAST;
            }
            return SpellResult.FAIL;
        }
        if (this.isLookingDown() && allowMarker) {
            if (allowMarker) {
                if (this.placeMarker(this.getLocation().getBlock())) {
                    this.registerForUndo();
                    return SpellResult.CAST;
                }
                return SpellResult.FAIL;
            }
            reverseDirection = true;
            this.cycleTarget(reverseDirection);
        } else if (this.isLookingUp()) {
            reverseDirection = false;
            this.cycleTarget(reverseDirection);
        } else {
            Location location = this.getLocation();
            LinkedList<Target> allWaypoints = new LinkedList<Target>();
            for (RecallType selectedType : this.enabledTypes) {
                Location targetLocation;
                if (selectedType == RecallType.WARP) {
                    for (int i = 0; i < this.warps.size(); ++i) {
                        Location targetLocation2;
                        if (selectedType == this.selectedType && i == this.selectedIndex || (targetLocation2 = this.getTargetLocation(player, selectedType, i)) == null || !targetLocation2.getWorld().equals(location.getWorld())) continue;
                        Target target = new Target(location, targetLocation2.getBlock(), 0, Math.PI);
                        target.setExtraData(new Waypoint(selectedType, i));
                        allWaypoints.add(target);
                    }
                    continue;
                }
                if (selectedType == RecallType.WAND) {
                    List<LostWand> lostWands = this.mage.getLostWands();
                    for (int i = 0; i < lostWands.size(); ++i) {
                        Location targetLocation3;
                        if (selectedType == this.selectedType && i == this.selectedIndex || (targetLocation3 = this.getTargetLocation(player, selectedType, i)) == null || !targetLocation3.getWorld().equals(location.getWorld())) continue;
                        Target target = new Target(location, targetLocation3.getBlock(), 0, Math.PI);
                        target.setExtraData(new Waypoint(selectedType, i));
                        allWaypoints.add(target);
                    }
                    continue;
                }
                if (selectedType == this.selectedType || (targetLocation = this.getTargetLocation(player, selectedType, 0)) == null || !targetLocation.getWorld().equals(location.getWorld())) continue;
                Target target = new Target(location, targetLocation.getBlock(), 0, Math.PI);
                target.setExtraData(new Waypoint(selectedType, 0));
                allWaypoints.add(target);
            }
            if (allWaypoints.size() == 0) {
                return SpellResult.NO_TARGET;
            }
            Collections.sort(allWaypoints);
            Target targetWaypoint = (Target)allWaypoints.get(0);
            Waypoint waypoint = (Waypoint)targetWaypoint.getExtraData();
            this.selectedType = waypoint.type;
            this.selectedIndex = waypoint.index;
            if (this.tryCurrentType(player)) {
                this.registerForUndo();
                return SpellResult.CAST;
            }
            return SpellResult.FAIL;
        }
        if (this.selectedType == null) {
            if (this.enabledTypes.size() == 0) {
                return SpellResult.FAIL;
            }
            this.selectedType = this.enabledTypes.get(0);
        }
        boolean success = false;
        while (!success && cycleRetries >= 0) {
            success = this.tryCurrentType(player);
            if (!success && cycleRetries > 0) {
                this.cycleTarget(reverseDirection);
            }
            --cycleRetries;
        }
        if (!success) {
            this.sendMessage(this.failMessage);
            return SpellResult.FAIL;
        }
        this.registerForUndo();
        return SpellResult.CAST;
    }

    protected void cycleTargetType(boolean reverse) {
        this.selectedTypeIndex = reverse ? --this.selectedTypeIndex : ++this.selectedTypeIndex;
        if (this.selectedTypeIndex < 0) {
            this.selectedTypeIndex = this.enabledTypes.size() - 1;
        }
        if (this.selectedTypeIndex >= this.enabledTypes.size()) {
            this.selectedTypeIndex = 0;
        }
        this.selectedType = this.enabledTypes.get(this.selectedTypeIndex);
        if (this.selectedType == RecallType.WARP) {
            this.selectedIndex = reverse ? this.warps.size() - 1 : 0;
        } else if (this.selectedType == RecallType.WAND) {
            if (reverse) {
                List<LostWand> lostWands = this.mage.getLostWands();
                this.selectedIndex = lostWands.size() - 1;
            } else {
                this.selectedIndex = 0;
            }
        } else {
            this.selectedIndex = 0;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void cycleTarget(boolean reverse) {
        if (this.selectedType == RecallType.WARP) {
            if (reverse) {
                --this.selectedIndex;
                if (this.selectedIndex >= 0) return;
                this.selectedIndex = this.warps.size() - 1;
            } else {
                ++this.selectedIndex;
                if (this.selectedIndex < this.warps.size()) return;
                this.selectedIndex = 0;
            }
        } else if (this.selectedType == RecallType.WAND) {
            List<LostWand> lostWands = this.mage.getLostWands();
            if (reverse) {
                --this.selectedIndex;
                if (this.selectedIndex >= 0) return;
                this.selectedIndex = lostWands.size() - 1;
            } else {
                ++this.selectedIndex;
                if (this.selectedIndex < lostWands.size()) return;
                this.selectedIndex = 0;
            }
        }
        this.cycleTargetType(reverse);
    }

    protected Location getTargetLocation(Player player, RecallType type, int index) {
        this.castMessage = "";
        this.failMessage = "";
        switch (type) {
            case MARKER: {
                this.castMessage = this.getMessage("cast_marker");
                return this.location;
            }
            case DEATH: {
                this.castMessage = this.getMessage("cast_death");
                this.failMessage = this.getMessage("no_target_death");
                return this.mage.getLastDeathLocation();
            }
            case SPAWN: {
                this.castMessage = this.getMessage("cast_spawn");
                return this.getWorld().getSpawnLocation();
            }
            case HOME: {
                this.castMessage = this.getMessage("cast_home");
                this.failMessage = this.getMessage("no_target_home");
                return player == null ? null : player.getBedSpawnLocation();
            }
            case WAND: {
                List<LostWand> lostWands = this.mage.getLostWands();
                this.failMessage = this.getMessage("no_target_wand");
                this.castMessage = this.getMessage("cast_wand");
                if (lostWands == null || index < 0 || index >= lostWands.size()) {
                    return null;
                }
                return lostWands.get(index).getLocation();
            }
            case WARP: {
                if (this.warps == null || index < 0 || index >= this.warps.size()) {
                    return null;
                }
                String warpName = this.warps.get(index);
                this.castMessage = this.getMessage("cast_warp").replace("$name", warpName);
                return this.controller.getWarp(warpName);
            }
        }
        return null;
    }

    protected boolean tryCurrentType(Player player) {
        Location location = this.getTargetLocation(player, this.selectedType, this.selectedIndex);
        if (location == null) {
            return false;
        }
        return this.tryTeleport(player, location);
    }

    protected boolean removeMarker() {
        if (this.location == null) {
            return false;
        }
        this.location = null;
        return true;
    }

    protected boolean tryTeleport(final Player player, final Location targetLocation) {
        if (targetLocation == null) {
            this.sendMessage(this.failMessage);
            return false;
        }
        if (!this.allowCrossWorld && !this.mage.getLocation().getWorld().equals(targetLocation.getWorld())) {
            this.sendMessage(this.getMessage("cross_world_disallowed"));
            return false;
        }
        Chunk chunk = targetLocation.getBlock().getChunk();
        if (!chunk.isLoaded()) {
            chunk.load(true);
            if (this.retryCount < MAX_RETRY_COUNT) {
                Plugin plugin = this.controller.getPlugin();
                final RecallSpell me = this;
                Bukkit.getScheduler().scheduleSyncDelayedTask(plugin, new Runnable(){

                    @Override
                    public void run() {
                        me.tryTeleport(player, targetLocation);
                    }
                }, (long)RETRY_INTERVAL);
                return true;
            }
        }
        this.registerMoved((Entity)player);
        Location playerLocation = player.getLocation();
        targetLocation.setYaw(playerLocation.getYaw());
        targetLocation.setPitch(playerLocation.getPitch());
        player.teleport(this.tryFindPlaceToStand(targetLocation));
        this.castMessage(this.castMessage);
        return true;
    }

    protected boolean placeMarker(Block target) {
        if (target == null) {
            return false;
        }
        this.registerForUndo(new UndoMarkerMove(this, this.location));
        if (this.location != null) {
            this.removeMarker();
            this.castMessage(this.getMessage("cast_marker_move"));
        } else {
            this.castMessage(this.getMessage("cast_marker_place"));
        }
        this.location = this.getLocation();
        this.location.setX((double)target.getX());
        this.location.setY((double)target.getY());
        this.location.setZ((double)target.getZ());
        return true;
    }

    @Override
    public void onLoad(ConfigurationSection node) {
        this.location = ConfigurationUtils.getLocation(node, "location");
    }

    @Override
    public void onSave(ConfigurationSection node) {
        node.set("location", (Object)ConfigurationUtils.fromLocation(this.location));
    }

    private class Waypoint {
        public final RecallType type;
        public final int index;

        public Waypoint(RecallType type, int index) {
            this.type = type;
            this.index = index;
        }
    }

    private static enum RecallType {
        MARKER,
        DEATH,
        SPAWN,
        HOME,
        WAND,
        WARP;

    }

    private class UndoMarkerMove
    implements Runnable {
        private final Location location;
        private final RecallSpell spell;

        public UndoMarkerMove(RecallSpell spell, Location currentLocation) {
            this.location = currentLocation;
            this.spell = spell;
        }

        @Override
        public void run() {
            this.spell.location = this.location;
        }
    }
}

