/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell.builtin;

import com.elmakers.mine.bukkit.api.block.MaterialBrush;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.BrushSpell;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.util.Vector;

public class IterateSpell
extends BrushSpell {
    private int DEFAULT_SIZE = 16;

    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        Block target;
        boolean incrementData = parameters.getBoolean("increment_data", false);
        int radius = parameters.getInt("radius", 0);
        int size = parameters.getInt("size", this.DEFAULT_SIZE);
        boolean reverse = parameters.getBoolean("reverse", false);
        boolean requireBlock = parameters.getBoolean("require_block", false);
        size = (int)(this.mage.getConstructionMultiplier() * (float)size);
        boolean reverseTargeting = parameters.getBoolean("transparent_reverse", false);
        if (reverseTargeting) {
            this.setReverseTargeting(true);
        }
        if ((target = this.getTargetBlock()) == null) {
            return SpellResult.NO_TARGET;
        }
        if (!this.hasBuildPermission(target) || !this.hasBuildPermission(this.getLocation().getBlock())) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        int iterateBlocks = (int)this.getLocation().distance(target.getLocation());
        if (iterateBlocks <= 0) {
            return SpellResult.NO_TARGET;
        }
        iterateBlocks = Math.min(iterateBlocks, size);
        Vector targetLoc = new Vector(target.getX(), target.getY(), target.getZ());
        Vector playerLoc = this.getEyeLocation().toVector();
        Vector aim = null;
        if (reverse) {
            aim = playerLoc;
            aim.subtract(targetLoc);
            aim.normalize();
        } else {
            aim = targetLoc;
            aim.subtract(playerLoc);
            aim.normalize();
            targetLoc = playerLoc;
            targetLoc.add(aim);
            targetLoc.add(aim);
        }
        MaterialBrush buildWith = this.getBrush();
        buildWith.setTarget(target.getLocation());
        buildWith.update(this.mage, target.getLocation());
        for (int dr = 0; dr <= radius; ++dr) {
            int spokes = 1;
            if (dr > 0) {
                spokes = dr * 8;
            }
            for (int dspoke = 0; dspoke < spokes; ++dspoke) {
                Vector currentLoc = targetLoc.clone();
                if (dr > 0) {
                    double y;
                    double z;
                    Vector perp;
                    Vector axis;
                    double q = (double)dspoke * Math.PI * 2.0 / (double)spokes;
                    if (aim.getY() > 0.7) {
                        axis = new Vector(1, 0, 0);
                        perp = aim.clone().crossProduct(axis).multiply(dr);
                        double x = perp.getZ() * Math.sin(q) - perp.getX() * Math.cos(q);
                        z = perp.getZ() * Math.cos(q) - perp.getX() * Math.sin(q);
                        perp.setX(x);
                        perp.setZ(z);
                        currentLoc.add(perp);
                    } else if (aim.getX() > 0.7) {
                        axis = new Vector(0, 1, 0);
                        perp = aim.clone().crossProduct(axis).multiply(dr);
                        y = perp.getZ() * Math.sin(q) - perp.getY() * Math.cos(q);
                        z = perp.getZ() * Math.cos(q) - perp.getY() * Math.sin(q);
                        perp.setY(y);
                        perp.setZ(z);
                        currentLoc.add(perp);
                    } else {
                        axis = new Vector(0, 1, 0);
                        perp = aim.clone().crossProduct(axis).multiply(dr);
                        y = perp.getX() * Math.sin(q) - perp.getY() * Math.cos(q);
                        double x = perp.getX() * Math.cos(q) - perp.getY() * Math.sin(q);
                        perp.setY(y);
                        perp.setX(x);
                        currentLoc.add(perp);
                    }
                }
                for (int i = 0; i < iterateBlocks; ++i) {
                    Block currentTarget = target.getWorld().getBlockAt(currentLoc.getBlockX(), currentLoc.getBlockY(), currentLoc.getBlockZ());
                    if (!this.isTargetable(currentTarget.getType()) && this.isDestructible(currentTarget) && this.hasBuildPermission(currentTarget)) {
                        Block lowerBlock;
                        this.registerForUndo(currentTarget);
                        buildWith.update(this.mage, currentTarget.getLocation());
                        if (incrementData) {
                            byte data = buildWith.getData();
                            data = (byte)(i > 15 ? 15 : (byte)i);
                            buildWith.setData(data);
                        }
                        if (requireBlock && ((lowerBlock = currentTarget.getRelative(BlockFace.DOWN)).getType() == Material.AIR || lowerBlock.getType() == buildWith.getMaterial())) {
                            currentLoc.add(aim);
                            continue;
                        }
                        buildWith.modify(currentTarget);
                        this.controller.updateBlock(currentTarget);
                        Location effectLocation = currentTarget.getLocation();
                        effectLocation.add(0.5, 0.5, 0.5);
                        if (dr == 0) {
                            Material material = buildWith.getMaterial();
                            if (material == Material.AIR) {
                                effectLocation.getWorld().playEffect(effectLocation, Effect.STEP_SOUND, Material.OBSIDIAN.getId());
                            } else {
                                effectLocation.getWorld().playEffect(effectLocation, Effect.STEP_SOUND, material.getId());
                            }
                        }
                    }
                    currentLoc.add(aim);
                }
            }
        }
        this.registerForUndo();
        return SpellResult.CAST;
    }
}

