/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell.builtin;

import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.BlockSpell;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;

public class CushionSpell
extends BlockSpell {
    private static final int DEFAULT_CUSHION_WIDTH = 3;
    private static final int DEFAULT_CUSHION_HEIGHT = 4;

    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        World world = this.getWorld();
        Block targetFace = this.getTargetBlock();
        if (targetFace == null) {
            return SpellResult.NO_TARGET;
        }
        if (!this.hasBuildPermission(targetFace)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        int cushionWidth = parameters.getInt("width", 3);
        int cushionHeight = parameters.getInt("height", 4);
        int bubbleStart = -cushionWidth / 2;
        int bubbleEnd = cushionWidth / 2;
        for (int dx = bubbleStart; dx < bubbleEnd; ++dx) {
            for (int dz = bubbleStart; dz < bubbleEnd; ++dz) {
                for (int dy = 0; dy < cushionHeight; ++dy) {
                    int z;
                    int y;
                    int x = targetFace.getX() + dx;
                    Block block = world.getBlockAt(x, y = targetFace.getY() + dy, z = targetFace.getZ() + dz);
                    if (block.getType() != Material.AIR && block.getType() != Material.FIRE) continue;
                    this.registerForUndo(block);
                    block.setType(Material.STATIONARY_WATER);
                }
            }
        }
        this.registerForUndo();
        return SpellResult.CAST;
    }
}

