/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell;

import com.elmakers.mine.bukkit.api.block.MaterialAndData;
import com.elmakers.mine.bukkit.api.event.CastEvent;
import com.elmakers.mine.bukkit.api.event.PreCastEvent;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.MageSpell;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellCategory;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.api.spell.TargetType;
import com.elmakers.mine.bukkit.effect.EffectPlayer;
import com.elmakers.mine.bukkit.spell.CastingCost;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.Messages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public abstract class BaseSpell
implements MageSpell,
Cloneable {
    protected static final double VIEW_HEIGHT = 1.65;
    protected static final double LOOK_THRESHOLD_RADIANS = 0.8;
    protected static final int MIN_Y = 1;
    protected static final int MAX_Y = 255;
    protected static final int MAX_NETHER_Y = 120;
    protected static final Material DEFAULT_EFFECT_MATERIAL = Material.STATIONARY_WATER;
    public static final String[] EXAMPLE_VECTOR_COMPONENTS = new String[]{"-1", "-0.5", "0", "0.5", "1", "~-1", "~-0.5", "~0", "~0.5", "*1", "*-1", "*-0.5", "*0.5", "*1"};
    public static final String[] EXAMPLE_SIZES = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "12", "16", "32", "64"};
    public static final String[] EXAMPLE_BOOLEANS = new String[]{"true", "false"};
    public static final String[] EXAMPLE_DURATIONS = new String[]{"500", "1000", "2000", "5000", "10000", "60000", "120000"};
    public static final String[] EXAMPLE_PERCENTAGES = new String[]{"0", "0.1", "0.25", "0.5", "0.75", "1"};
    public static final String[] OTHER_PARAMETERS = new String[]{"transparent", "target", "target_type", "range", "duration", "player"};
    public static final String[] WORLD_PARAMETERS = new String[]{"pworld", "tworld", "otworld", "t2world"};
    protected static final Set<String> worldParameterMap = new HashSet<String>(Arrays.asList(WORLD_PARAMETERS));
    public static final String[] VECTOR_PARAMETERS = new String[]{"px", "py", "pz", "pdx", "pdy", "pdz", "tx", "ty", "tz", "otx", "oty", "otz", "t2x", "t2y", "t2z", "otdx", "otdy", "otdz"};
    protected static final Set<String> vectorParameterMap = new HashSet<String>(Arrays.asList(VECTOR_PARAMETERS));
    public static final String[] BOOLEAN_PARAMETERS = new String[]{"allow_max_range", "prevent_passthrough", "passthrough", "bypass_build", "bypass_pvp", "target_npc"};
    protected static final Set<String> booleanParameterMap = new HashSet<String>(Arrays.asList(BOOLEAN_PARAMETERS));
    public static final String[] PERCENTAGE_PARAMETERS = new String[]{"fizzle_chance", "backfire_chance", "cooldown_reduction"};
    protected static final Set<String> percentageParameterMap = new HashSet<String>(Arrays.asList(PERCENTAGE_PARAMETERS));
    public static final String[] COMMON_PARAMETERS = (String[])ArrayUtils.addAll((Object[])ArrayUtils.addAll((Object[])ArrayUtils.addAll((Object[])ArrayUtils.addAll((Object[])VECTOR_PARAMETERS, (Object[])BOOLEAN_PARAMETERS), (Object[])OTHER_PARAMETERS), (Object[])WORLD_PARAMETERS), (Object[])PERCENTAGE_PARAMETERS);
    protected MageController controller;
    protected Mage mage;
    protected Location location;
    private String key;
    private String name;
    private String alias;
    private String description;
    private String extendedDescription;
    private String usage;
    private long worth;
    private Color color;
    private String particle;
    private SpellCategory category;
    private BaseSpell template;
    private com.elmakers.mine.bukkit.block.MaterialAndData icon = new com.elmakers.mine.bukkit.block.MaterialAndData(Material.AIR);
    private List<CastingCost> costs = null;
    private List<CastingCost> activeCosts = null;
    private boolean pvpRestricted = false;
    private boolean bypassPvpRestriction = false;
    private boolean bypassConfusion = false;
    private boolean bypassPermissions = false;
    private boolean requirePassthrough = false;
    private boolean castOnNoTarget = false;
    private boolean bypassDeactivate = false;
    private boolean quiet = false;
    private boolean backfired = false;
    private boolean hidden = false;
    protected ConfigurationSection parameters = null;
    protected static Random random = new Random();
    private float cooldownReduction = 0.0f;
    private float costReduction = 0.0f;
    private int cooldown = 0;
    private int duration = 0;
    private long lastCast = 0L;
    private long castCount = 0L;
    private boolean isActive = false;
    private Map<String, Collection<EffectPlayer>> effects = new HashMap<String, Collection<EffectPlayer>>();
    private float fizzleChance = 0.0f;
    private float backfireChance = 0.0f;
    private long lastMessageSent = 0L;
    private Set<Material> preventPassThroughMaterials = null;
    private Set<Material> passthroughMaterials = null;
    private Collection<EffectPlayer> currentEffects = null;

    public boolean allowPassThrough(Material mat) {
        if (this.mage != null && this.mage.isSuperPowered()) {
            return true;
        }
        if (this.passthroughMaterials != null && this.passthroughMaterials.contains(mat)) {
            return true;
        }
        return this.preventPassThroughMaterials == null || !this.preventPassThroughMaterials.contains(mat);
    }

    public boolean isOkToStandIn(Material mat) {
        return this.passthroughMaterials.contains(mat);
    }

    public boolean isWater(Material mat) {
        return mat == Material.WATER || mat == Material.STATIONARY_WATER;
    }

    public boolean isOkToStandOn(Material mat) {
        return mat != Material.AIR && mat != Material.LAVA && mat != Material.STATIONARY_LAVA;
    }

    public boolean isSafeLocation(Block block) {
        if (!block.getChunk().isLoaded()) {
            block.getChunk().load(true);
            return false;
        }
        if (block.getY() > 255) {
            return false;
        }
        Block blockOneUp = block.getRelative(BlockFace.UP);
        Block blockOneDown = block.getRelative(BlockFace.DOWN);
        Player player = this.mage.getPlayer();
        return (this.isOkToStandOn(blockOneDown.getType()) || player != null && player.isFlying()) && this.isOkToStandIn(blockOneUp.getType()) && this.isOkToStandIn(block.getType());
    }

    public boolean isSafeLocation(Location loc) {
        return this.isSafeLocation(loc.getBlock());
    }

    public Location tryFindPlaceToStand(Location targetLoc) {
        return this.tryFindPlaceToStand(targetLoc, 255, 255);
    }

    public Location tryFindPlaceToStand(Location targetLoc, int maxDownDelta, int maxUpDelta) {
        Location location = this.findPlaceToStand(targetLoc, maxDownDelta, maxUpDelta);
        return location == null ? targetLoc : location;
    }

    public Location findPlaceToStand(Location targetLoc, int maxDownDelta, int maxUpDelta) {
        if (!targetLoc.getBlock().getChunk().isLoaded()) {
            return null;
        }
        int minY = 1;
        int maxY = targetLoc.getWorld().getEnvironment() == World.Environment.NETHER ? 120 : 255;
        int targetY = targetLoc.getBlockY();
        if (targetY >= minY && targetY <= maxY && this.isSafeLocation(targetLoc)) {
            return targetLoc;
        }
        Location location = null;
        if (targetY < minY) {
            location = targetLoc.clone();
            location.setY((double)minY);
            location = this.findPlaceToStand(location, true, maxUpDelta);
        } else if (targetY > maxY) {
            location = targetLoc.clone();
            location.setY((double)maxY);
            location = this.findPlaceToStand(location, false, maxDownDelta);
        } else {
            int testMinY = Math.min(maxDownDelta, 4);
            location = this.findPlaceToStand(targetLoc, false, testMinY);
            if (location == null) {
                location = this.findPlaceToStand(targetLoc, true, maxUpDelta);
            }
            if (location == null) {
                location = this.findPlaceToStand(targetLoc, false, maxDownDelta);
            }
        }
        return location;
    }

    public Location findPlaceToStand(Location target, boolean goUp) {
        return this.findPlaceToStand(target, goUp, 255);
    }

    public Location findPlaceToStand(Location target, boolean goUp, int maxDelta) {
        int maxY;
        int direction = goUp ? 1 : -1;
        Location targetLocation = target.clone();
        boolean minY = true;
        int n = maxY = targetLocation.getWorld().getEnvironment() == World.Environment.NETHER ? 120 : 255;
        for (int yDelta = 0; (double)minY <= targetLocation.getY() && targetLocation.getY() <= (double)maxY && yDelta < maxDelta; ++yDelta) {
            Block block = targetLocation.getBlock();
            if (!(!this.isSafeLocation(block) || goUp && this.isUnderwater() && this.isWater(block.getType()))) {
                return targetLocation;
            }
            if (!this.allowPassThrough(block.getType())) {
                return null;
            }
            targetLocation.setY(targetLocation.getY() + (double)direction);
        }
        return null;
    }

    public Block getPlayerBlock() {
        Location location = this.getLocation();
        if (location == null) {
            return null;
        }
        return location.getBlock().getRelative(BlockFace.DOWN);
    }

    public BlockFace getPlayerFacing() {
        return BaseSpell.getFacing(this.getLocation());
    }

    public static BlockFace getFacing(Location location) {
        float playerRot;
        for (playerRot = location.getYaw(); playerRot < 0.0f; playerRot += 360.0f) {
        }
        while (playerRot > 360.0f) {
            playerRot -= 360.0f;
        }
        BlockFace direction = BlockFace.NORTH;
        if (playerRot <= 45.0f || playerRot > 315.0f) {
            direction = BlockFace.SOUTH;
        } else if (playerRot > 45.0f && playerRot <= 135.0f) {
            direction = BlockFace.WEST;
        } else if (playerRot > 135.0f && playerRot <= 225.0f) {
            direction = BlockFace.NORTH;
        } else if (playerRot > 225.0f && playerRot <= 315.0f) {
            direction = BlockFace.EAST;
        }
        return direction;
    }

    public void castMessage(String message) {
        if (!this.quiet && this.canSendMessage() && message != null && message.length() > 0) {
            this.mage.castMessage(message);
            this.lastMessageSent = System.currentTimeMillis();
        }
    }

    public void sendMessage(String message) {
        if (!this.quiet && message != null && message.length() > 0) {
            this.mage.sendMessage(message);
            this.lastMessageSent = System.currentTimeMillis();
        }
    }

    @Override
    public Location getLocation() {
        if (this.location != null) {
            return this.location.clone();
        }
        if (this.mage != null) {
            return this.mage.getLocation();
        }
        return null;
    }

    public Location getEyeLocation() {
        Location location = this.getLocation();
        if (location == null) {
            return null;
        }
        location.setY(location.getY() + 1.5);
        return location;
    }

    @Override
    public Vector getDirection() {
        if (this.location == null) {
            return this.mage.getDirection();
        }
        return this.location.getDirection();
    }

    public boolean isLookingUp() {
        Vector direction = this.getDirection();
        if (direction == null) {
            return false;
        }
        return direction.getY() > 0.8;
    }

    public boolean isLookingDown() {
        Vector direction = this.getDirection();
        if (direction == null) {
            return false;
        }
        return direction.getY() < -0.8;
    }

    public World getWorld() {
        Location location = this.getLocation();
        if (location != null) {
            return location.getWorld();
        }
        return null;
    }

    public boolean isUnderwater() {
        Block playerBlock = this.getPlayerBlock();
        if (playerBlock == null) {
            return false;
        }
        return (playerBlock = playerBlock.getRelative(BlockFace.UP)).getType() == Material.WATER || playerBlock.getType() == Material.STATIONARY_WATER;
    }

    protected String getBlockSkin(Material blockType) {
        String skinName = null;
        switch (blockType) {
            case CACTUS: {
                skinName = "MHF_Cactus";
                break;
            }
            case CHEST: {
                skinName = "MHF_Chest";
                break;
            }
            case MELON_BLOCK: {
                skinName = "MHF_Melon";
                break;
            }
            case TNT: {
                if (random.nextDouble() > 0.5) {
                    skinName = "MHF_TNT";
                    break;
                }
                skinName = "MHF_TNT2";
                break;
            }
            case LOG: {
                skinName = "MHF_OakLog";
                break;
            }
            case PUMPKIN: {
                skinName = "MHF_Pumpkin";
                break;
            }
        }
        return skinName;
    }

    protected String getMobSkin(EntityType mobType) {
        String mobSkin = null;
        switch (mobType) {
            case BLAZE: {
                mobSkin = "MHF_Blaze";
                break;
            }
            case CAVE_SPIDER: {
                mobSkin = "MHF_CaveSpider";
                break;
            }
            case CHICKEN: {
                mobSkin = "MHF_Chicken";
                break;
            }
            case COW: {
                mobSkin = "MHF_Cow";
                break;
            }
            case ENDERMAN: {
                mobSkin = "MHF_Enderman";
                break;
            }
            case GHAST: {
                mobSkin = "MHF_Ghast";
                break;
            }
            case IRON_GOLEM: {
                mobSkin = "MHF_Golem";
                break;
            }
            case MAGMA_CUBE: {
                mobSkin = "MHF_LavaSlime";
                break;
            }
            case MUSHROOM_COW: {
                mobSkin = "MHF_MushroomCow";
                break;
            }
            case OCELOT: {
                mobSkin = "MHF_Ocelot";
                break;
            }
            case PIG: {
                mobSkin = "MHF_Pig";
                break;
            }
            case PIG_ZOMBIE: {
                mobSkin = "MHF_PigZombie";
                break;
            }
            case SHEEP: {
                mobSkin = "MHF_Sheep";
                break;
            }
            case SLIME: {
                mobSkin = "MHF_Slime";
                break;
            }
            case SPIDER: {
                mobSkin = "MHF_Spider";
                break;
            }
            case SQUID: {
                mobSkin = "MHF_Squid";
                break;
            }
            case VILLAGER: {
                mobSkin = "MHF_Villager";
            }
        }
        return mobSkin;
    }

    protected static Collection<PotionEffect> getPotionEffects(ConfigurationSection parameters) {
        return BaseSpell.getPotionEffects(parameters, null);
    }

    protected static Collection<PotionEffect> getPotionEffects(ConfigurationSection parameters, Integer duration) {
        PotionEffectType[] effectTypes;
        ArrayList<PotionEffect> effects = new ArrayList<PotionEffect>();
        for (PotionEffectType effectType : effectTypes = PotionEffectType.values()) {
            String parameterName;
            if (effectType == null || !parameters.contains(parameterName = "effect_" + effectType.getName().toLowerCase())) continue;
            String value = parameters.getString(parameterName);
            int ticks = 10;
            int power = 1;
            try {
                if (value.contains(",")) {
                    String[] pieces = value.split(",");
                    ticks = Integer.parseInt(pieces[0]);
                    power = Integer.parseInt(pieces[1]);
                } else {
                    power = Integer.parseInt(value);
                    if (duration != null) {
                        ticks = duration / 50;
                    }
                }
            }
            catch (Exception ex) {
                Bukkit.getLogger().warning("Error parsing potion effect for " + effectType + ": " + value);
            }
            PotionEffect effect = new PotionEffect(effectType, ticks, power, true);
            effects.add(effect);
        }
        return effects;
    }

    public boolean isInCircle(int x, int z, int R) {
        return x * x + z * z - R * R <= 0;
    }

    private boolean canSendMessage() {
        if (this.lastMessageSent == 0L) {
            return true;
        }
        int throttle = this.controller.getMessageThrottle();
        long now = System.currentTimeMillis();
        return this.lastMessageSent < now - (long)throttle;
    }

    protected Location getEffectLocation() {
        return this.getEyeLocation();
    }

    public FireworkEffect getFireworkEffect() {
        return this.getFireworkEffect(null, null, null, null, null);
    }

    public FireworkEffect getFireworkEffect(Color color1, Color color2, FireworkEffect.Type fireworkType) {
        return this.getFireworkEffect(color1, color2, fireworkType, null, null);
    }

    public FireworkEffect getFireworkEffect(Color color1, Color color2, FireworkEffect.Type fireworkType, Boolean flicker, Boolean trail) {
        Color wandColor;
        Color color = wandColor = this.mage == null ? null : this.mage.getEffectColor();
        if (wandColor != null) {
            color1 = wandColor;
            color2 = wandColor.mixColors(new Color[]{color1, Color.WHITE});
        } else {
            if (color1 == null) {
                color1 = Color.fromRGB((int)random.nextInt(255), (int)random.nextInt(255), (int)random.nextInt(255));
            }
            if (color2 == null) {
                color2 = Color.fromRGB((int)random.nextInt(255), (int)random.nextInt(255), (int)random.nextInt(255));
            }
        }
        if (fireworkType == null) {
            fireworkType = FireworkEffect.Type.values()[random.nextInt(FireworkEffect.Type.values().length)];
        }
        if (flicker == null) {
            flicker = random.nextBoolean();
        }
        if (trail == null) {
            trail = random.nextBoolean();
        }
        return FireworkEffect.builder().flicker(flicker.booleanValue()).withColor(color1).withFade(color2).with(fireworkType).trail(trail.booleanValue()).build();
    }

    @Override
    public boolean hasBrushOverride() {
        return false;
    }

    public void checkActiveCosts() {
        if (this.activeCosts == null) {
            return;
        }
        for (CastingCost cost : this.activeCosts) {
            if (!cost.has(this)) {
                this.deactivate();
                return;
            }
            cost.use(this);
        }
    }

    public void checkActiveDuration() {
        if (this.duration > 0 && this.lastCast < System.currentTimeMillis() - (long)this.duration) {
            this.deactivate();
        }
    }

    protected List<CastingCost> parseCosts(ConfigurationSection node) {
        if (node == null) {
            return null;
        }
        ArrayList<CastingCost> castingCosts = new ArrayList<CastingCost>();
        Set costKeys = node.getKeys(false);
        for (String key : costKeys) {
            castingCosts.add(new CastingCost(key, node.getDouble(key, 1.0)));
        }
        return castingCosts;
    }

    protected void loadTemplate(ConfigurationSection node) {
        this.name = this.key;
        this.name = node.getString("name", this.name);
        this.name = Messages.get("spells." + this.key + ".name", this.name);
        this.alias = node.getString("alias", "");
        this.description = node.getString("description", "");
        this.description = Messages.get("spells." + this.key + ".description", this.description);
        this.extendedDescription = node.getString("extended_description", "");
        this.extendedDescription = Messages.get("spells." + this.key + ".extended_description", this.extendedDescription);
        this.usage = Messages.get("spells." + this.key + ".usage", this.usage);
        this.icon = ConfigurationUtils.getMaterialAndData(node, "icon", this.icon);
        this.color = ConfigurationUtils.getColor(node, "color", null);
        this.worth = node.getLong("worth", this.worth);
        this.category = this.controller.getCategory(node.getString("category"));
        this.parameters = node.getConfigurationSection("parameters");
        this.costs = this.parseCosts(node.getConfigurationSection("costs"));
        this.activeCosts = this.parseCosts(node.getConfigurationSection("active_costs"));
        this.pvpRestricted = node.getBoolean("pvp_restricted", this.pvpRestricted);
        this.castOnNoTarget = node.getBoolean("cast_on_no_target", false);
        this.hidden = node.getBoolean("hidden", false);
        this.effects.clear();
        if (node.contains("effects")) {
            ConfigurationSection effectsNode = node.getConfigurationSection("effects");
            Set effectKeys = effectsNode.getKeys(false);
            for (String effectKey : effectKeys) {
                if (effectsNode.isString(effectKey)) {
                    String referenceKey = effectsNode.getString(effectKey);
                    if (!this.effects.containsKey(referenceKey)) continue;
                    this.effects.put(effectKey, new ArrayList<EffectPlayer>(this.effects.get(referenceKey)));
                    continue;
                }
                this.effects.put(effectKey, EffectPlayer.loadEffects(this.controller.getPlugin(), effectsNode, effectKey));
            }
        }
    }

    public boolean isMatch(String spell, String[] params) {
        if (params == null) {
            params = new String[]{};
        }
        return this.key.equalsIgnoreCase(spell) && this.parameters.equals(params);
    }

    protected void preCast() {
    }

    protected void reset() {
        Location mageLocation;
        Location location = mageLocation = this.mage != null ? this.mage.getLocation() : null;
        if (this.location != null && mageLocation != null) {
            this.location.setPitch(mageLocation.getPitch());
            this.location.setYaw(mageLocation.getYaw());
        }
        this.backfired = false;
        this.cancelEffects();
    }

    @Override
    public boolean cast(String[] extraParameters, Location defaultLocation) {
        double cooldownReduction;
        this.reset();
        PreCastEvent preCast = new PreCastEvent(this.mage, this);
        Bukkit.getPluginManager().callEvent((Event)preCast);
        if (preCast.isCancelled()) {
            this.processResult(SpellResult.EVENT_CANCELLED);
            return false;
        }
        if (this.parameters == null) {
            this.parameters = new MemoryConfiguration();
        }
        this.location = defaultLocation;
        MemoryConfiguration parameters = new MemoryConfiguration();
        ConfigurationUtils.addConfigurations((ConfigurationSection)parameters, this.parameters);
        ConfigurationUtils.addParameters(extraParameters, (ConfigurationSection)parameters);
        this.processParameters((ConfigurationSection)parameters);
        this.bypassConfusion = parameters.getBoolean("bypass_confusion", this.bypassConfusion);
        LivingEntity livingEntity = this.mage.getLivingEntity();
        if (livingEntity != null && !this.bypassConfusion && !this.mage.isSuperPowered() && livingEntity.hasPotionEffect(PotionEffectType.CONFUSION)) {
            this.processResult(SpellResult.CURSED);
            return false;
        }
        if (!this.canCast(defaultLocation)) {
            this.processResult(SpellResult.INSUFFICIENT_PERMISSION);
            return false;
        }
        this.preCast();
        this.bypassPvpRestriction = parameters.getBoolean("bypass_pvp", false);
        this.bypassPvpRestriction = parameters.getBoolean("bp", this.bypassPvpRestriction);
        this.bypassPermissions = parameters.getBoolean("bypass_permissions", this.bypassPermissions);
        this.requirePassthrough = parameters.getBoolean("require_passthrough", this.requirePassthrough);
        this.cooldown = parameters.getInt("cooldown", this.cooldown);
        this.cooldown = parameters.getInt("cool", this.cooldown);
        this.color = ConfigurationUtils.getColor((ConfigurationSection)parameters, "color", this.color);
        this.particle = parameters.getString("particle", null);
        long currentTime = System.currentTimeMillis();
        if (!this.mage.isCooldownFree() && (cooldownReduction = (double)(this.mage.getCooldownReduction() + this.cooldownReduction)) < 1.0 && !this.isActive && this.cooldown > 0) {
            int reducedCooldown = (int)Math.ceil((1.0 - cooldownReduction) * (double)this.cooldown);
            if (this.lastCast != 0L && this.lastCast > currentTime - (long)reducedCooldown) {
                long seconds = (this.lastCast - (currentTime - (long)reducedCooldown)) / 1000L;
                if (seconds > 3600L) {
                    long hours = seconds / 3600L;
                    this.sendMessage(Messages.get("cooldown.wait_hours").replace("$hours", Long.valueOf(hours).toString()));
                } else if (seconds > 60L) {
                    long minutes = seconds / 60L;
                    this.sendMessage(Messages.get("cooldown.wait_minutes").replace("$minutes", Long.valueOf(minutes).toString()));
                } else if (seconds > 1L) {
                    this.sendMessage(Messages.get("cooldown.wait_seconds").replace("$seconds", Long.valueOf(seconds).toString()));
                } else {
                    this.sendMessage(Messages.get("cooldown.wait_moment"));
                }
                this.processResult(SpellResult.COOLDOWN);
                return false;
            }
        }
        if (!this.mage.isCostFree() && this.costs != null && !this.isActive) {
            for (CastingCost cost : this.costs) {
                if (cost.has(this)) continue;
                String baseMessage = Messages.get("costs.insufficient_resources");
                String costDescription = cost.getDescription(this.mage);
                this.sendMessage(baseMessage.replace("$cost", costDescription));
                this.processResult(SpellResult.INSUFFICIENT_RESOURCES);
                return false;
            }
        }
        return this.finalizeCast((ConfigurationSection)parameters);
    }

    protected boolean canCast(Location location) {
        if (!this.hasCastPermission(this.mage.getCommandSender())) {
            return false;
        }
        if (this.requirePassthrough && !this.controller.isPassthrough(location)) {
            return false;
        }
        return !this.pvpRestricted || this.bypassPvpRestriction || this.mage.isPVPAllowed(location) || this.mage.isSuperPowered();
    }

    protected void onBackfire() {
    }

    protected void backfire() {
        if (!this.backfired) {
            this.onBackfire();
        }
        this.backfired = true;
    }

    protected boolean finalizeCast(ConfigurationSection parameters) {
        boolean success;
        SpellResult result = null;
        this.controller.disablePhysics(parameters.getInt("disable_physics", 0));
        if (!this.mage.isSuperPowered()) {
            if (this.backfireChance > 0.0f && random.nextDouble() < (double)this.backfireChance) {
                this.backfire();
            } else if (this.fizzleChance > 0.0f && random.nextDouble() < (double)this.fizzleChance) {
                result = SpellResult.FIZZLE;
            }
        }
        if (result == null) {
            result = this.onCast(parameters);
        }
        if (this.backfired) {
            result = SpellResult.BACKFIRE;
        }
        this.processResult(result);
        boolean bl = success = this.castOnNoTarget && result == SpellResult.NO_TARGET || result.isSuccess();
        if (success) {
            this.lastCast = System.currentTimeMillis();
            if (this.costs != null && !this.mage.isCostFree()) {
                for (CastingCost cost : this.costs) {
                    cost.use(this);
                }
            }
            ++this.castCount;
            if (this.template != null) {
                ++this.template.castCount;
            }
        }
        return success;
    }

    public String getMessage(String messageKey) {
        return this.getMessage(messageKey, "");
    }

    public String getMessage(String messageKey, String def) {
        String message = Messages.get("spells.default." + messageKey, def);
        message = Messages.get("spells." + this.key + "." + messageKey, message);
        if (message == null) {
            message = "";
        }
        String playerName = this.mage.getName();
        message = message.replace("$player", playerName);
        String materialName = this.getDisplayMaterialName();
        materialName = materialName == null ? "None" : materialName;
        message = message.replace("$material", materialName);
        return message;
    }

    protected String getDisplayMaterialName() {
        return "None";
    }

    protected void processResult(SpellResult result) {
        CastEvent castEvent = new CastEvent(this.mage, this, result);
        Bukkit.getPluginManager().callEvent((Event)castEvent);
        if (this.mage != null) {
            this.mage.onCast(this, result);
        }
        String resultName = result.name().toLowerCase();
        if (result == SpellResult.CAST) {
            String message = this.getMessage(resultName);
            LivingEntity sourceEntity = this.mage.getLivingEntity();
            Entity targetEntity = this.getTargetEntity();
            if (targetEntity == sourceEntity) {
                message = this.getMessage("cast_self", message);
            } else if (targetEntity instanceof Player) {
                message = this.getMessage("cast_player", message);
                String playerMessage = this.getMessage("cast_player_message");
                if (playerMessage.length() > 0) {
                    playerMessage = playerMessage.replace("$spell", this.getName());
                    Player targetPlayer = (Player)targetEntity;
                    Mage targetMage = this.controller.getMage(targetPlayer);
                    targetMage.sendMessage(playerMessage);
                }
            } else if (targetEntity instanceof LivingEntity) {
                message = this.getMessage("cast_livingentity", message);
            } else if (targetEntity instanceof Entity) {
                message = this.getMessage("cast_entity", message);
            }
            this.castMessage(message);
        } else {
            this.sendMessage(this.getMessage(resultName));
        }
        this.playEffects(resultName);
    }

    public void playEffects(String effectName, float scale) {
        Location mageLocation = this.getEffectLocation();
        if (this.effects.containsKey(effectName) && mageLocation != null) {
            Location targetLocation = this.getTargetLocation();
            Entity targetEntity = this.getTargetEntity();
            this.cancelEffects();
            this.currentEffects = this.effects.get(effectName);
            for (EffectPlayer player : this.currentEffects) {
                player.setScale(scale);
                player.setMaterial(this.getEffectMaterial());
                player.setColor(this.mage.getEffectColor());
                String overrideParticle = this.particle != null ? this.particle : this.mage.getEffectParticleName();
                player.setParticleOverride(overrideParticle);
                Entity entity = this.mage.getEntity();
                player.start(mageLocation, entity, targetLocation, targetEntity);
            }
        }
    }

    public void playEffects(String effectName) {
        this.playEffects(effectName, 1.0f);
    }

    @Override
    public Location getTargetLocation() {
        return null;
    }

    @Override
    public Entity getTargetEntity() {
        return null;
    }

    public MaterialAndData getEffectMaterial() {
        return new com.elmakers.mine.bukkit.block.MaterialAndData(DEFAULT_EFFECT_MATERIAL);
    }

    protected void processParameters(ConfigurationSection parameters) {
        this.duration = parameters.getInt("duration", this.duration);
        this.fizzleChance = (float)parameters.getDouble("fizzle_chance", (double)this.fizzleChance);
        this.backfireChance = (float)parameters.getDouble("backfire_chance", (double)this.backfireChance);
        Location defaultLocation = this.location == null ? this.mage.getLocation() : this.location;
        Location locationOverride = ConfigurationUtils.overrideLocation(parameters, "p", defaultLocation, this.controller.canCreateWorlds());
        if (locationOverride != null) {
            this.location = locationOverride;
        }
        this.costReduction = (float)parameters.getDouble("cost_reduction", 0.0);
        this.cooldownReduction = (float)parameters.getDouble("cooldown_reduction", 0.0);
        this.preventPassThroughMaterials = parameters.contains("prevent_passthrough") ? this.controller.getMaterialSet(parameters.getString("prevent_passthrough")) : this.controller.getMaterialSet("indestructible");
        this.passthroughMaterials = parameters.contains("passthrough") ? this.controller.getMaterialSet(parameters.getString("passthrough")) : this.controller.getMaterialSet("passthrough");
        this.bypassDeactivate = parameters.getBoolean("bypass_deactivate", false);
        this.quiet = parameters.getBoolean("quiet", false);
    }

    @Override
    public String getPermissionNode() {
        return "Magic.cast." + this.key;
    }

    public boolean onCancel() {
        return false;
    }

    public void onPlayerQuit(PlayerQuitEvent event) {
    }

    public void onPlayerDeath(EntityDeathEvent event) {
    }

    public void onPlayerDamage(EntityDamageEvent event) {
    }

    @Override
    public void initialize(MageController instance) {
        this.controller = instance;
    }

    @Override
    public long getCastCount() {
        return this.castCount;
    }

    public void onActivate() {
    }

    public void onDeactivate() {
    }

    public void onLoad(ConfigurationSection node) {
    }

    public void onSave(ConfigurationSection node) {
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }

    @Override
    public float getCostReduction() {
        return this.costReduction + this.mage.getCostReduction();
    }

    @Override
    public boolean usesMana() {
        return this.mage.usesMana();
    }

    @Override
    public Spell createSpell() {
        BaseSpell spell = (BaseSpell)this.clone();
        spell.template = this;
        return spell;
    }

    @Override
    public boolean cast() {
        return this.cast(null, null);
    }

    @Override
    public boolean cast(String[] extraParameters) {
        return this.cast(extraParameters, null);
    }

    @Override
    public final String getKey() {
        return this.key;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final String getAlias() {
        return this.alias;
    }

    @Override
    public final MaterialAndData getIcon() {
        return this.icon;
    }

    @Override
    public boolean hasIcon() {
        return this.icon != null && this.icon.getMaterial() != Material.AIR;
    }

    @Override
    public final String getDescription() {
        return this.description;
    }

    @Override
    public final String getExtendedDescription() {
        return this.extendedDescription;
    }

    @Override
    public final String getUsage() {
        return this.usage;
    }

    @Override
    public final long getWorth() {
        return this.worth;
    }

    @Override
    public final SpellCategory getCategory() {
        return this.category;
    }

    @Override
    public Collection<com.elmakers.mine.bukkit.api.effect.EffectPlayer> getEffects(SpellResult result) {
        return this.getEffects(result.name().toLowerCase());
    }

    @Override
    public Collection<com.elmakers.mine.bukkit.api.effect.EffectPlayer> getEffects(String key) {
        Collection<EffectPlayer> effectList = this.effects.get(key);
        if (effectList == null) {
            return new ArrayList<com.elmakers.mine.bukkit.api.effect.EffectPlayer>();
        }
        return new ArrayList<com.elmakers.mine.bukkit.api.effect.EffectPlayer>(effectList);
    }

    @Override
    public Collection<com.elmakers.mine.bukkit.api.spell.CastingCost> getCosts() {
        if (this.costs == null) {
            return null;
        }
        ArrayList<com.elmakers.mine.bukkit.api.spell.CastingCost> copy = new ArrayList<com.elmakers.mine.bukkit.api.spell.CastingCost>();
        copy.addAll(this.costs);
        return copy;
    }

    @Override
    public Collection<com.elmakers.mine.bukkit.api.spell.CastingCost> getActiveCosts() {
        if (this.activeCosts == null) {
            return null;
        }
        ArrayList<com.elmakers.mine.bukkit.api.spell.CastingCost> copy = new ArrayList<com.elmakers.mine.bukkit.api.spell.CastingCost>();
        copy.addAll(this.activeCosts);
        return copy;
    }

    @Override
    public void getParameters(Collection<String> parameters) {
        parameters.addAll(Arrays.asList(COMMON_PARAMETERS));
    }

    @Override
    public void getParameterOptions(Collection<String> examples, String parameterKey) {
        if (parameterKey.equals("duration")) {
            examples.addAll(Arrays.asList(EXAMPLE_DURATIONS));
        } else if (parameterKey.equals("range")) {
            examples.addAll(Arrays.asList(EXAMPLE_SIZES));
        } else if (parameterKey.equals("transparent")) {
            examples.addAll(this.controller.getMaterialSets());
        } else if (parameterKey.equals("player")) {
            examples.addAll(this.controller.getPlayerNames());
        } else if (parameterKey.equals("target")) {
            TargetType[] targetTypes;
            for (TargetType targetType : targetTypes = TargetType.values()) {
                examples.add(targetType.name().toLowerCase());
            }
        } else if (parameterKey.equals("target")) {
            TargetType[] targetTypes;
            for (TargetType targetType : targetTypes = TargetType.values()) {
                examples.add(targetType.name().toLowerCase());
            }
        } else if (parameterKey.equals("target_type")) {
            EntityType[] entityTypes;
            for (EntityType entityType : entityTypes = EntityType.values()) {
                examples.add(entityType.name().toLowerCase());
            }
        } else if (booleanParameterMap.contains(parameterKey)) {
            examples.addAll(Arrays.asList(EXAMPLE_BOOLEANS));
        } else if (vectorParameterMap.contains(parameterKey)) {
            examples.addAll(Arrays.asList(EXAMPLE_VECTOR_COMPONENTS));
        } else if (worldParameterMap.contains(parameterKey)) {
            List worlds = Bukkit.getWorlds();
            for (World world : worlds) {
                examples.add(world.getName());
            }
        } else if (percentageParameterMap.contains(parameterKey)) {
            examples.addAll(Arrays.asList(EXAMPLE_PERCENTAGES));
        }
    }

    @Override
    public long getCooldown() {
        return this.cooldown;
    }

    @Override
    public long getDuration() {
        return this.duration;
    }

    @Override
    public void setMage(Mage mage) {
        this.mage = mage;
    }

    @Override
    public boolean cancel() {
        boolean cancelled = this.onCancel();
        if (cancelled) {
            this.sendMessage(this.getMessage("cancel"));
        }
        return cancelled;
    }

    @Override
    public void reactivate() {
        this.isActive = true;
        this.onActivate();
    }

    @Override
    public void activate() {
        if (!this.isActive) {
            this.mage.activateSpell(this);
        }
    }

    @Override
    public boolean deactivate() {
        return this.deactivate(false, false);
    }

    @Override
    public boolean deactivate(boolean force, boolean quiet) {
        if (!force && this.bypassDeactivate) {
            return false;
        }
        if (this.isActive) {
            this.isActive = false;
            this.onDeactivate();
            this.mage.deactivateSpell(this);
            if (!quiet) {
                this.sendMessage(this.getMessage("deactivate"));
            }
            this.cancelEffects();
        }
        return true;
    }

    public void cancelEffects() {
        if (this.currentEffects != null) {
            for (EffectPlayer player : this.currentEffects) {
                player.cancel();
            }
            this.currentEffects = null;
        }
    }

    @Override
    public Mage getMage() {
        return this.mage;
    }

    @Override
    public void load(ConfigurationSection node) {
        try {
            this.castCount = node.getLong("cast_count", 0L);
            this.lastCast = node.getLong("last_cast", 0L);
            if (this.category != null && this.template == null) {
                this.category.addCasts(this.castCount, this.lastCast);
            }
            this.isActive = node.getBoolean("active", false);
            this.onLoad(node);
        }
        catch (Exception ex) {
            this.controller.getPlugin().getLogger().warning("Failed to load data for spell " + this.name + ": " + ex.getMessage());
        }
    }

    @Override
    public void save(ConfigurationSection node) {
        try {
            node.set("cast_count", (Object)this.castCount);
            node.set("last_cast", (Object)this.lastCast);
            node.set("active", (Object)this.isActive);
            this.onSave(node);
        }
        catch (Exception ex) {
            this.controller.getPlugin().getLogger().warning("Failed to save data for spell " + this.name);
            ex.printStackTrace();
        }
    }

    @Override
    public void loadTemplate(String key, ConfigurationSection node) {
        this.key = key;
        this.loadTemplate(node);
    }

    @Override
    public void tick() {
        this.checkActiveDuration();
        this.checkActiveCosts();
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public int compareTo(SpellTemplate other) {
        return this.name.compareTo(other.getName());
    }

    @Override
    public boolean hasCastPermission(CommandSender sender) {
        if (sender == null || this.bypassPermissions) {
            return true;
        }
        return this.controller.hasCastPermission(sender, this);
    }

    @Override
    public Color getColor() {
        if (this.color != null) {
            return this.color;
        }
        if (this.category != null) {
            return this.category.getColor();
        }
        return null;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    public abstract SpellResult onCast(ConfigurationSection var1);
}

