/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.slikey.effectlib.effect;

import com.elmakers.mine.bukkit.slikey.effectlib.Effect;
import com.elmakers.mine.bukkit.slikey.effectlib.EffectManager;
import com.elmakers.mine.bukkit.slikey.effectlib.EffectType;
import com.elmakers.mine.bukkit.slikey.effectlib.util.ParticleEffect;
import org.bukkit.Location;
import org.bukkit.util.Vector;

public class LineEffect
extends Effect {
    public ParticleEffect particle = ParticleEffect.FLAME;
    public int particles = 100;

    public LineEffect(EffectManager effectManager) {
        super(effectManager);
        this.type = EffectType.INSTANT;
        this.period = 5;
        this.iterations = 200;
    }

    @Override
    public void onRun() {
        Location location = this.getLocation();
        Location target = this.getTarget();
        if (target == null) {
            this.cancel();
            return;
        }
        Vector link = target.toVector().subtract(location.toVector());
        float length = (float)link.length();
        link.normalize();
        float ratio = length / (float)this.particles;
        Vector v = link.multiply(ratio);
        Location loc = location.clone().subtract(v);
        for (int i = 0; i < this.particles; ++i) {
            loc.add(v);
            this.particle.display(loc, this.visibleRange);
        }
    }
}

